/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.MemoryIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.FastLongMethodOneArg;
import org.jruby.ext.ffi.jffi.FastLongMethodThreeArg;
import org.jruby.ext.ffi.jffi.FastLongMethodTwoArg;
import org.jruby.ext.ffi.jffi.FastLongMethodZeroArg;
import org.jruby.ext.ffi.jffi.LongParameterConverter;
import org.jruby.ext.ffi.jffi.LongResultConverter;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FastLongMethodFactory {
    private FastLongMethodFactory() {
    }

    public static final FastLongMethodFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    final boolean isFastLongMethod(Type returnType, Type[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (this.isFastLongParam(parameterTypes[i])) continue;
            return false;
        }
        return parameterTypes.length <= 3 && this.isFastLongResult(returnType);
    }

    final boolean isFastLongResult(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: 
                case INT8: 
                case UINT8: 
                case INT16: 
                case UINT16: 
                case INT32: 
                case UINT32: 
                case INT64: 
                case UINT64: 
                case POINTER: 
                case STRING: 
                case LONG: 
                case ULONG: {
                    return true;
                }
            }
        }
        return false;
    }

    final boolean isFastLongParam(Type paramType) {
        if (paramType instanceof Type.Builtin) {
            switch (paramType.getNativeType()) {
                case INT8: 
                case UINT8: 
                case INT16: 
                case UINT16: 
                case INT32: 
                case UINT32: 
                case INT64: 
                case UINT64: 
                case LONG: 
                case ULONG: {
                    return true;
                }
            }
        }
        return false;
    }

    DynamicMethod createMethod(RubyModule module, Function function, Type returnType, Type[] parameterTypes) {
        LongParameterConverter[] parameterConverters = new LongParameterConverter[parameterTypes.length];
        LongResultConverter resultConverter = this.getLongResultConverter(returnType);
        for (int i = 0; i < parameterConverters.length; ++i) {
            parameterConverters[i] = this.getLongParameterConverter(parameterTypes[i]);
        }
        switch (parameterTypes.length) {
            case 0: {
                return new FastLongMethodZeroArg(module, function, resultConverter, parameterConverters);
            }
            case 1: {
                return new FastLongMethodOneArg(module, function, resultConverter, parameterConverters);
            }
            case 2: {
                return new FastLongMethodTwoArg(module, function, resultConverter, parameterConverters);
            }
            case 3: {
                return new FastLongMethodThreeArg(module, function, resultConverter, parameterConverters);
            }
        }
        throw module.getRuntime().newRuntimeError("Arity " + parameterTypes.length + " not implemented");
    }

    final LongParameterConverter getLongParameterConverter(Type type2) {
        switch (type2.getNativeType()) {
            case INT8: {
                return Signed8ParameterConverter.INSTANCE;
            }
            case UINT8: {
                return Unsigned8ParameterConverter.INSTANCE;
            }
            case INT16: {
                return Signed16ParameterConverter.INSTANCE;
            }
            case UINT16: {
                return Unsigned16ParameterConverter.INSTANCE;
            }
            case INT32: {
                return Signed32ParameterConverter.INSTANCE;
            }
            case UINT32: {
                return Unsigned32ParameterConverter.INSTANCE;
            }
            case INT64: {
                return Signed64ParameterConverter.INSTANCE;
            }
            case UINT64: {
                return Unsigned64ParameterConverter.INSTANCE;
            }
            case FLOAT32: {
                return Float32ParameterConverter.INSTANCE;
            }
            case FLOAT64: {
                return Float64ParameterConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Signed32ParameterConverter.INSTANCE;
                }
                return Signed64ParameterConverter.INSTANCE;
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Unsigned32ParameterConverter.INSTANCE;
                }
                return Unsigned64ParameterConverter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }

    final LongResultConverter getLongResultConverter(Type type2) {
        switch (type2.getNativeType()) {
            case VOID: {
                return VoidResultConverter.INSTANCE;
            }
            case INT8: {
                return Signed8ResultConverter.INSTANCE;
            }
            case UINT8: {
                return Unsigned8ResultConverter.INSTANCE;
            }
            case INT16: {
                return Signed16ResultConverter.INSTANCE;
            }
            case UINT16: {
                return Unsigned16ResultConverter.INSTANCE;
            }
            case INT32: {
                return Signed32ResultConverter.INSTANCE;
            }
            case UINT32: {
                return Unsigned32ResultConverter.INSTANCE;
            }
            case INT64: {
                return Signed64ResultConverter.INSTANCE;
            }
            case UINT64: {
                return Unsigned64ResultConverter.INSTANCE;
            }
            case FLOAT32: {
                return Float32ResultConverter.INSTANCE;
            }
            case FLOAT64: {
                return Float64ResultConverter.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32ResultConverter.INSTANCE : Signed64ResultConverter.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Unsigned32ResultConverter.INSTANCE : Unsigned64ResultConverter.INSTANCE;
            }
            case POINTER: {
                return PointerResultConverter.INSTANCE;
            }
            case STRING: {
                return StringResultConverter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }

    static final class Float64ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Float64ParameterConverter();

        Float64ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Double.doubleToRawLongBits(RubyNumeric.num2dbl(obj));
        }
    }

    static final class Float32ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Float32ParameterConverter();

        Float32ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return (long)Float.floatToRawIntBits((float)RubyNumeric.num2dbl(obj)) & 0xFFFFFFFFL;
        }
    }

    static final class Unsigned64ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Unsigned64ParameterConverter();

        Unsigned64ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.uint64Value(obj);
        }
    }

    static final class Signed64ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Signed64ParameterConverter();

        Signed64ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.int64Value(obj);
        }
    }

    static final class Unsigned32ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Unsigned32ParameterConverter();

        Unsigned32ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.uint32Value(obj);
        }
    }

    static final class Signed32ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Signed32ParameterConverter();

        Signed32ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.int32Value(obj);
        }
    }

    static final class Unsigned16ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Unsigned16ParameterConverter();

        Unsigned16ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.uint16Value(obj);
        }
    }

    static final class Signed16ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Signed16ParameterConverter();

        Signed16ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.int16Value(obj);
        }
    }

    static final class Unsigned8ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Unsigned8ParameterConverter();

        Unsigned8ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.uint8Value(obj);
        }
    }

    static final class Signed8ParameterConverter
    extends BaseParameterConverter {
        public static final LongParameterConverter INSTANCE = new Signed8ParameterConverter();

        Signed8ParameterConverter() {
        }

        public final long longValue(ThreadContext context, IRubyObject obj) {
            return Util.int8Value(obj);
        }
    }

    static abstract class BaseParameterConverter
    implements LongParameterConverter {
        static final MemoryIO IO = MemoryIO.getInstance();

        BaseParameterConverter() {
        }
    }

    static final class StringResultConverter
    implements LongResultConverter {
        private static final MemoryIO IO = MemoryIO.getInstance();
        public static final LongResultConverter INSTANCE = new StringResultConverter();

        StringResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            long address2 = value2 & PointerResultConverter.ADDRESS_MASK;
            if (address2 == 0L) {
                return context.getRuntime().getNil();
            }
            int len = (int)IO.getStringLength(address2);
            if (len == 0) {
                return RubyString.newEmptyString(context.getRuntime());
            }
            byte[] bytes2 = new byte[len];
            IO.getByteArray(address2, bytes2, 0, len);
            RubyString s = RubyString.newStringShared(context.getRuntime(), bytes2);
            s.setTaint(true);
            return s;
        }
    }

    static final class PointerResultConverter
    implements LongResultConverter {
        static final long ADDRESS_MASK = Platform.getPlatform().addressSize() == 32 ? 0xFFFFFFFFL : -1L;
        public static final LongResultConverter INSTANCE = new PointerResultConverter();

        PointerResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            long address2 = value2 & ADDRESS_MASK;
            return new BasePointer(context.getRuntime(), address2 != 0L ? new NativeMemoryIO(address2) : new NullMemoryIO(context.getRuntime()));
        }
    }

    static final class Float64ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Float64ResultConverter();

        Float64ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return context.getRuntime().newFloat(Double.longBitsToDouble(value2));
        }
    }

    static final class Float32ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Float32ResultConverter();

        Float32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return context.getRuntime().newFloat(Float.intBitsToFloat((int)value2));
        }
    }

    static final class Unsigned64ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Unsigned64ResultConverter();

        Unsigned64ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newUnsigned64(context.getRuntime(), value2);
        }
    }

    static final class Signed64ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Signed64ResultConverter();

        Signed64ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newSigned64(context.getRuntime(), value2);
        }
    }

    static final class Unsigned32ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Unsigned32ResultConverter();

        Unsigned32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newUnsigned32(context.getRuntime(), (int)value2);
        }
    }

    static final class Signed32ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Signed32ResultConverter();

        Signed32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newSigned32(context.getRuntime(), (int)value2);
        }
    }

    static final class Unsigned16ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Unsigned16ResultConverter();

        Unsigned16ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newUnsigned16(context.getRuntime(), (short)value2);
        }
    }

    static final class Signed16ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Signed16ResultConverter();

        Signed16ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newSigned16(context.getRuntime(), (short)value2);
        }
    }

    static final class Unsigned8ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Unsigned8ResultConverter();

        Unsigned8ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newUnsigned8(context.getRuntime(), (byte)value2);
        }
    }

    static final class Signed8ResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new Signed8ResultConverter();

        Signed8ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return Util.newSigned8(context.getRuntime(), (byte)value2);
        }
    }

    static final class VoidResultConverter
    implements LongResultConverter {
        public static final LongResultConverter INSTANCE = new VoidResultConverter();

        VoidResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, long value2) {
            return context.getRuntime().getNil();
        }
    }

    private static final class SingletonHolder {
        private static final FastLongMethodFactory INSTANCE = new FastLongMethodFactory();

        private SingletonHolder() {
        }
    }
}

