/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"StructLayoutBuilder"}, parent="Object")
public final class StructLayoutBuilder
extends RubyObject {
    public static final String CLASS_NAME = "StructLayoutBuilder";
    static final int LONG_SIZE = Platform.getPlatform().longSize();
    static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    static final int REGISTER_SIZE = Platform.getPlatform().addressSize();
    static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
    static final int LONG_ALIGN = StructLayoutBuilder.isSparc() ? 64 : LONG_SIZE;
    static final int ADDRESS_ALIGN = StructLayoutBuilder.isSparc() ? 64 : REGISTER_SIZE;
    static final int DOUBLE_ALIGN = StructLayoutBuilder.isSparc() ? 64 : REGISTER_SIZE;
    static final int FLOAT_ALIGN = StructLayoutBuilder.isSparc() ? 64 : 32;
    private final Map<IRubyObject, StructLayout.Member> fields = new LinkedHashMap<IRubyObject, StructLayout.Member>();
    private int size = 0;
    private int minAlign = 1;
    private int fieldCount = 0;
    private boolean isUnion = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSparc() {
        Platform.CPU cpu = Platform.getPlatform().getCPU();
        if (cpu == Platform.CPU.SPARC) return true;
        if (cpu != Platform.CPU.SPARCV9) return false;
        return true;
    }

    public static RubyClass createStructLayoutBuilderClass(Ruby runtime2, RubyModule module) {
        RubyClass result = runtime2.defineClassUnder(CLASS_NAME, runtime2.getObject(), Allocator.INSTANCE, module);
        result.defineAnnotatedMethods(StructLayoutBuilder.class);
        result.defineAnnotatedConstants(StructLayoutBuilder.class);
        return result;
    }

    StructLayoutBuilder(Ruby runtime2) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME));
    }

    StructLayoutBuilder(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static StructLayoutBuilder newInstance(ThreadContext context, IRubyObject recv2) {
        return new StructLayoutBuilder(context.getRuntime());
    }

    @JRubyMethod(name={"build"})
    public StructLayout build(ThreadContext context) {
        return new StructLayout(context.getRuntime(), this.fields, this.minAlign + (this.size - 1 & ~(this.minAlign - 1)), this.minAlign);
    }

    @JRubyMethod(name={"size"})
    public IRubyObject get_size(ThreadContext context) {
        return context.getRuntime().newFixnum(this.size);
    }

    @JRubyMethod(name={"size="})
    public IRubyObject set_size(ThreadContext context, IRubyObject sizeArg) {
        int newSize = RubyNumeric.num2int(sizeArg);
        if (newSize > this.size) {
            this.size = newSize;
        }
        return context.getRuntime().newFixnum(this.size);
    }

    private static final int alignMember(int offset2, int align) {
        return align + (offset2 - 1 & ~(align - 1));
    }

    private static final IRubyObject createSymbolKey(Ruby runtime2, IRubyObject key2) {
        if (key2 instanceof RubySymbol) {
            return key2;
        }
        return runtime2.getSymbolTable().getSymbol(key2.asJavaString());
    }

    private static IRubyObject createStringKey(Ruby runtime2, IRubyObject key2) {
        return RubyString.newString(runtime2, key2.asJavaString());
    }

    private final IRubyObject storeField(Ruby runtime2, IRubyObject name2, StructLayout.Member field2, int align, int size2) {
        this.fields.put(StructLayoutBuilder.createStringKey(runtime2, name2), field2);
        this.fields.put(StructLayoutBuilder.createSymbolKey(runtime2, name2), field2);
        this.size = Math.max(this.size, (int)field2.offset + size2);
        this.minAlign = Math.max(this.minAlign, align);
        return this;
    }

    @JRubyMethod(name={"union="})
    public IRubyObject set_union(ThreadContext context, IRubyObject isUnion) {
        this.isUnion = isUnion.isTrue();
        return this;
    }

    private final int calculateOffset(IRubyObject[] args2, int index2, int alignment) {
        return args2.length > index2 && args2[index2] instanceof RubyInteger ? Util.int32Value(args2[index2]) : (this.isUnion ? 0 : StructLayoutBuilder.alignMember(this.size, alignment));
    }

    @JRubyMethod(name={"add_field"}, required=2, optional=1)
    public IRubyObject add(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (!(args2[0] instanceof RubyString) && !(args2[0] instanceof RubySymbol)) {
            throw runtime2.newTypeError("wrong argument type " + args2[0].getMetaClass().getName() + " (expected String or Symbol)");
        }
        if (!(args2[1] instanceof Type)) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected FFI::Type)");
        }
        Type type2 = (Type)args2[1];
        int offset2 = this.calculateOffset(args2, 2, type2.getNativeAlignment());
        StructLayout.Member field2 = null;
        if (type2 instanceof Type.Builtin) {
            field2 = StructLayoutBuilder.createBuiltinMember((Type.Builtin)type2, this.fieldCount, offset2);
        } else if (type2 instanceof CallbackInfo) {
            field2 = new CallbackMember((CallbackInfo)type2, this.fieldCount, (long)offset2);
        }
        if (field2 == null) {
            throw runtime2.newArgumentError("Unknown field type: " + type2);
        }
        ++this.fieldCount;
        return this.storeField(runtime2, args2[0], field2, type2.getNativeAlignment(), type2.getNativeSize());
    }

    @JRubyMethod(name={"add_struct"}, required=2, optional=1)
    public IRubyObject add_struct(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (!(args2[0] instanceof RubyString) && !(args2[0] instanceof RubySymbol)) {
            throw runtime2.newTypeError("wrong argument type " + args2[0].getMetaClass().getName() + " (expected String or Symbol)");
        }
        if (!(args2[1] instanceof RubyClass) || !((RubyClass)args2[1]).isKindOfModule(runtime2.fastGetModule("FFI").fastGetClass("Struct"))) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected FFI::Struct subclass)");
        }
        StructLayout layout = Struct.getStructLayout(runtime2, args2[1]);
        int offset2 = this.calculateOffset(args2, 2, layout.getNativeAlignment());
        StructMember field2 = new StructMember(layout, (RubyClass)args2[1], this.fieldCount++, offset2);
        return this.storeField(runtime2, args2[0], field2, layout.getNativeAlignment(), layout.getNativeSize());
    }

    @JRubyMethod(name={"add_array"}, required=3, optional=1)
    public IRubyObject add_array(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (!(args2[0] instanceof RubyString) && !(args2[0] instanceof RubySymbol)) {
            throw runtime2.newTypeError("wrong argument type " + args2[0].getMetaClass().getName() + " (expected String or Symbol)");
        }
        if (!(args2[1] instanceof Type)) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected FFI::Type)");
        }
        if (!(args2[2] instanceof RubyInteger)) {
            throw runtime2.newTypeError("wrong argument type " + args2[2].getMetaClass().getName() + " (expected Integer)");
        }
        Type type2 = (Type)args2[1];
        int offset2 = this.calculateOffset(args2, 3, type2.getNativeAlignment());
        int length2 = Util.int32Value(args2[2]);
        MemoryOp io2 = MemoryOp.getMemoryOp(type2.getNativeType());
        if (io2 == null) {
            throw context.getRuntime().newNotImplementedError("Unsupported array field type: " + type2);
        }
        ArrayMember field2 = new ArrayMember(type2, this.fieldCount++, offset2, io2, length2);
        return this.storeField(runtime2, args2[0], field2, type2.getNativeAlignment(), type2.getNativeSize() * length2);
    }

    @JRubyMethod(name={"add_char_array"}, required=2, optional=1)
    public IRubyObject add_char_array(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (!(args2[0] instanceof RubyString) && !(args2[0] instanceof RubySymbol)) {
            throw runtime2.newTypeError("wrong argument type " + args2[0].getMetaClass().getName() + " (expected String or Symbol)");
        }
        if (!(args2[1] instanceof RubyInteger)) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected Integer)");
        }
        int strlen = Util.int32Value(args2[1]);
        int offset2 = this.calculateOffset(args2, 2, 1);
        Type type2 = (Type)context.getRuntime().fastGetModule("FFI").fastGetClass("Type").fastFetchConstant("INT8");
        return this.storeField(runtime2, args2[0], new CharArrayMember(type2, this.fieldCount++, offset2, strlen), 1, strlen);
    }

    static StructLayout.Member createBuiltinMember(Type.Builtin type2, int index2, long offset2) {
        switch (type2.getNativeType()) {
            case INT8: 
            case UINT8: 
            case INT16: 
            case UINT16: 
            case INT32: 
            case UINT32: 
            case INT64: 
            case UINT64: 
            case LONG: 
            case ULONG: 
            case FLOAT32: 
            case FLOAT64: {
                return new PrimitiveMember(type2, index2, offset2);
            }
            case POINTER: {
                return new PointerMember(type2, index2, offset2);
            }
            case STRING: 
            case RBXSTRING: {
                return new StringMember(type2, index2, offset2);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ArrayMember
    extends StructLayout.Member
    implements StructLayout.Aggregate {
        private final MemoryOp op;
        private final int length;

        ArrayMember(Type type2, int index2, long offset2, MemoryOp op, int length2) {
            super(type2, index2, offset2);
            this.op = op;
            this.length = length2;
        }

        @Override
        public void put(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr, IRubyObject value2) {
            throw runtime2.newNotImplementedError("Cannot set Array fields");
        }

        @Override
        public IRubyObject get(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr) {
            IRubyObject s = cache.getCachedValue(this);
            if (s == null) {
                s = new StructLayout.Array(runtime2, ptr, this.offset, this.length, this.type.getNativeSize(), this.op);
                cache.putCachedValue(this, s);
            }
            return s;
        }

        @Override
        protected boolean isCacheable() {
            return true;
        }

        @Override
        public Collection<StructLayout.Member> getMembers() {
            ArrayList<StructLayout.Member> members2 = new ArrayList<StructLayout.Member>(this.length);
            for (int i = 0; i < this.length; ++i) {
                members2.add(new PrimitiveMember(this.type, i, i * this.type.getNativeSize()));
            }
            return members2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StructMember
    extends StructLayout.Member
    implements StructLayout.Aggregate {
        private final RubyClass klass;
        private final StructLayout layout;

        StructMember(StructLayout layout, RubyClass klass, int index2, long offset2) {
            super(layout, index2, offset2);
            this.klass = klass;
            this.layout = layout;
        }

        @Override
        public void put(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr, IRubyObject value2) {
            throw runtime2.newNotImplementedError("Cannot set Struct fields");
        }

        @Override
        public IRubyObject get(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr) {
            IRubyObject s = cache.getCachedValue(this);
            if (s == null) {
                s = Struct.newStruct(runtime2, this.klass, ((AbstractMemory)ptr).slice(runtime2, this.getOffset(ptr)));
                cache.putCachedValue(this, s);
            }
            return s;
        }

        @Override
        protected boolean isCacheable() {
            return true;
        }

        @Override
        protected boolean isValueReferenceNeeded() {
            return true;
        }

        @Override
        public Collection<StructLayout.Member> getMembers() {
            return this.layout.getFields();
        }
    }

    static final class CallbackMember
    extends StructLayout.Member {
        private final CallbackInfo cbInfo;

        CallbackMember(CallbackInfo cbInfo, int index2, long offset2) {
            super(cbInfo, index2, offset2);
            this.cbInfo = cbInfo;
        }

        protected boolean isCacheable() {
            return true;
        }

        protected boolean isValueReferenceNeeded() {
            return true;
        }

        public void put(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr, IRubyObject value2) {
            if (value2.isNil()) {
                CallbackMember.getMemoryIO(ptr).putAddress(this.getOffset(ptr), 0L);
            } else {
                Pointer cb = Factory.getInstance().getCallbackManager().getCallback(runtime2, this.cbInfo, value2);
                CallbackMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), cb.getMemoryIO());
                cache.putCachedValue(this, cb);
                cache.putReference(this, cb);
            }
        }

        public IRubyObject get(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr) {
            throw runtime2.newNotImplementedError("Cannot get callback struct fields");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CharArrayMember
    extends StructLayout.Member
    implements StructLayout.Aggregate {
        private final int length;

        CharArrayMember(Type type2, int index2, long offset2, int size2) {
            super(type2, index2, offset2);
            this.length = size2;
        }

        @Override
        public void put(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr, IRubyObject value2) {
            MemoryIO io2 = CharArrayMember.getMemoryIO(ptr);
            ByteList bl = value2.convertToString().getByteList();
            int len = Math.min(bl.length(), this.length - 1);
            io2.put(this.getOffset(ptr), bl.unsafeBytes(), bl.begin(), len);
            io2.putByte(this.getOffset(ptr) + (long)len, (byte)0);
        }

        @Override
        public IRubyObject get(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr) {
            MemoryIO io2 = CharArrayMember.getMemoryIO(ptr);
            int len = io2.indexOf(this.getOffset(ptr), (byte)0, this.length);
            if (len < 0) {
                len = this.length;
            }
            ByteList bl = new ByteList(len);
            bl.length(len);
            io2.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime2.newString(bl);
        }

        @Override
        public Collection<StructLayout.Member> getMembers() {
            ArrayList<StructLayout.Member> members2 = new ArrayList<StructLayout.Member>(this.length);
            for (int i = 0; i < this.length; ++i) {
                members2.add(new PrimitiveMember(this.type, i, i * this.type.getNativeSize()));
            }
            return members2;
        }
    }

    static final class StringMember
    extends StructLayout.Member {
        StringMember(Type type2, int index2, long offset2) {
            super(type2, index2, offset2);
        }

        protected boolean isCacheable() {
            return true;
        }

        protected boolean isValueReferenceNeeded() {
            return true;
        }

        public IRubyObject get(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr) {
            DirectMemoryIO io2 = StringMember.getMemoryIO(ptr).getMemoryIO(this.getOffset(ptr));
            if (io2 == null || io2.isNull()) {
                return runtime2.getNil();
            }
            int len = io2.indexOf(0L, (byte)0, Integer.MAX_VALUE);
            ByteList bl = new ByteList(len);
            bl.length(len);
            io2.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime2.newString(bl);
        }

        public void put(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr, IRubyObject value2) {
            ByteList bl = value2.convertToString().getByteList();
            MemoryPointer mem = MemoryPointer.allocate(runtime2, 1, bl.length() + 1, false);
            cache.putReference(this, mem);
            MemoryIO io2 = mem.getMemoryIO();
            io2.put(0L, bl.unsafeBytes(), bl.begin(), bl.length());
            io2.putByte(bl.length(), (byte)0);
            StringMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), io2);
        }
    }

    static final class PointerMember
    extends StructLayout.Member {
        PointerMember(Type type2, int index2, long offset2) {
            super(type2, index2, offset2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void put(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr, IRubyObject value2) {
            if (value2 instanceof Pointer) {
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), ((Pointer)value2).getMemoryIO());
            } else if (value2 instanceof Struct) {
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), ((Struct)value2).getMemoryIO());
            } else if (value2 instanceof RubyInteger) {
                PointerMember.getMemoryIO(ptr).putAddress(this.offset, Util.int64Value(ptr));
            } else if (value2.respondsTo("to_ptr")) {
                IRubyObject addr2 = value2.callMethod(runtime2.getCurrentContext(), "to_ptr");
                if (!(addr2 instanceof Pointer)) throw runtime2.newArgumentError("Invalid pointer value");
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.offset, ((Pointer)addr2).getMemoryIO());
            } else {
                if (!value2.isNil()) throw runtime2.newArgumentError("Invalid pointer value");
                PointerMember.getMemoryIO(ptr).putAddress(this.offset, 0L);
            }
            cache.putReference(this, value2);
        }

        public IRubyObject get(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr) {
            DirectMemoryIO memory = ((AbstractMemory)ptr).getMemoryIO().getMemoryIO(this.getOffset(ptr));
            IRubyObject old = cache.getCachedValue(this);
            if (old instanceof Pointer) {
                MemoryIO oldMemory = ((Pointer)old).getMemoryIO();
                if (memory != null && memory.equals(oldMemory) || memory == null && oldMemory.isNull()) {
                    return old;
                }
            }
            BasePointer retval = new BasePointer(runtime2, memory != null ? memory : new NullMemoryIO(runtime2));
            cache.putCachedValue(this, retval);
            return retval;
        }

        protected boolean isCacheable() {
            return true;
        }

        protected boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class PrimitiveMember
    extends StructLayout.Member {
        private final MemoryOp op;

        PrimitiveMember(Type type2, int index2, long offset2) {
            super(type2, index2, offset2);
            this.op = MemoryOp.getMemoryOp(type2.getNativeType());
        }

        public void put(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr, IRubyObject value2) {
            this.op.put(runtime2, PrimitiveMember.getMemoryIO(ptr), this.offset, value2);
        }

        public IRubyObject get(Ruby runtime2, StructLayout.Storage cache, IRubyObject ptr) {
            return this.op.get(runtime2, PrimitiveMember.getMemoryIO(ptr), this.offset);
        }
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StructLayoutBuilder(runtime2, klass);
        }
    }
}

