/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.executable;

import java.math.BigInteger;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.executable.Script;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.ByteList;

public abstract class AbstractScript
implements Script {
    public static final int NUMBERED_SCOPE_COUNT = 10;
    public static final int NUMBERED_CALLSITE_COUNT = 10;
    public static final int NUMBERED_BLOCKBODY_COUNT = 10;
    public static final int NUMBERED_BLOCKCALLBACK_COUNT = 10;
    public static final int NUMBERED_SYMBOL_COUNT = 10;
    public static final int NUMBERED_STRING_COUNT = 10;
    public static final int NUMBERED_FIXNUM_COUNT = 10;
    public static final int NUMBERED_REGEXP_COUNT = 10;
    public static final int NUMBERED_BIGINTEGER_COUNT = 10;
    public static final int NUMBERED_VARIABLEREADER_COUNT = 10;
    public static final int NUMBERED_VARIABLEWRITER_COUNT = 10;
    public static final int NUMBERED_CONSTANT_COUNT = 10;
    public static final int NUMBERED_CONSTANTFROM_COUNT = 10;
    public static final int NUMBERED_METHOD_COUNT = 10;
    public StaticScope[] scopes;
    public CallSite[] callSites;
    public CacheEntry[] methodCache = new CacheEntry[100];
    public BlockBody[] blockBodies;
    public CompiledBlockCallback[] blockCallbacks;
    public RubySymbol[] symbols;
    public ByteList[] byteLists;
    public RubyFixnum[] fixnums;
    public RubyRegexp[] regexps;
    public BigInteger[] bigIntegers;
    public RubyClass.VariableAccessor[] variableReaders;
    public RubyClass.VariableAccessor[] variableWriters;
    public String filename;
    public IRubyObject[] constants;
    public int[] constantGenerations;
    public int[] constantTargetHashes;

    public AbstractScript() {
        Arrays.fill(this.methodCache, CacheEntry.NULL_CACHE);
    }

    public IRubyObject __file__(ThreadContext context, IRubyObject self, Block block) {
        return this.__file__(context, self, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject __file__(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        return this.__file__(context, self, new IRubyObject[]{arg2}, block);
    }

    public IRubyObject __file__(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.__file__(context, self, new IRubyObject[]{arg1, arg2}, block);
    }

    public IRubyObject __file__(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.__file__(context, self, new IRubyObject[]{arg1, arg2, arg3}, block);
    }

    public IRubyObject load(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return null;
    }

    public IRubyObject run(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return this.__file__(context, self, args2, block);
    }

    public final StaticScope getScope(ThreadContext context, String varNamesDescriptor, int index2) {
        StaticScope scope = this.scopes[index2];
        if (scope == null) {
            String[] varNames = varNamesDescriptor.split(";");
            for (int i = 0; i < varNames.length; ++i) {
                varNames[i] = varNames[i].intern();
            }
            scope = this.scopes[index2] = new LocalStaticScope(context.getCurrentScope().getStaticScope(), varNames);
        }
        return scope;
    }

    public final StaticScope getScope0(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 0);
    }

    public final StaticScope getScope1(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 1);
    }

    public final StaticScope getScope2(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 2);
    }

    public final StaticScope getScope3(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 3);
    }

    public final StaticScope getScope4(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 4);
    }

    public final StaticScope getScope5(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 5);
    }

    public final StaticScope getScope6(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 6);
    }

    public final StaticScope getScope7(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 7);
    }

    public final StaticScope getScope8(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 8);
    }

    public final StaticScope getScope9(ThreadContext context, String varNamesDescriptor) {
        return this.getScope(context, varNamesDescriptor, 9);
    }

    public final CallSite getCallSite(int index2) {
        return this.callSites[index2];
    }

    public final CallSite getCallSite0() {
        return this.callSites[0];
    }

    public final CallSite getCallSite1() {
        return this.callSites[1];
    }

    public final CallSite getCallSite2() {
        return this.callSites[2];
    }

    public final CallSite getCallSite3() {
        return this.callSites[3];
    }

    public final CallSite getCallSite4() {
        return this.callSites[4];
    }

    public final CallSite getCallSite5() {
        return this.callSites[5];
    }

    public final CallSite getCallSite6() {
        return this.callSites[6];
    }

    public final CallSite getCallSite7() {
        return this.callSites[7];
    }

    public final CallSite getCallSite8() {
        return this.callSites[8];
    }

    public final CallSite getCallSite9() {
        return this.callSites[9];
    }

    public final BlockBody getBlockBody(ThreadContext context, int index2, String descriptor) {
        BlockBody body = this.blockBodies[index2];
        if (body == null) {
            return this.createBlockBody(context, index2, descriptor);
        }
        return body;
    }

    public final BlockBody getBlockBody0(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 0, descriptor);
    }

    public final BlockBody getBlockBody1(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 1, descriptor);
    }

    public final BlockBody getBlockBody2(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 2, descriptor);
    }

    public final BlockBody getBlockBody3(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 3, descriptor);
    }

    public final BlockBody getBlockBody4(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 4, descriptor);
    }

    public final BlockBody getBlockBody5(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 5, descriptor);
    }

    public final BlockBody getBlockBody6(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 6, descriptor);
    }

    public final BlockBody getBlockBody7(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 7, descriptor);
    }

    public final BlockBody getBlockBody8(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 8, descriptor);
    }

    public final BlockBody getBlockBody9(ThreadContext context, String descriptor) {
        return this.getBlockBody(context, 9, descriptor);
    }

    public final BlockBody getBlockBody19(ThreadContext context, int index2, String descriptor) {
        BlockBody body = this.blockBodies[index2];
        if (body == null) {
            return this.createBlockBody19(context, index2, descriptor);
        }
        return body;
    }

    public final BlockBody getBlockBody190(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 0, descriptor);
    }

    public final BlockBody getBlockBody191(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 1, descriptor);
    }

    public final BlockBody getBlockBody192(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 2, descriptor);
    }

    public final BlockBody getBlockBody193(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 3, descriptor);
    }

    public final BlockBody getBlockBody194(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 4, descriptor);
    }

    public final BlockBody getBlockBody195(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 5, descriptor);
    }

    public final BlockBody getBlockBody196(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 6, descriptor);
    }

    public final BlockBody getBlockBody197(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 7, descriptor);
    }

    public final BlockBody getBlockBody198(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 8, descriptor);
    }

    public final BlockBody getBlockBody199(ThreadContext context, String descriptor) {
        return this.getBlockBody19(context, 9, descriptor);
    }

    public final CompiledBlockCallback getBlockCallback(Ruby runtime2, int index2, String method2) {
        CompiledBlockCallback callback = this.blockCallbacks[index2];
        if (callback == null) {
            return this.createCompiledBlockCallback(runtime2, index2, method2);
        }
        return callback;
    }

    public final CompiledBlockCallback getBlockCallback0(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 0, method2);
    }

    public final CompiledBlockCallback getBlockCallback1(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 1, method2);
    }

    public final CompiledBlockCallback getBlockCallback2(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 2, method2);
    }

    public final CompiledBlockCallback getBlockCallback3(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 3, method2);
    }

    public final CompiledBlockCallback getBlockCallback4(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 4, method2);
    }

    public final CompiledBlockCallback getBlockCallback5(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 5, method2);
    }

    public final CompiledBlockCallback getBlockCallback6(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 6, method2);
    }

    public final CompiledBlockCallback getBlockCallback7(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 7, method2);
    }

    public final CompiledBlockCallback getBlockCallback8(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 8, method2);
    }

    public final CompiledBlockCallback getBlockCallback9(Ruby runtime2, String method2) {
        return this.getBlockCallback(runtime2, 9, method2);
    }

    public final RubySymbol getSymbol(Ruby runtime2, int index2, String name2) {
        RubySymbol symbol = this.symbols[index2];
        if (symbol == null) {
            this.symbols[index2] = runtime2.newSymbol(name2);
            return this.symbols[index2];
        }
        return symbol;
    }

    public final RubySymbol getSymbol0(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 0, name2);
    }

    public final RubySymbol getSymbol1(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 1, name2);
    }

    public final RubySymbol getSymbol2(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 2, name2);
    }

    public final RubySymbol getSymbol3(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 3, name2);
    }

    public final RubySymbol getSymbol4(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 4, name2);
    }

    public final RubySymbol getSymbol5(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 5, name2);
    }

    public final RubySymbol getSymbol6(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 6, name2);
    }

    public final RubySymbol getSymbol7(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 7, name2);
    }

    public final RubySymbol getSymbol8(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 8, name2);
    }

    public final RubySymbol getSymbol9(Ruby runtime2, String name2) {
        return this.getSymbol(runtime2, 9, name2);
    }

    public final RubyString getString(Ruby runtime2, int index2) {
        return RubyString.newStringShared(runtime2, this.byteLists[index2]);
    }

    public static ByteList[] createByteList(ByteList[] byteLists, int index2, String str) {
        byteLists[index2] = ByteList.create(str);
        return byteLists;
    }

    public final RubyString getString0(Ruby runtime2) {
        return this.getString(runtime2, 0);
    }

    public final RubyString getString1(Ruby runtime2) {
        return this.getString(runtime2, 1);
    }

    public final RubyString getString2(Ruby runtime2) {
        return this.getString(runtime2, 2);
    }

    public final RubyString getString3(Ruby runtime2) {
        return this.getString(runtime2, 3);
    }

    public final RubyString getString4(Ruby runtime2) {
        return this.getString(runtime2, 4);
    }

    public final RubyString getString5(Ruby runtime2) {
        return this.getString(runtime2, 5);
    }

    public final RubyString getString6(Ruby runtime2) {
        return this.getString(runtime2, 6);
    }

    public final RubyString getString7(Ruby runtime2) {
        return this.getString(runtime2, 7);
    }

    public final RubyString getString8(Ruby runtime2) {
        return this.getString(runtime2, 8);
    }

    public final RubyString getString9(Ruby runtime2) {
        return this.getString(runtime2, 9);
    }

    public final RubyFixnum getFixnum(Ruby runtime2, int index2, int value2) {
        RubyFixnum fixnum = this.fixnums[index2];
        if (fixnum == null) {
            this.fixnums[index2] = RubyFixnum.newFixnum(runtime2, value2);
            return this.fixnums[index2];
        }
        return fixnum;
    }

    public final RubyFixnum getFixnum0(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 0, value2);
    }

    public final RubyFixnum getFixnum1(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 1, value2);
    }

    public final RubyFixnum getFixnum2(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 2, value2);
    }

    public final RubyFixnum getFixnum3(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 3, value2);
    }

    public final RubyFixnum getFixnum4(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 4, value2);
    }

    public final RubyFixnum getFixnum5(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 5, value2);
    }

    public final RubyFixnum getFixnum6(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 6, value2);
    }

    public final RubyFixnum getFixnum7(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 7, value2);
    }

    public final RubyFixnum getFixnum8(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 8, value2);
    }

    public final RubyFixnum getFixnum9(Ruby runtime2, int value2) {
        return this.getFixnum(runtime2, 9, value2);
    }

    public final RubyFixnum getFixnum(Ruby runtime2, int index2, long value2) {
        RubyFixnum fixnum = this.fixnums[index2];
        if (fixnum == null) {
            this.fixnums[index2] = RubyFixnum.newFixnum(runtime2, value2);
            return this.fixnums[index2];
        }
        return fixnum;
    }

    public final RubyRegexp getRegexp(Ruby runtime2, int index2, String pattern, int options2) {
        RubyRegexp regexp2 = this.regexps[index2];
        if (regexp2 == null) {
            regexp2 = RubyRegexp.newRegexp(runtime2, pattern, options2);
            regexp2.setLiteral();
            this.regexps[index2] = regexp2;
        }
        return regexp2;
    }

    public final RubyRegexp getRegexp0(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 0, name2, options2);
    }

    public final RubyRegexp getRegexp1(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 1, name2, options2);
    }

    public final RubyRegexp getRegexp2(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 2, name2, options2);
    }

    public final RubyRegexp getRegexp3(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 3, name2, options2);
    }

    public final RubyRegexp getRegexp4(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 4, name2, options2);
    }

    public final RubyRegexp getRegexp5(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 5, name2, options2);
    }

    public final RubyRegexp getRegexp6(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 6, name2, options2);
    }

    public final RubyRegexp getRegexp7(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 7, name2, options2);
    }

    public final RubyRegexp getRegexp8(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 8, name2, options2);
    }

    public final RubyRegexp getRegexp9(Ruby runtime2, String name2, int options2) {
        return this.getRegexp(runtime2, 9, name2, options2);
    }

    public final RubyRegexp getRegexp(int index2) {
        return this.regexps[index2];
    }

    public final void cacheRegexp(Ruby runtime2, int index2, ByteList pattern, int options2) {
        RubyRegexp regexp2 = this.regexps[index2];
        if (regexp2 == null) {
            this.regexps[index2] = regexp2 = RubyRegexp.newRegexp(runtime2, pattern, options2);
        }
    }

    public final BigInteger getBigInteger(Ruby runtime2, int index2, String pattern) {
        BigInteger bigint = this.bigIntegers[index2];
        if (bigint == null) {
            this.bigIntegers[index2] = new BigInteger(pattern, 16);
            return this.bigIntegers[index2];
        }
        return bigint;
    }

    public final BigInteger getBigInteger0(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 0, name2);
    }

    public final BigInteger getBigInteger1(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 1, name2);
    }

    public final BigInteger getBigInteger2(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 2, name2);
    }

    public final BigInteger getBigInteger3(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 3, name2);
    }

    public final BigInteger getBigInteger4(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 4, name2);
    }

    public final BigInteger getBigInteger5(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 5, name2);
    }

    public final BigInteger getBigInteger6(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 6, name2);
    }

    public final BigInteger getBigInteger7(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 7, name2);
    }

    public final BigInteger getBigInteger8(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 8, name2);
    }

    public final BigInteger getBigInteger9(Ruby runtime2, String name2) {
        return this.getBigInteger(runtime2, 9, name2);
    }

    public final IRubyObject getVariable(Ruby runtime2, int index2, String name2, IRubyObject object) {
        IRubyObject value2;
        RubyClass.VariableAccessor variableAccessor = this.variableReaders[index2];
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.variableReaders[index2] = variableAccessor = cls.getVariableAccessorForRead(name2);
        }
        if ((value2 = (IRubyObject)variableAccessor.get(object)) != null) {
            return value2;
        }
        if (runtime2.isVerbose()) {
            this.warnAboutUninitializedIvar(runtime2, name2);
        }
        return runtime2.getNil();
    }

    private void warnAboutUninitializedIvar(Ruby runtime2, String name2) {
        runtime2.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + name2 + " not initialized", new Object[0]);
    }

    public final IRubyObject getVariable0(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 0, name2, object);
    }

    public final IRubyObject getVariable1(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 1, name2, object);
    }

    public final IRubyObject getVariable2(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 2, name2, object);
    }

    public final IRubyObject getVariable3(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 3, name2, object);
    }

    public final IRubyObject getVariable4(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 4, name2, object);
    }

    public final IRubyObject getVariable5(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 5, name2, object);
    }

    public final IRubyObject getVariable6(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 6, name2, object);
    }

    public final IRubyObject getVariable7(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 7, name2, object);
    }

    public final IRubyObject getVariable8(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 8, name2, object);
    }

    public final IRubyObject getVariable9(Ruby runtime2, String name2, IRubyObject object) {
        return this.getVariable(runtime2, 9, name2, object);
    }

    public final IRubyObject setVariable(Ruby runtime2, int index2, String name2, IRubyObject object, IRubyObject value2) {
        RubyClass.VariableAccessor variableAccessor = this.variableWriters[index2];
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.variableWriters[index2] = variableAccessor = cls.getVariableAccessorForWrite(name2);
        }
        variableAccessor.set(object, value2);
        return value2;
    }

    public final IRubyObject setVariable0(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 0, name2, object, value2);
    }

    public final IRubyObject setVariable1(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 1, name2, object, value2);
    }

    public final IRubyObject setVariable2(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 2, name2, object, value2);
    }

    public final IRubyObject setVariable3(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 3, name2, object, value2);
    }

    public final IRubyObject setVariable4(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 4, name2, object, value2);
    }

    public final IRubyObject setVariable5(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 5, name2, object, value2);
    }

    public final IRubyObject setVariable6(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 6, name2, object, value2);
    }

    public final IRubyObject setVariable7(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 7, name2, object, value2);
    }

    public final IRubyObject setVariable8(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 8, name2, object, value2);
    }

    public final IRubyObject setVariable9(Ruby runtime2, String name2, IRubyObject object, IRubyObject value2) {
        return this.setVariable(runtime2, 9, name2, object, value2);
    }

    public final void initScopes(int size2) {
        this.scopes = new StaticScope[size2];
    }

    public final void initCallSites(int size2) {
        this.callSites = new CallSite[size2];
    }

    public final void initBlockBodies(int size2) {
        this.blockBodies = new BlockBody[size2];
    }

    public final void initBlockCallbacks(int size2) {
        this.blockCallbacks = new CompiledBlockCallback[size2];
    }

    public final void initSymbols(int size2) {
        this.symbols = new RubySymbol[size2];
    }

    public final ByteList[] initStrings(int size2) {
        this.byteLists = new ByteList[size2];
        return this.byteLists;
    }

    public final void initFixnums(int size2) {
        this.fixnums = new RubyFixnum[size2];
    }

    public final void initRegexps(int size2) {
        this.regexps = new RubyRegexp[size2];
    }

    public final void initBigIntegers(int size2) {
        this.bigIntegers = new BigInteger[size2];
    }

    public final void initConstants(int size2) {
        this.constants = new IRubyObject[size2];
        this.constantTargetHashes = new int[size2];
        this.constantGenerations = new int[size2];
        Arrays.fill(this.constantGenerations, -1);
        Arrays.fill(this.constantTargetHashes, -1);
    }

    public final void initVariableReaders(int size2) {
        this.variableReaders = new RubyClass.VariableAccessor[size2];
        Arrays.fill(this.variableReaders, RubyClass.VariableAccessor.DUMMY_ACCESSOR);
    }

    public final void initVariableWriters(int size2) {
        this.variableWriters = new RubyClass.VariableAccessor[size2];
        Arrays.fill(this.variableWriters, RubyClass.VariableAccessor.DUMMY_ACCESSOR);
    }

    public final void initMethodCache(int size2) {
        this.methodCache = new CacheEntry[size2];
        Arrays.fill(this.methodCache, CacheEntry.NULL_CACHE);
    }

    public static CallSite[] setCallSite(CallSite[] callSites, int index2, String name2) {
        callSites[index2] = MethodIndex.getCallSite(name2);
        return callSites;
    }

    public static CallSite[] setFunctionalCallSite(CallSite[] callSites, int index2, String name2) {
        callSites[index2] = MethodIndex.getFunctionalCallSite(name2);
        return callSites;
    }

    public static CallSite[] setVariableCallSite(CallSite[] callSites, int index2, String name2) {
        callSites[index2] = MethodIndex.getVariableCallSite(name2);
        return callSites;
    }

    public static CallSite[] setSuperCallSite(CallSite[] callSites, int index2) {
        callSites[index2] = MethodIndex.getSuperCallSite();
        return callSites;
    }

    public final void setFilename(String filename2) {
        this.filename = filename2;
    }

    public final IRubyObject getConstant(ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.getValue(context, name2, index2);
        return value2 != null ? value2 : context.getRubyClass().callMethod(context, "const_missing", context.getRuntime().fastNewSymbol(name2));
    }

    public final IRubyObject getConstant0(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 0);
    }

    public final IRubyObject getConstant1(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 1);
    }

    public final IRubyObject getConstant2(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 2);
    }

    public final IRubyObject getConstant3(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 3);
    }

    public final IRubyObject getConstant4(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 4);
    }

    public final IRubyObject getConstant5(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 5);
    }

    public final IRubyObject getConstant6(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 6);
    }

    public final IRubyObject getConstant7(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 7);
    }

    public final IRubyObject getConstant8(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 8);
    }

    public final IRubyObject getConstant9(ThreadContext context, String name2) {
        return this.getConstant(context, name2, 9);
    }

    public IRubyObject getValue(ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.constants[index2];
        return this.isCached(context, value2, index2) ? value2 : this.reCache(context, name2, index2);
    }

    private boolean isCached(ThreadContext context, IRubyObject value2, int index2) {
        return value2 != null && this.constantGenerations[index2] == context.getRuntime().getConstantGeneration();
    }

    public IRubyObject reCache(ThreadContext context, String name2, int index2) {
        IRubyObject value2;
        int newGeneration = context.getRuntime().getConstantGeneration();
        this.constants[index2] = value2 = context.getConstant(name2);
        if (value2 != null) {
            this.constantGenerations[index2] = newGeneration;
        }
        return value2;
    }

    public final IRubyObject getConstantFrom(RubyModule target, ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.getValueFrom(target, context, name2, index2);
        return value2 != null ? value2 : target.fastGetConstantFromConstMissing(name2);
    }

    public final IRubyObject getConstantFrom0(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 0);
    }

    public final IRubyObject getConstantFrom1(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 1);
    }

    public final IRubyObject getConstantFrom2(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 2);
    }

    public final IRubyObject getConstantFrom3(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 3);
    }

    public final IRubyObject getConstantFrom4(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 4);
    }

    public final IRubyObject getConstantFrom5(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 5);
    }

    public final IRubyObject getConstantFrom6(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 6);
    }

    public final IRubyObject getConstantFrom7(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 7);
    }

    public final IRubyObject getConstantFrom8(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 8);
    }

    public final IRubyObject getConstantFrom9(RubyModule target, ThreadContext context, String name2) {
        return this.getConstantFrom(target, context, name2, 9);
    }

    public IRubyObject getValueFrom(RubyModule target, ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.constants[index2];
        return this.isCachedFrom(target, context, value2, index2) ? value2 : this.reCacheFrom(target, context, name2, index2);
    }

    private boolean isCachedFrom(RubyModule target, ThreadContext context, IRubyObject value2, int index2) {
        return value2 != null && this.constantGenerations[index2] == context.getRuntime().getConstantGeneration() && this.constantTargetHashes[index2] == target.hashCode();
    }

    public IRubyObject reCacheFrom(RubyModule target, ThreadContext context, String name2, int index2) {
        IRubyObject value2;
        int newGeneration = context.getRuntime().getConstantGeneration();
        this.constants[index2] = value2 = target.fastGetConstantFromNoConstMissing(name2);
        if (value2 != null) {
            this.constantGenerations[index2] = newGeneration;
            this.constantTargetHashes[index2] = target.hashCode();
        }
        return value2;
    }

    private BlockBody createBlockBody(ThreadContext context, int index2, String descriptor) throws NumberFormatException {
        BlockBody body;
        String[] secondSplit;
        String[] firstSplit = descriptor.split(",");
        if (firstSplit[2].length() == 0) {
            secondSplit = new String[]{};
        } else {
            secondSplit = firstSplit[2].split(";");
            for (int i = 0; i < secondSplit.length; ++i) {
                secondSplit[i] = secondSplit[i].intern();
            }
        }
        this.blockBodies[index2] = body = RuntimeHelpers.createCompiledBlockBody(context, this, firstSplit[0], Integer.parseInt(firstSplit[1]), secondSplit, Boolean.valueOf(firstSplit[3]), Integer.parseInt(firstSplit[4]), Boolean.valueOf(firstSplit[5]));
        return this.blockBodies[index2];
    }

    private BlockBody createBlockBody19(ThreadContext context, int index2, String descriptor) throws NumberFormatException {
        BlockBody body;
        String[] secondSplit;
        String[] firstSplit = descriptor.split(",");
        if (firstSplit[2].length() == 0) {
            secondSplit = new String[]{};
        } else {
            secondSplit = firstSplit[2].split(";");
            for (int i = 0; i < secondSplit.length; ++i) {
                secondSplit[i] = secondSplit[i].intern();
            }
        }
        this.blockBodies[index2] = body = RuntimeHelpers.createCompiledBlockBody19(context, this, firstSplit[0], Integer.parseInt(firstSplit[1]), secondSplit, Boolean.valueOf(firstSplit[3]), Integer.parseInt(firstSplit[4]), Boolean.valueOf(firstSplit[5]));
        return this.blockBodies[index2];
    }

    private CompiledBlockCallback createCompiledBlockCallback(Ruby runtime2, int index2, String method2) {
        CompiledBlockCallback callback;
        this.blockCallbacks[index2] = callback = RuntimeHelpers.createBlockCallback(runtime2, this, method2);
        return this.blockCallbacks[index2];
    }

    protected DynamicMethod getMethod(ThreadContext context, IRubyObject self, int index2, String methodName) {
        RubyClass selfType = AbstractScript.pollAndGetClass(context, self);
        CacheEntry myCache = this.getCacheEntry(index2);
        if (myCache.typeOk(selfType)) {
            return myCache.method;
        }
        return this.cacheAndGet(context, selfType, index2, methodName);
    }

    private DynamicMethod cacheAndGet(ThreadContext context, RubyClass selfType, int index2, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return RuntimeHelpers.selectMethodMissing(context, selfType, method2.getVisibility(), methodName, CallType.FUNCTIONAL);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    private static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    private CacheEntry getCacheEntry(int index2) {
        return this.methodCache[index2];
    }

    protected DynamicMethod getMethod0(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 0, methodName);
    }

    protected DynamicMethod getMethod1(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 1, methodName);
    }

    protected DynamicMethod getMethod2(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 2, methodName);
    }

    protected DynamicMethod getMethod3(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 3, methodName);
    }

    protected DynamicMethod getMethod4(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 4, methodName);
    }

    protected DynamicMethod getMethod5(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 5, methodName);
    }

    protected DynamicMethod getMethod6(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 6, methodName);
    }

    protected DynamicMethod getMethod7(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 7, methodName);
    }

    protected DynamicMethod getMethod8(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 8, methodName);
    }

    protected DynamicMethod getMethod9(ThreadContext context, IRubyObject self, String methodName) {
        return this.getMethod(context, self, 9, methodName);
    }
}

