/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Pack {
    private static final String sSp10 = "          ";
    private static final String sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final int IS_STAR = -1;
    private static final String NATIVE_CODES = "sSiIlL";
    private static final String sTooFew = "too few arguments";
    private static final byte[] hex_table;
    private static final byte[] uu_table;
    private static final byte[] b64_table;
    private static final byte[] sHexDigits;
    private static final int[] b64_xtable;
    private static final Converter[] converters;
    private static final BigInteger QUAD_MIN;
    private static final BigInteger QUAD_MAX;

    private static long num2quad(IRubyObject arg) {
        if (arg == arg.getRuntime().getNil()) {
            return 0L;
        }
        if (arg instanceof RubyBignum) {
            BigInteger big = ((RubyBignum)arg).getValue();
            if (big.compareTo(QUAD_MIN) < 0 || big.compareTo(QUAD_MAX) > 0) {
                throw arg.getRuntime().newRangeError("bignum too big to convert into `quad int'");
            }
            return big.longValue();
        }
        return RubyNumeric.num2long(arg);
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuffer encodes(Ruby runtime, StringBuffer io2Append, String stringToEncode, int charCount, char encodingType) {
        void lNextChar;
        void lCurChar;
        void lPadding;
        char charsToEncode;
        charCount = charCount < stringToEncode.length() ? charCount : stringToEncode.length();
        io2Append.ensureCapacity(charCount * 4 / 3 + 6);
        int i = 0;
        byte[] lTranslationTable = encodingType == 'u' ? uu_table : b64_table;
        char[] cArray = stringToEncode.toCharArray();
        if (encodingType == 'u') {
            if (charCount >= lTranslationTable.length) {
                throw runtime.newArgumentError("" + charCount + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + lTranslationTable.length);
            }
            io2Append.append((char)lTranslationTable[charCount]);
            charsToEncode = '`';
        } else {
            charsToEncode = '=';
        }
        while (charCount >= 3) {
            lCurChar = lPadding[i++];
            lNextChar = lPadding[i++];
            void lNextNextChar = lPadding[i++];
            io2Append.append((char)lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append((char)lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append((char)lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append((char)lTranslationTable[0x3F & lNextNextChar]);
            charCount -= 3;
        }
        if (charCount == 2) {
            lCurChar = lPadding[i++];
            lNextChar = lPadding[i++];
            io2Append.append((char)lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append((char)lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append((char)lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(charsToEncode);
        } else if (charCount == 1) {
            lCurChar = lPadding[i++];
            io2Append.append((char)lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append((char)lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(charsToEncode);
            io2Append.append(charsToEncode);
        }
        io2Append.append('\n');
        return io2Append;
    }

    private static StringBuffer qpencode(StringBuffer io2Append, String i2Encode, int iLength) {
        io2Append.ensureCapacity(1024);
        int lCurLineLength = 0;
        int lPrevChar = -1;
        char[] l2Encode = i2Encode.toCharArray();
        try {
            int i = 0;
            while (true) {
                int lCurChar;
                if ((lCurChar = l2Encode[i]) > 126 || lCurChar < 32 && lCurChar != 10 && lCurChar != 9 || lCurChar == 61) {
                    io2Append.append('=');
                    io2Append.append((char)hex_table[lCurChar >> 4]);
                    io2Append.append((char)hex_table[lCurChar & 0xF]);
                    lCurLineLength += 3;
                    lPrevChar = -1;
                } else if (lCurChar == 10) {
                    if (lPrevChar == 32 || lPrevChar == 9) {
                        io2Append.append('=');
                        io2Append.append((char)lCurChar);
                    }
                    io2Append.append((char)lCurChar);
                    lCurLineLength = 0;
                    lPrevChar = lCurChar;
                } else {
                    io2Append.append((char)lCurChar);
                    ++lCurLineLength;
                    lPrevChar = lCurChar;
                }
                if (lCurLineLength > iLength) {
                    io2Append.append('=');
                    io2Append.append('\n');
                    lCurLineLength = 0;
                    lPrevChar = 10;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (lCurLineLength > 0) {
                io2Append.append('=');
                io2Append.append('\n');
            }
            return io2Append;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static RubyArray unpack(Ruby runtime, ByteList encodedString, ByteList formatString) {
        RubyArray result = runtime.newArray();
        ByteBuffer format = ByteBuffer.wrap(formatString.unsafeBytes(), formatString.begin(), formatString.length());
        ByteBuffer encode = ByteBuffer.wrap(encodedString.unsafeBytes(), encodedString.begin(), encodedString.length());
        byte type = 0;
        byte next = Pack.safeGet(format);
        block23: while (next != 0) {
            type = next;
            next = Pack.safeGet(format);
            if (next == 95 || next == 33) {
                if (NATIVE_CODES.indexOf(type) == -1) {
                    throw runtime.newArgumentError("'" + next + "' allowed only after types " + NATIVE_CODES);
                }
                next = Pack.safeGet(format);
            }
            int occurrences = 0;
            if (next == 0) {
                occurrences = 1;
            } else if (next == 42) {
                occurrences = -1;
                next = Pack.safeGet(format);
            } else if (Character.isDigit((char)(next & 0xFF))) {
                occurrences = 0;
                do {
                    occurrences = occurrences * 10 + Character.digit((char)(next & 0xFF), 10);
                } while ((next = Pack.safeGet(format)) != 0 && Character.isDigit((char)(next & 0xFF)));
            } else {
                occurrences = type == 64 ? 0 : 1;
            }
            Converter converter = converters[type];
            if (converter != null) {
                Pack.decode(runtime, encode, occurrences, result, converter);
                type = next;
                continue;
            }
            switch (type) {
                case 64: {
                    encode.position(occurrences);
                    break;
                }
                case 37: {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 65: {
                    byte c;
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    int t = occurrences - 1;
                    while (occurrences > 0 && ((c = potential[t]) == 0 || c == 32)) {
                        --occurrences;
                        --t;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(potential, 0, occurrences, false)));
                    break;
                }
                case 90: {
                    char c;
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    int t = occurrences - 1;
                    while (occurrences > 0 && (c = (char)potential[t]) == '\u0000') {
                        --occurrences;
                        --t;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(potential, 0, occurrences, false)));
                    break;
                }
                case 97: {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    result.append(RubyString.newString(runtime, new ByteList(potential, false)));
                    break;
                }
                case 98: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)encode.get();
                        lElem[lCurByte] = (bits & 1) != 0 ? 49 : 48;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 66: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)encode.get();
                        lElem[lCurByte] = (bits & 0x80) != 0 ? 49 : 48;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 104: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits >>>= 4) : (int)encode.get();
                        lElem[lCurByte] = sHexDigits[bits & 0xF];
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 72: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits <<= 4) : (int)encode.get();
                        lElem[lCurByte] = sHexDigits[bits >>> 4 & 0xF];
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 117: {
                    int n;
                    int length = encode.remaining() * 3 / 4;
                    byte[] lElem = new byte[length];
                    int index = 0;
                    boolean bl = false;
                    byte total = encode.get();
                    while (encode.hasRemaining() && total > 32 && total < 97) {
                        byte[] byArray = new byte[3];
                        int n2 = total - 32 & 0x3F;
                        total = Pack.safeGet(encode);
                        if ((s += n2) > length) {
                            int s;
                            n2 -= s - length;
                            s = length;
                        }
                        while (n2 > 0) {
                            int c;
                            void d;
                            int mlen;
                            int len;
                            int hunk;
                            int n3;
                            int n4 = n3 = n2 > 3 ? 3 : n2;
                            if (encode.hasRemaining() && total >= 32) {
                                n = total - 32 & 0x3F;
                                total = Pack.safeGet(encode);
                            } else {
                                n = 0;
                            }
                            if (encode.hasRemaining() && total >= 32) {
                                hunk = total - 32 & 0x3F;
                                total = Pack.safeGet(encode);
                            } else {
                                hunk = 0;
                            }
                            if (encode.hasRemaining() && total >= 32) {
                                len = total - 32 & 0x3F;
                                total = Pack.safeGet(encode);
                            } else {
                                len = 0;
                            }
                            if (encode.hasRemaining() && total >= 32) {
                                mlen = total - 32 & 0x3F;
                                total = Pack.safeGet(encode);
                            } else {
                                mlen = 0;
                            }
                            a[0] = (byte)((d << 2 | hunk >> 4) & 0xFF);
                            a[1] = (byte)((hunk << 4 | len >> 2) & 0xFF);
                            a[2] = (byte)((len << 6 | mlen) & 0xFF);
                            for (int i = 0; i < c; ++i) {
                                void a;
                                lElem[index++] = a[i];
                            }
                            b -= c;
                        }
                        if (total == 13) {
                            total = Pack.safeGet(encode);
                        }
                        if (total == 10) {
                            total = Pack.safeGet(encode);
                            continue;
                        }
                        if (!encode.hasRemaining()) continue;
                        if (Pack.safeGet(encode) == 10) {
                            Pack.safeGet(encode);
                            continue;
                        }
                        if (!encode.hasRemaining()) continue;
                        encode.position(encode.position() - 1);
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, 0, index, false)));
                    break;
                }
                case 109: {
                    int c3;
                    int n;
                    int length = encode.remaining() * 3 / 4;
                    byte[] lElem = new byte[length];
                    int a = -1;
                    int total = -1;
                    int b = 0;
                    int n5 = 0;
                    while (encode.hasRemaining()) {
                        byte by;
                        while ((by = Pack.safeGet(encode)) == 13 || by == 10) {
                        }
                        a = b64_xtable[by];
                        if (a == -1 || (c3 = b64_xtable[by = Pack.safeGet(encode)]) == -1 || (b = b64_xtable[by = Pack.safeGet(encode)]) == -1 || (n = b64_xtable[by = Pack.safeGet(encode)]) == -1) break;
                        lElem[n5++] = (byte)((a << 2 | c3 >> 4) & 0xFF);
                        lElem[n5++] = (byte)((c3 << 4 | b >> 2) & 0xFF);
                        lElem[n5++] = (byte)((b << 6 | n) & 0xFF);
                        a = -1;
                    }
                    if (a != -1 && c3 != -1) {
                        lElem[n5++] = (byte)((a << 2 | c3 >> 4) & 0xFF);
                        if (b != -1) {
                            lElem[n5++] = (byte)((c3 << 4 | b >> 2) & 0xFF);
                        }
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, 0, n5, false)));
                    break;
                }
                case 77: {
                    int n;
                    byte[] lElem = new byte[Math.max(encode.remaining(), 0)];
                    int index = 0;
                    while (encode.hasRemaining()) {
                        void c2;
                        byte c = Pack.safeGet(encode);
                        if (c != 61) {
                            lElem[index++] = c;
                            continue;
                        }
                        if (!encode.hasRemaining()) break;
                        byte c3 = Pack.safeGet(encode);
                        if (c3 == 10) continue;
                        byte c1 = Pack.safeGet(encode);
                        n = Character.digit((char)(c2 & 0xFF), 16) * 16 + Character.digit((char)(c1 & 0xFF), 16);
                        lElem[index++] = n;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, 0, index, false)));
                    break;
                }
                case 85: {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] toUnpack = new byte[occurrences];
                    encode.get(toUnpack);
                    CharBuffer lUtf8 = null;
                    try {
                        void buffer;
                        Charset utf8 = Charset.forName("UTF-8");
                        CharsetDecoder c2 = utf8.newDecoder();
                        c2.onMalformedInput(CodingErrorAction.REPORT);
                        c2.onUnmappableCharacter(CodingErrorAction.REPORT);
                        ByteBuffer utf8Decoder = ByteBuffer.wrap(toUnpack);
                        lUtf8 = buffer.decode(utf8Decoder);
                    }
                    catch (CharacterCodingException cce) {
                        throw runtime.newArgumentError("malformed UTF-8 character");
                    }
                    while (occurrences-- > 0 && lUtf8.hasRemaining()) {
                        long l = lUtf8.get();
                        result.append(runtime.newFixnum(l));
                    }
                    continue block23;
                }
                case 88: {
                    if (occurrences == -1) {
                        occurrences = encode.limit() - encode.remaining();
                    }
                    try {
                        encode.position(encode.position() - occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': X outside of string");
                    }
                }
                case 120: {
                    if (occurrences == -1) {
                        occurrences = encode.remaining();
                    }
                    try {
                        encode.position(encode.position() + occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': x outside of string");
                    }
                }
            }
        }
        return result;
    }

    private static byte safeGet(ByteBuffer encode) {
        return encode.hasRemaining() ? encode.get() : (byte)0;
    }

    public static void decode(Ruby runtime, ByteBuffer encode, int occurrences, RubyArray result, Converter converter) {
        int lPadLength = 0;
        if (occurrences == -1) {
            occurrences = encode.remaining() / converter.size;
        } else if (occurrences > encode.remaining() / converter.size) {
            lPadLength = occurrences - encode.remaining() / converter.size;
            occurrences = encode.remaining() / converter.size;
        }
        while (occurrences-- > 0) {
            result.append(converter.decode(runtime, encode));
        }
        while (lPadLength-- > 0) {
            result.append(runtime.getNil());
        }
    }

    public static int encode(Ruby runtime, int occurrences, StringBuffer result, RubyArray list, int index, Converter converter) {
        int listSize = list.size();
        while (occurrences-- > 0) {
            if (listSize-- <= 0) {
                throw runtime.newArgumentError(sTooFew);
            }
            IRubyObject from = list.eltInternal(index++);
            converter.encode(runtime, from, result);
        }
        return index;
    }

    private static final StringBuffer shrink(StringBuffer i2Shrink, int iLength) {
        iLength = i2Shrink.length() - iLength;
        if (iLength < 0) {
            throw new IllegalArgumentException();
        }
        i2Shrink.setLength(iLength);
        return i2Shrink;
    }

    private static final StringBuffer grow(StringBuffer i2Grow, String iPads, int iLength) {
        int lPadLength = iPads.length();
        while (iLength >= lPadLength) {
            i2Grow.append(iPads);
            iLength -= lPadLength;
        }
        i2Grow.append(iPads.substring(0, iLength));
        return i2Grow;
    }

    /*
     * WARNING - void declaration
     */
    public static RubyString pack(Ruby runtime, RubyArray list, ByteList formatString) {
        ByteBuffer format = ByteBuffer.wrap(formatString.unsafeBytes(), formatString.begin(), formatString.length());
        StringBuffer result = new StringBuffer();
        int listSize = list.size();
        byte type = 0;
        byte next = Pack.safeGet(format);
        int idx = 0;
        block25: while (next != 0) {
            Converter isStar;
            type = next;
            next = Pack.safeGet(format);
            while (Character.isWhitespace((char)(type & 0xFF))) {
                if (next == 0) break block25;
                type = next;
                next = Pack.safeGet(format);
            }
            if (type == 35) {
                while (type != 10) {
                    if (next == 0) break block25;
                    type = next;
                    next = Pack.safeGet(format);
                }
            }
            if (next == 33 || next == 95) {
                if (NATIVE_CODES.indexOf(type) == -1) {
                    throw runtime.newArgumentError("'" + next + "' allowed only after types " + NATIVE_CODES);
                }
                next = Pack.safeGet(format);
            }
            int n = 1;
            boolean occurrences = false;
            if (next != 0) {
                if (next == 42) {
                    if ("@Xxu".indexOf(type) != -1) {
                        n = 0;
                    } else {
                        n = listSize;
                        occurrences = true;
                    }
                    next = Pack.safeGet(format);
                } else if (Character.isDigit((char)(next & 0xFF))) {
                    n = 0;
                    do {
                        n = n * 10 + Character.digit((char)(next & 0xFF), 10);
                    } while ((next = Pack.safeGet(format)) != 0 && Character.isDigit((char)(next & 0xFF)));
                }
            }
            if ((isStar = converters[type]) != null) {
                idx = Pack.encode(runtime, n, result, list, idx, isStar);
                continue;
            }
            block2 : switch (type) {
                case 37: {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 65: 
                case 66: 
                case 72: 
                case 90: 
                case 97: 
                case 98: 
                case 104: {
                    int lCurElemString;
                    Object converter;
                    String from;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String string = from = (converter = (Object)list.eltInternal(idx++)) == runtime.getNil() ? "" : converter.convertToString().toString();
                    if (occurrences) {
                        lCurElemString = from.length();
                        if (type == 90) {
                            ++lCurElemString;
                        }
                    }
                    switch (type) {
                        case 65: 
                        case 90: 
                        case 97: {
                            if (from.length() >= lCurElemString) {
                                result.append(from.toCharArray(), 0, lCurElemString);
                                break block2;
                            }
                            result.append(from);
                            lCurElemString -= from.length();
                            switch (type) {
                                case 90: 
                                case 97: {
                                    Pack.grow(result, sNil10, lCurElemString);
                                    break block2;
                                }
                            }
                            Pack.grow(result, sSp10, lCurElemString);
                            break block2;
                        }
                        case 98: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (lCurElemString > from.length()) {
                                padLength = (lCurElemString - from.length()) / 2 + lCurElemString % 2;
                                lCurElemString = from.length();
                            }
                            int i = 0;
                            while (i < lCurElemString) {
                                if ((from.charAt(i++) & '\u0001') != 0) {
                                    currentByte |= 0x80;
                                }
                                if ((i & 7) == 0) {
                                    result.append((char)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte >>= 1;
                            }
                            if ((lCurElemString & 7) != 0) {
                                result.append((char)((currentByte >>= 7 - (lCurElemString & 7)) & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break block2;
                        }
                        case 66: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (lCurElemString > from.length()) {
                                padLength = (lCurElemString - from.length()) / 2 + lCurElemString % 2;
                                lCurElemString = from.length();
                            }
                            int i = 0;
                            while (i < lCurElemString) {
                                currentByte |= from.charAt(i++) & '\u0001';
                                if ((i & 7) == 0) {
                                    result.append((char)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte <<= 1;
                            }
                            if ((lCurElemString & 7) != 0) {
                                result.append((char)((currentByte <<= 7 - (lCurElemString & 7)) & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break block2;
                        }
                        case 104: {
                            char currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (lCurElemString > from.length()) {
                                padLength = lCurElemString - from.length();
                                lCurElemString = from.length();
                            }
                            int i = 0;
                            while (i < lCurElemString) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = from.charAt(i++)) ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) << 4);
                                if ((i & 1) != 0) {
                                    currentByte >>= 4;
                                    continue;
                                }
                                result.append((char)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((lCurElemString & 1) != 0) {
                                result.append((char)(currentByte & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break block2;
                        }
                        case 72: {
                            char currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (lCurElemString > from.length()) {
                                padLength = lCurElemString - from.length();
                                lCurElemString = from.length();
                            }
                            int i = 0;
                            while (i < lCurElemString) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = from.charAt(i++)) ? (currentByte |= (currentChar & 0xF) + 9 & 0xF) : (currentByte |= currentChar & 0xF);
                                if ((i & 1) != 0) {
                                    currentByte <<= 4;
                                    continue;
                                }
                                result.append((char)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((lCurElemString & 1) != 0) {
                                result.append((char)(currentByte & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                        }
                    }
                    break;
                }
                case 120: {
                    int lCurElemString;
                    Pack.grow(result, sNil10, lCurElemString);
                    break;
                }
                case 88: {
                    int lCurElemString;
                    try {
                        Pack.shrink(result, lCurElemString);
                        break;
                    }
                    catch (IllegalArgumentException converter) {
                        throw runtime.newArgumentError("in `pack': X outside of string");
                    }
                }
                case 64: {
                    int lCurElemString;
                    if ((lCurElemString -= result.length()) > 0) {
                        Pack.grow(result, sNil10, lCurElemString);
                    }
                    if ((lCurElemString = -lCurElemString) <= 0) break;
                    Pack.shrink(result, lCurElemString);
                    break;
                }
                case 109: 
                case 117: {
                    int lCurElemString;
                    Object converter;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String from = (converter = (Object)list.eltInternal(idx++)) == runtime.getNil() ? "" : converter.convertToString().toString();
                    int n2 = lCurElemString = lCurElemString <= 2 ? 45 : lCurElemString / 3 * 3;
                    if ("".equals(from)) break;
                    while (true) {
                        Pack.encodes(runtime, result, from, lCurElemString, (char)type);
                        if (lCurElemString >= from.length()) break block2;
                        from = from.substring(lCurElemString);
                    }
                }
                case 77: {
                    int lCurElemString;
                    Object converter;
                    String from;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String string = from = (converter = (Object)list.eltInternal(idx++)) == runtime.getNil() ? "" : converter.asString().toString();
                    if (lCurElemString <= 1) {
                        lCurElemString = 72;
                    }
                    Pack.qpencode(result, from, lCurElemString);
                    break;
                }
                case 85: {
                    int lCurElemString;
                    Object converter = new char[lCurElemString];
                    int cIndex = 0;
                    while (lCurElemString-- > 0) {
                        IRubyObject from;
                        if (listSize-- <= 0) {
                            throw runtime.newArgumentError(sTooFew);
                        }
                        long l = (from = list.eltInternal(idx++)) == runtime.getNil() ? 0L : RubyNumeric.num2long(from);
                        converter[cIndex] = (char)l;
                        ++cIndex;
                    }
                    try {
                        byte[] bytes = new String((char[])converter).getBytes("UTF8");
                        result.append(RubyString.bytesToString(bytes));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        assert (false) : "can't convert to UTF8";
                        continue block25;
                    }
                }
                case 119: {
                    void destBit;
                    int destByte;
                    IRubyObject from = list.eltInternal(idx++);
                    String stringVal = from == runtime.getNil() ? "0" : from.asString().toString();
                    BigInteger bigInt = new BigInteger(stringVal);
                    if (bigInt.compareTo(new BigInteger("0")) < 0) break;
                    int bitLength = bigInt.toString(2).length();
                    byte[] byArray = bigInt.toByteArray();
                    byte[] byArray2 = new byte[bitLength / 7 + (bitLength % 7 > 0 ? 1 : 0)];
                    boolean bl = false;
                    boolean bl2 = false;
                    int n3 = 0;
                    for (int i = ((void)b).length - 1; i >= 0; --i) {
                        int n4 = 0;
                        while (n4 < 8) {
                            void b;
                            int srcByte;
                            if (srcByte == 7) {
                                destBit[((void)destBit).length - 1 - ++srcBit] = (byte)(destByte & 0xFF);
                                destByte = 128;
                                srcByte = 0;
                            }
                            int n5 = b[i] & 1 << n4;
                            if (srcByte > n4) {
                                n5 = 0xFF & n5 << srcByte - n4;
                            } else if (srcByte < n4) {
                                n5 = 0xFF & n5 >> n4 - srcByte;
                            }
                            destByte |= 0xFF & n5;
                            ++n4;
                            ++srcByte;
                        }
                    }
                    if (destByte != 128) {
                        destBit[n3] = (byte)(destByte & 0xFF);
                    }
                    result.append(RubyString.bytesToString((byte[])destBit));
                }
            }
        }
        return runtime.newString(result.toString());
    }

    private static int decodeIntLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        int value = encode.getInt();
        encode.order(ByteOrder.BIG_ENDIAN);
        return value;
    }

    private static int decodeIntBigEndian(ByteBuffer encode) {
        return encode.getInt();
    }

    private static long decodeIntUnsignedBigEndian(ByteBuffer encode) {
        return (long)encode.getInt() & 0xFFFFFFFFL;
    }

    private static long decodeIntUnsignedLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        long value = (long)encode.getInt() & 0xFFFFFFFFL;
        encode.order(ByteOrder.BIG_ENDIAN);
        return value;
    }

    private static void encodeIntLittleEndian(StringBuffer result, int s) {
        result.append((char)(s & 0xFF)).append((char)(s >> 8 & 0xFF));
        result.append((char)(s >> 16 & 0xFF)).append((char)(s >> 24 & 0xFF));
    }

    private static void encodeIntBigEndian(StringBuffer result, int s) {
        result.append((char)(s >> 24 & 0xFF)).append((char)(s >> 16 & 0xFF));
        result.append((char)(s >> 8 & 0xFF)).append((char)(s & 0xFF));
    }

    private static long decodeLongBigEndian(ByteBuffer encode) {
        int c1 = Pack.decodeIntBigEndian(encode);
        int c2 = Pack.decodeIntBigEndian(encode);
        return ((long)c1 << 32) + ((long)c2 & 0xFFFFFFFFL);
    }

    private static long decodeLongLittleEndian(ByteBuffer encode) {
        int c1 = Pack.decodeIntLittleEndian(encode);
        int c2 = Pack.decodeIntLittleEndian(encode);
        return ((long)c2 << 32) + ((long)c1 & 0xFFFFFFFFL);
    }

    private static void encodeLongLittleEndian(StringBuffer result, long l) {
        Pack.encodeIntLittleEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        Pack.encodeIntLittleEndian(result, (int)(l >>> 32));
    }

    private static void encodeLongBigEndian(StringBuffer result, long l) {
        Pack.encodeIntBigEndian(result, (int)(l >>> 32));
        Pack.encodeIntBigEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    private static double decodeDoubleLittleEndian(ByteBuffer encode) {
        return Double.longBitsToDouble(Pack.decodeLongLittleEndian(encode));
    }

    private static double decodeDoubleBigEndian(ByteBuffer encode) {
        return Double.longBitsToDouble(Pack.decodeLongBigEndian(encode));
    }

    private static void encodeDoubleLittleEndian(StringBuffer result, double d) {
        Pack.encodeLongLittleEndian(result, Double.doubleToLongBits(d));
    }

    private static void encodeDoubleBigEndian(StringBuffer result, double d) {
        Pack.encodeLongBigEndian(result, Double.doubleToLongBits(d));
    }

    private static float decodeFloatBigEndian(ByteBuffer encode) {
        return Float.intBitsToFloat(Pack.decodeIntBigEndian(encode));
    }

    private static float decodeFloatLittleEndian(ByteBuffer encode) {
        return Float.intBitsToFloat(Pack.decodeIntLittleEndian(encode));
    }

    private static void encodeFloatLittleEndian(StringBuffer result, float f) {
        Pack.encodeIntLittleEndian(result, Float.floatToIntBits(f));
    }

    private static void encodeFloatBigEndian(StringBuffer result, float f) {
        Pack.encodeIntBigEndian(result, Float.floatToIntBits(f));
    }

    private static int decodeShortUnsignedLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        int value = encode.getShort() & 0xFFFF;
        encode.order(ByteOrder.BIG_ENDIAN);
        return value;
    }

    private static int decodeShortUnsignedBigEndian(ByteBuffer encode) {
        int value = encode.getShort() & 0xFFFF;
        return value;
    }

    private static short decodeShortBigEndian(ByteBuffer encode) {
        return encode.getShort();
    }

    private static void encodeShortLittleEndian(StringBuffer result, int s) {
        result.append((char)(s & 0xFF)).append((char)((s & 0xFF00) >> 8));
    }

    private static void encodeShortBigEndian(StringBuffer result, int s) {
        result.append((char)((s & 0xFF00) >> 8)).append((char)(s & 0xFF));
    }

    static {
        Converter tmp;
        int i;
        b64_xtable = new int[256];
        converters = new Converter[256];
        QUAD_MIN = BigInteger.valueOf(Long.MIN_VALUE);
        QUAD_MAX = new BigInteger("ffffffffffffffff", 16);
        hex_table = ByteList.plain("0123456789ABCDEF");
        uu_table = ByteList.plain("`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        b64_table = ByteList.plain("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        sHexDigits = ByteList.plain("0123456789abcdef0123456789ABCDEFx");
        for (i = 0; i < 256; ++i) {
            Pack.b64_xtable[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Pack.b64_xtable[Pack.b64_table[i]] = i;
        }
        Pack.converters[118] = new Converter(2){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortLittleEndian(result, s);
            }
        };
        Pack.converters[101] = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                float f = o == runtime.getNil() ? 0.0f : (float)RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeFloatLittleEndian(result, f);
            }
        };
        Pack.converters[70] = tmp = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                float f = o == runtime.getNil() ? 0.0f : (float)RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeFloatBigEndian(result, f);
            }
        };
        Pack.converters[102] = tmp;
        Pack.converters[103] = tmp;
        Pack.converters[69] = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                double d = o == runtime.getNil() ? 0.0 : RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeDoubleLittleEndian(result, d);
            }
        };
        Pack.converters[68] = tmp = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                double d = o == runtime.getNil() ? 0.0 : RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeDoubleBigEndian(result, d);
            }
        };
        Pack.converters[100] = tmp;
        Pack.converters[71] = tmp;
        Pack.converters[115] = new Converter(2){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        };
        Pack.converters[83] = tmp = new Converter(2){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        };
        Pack.converters[110] = tmp;
        Pack.converters[99] = new Converter(1){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                byte c = enc.get();
                return runtime.newFixnum(c > 127 ? (long)(c - 256) : (long)c);
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                char c = o == runtime.getNil() ? (char)'\u0000' : (char)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        };
        Pack.converters[67] = new Converter(1){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(enc.get() & 0xFF);
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                char c = o == runtime.getNil() ? (char)'\u0000' : (char)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        };
        Pack.converters[86] = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntLittleEndian(result, s);
            }
        };
        Pack.converters[73] = tmp = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        Pack.converters[76] = tmp;
        Pack.converters[78] = tmp;
        Pack.converters[108] = tmp = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        Pack.converters[105] = tmp;
        Pack.converters[81] = tmp = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                long l = Pack.decodeLongLittleEndian(enc);
                return RubyBignum.newBignum(runtime, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                long l = Pack.num2quad(o);
                Pack.encodeLongBigEndian(result, l);
            }
        };
        Pack.converters[113] = tmp = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyBignum.newBignum(runtime, Pack.decodeLongLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                long l = Pack.num2quad(o);
                Pack.encodeLongBigEndian(result, l);
            }
        };
    }

    static class PtrList {
        private byte[] buffer;
        private int index;

        public PtrList(byte[] bufferString) {
            this.buffer = bufferString;
            this.index = 0;
        }

        public int remaining() {
            return this.buffer.length - this.index;
        }

        public String nextSubstring(int length) {
            if (this.index + length > this.buffer.length) {
                throw new IllegalArgumentException();
            }
            String substring = null;
            substring = new String(ByteList.plain(this.buffer, this.index, length));
            this.index += length;
            return substring;
        }

        public void setPosition(int position) {
            if (position < this.buffer.length) {
                this.index = position;
            }
        }

        public int nextAsciiNumber() {
            int i;
            for (i = this.index; i < this.buffer.length && Character.isDigit((char)(this.buffer[i] & 0xFF)); ++i) {
            }
            int number = 0;
            Integer.parseInt(new String(ByteList.plain(this.buffer, this.index, i - this.index)));
            this.index = i;
            return number;
        }

        public int getLength() {
            return this.buffer.length;
        }

        public int nextByte() {
            int next = 0;
            if (this.index < this.buffer.length) {
                next = this.buffer[this.index++];
            } else if (this.index == this.buffer.length) {
                ++this.index;
            }
            return next & 0xFF;
        }

        public void backup(int occurrences) {
            this.index -= occurrences;
            if (this.index < 0) {
                throw new IllegalArgumentException();
            }
        }

        public boolean isAtEnd() {
            return this.index > this.buffer.length;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static abstract class Converter {
        public int size;

        public Converter(int size) {
            this.size = size;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, StringBuffer var3);
    }
}

