/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.Dispatcher;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.FastInvocationCallback;
import org.jruby.runtime.callback.InvocationCallback;
import org.jruby.runtime.callback.ReflectionCallback;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

public class InvocationCallbackFactory
extends CallbackFactory
implements Opcodes {
    private static final CodegenUtils cg = CodegenUtils.cg;
    private final Class type;
    protected final JRubyClassLoader classLoader;
    private final String typePath;
    protected final Ruby runtime;
    private static final String SUPER_CLASS = cg.p(InvocationCallback.class);
    private static final String FAST_SUPER_CLASS = cg.p(FastInvocationCallback.class);
    private static final String CALL_SIG = cg.sig(RubyKernel.IRUBY_OBJECT, cg.params(Object.class, Object[].class, Block.class));
    private static final String FAST_CALL_SIG = cg.sig(RubyKernel.IRUBY_OBJECT, cg.params(Object.class, Object[].class));
    private static final String BLOCK_CALL_SIG = cg.sig(RubyKernel.IRUBY_OBJECT, cg.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject[].class));
    private static final String IRUB = cg.p(RubyKernel.IRUBY_OBJECT);
    public static final int DISPATCHER_THREADCONTEXT_INDEX = 1;
    public static final int DISPATCHER_SELF_INDEX = 2;
    public static final int DISPATCHER_RUBYMODULE_INDEX = 3;
    public static final int DISPATCHER_METHOD_INDEX = 4;
    public static final int DISPATCHER_NAME_INDEX = 5;
    public static final int DISPATCHER_ARGS_INDEX = 6;
    public static final int DISPATCHER_CALLTYPE_INDEX = 7;
    public static final int DISPATCHER_BLOCK_INDEX = 8;
    public static final int DISPATCHER_RUNTIME_INDEX = 9;
    private static final int METHOD_ARGS_INDEX = 2;

    public InvocationCallbackFactory(Ruby runtime, Class type, ClassLoader classLoader) {
        this.type = type;
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
        this.typePath = cg.p(type);
        this.runtime = runtime;
    }

    private Class getReturnClass(String method, Class[] args) throws Exception {
        return this.type.getMethod(method, args).getReturnType();
    }

    private ClassWriter createCtor(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, SUPER_CLASS, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, SUPER_CLASS, "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createCtorDispatcher(String namePath, Map switchMap) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, cg.p(Dispatcher.class), null);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", cg.sig(Void.TYPE, cg.params(Ruby.class)), null, null));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, cg.p(Dispatcher.class), "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.aload(0);
        mv.ldc(new Integer(MethodIndex.NAMES.size()));
        mv.newarray(8);
        mv.putfield(cg.p(Dispatcher.class), "switchTable", cg.ci(byte[].class));
        mv.aload(0);
        mv.getfield(cg.p(Dispatcher.class), "switchTable", cg.ci(byte[].class));
        for (Integer switchValue : switchMap.keySet()) {
            mv.dup();
            mv.ldc(new Integer(MethodIndex.getIndex((String)switchMap.get(switchValue))));
            mv.ldc(switchValue);
            mv.barraystore();
        }
        mv.pop();
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createCtorFast(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, FAST_SUPER_CLASS, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, FAST_SUPER_CLASS, "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createBlockCtor(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, cg.p(Object.class), new String[]{cg.p(CompiledBlockCallback.class)});
        cw.visitField(18, "$scriptObject", cg.ci(Object.class), null, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", cg.sig(Void.TYPE, cg.params(Object.class)), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, cg.p(Object.class), "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, namePath, "$scriptObject", cg.ci(Object.class));
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private Class tryClass(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private MethodVisitor startCall(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    private MethodVisitor startCallS(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        this.checkCast(mv, IRubyObject.class);
        return mv;
    }

    private MethodVisitor startCallFast(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    private MethodVisitor startDispatcher(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "callMethod", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, RubyModule.class, Integer.TYPE, String.class, IRubyObject[].class, CallType.class, Block.class)), null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    private MethodVisitor startCallSFast(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, IRUB);
        return mv;
    }

    private MethodVisitor startBlockCall(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", BLOCK_CALL_SIG, null, null);
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        return mv;
    }

    protected Class endCall(ClassWriter cw, MethodVisitor mv, String name) {
        mv.visitEnd();
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        return this.classLoader.defineClass(name, code);
    }

    @Override
    public Callback getMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "_0";
        String mnamePath = this.typePath + "Invoker$" + method + "_0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getMethod(String method, Class arg1) {
        String mname = this.type.getName() + "Invoker$" + method + "_1";
        String mnamePath = this.typePath + "Invoker$" + method + "_1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = new Class[]{arg1, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Invoker$" + method + "_2";
        String mnamePath = this.typePath + "Invoker$" + method + "_2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = new Class[]{arg1, arg2, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Invoker$" + method + "_3";
        String mnamePath = this.typePath + "Invoker$" + method + "_3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = new Class[]{arg1, arg2, arg3, Block.class};
                    Class ret = this.getReturnClass(method, descriptor);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getSingletonMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "S0";
        String mnamePath = this.typePath + "Invoker$" + method + "S0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getSingletonMethod(String method, Class arg1) {
        String mname = this.type.getName() + "Invoker$" + method + "_S1";
        String mnamePath = this.typePath + "Invoker$" + method + "_S1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getSingletonMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Invoker$" + method + "_S2";
        String mnamePath = this.typePath + "Invoker$" + method + "_S2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 4);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Invoker$" + method + "_S3";
        String mnamePath = this.typePath + "Invoker$" + method + "_S3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, arg3, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getBlockMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT}, false, true, Arity.fixed(2), false);
    }

    @Override
    public CompiledBlockCallback getBlockCallback(String method, Object scriptObject) {
        Class<?> type = scriptObject.getClass();
        String typePath = cg.p(type);
        String mname = type.getName() + "Block" + method + "xx1";
        String mnamePath = typePath + "Block" + method + "xx1";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    ClassWriter cw = this.createBlockCtor(mnamePath);
                    MethodVisitor mv = this.startBlockCall(cw);
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, mnamePath, "$scriptObject", cg.ci(Object.class));
                    mv.visitTypeInsn(192, cg.p(type));
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, typePath, method, cg.sig(RubyKernel.IRUBY_OBJECT, cg.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject[].class)));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                CompiledBlockCallback ic = (CompiledBlockCallback)c.getConstructor(Object.class).newInstance(scriptObject);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getOptSingletonMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "_Sopt";
        String mnamePath = this.typePath + "Invoker$" + method + "_Sopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCallS(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getOptMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "_opt";
        String mnamePath = this.typePath + "Invoker$" + method + "_opt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{IRubyObject[].class, Block.class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtor(mnamePath);
                    MethodVisitor mv = this.startCall(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitVarInsn(25, 3);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                InvocationCallback ic = (InvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "_F0";
        String mnamePath = this.typePath + "Invoker$" + method + "_F0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class ret = this.getReturnClass(method, new Class[0]);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastMethod(String method, Class arg1) {
        String mname = this.type.getName() + "Invoker$" + method + "_F1";
        String mnamePath = this.typePath + "Invoker$" + method + "_F1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = descriptor;
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Invoker$" + method + "_F2";
        String mnamePath = this.typePath + "Invoker$" + method + "_F2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = descriptor;
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Invoker$" + method + "_F3";
        String mnamePath = this.typePath + "Invoker$" + method + "_F3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = descriptor;
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "_FS0";
        String mnamePath = this.typePath + "Invoker$" + method + "_FS0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.noArguments());
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method, Class arg1) {
        String mname = this.type.getName() + "Invoker$" + method + "_FS1";
        String mnamePath = this.typePath + "Invoker$" + method + "_FS1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    this.loadArguments(mv, 2, 1, descriptor);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(3, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.singleArgument());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Invoker$" + method + "_FS2";
        String mnamePath = this.typePath + "Invoker$" + method + "_FS2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    this.loadArguments(mv, 2, 2, descriptor);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(4, 4);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.twoArguments());
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Invoker$" + method + "_FS3";
        String mnamePath = this.typePath + "Invoker$" + method + "_FS3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                Class[] descriptor = new Class[]{arg1, arg2, arg3};
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, arg3};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    this.loadArguments(mv, 2, 3, descriptor);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(5, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.fixed(3));
                ic.setArgumentTypes(descriptor);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastOptMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "_Fopt";
        String mnamePath = this.typePath + "Invoker$" + method + "_Fopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{IRubyObject[].class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallFast(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitMethodInsn(182, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Callback getFastOptSingletonMethod(String method) {
        String mname = this.type.getName() + "Invoker$" + method + "_FSopt";
        String mnamePath = this.typePath + "Invoker$" + method + "_FSopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    Class[] signature = new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class};
                    Class ret = this.getReturnClass(method, signature);
                    ClassWriter cw = this.createCtorFast(mnamePath);
                    MethodVisitor mv = this.startCallSFast(cw);
                    mv.visitVarInsn(25, 2);
                    this.checkCast(mv, IRubyObject[].class);
                    mv.visitMethodInsn(184, this.typePath, method, cg.sig(ret, signature));
                    mv.visitInsn(176);
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
                ic.setArity(Arity.optional());
                ic.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                ic.setJavaName(method);
                ic.setSingleton(true);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public Dispatcher createDispatcher(RubyClass metaClass) {
        String className = this.type.getName() + "Dispatcher_for_" + metaClass.getBaseName();
        String classPath = this.typePath + "Dispatcher_for_" + metaClass.getBaseName();
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(className);
            try {
                if (c == null) {
                    HashMap allMethods = new HashMap();
                    RubyClass current = metaClass;
                    while (current != null) {
                        for (Map.Entry entry : current.getMethods().entrySet()) {
                            JavaMethod javaMethod;
                            DynamicMethod dynamicMethod;
                            if (allMethods.containsKey(entry.getKey()) || !((dynamicMethod = (DynamicMethod)entry.getValue()) instanceof JavaMethod) || (javaMethod = (JavaMethod)dynamicMethod).isSingleton() || javaMethod.getCallConfig() != CallConfiguration.JAVA_FAST || dynamicMethod.getVisibility() != Visibility.PUBLIC) continue;
                            allMethods.put(entry.getKey(), entry.getValue());
                        }
                        for (current = current.getSuperClass(); current != null && current.isIncluded(); current = current.getSuperClass()) {
                        }
                    }
                    Label[] labels = new Label[allMethods.size()];
                    Label defaultLabel = new Label();
                    int switchValue = 0;
                    HashMap<Integer, String> switchMap = new HashMap<Integer, String>();
                    ArrayList methodKeys = new ArrayList(allMethods.keySet());
                    Collections.sort(methodKeys);
                    for (String indexKey : methodKeys) {
                        switchMap.put(new Integer(++switchValue), indexKey);
                        labels[switchValue - 1] = new Label();
                    }
                    ClassWriter cw = this.createCtorDispatcher(classPath, switchMap);
                    SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.startDispatcher(cw));
                    mv.aload(1);
                    mv.invokevirtual(cg.p(ThreadContext.class), "getRuntime", cg.sig(Ruby.class));
                    mv.astore(9);
                    Label tryBegin = new Label();
                    Label tryEnd = new Label();
                    Label tryCatch = new Label();
                    mv.trycatch(tryBegin, tryEnd, tryCatch, cg.p(StackOverflowError.class));
                    mv.label(tryBegin);
                    mv.aload(9);
                    mv.invokevirtual(cg.p(Ruby.class), "hasEventHooks", cg.sig(Boolean.TYPE));
                    mv.ifne(defaultLabel);
                    if (switchValue == 0) {
                        mv.go_to(defaultLabel);
                    } else {
                        mv.aload(0);
                        mv.getfield(cg.p(Dispatcher.class), "switchTable", cg.ci(byte[].class));
                        mv.dup();
                        mv.arraylength();
                        mv.iload(4);
                        Label ok = new Label();
                        mv.if_icmpgt(ok);
                        mv.pop();
                        mv.go_to(defaultLabel);
                        mv.label(ok);
                        mv.iload(4);
                        mv.barrayload();
                        mv.tableswitch(1, switchValue, defaultLabel, labels);
                        for (int i = 0; i < labels.length; ++i) {
                            String rubyName = (String)switchMap.get(new Integer(i + 1));
                            DynamicMethod dynamicMethod = (DynamicMethod)allMethods.get(rubyName);
                            mv.label(labels[i]);
                            JavaMethod javaMethod = (JavaMethod)dynamicMethod;
                            String method = javaMethod.getJavaName();
                            Arity arity = javaMethod.getArity();
                            Class[] descriptor = javaMethod.getArgumentTypes();
                            this.checkArity(mv, arity);
                            if (javaMethod.isSingleton()) {
                                mv.aload(2);
                            }
                            switch (arity.getValue()) {
                                case 3: {
                                    this.loadArguments(mv, 6, 3, descriptor);
                                    break;
                                }
                                case 2: {
                                    this.loadArguments(mv, 6, 2, descriptor);
                                    break;
                                }
                                case 1: {
                                    this.loadArguments(mv, 6, 1, descriptor);
                                    break;
                                }
                                case 0: {
                                    break;
                                }
                                default: {
                                    mv.aload(6);
                                    this.checkCast(mv, IRubyObject[].class);
                                }
                            }
                            Class ret = this.getReturnClass(method, descriptor);
                            String callSig = cg.sig(ret, descriptor);
                            if (descriptor.length > 0 && descriptor[descriptor.length - 1] == Block.class) {
                                mv.aload(8);
                            }
                            mv.invokevirtual(this.typePath, method, callSig);
                            mv.areturn();
                        }
                    }
                    mv.label(defaultLabel);
                    Label afterCall = new Label();
                    this.dispatchWithoutSTI(mv, afterCall);
                    mv.label(tryEnd);
                    mv.go_to(afterCall);
                    mv.label(tryCatch);
                    mv.aload(9);
                    mv.ldc("stack level too deep");
                    mv.invokevirtual(cg.p(Ruby.class), "newSystemStackError", cg.sig(RaiseException.class, cg.params(String.class)));
                    mv.athrow();
                    mv.label(afterCall);
                    mv.areturn();
                    mv.visitMaxs(1, 1);
                    c = this.endCall(cw, mv, className);
                }
                Dispatcher dispatcher = (Dispatcher)c.getConstructor(Ruby.class).newInstance(this.runtime);
                return dispatcher;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    private void dispatchWithoutSTI(SkinnyMethodAdapter mv, Label afterCall) {
        mv.aload(3);
        mv.aload(5);
        mv.invokevirtual(cg.p(RubyModule.class), "searchMethod", cg.sig(DynamicMethod.class, cg.params(String.class)));
        Label okCall = new Label();
        this.callMethodMissingIfNecessary(mv, afterCall, okCall);
        mv.label(okCall);
        mv.aload(1);
        mv.aload(2);
        mv.aload(3);
        mv.aload(5);
        mv.aload(6);
        mv.aload(8);
        mv.invokevirtual(cg.p(DynamicMethod.class), "call", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class)));
    }

    public void callMethodMissingIfNecessary(SkinnyMethodAdapter mv, Label afterCall, Label okCall) {
        Label methodMissing = new Label();
        mv.dup();
        mv.invokevirtual(cg.p(DynamicMethod.class), "isUndefined", cg.sig(Boolean.TYPE));
        mv.ifne(methodMissing);
        mv.aload(5);
        mv.ldc("method_missing");
        mv.invokevirtual(cg.p(String.class), "equals", cg.sig(Boolean.TYPE, cg.params(Object.class)));
        mv.ifne(okCall);
        mv.dup();
        mv.aload(1);
        mv.invokevirtual(cg.p(ThreadContext.class), "getFrameSelf", cg.sig(IRubyObject.class));
        mv.aload(7);
        mv.invokevirtual(cg.p(DynamicMethod.class), "isCallableFrom", cg.sig(Boolean.TYPE, cg.params(IRubyObject.class, CallType.class)));
        mv.ifne(okCall);
        mv.label(methodMissing);
        mv.aload(1);
        mv.swap();
        mv.aload(2);
        mv.swap();
        mv.aload(5);
        mv.aload(6);
        mv.aload(1);
        mv.invokevirtual(cg.p(ThreadContext.class), "getFrameSelf", cg.sig(IRubyObject.class));
        mv.aload(7);
        mv.aload(8);
        mv.invokestatic(cg.p(RuntimeHelpers.class), "callMethodMissing", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, DynamicMethod.class, String.class, IRubyObject[].class, IRubyObject.class, CallType.class, Block.class)));
        mv.go_to(afterCall);
    }

    private void loadArguments(MethodVisitor mv, int argsIndex, int count, Class[] types) {
        for (int i = 0; i < count; ++i) {
            this.loadArgument(mv, argsIndex, i, types[i]);
        }
    }

    private void loadArgument(MethodVisitor mv, int argsIndex, int argIndex, Class type1) {
        mv.visitVarInsn(25, argsIndex);
        mv.visitLdcInsn(new Integer(argIndex));
        mv.visitInsn(50);
        this.checkCast(mv, type1);
    }

    private void checkCast(MethodVisitor mv, Class clazz) {
        mv.visitTypeInsn(192, cg.p(clazz));
    }

    private void checkArity(SkinnyMethodAdapter mv, Arity arity) {
        if (arity.getValue() >= 0) {
            Label arityOk = new Label();
            mv.aload(6);
            mv.arraylength();
            switch (arity.getValue()) {
                case 3: {
                    mv.iconst_3();
                    break;
                }
                case 2: {
                    mv.iconst_2();
                    break;
                }
                case 1: {
                    mv.iconst_1();
                    break;
                }
                case 0: {
                    mv.iconst_0();
                    break;
                }
                default: {
                    mv.ldc(new Integer(arity.getValue()));
                }
            }
            mv.if_icmpeq(arityOk);
            mv.aload(9);
            mv.aload(6);
            mv.arraylength();
            switch (arity.getValue()) {
                case 3: {
                    mv.iconst_3();
                    break;
                }
                case 2: {
                    mv.iconst_2();
                    break;
                }
                case 1: {
                    mv.iconst_1();
                    break;
                }
                case 0: {
                    mv.iconst_0();
                    break;
                }
                default: {
                    mv.ldc(new Integer(arity.getValue()));
                }
            }
            mv.invokevirtual(cg.p(Ruby.class), "newArgumentError", cg.sig(RaiseException.class, cg.params(Integer.TYPE, Integer.TYPE)));
            mv.athrow();
            mv.label(arityOk);
        }
    }
}

