/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.parser.BlockStaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Block {
    public static final int ZERO_ARGS = 0;
    public static final int MULTIPLE_ASSIGNMENT = 1;
    public static final int ARRAY = 2;
    public static final int SINGLE_RESTARG = 3;
    public static final Block NULL_BLOCK = new Block(){

        @Override
        public boolean isGiven() {
            return false;
        }

        @Override
        public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
            throw context.getRuntime().newLocalJumpError("noreason", value, "yield called out of block");
        }

        @Override
        public Block cloneBlock() {
            return this;
        }
    };
    protected IRubyObject self;
    private IterNode iterNode;
    protected Frame frame;
    protected Visibility visibility;
    protected RubyModule klass;
    protected DynamicScope dynamicScope;
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    protected Arity arity;

    public static Block createBlock(ThreadContext context, IterNode iterNode, DynamicScope dynamicScope, IRubyObject self) {
        Frame f = context.getCurrentFrame();
        f.setPosition(context.getPosition());
        return new Block(iterNode, self, f, f.getVisibility(), context.getRubyClass(), dynamicScope);
    }

    protected Block() {
        this(null, null, null, null, null, null);
    }

    public Block(IterNode iterNode, IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        this(iterNode, self, iterNode == null ? null : Arity.procArityOf(iterNode.getVarNode()), frame, visibility, klass, dynamicScope);
    }

    public Block(IterNode iterNode, IRubyObject self, Arity arity, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        this.iterNode = iterNode;
        this.self = self;
        this.arity = arity;
        this.frame = frame;
        this.visibility = visibility;
        this.klass = klass;
        this.dynamicScope = dynamicScope;
    }

    public static Block createBinding(Frame frame, DynamicScope dynamicScope) {
        ThreadContext context = frame.getSelf().getRuntime().getCurrentContext();
        DynamicScope extraScope = dynamicScope.getBindingScope();
        if (extraScope == null) {
            DynamicScope parent = dynamicScope.getNextCapturedScope();
            if (parent != null && parent.getBindingScope() == dynamicScope) {
                extraScope = dynamicScope;
            } else {
                extraScope = new DynamicScope(new BlockStaticScope(dynamicScope.getStaticScope()), dynamicScope);
                dynamicScope.setBindingScope(extraScope);
            }
        }
        return new Block(null, frame.getSelf(), frame.duplicate(), frame.getVisibility(), context.getBindingRubyClass(), extraScope);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        switch (this.type) {
            case NORMAL: {
                assert (false) : "can this happen?";
                if (args.length != 1 || !(args[0] instanceof RubyArray) || this.iterNode == null) break;
                Node vNode = this.iterNode.getVarNode();
                if (vNode.nodeId != NodeType.MULTIPLEASGNNODE) break;
                args = ((RubyArray)args[0]).toJavaArray();
                break;
            }
            case PROC: {
                if (args.length != 1 || !(args[0] instanceof RubyArray) || this.iterNode == null) break;
                Node vNode = this.iterNode.getVarNode();
                if (vNode.nodeId != NodeType.MULTIPLEASGNNODE || ((MultipleAsgnNode)vNode).getArgsNode() != null) break;
                args = ((RubyArray)args[0]).toJavaArray();
                break;
            }
            case LAMBDA: {
                this.arity().checkArity(context.getRuntime(), args);
            }
        }
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true);
    }

    protected void pre(ThreadContext context, RubyModule klass) {
        context.preYieldSpecificBlock(this, klass);
    }

    protected void post(ThreadContext context) {
        context.postYield(this);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.yield(context, value, null, null, false);
    }

    /*
     * Exception decompiling
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupBlockArgs(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = self.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                break;
            }
            case MULTIPLEASGNNODE: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, (RubyArray)value, false);
                break;
            }
            default: {
                int length = this.arrayLength(value);
                switch (length) {
                    case 0: {
                        value = runtime.getNil();
                        break;
                    }
                    case 1: {
                        value = ((RubyArray)value).eltInternal(0);
                        break;
                    }
                    default: {
                        runtime.getWarnings().warn("multiple values for a block parameter (" + length + " for 1)");
                    }
                }
                AssignmentVisitor.assign(runtime, context, self, varNode, value, NULL_BLOCK, false);
            }
        }
    }

    private void setupBlockArg(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = self.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                return;
            }
            case MULTIPLEASGNNODE: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, ArgsUtil.convertToRubyArray(runtime, value, ((MultipleAsgnNode)varNode).getHeadNode() != null), false);
                break;
            }
            default: {
                if (value == null) {
                    runtime.getWarnings().warn("multiple values for a block parameter (0 for 1)");
                }
                AssignmentVisitor.assign(runtime, context, self, varNode, value, NULL_BLOCK, false);
            }
        }
    }

    protected int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public Block cloneBlock() {
        Block newBlock = new Block(this.iterNode, this.self, this.frame.duplicate(), this.visibility, this.klass, this.dynamicScope.cloneScope());
        newBlock.type = this.type;
        return newBlock;
    }

    public IterNode getIterNode() {
        return this.iterNode;
    }

    public Arity arity() {
        return this.arity;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public boolean isGiven() {
        return true;
    }

    public static int asArgumentType(NodeType nodeId) {
        if (nodeId == null) {
            return 0;
        }
        switch (nodeId) {
            case ZEROARGNODE: {
                return 0;
            }
            case MULTIPLEASGNNODE: {
                return 1;
            }
            case SVALUENODE: {
                return 3;
            }
        }
        return 2;
    }

    public static enum Type {
        NORMAL,
        PROC,
        LAMBDA;

    }
}

