/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.util.List;
import org.jruby.lexer.yacc.CapturingByteListLexerSource;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.parser.ParserConfiguration;
import org.jruby.util.ByteList;

public class ByteListLexerSource
extends LexerSource {
    private int begin;
    private int realSize;
    private int index;
    private byte[] bytes;

    public ByteListLexerSource(String sourceName, ByteList bytelist, List<String> list, int line, boolean extraPositionInformation) {
        super(sourceName, list, line, extraPositionInformation);
        this.bytes = bytelist.bytes;
        this.begin = this.index = bytelist.begin();
        this.realSize = bytelist.realSize;
    }

    @Override
    public boolean matchMarker(ByteList marker, boolean indent) throws IOException {
        char c;
        int start = this.index;
        if (indent) {
            while ((c = this.read()) != '\u0000') {
                if (Character.isWhitespace(c) && c != '\n') continue;
                --this.index;
                break;
            }
        }
        for (int i = 0; i < marker.length(); ++i) {
            if (marker.charAt(i) == this.read()) continue;
            this.index = start;
            return false;
        }
        c = (char)this.internalRead();
        return c == '\u0000' || c == '\n';
    }

    @Override
    public boolean peek(char c) throws IOException {
        if (this.index >= this.realSize) {
            return false;
        }
        return this.bytes[this.index] == c;
    }

    private byte internalRead() {
        return this.index >= this.realSize ? (byte)0 : this.bytes[this.index++];
    }

    @Override
    public char read() throws IOException {
        int c = this.internalRead();
        switch (c) {
            case 13: {
                c = this.internalRead();
                if (c != 10) {
                    this.unread((char)c);
                    c = 10;
                    ++this.line;
                    break;
                }
                ++this.offset;
                break;
            }
            case 10: {
                ++this.line;
            }
        }
        return (char)c;
    }

    @Override
    public ByteList readLineBytes() throws IOException {
        int count = 0;
        char c = this.read();
        while (c != '\n' && c != '\u0000') {
            ++count;
            c = this.read();
        }
        return new ByteList(this.bytes, this.index - count, count, false);
    }

    @Override
    public char skipUntil(char c) throws IOException {
        c = this.read();
        while (c != '\n' && c != '\u0000') {
            c = this.read();
        }
        return c;
    }

    @Override
    public void unread(char c) {
        if (c == '\u0000') {
            return;
        }
        --this.index;
        if (c == '\n') {
            --this.line;
        }
    }

    @Override
    public void unreadMany(CharSequence line) {
        int length = line.length();
        this.index -= length;
    }

    @Override
    public boolean wasBeginOfLine() {
        return this.index == 0 || this.bytes[this.index - 1] == 10;
    }

    @Override
    public String matchMarkerNoCase(ByteList match) throws IOException {
        ByteList buf = new ByteList(match.length());
        for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            char r = this.read();
            buf.append(r);
            if (Character.toLowerCase(c) == r || Character.toUpperCase(c) == r) continue;
            this.unreadMany(buf);
            return null;
        }
        return buf.toString();
    }

    public static LexerSource getSource(String file, ByteList content, List<String> list, ParserConfiguration configuration) {
        if (list != null) {
            return new CapturingByteListLexerSource(file, content, list, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
        }
        return new ByteListLexerSource(file, content, list, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
    }

    @Override
    public int getOffset() {
        return this.index - this.begin + this.offset;
    }

    @Override
    public ByteList readUntil(char marker) throws IOException {
        int begin;
        int i;
        for (i = begin = this.index; i < this.realSize && this.bytes[i] != marker; ++i) {
        }
        if (i >= this.realSize) {
            return null;
        }
        this.index = i;
        return new ByteList(this.bytes, begin, i - begin, false);
    }

    @Override
    public ByteList readIdentifer() throws IOException {
        int begin;
        int i;
        for (i = begin = this.index; i < this.realSize && RubyYaccLexer.isIdentifierChar((char)this.bytes[i]); ++i) {
        }
        if ((this.bytes[i] == 33 || this.bytes[i] == 63) && i + 1 < this.realSize && this.bytes[i + 1] != 61) {
            ++i;
        }
        this.index = i;
        return new ByteList(this.bytes, begin, i - begin, false);
    }
}

