/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

public class NativeThread
implements ThreadLike {
    private Thread nativeThread;
    public RubyThread rubyThread;

    public NativeThread(RubyThread rubyThread, IRubyObject[] args, Block block) {
        this.rubyThread = rubyThread;
        this.nativeThread = new RubyNativeThread(rubyThread, args, block);
    }

    public NativeThread(RubyThread rubyThread, Thread nativeThread) {
        this.rubyThread = rubyThread;
        this.nativeThread = nativeThread;
    }

    @Override
    public void start() {
        this.nativeThread.start();
    }

    @Override
    public void interrupt() {
        this.nativeThread.interrupt();
    }

    @Override
    public boolean isAlive() {
        return this.nativeThread.isAlive();
    }

    @Override
    public void join() throws InterruptedException {
        this.nativeThread.join();
    }

    @Override
    public void join(long timeoutMillis) throws InterruptedException {
        this.nativeThread.join(timeoutMillis);
    }

    @Override
    public int getPriority() {
        return this.nativeThread.getPriority();
    }

    @Override
    public void setPriority(int priority) {
        this.nativeThread.setPriority(priority);
    }

    @Override
    public boolean isCurrent() {
        return Thread.currentThread() == this.nativeThread;
    }

    @Override
    public boolean isInterrupted() {
        return this.nativeThread.isInterrupted();
    }
}

