/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyTCPSocket
extends RubyIPSocket {
    private static ObjectAllocator TCPSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPSocket(runtime, klass);
        }
    };

    static void createTCPSocket(Ruby runtime) {
        RubyClass rb_cTCPSocket = runtime.defineClass("TCPSocket", runtime.fastGetClass("IPSocket"), TCPSOCKET_ALLOCATOR);
        CallbackFactory cfact = runtime.callbackFactory(RubyTCPSocket.class);
        rb_cTCPSocket.includeModule(runtime.fastGetClass("Socket").fastGetConstant("Constants"));
        rb_cTCPSocket.defineFastMethod("initialize", cfact.getFastOptMethod("initialize"));
        rb_cTCPSocket.defineFastMethod("setsockopt", cfact.getFastOptMethod("setsockopt"));
        rb_cTCPSocket.getMetaClass().defineFastMethod("gethostbyname", cfact.getFastSingletonMethod("gethostbyname", IRubyObject.class));
        rb_cTCPSocket.getMetaClass().defineMethod("open", cfact.getOptSingletonMethod("open"));
        runtime.getObject().fastSetConstant("TCPsocket", rb_cTCPSocket);
    }

    public RubyTCPSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private int getPortFrom(IRubyObject arg) {
        return RubyNumeric.fix2int(arg instanceof RubyString ? RubyNumeric.str2inum(this.getRuntime(), (RubyString)arg, 0, true) : arg);
    }

    public IRubyObject initialize(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 2, 4);
        String remoteHost = args[0].convertToString().toString();
        int remotePort = this.getPortFrom(args[1]);
        String localHost = args.length >= 3 ? args[2].convertToString().toString() : null;
        int localPort = args.length == 4 ? this.getPortFrom(args[3]) : 0;
        try {
            SocketChannel channel = null;
            if (localHost == null) {
                InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(remoteHost), remotePort);
                channel = SocketChannel.open(addr);
            } else {
                channel = SocketChannel.open();
                Socket socket = channel.socket();
                socket.bind(new InetSocketAddress(InetAddress.getByName(localHost), localPort));
                socket.connect(new InetSocketAddress(InetAddress.getByName(remoteHost), remotePort));
            }
            channel.finishConnect();
            this.setChannel(channel);
        }
        catch (ConnectException e) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    public IRubyObject setsockopt(IRubyObject[] args) {
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyTCPSocket sock = (RubyTCPSocket)recv.callMethod(recv.getRuntime().getCurrentContext(), "new", args);
        if (!block.isGiven()) {
            return sock;
        }
        try {
            IRubyObject iRubyObject = block.yield(recv.getRuntime().getCurrentContext(), sock);
            return iRubyObject;
        }
        finally {
            if (sock.isOpen()) {
                sock.close();
            }
        }
    }

    public static IRubyObject gethostbyname(IRubyObject recv, IRubyObject hostname) {
        try {
            IRubyObject[] ret = new IRubyObject[4];
            Ruby r = recv.getRuntime();
            InetAddress addr = InetAddress.getByName(hostname.convertToString().toString());
            ret[0] = r.newString(addr.getCanonicalHostName());
            ret[1] = r.newArray();
            ret[2] = r.newFixnum(2L);
            ret[3] = r.newString(addr.getHostAddress());
            return r.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubyTCPSocket.sockerr(recv, "gethostbyname: name or service not known");
        }
    }
}

