/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileStat
extends RubyObject {
    private static final int READ = 146;
    private static final int WRITE = 292;
    private RubyFixnum blksize;
    private RubyBoolean isDirectory;
    private RubyBoolean isFile;
    private RubyString ftype;
    private RubyFixnum mode;
    private RubyTime mtime;
    private RubyTime ctime;
    private RubyBoolean isReadable;
    private RubyBoolean isWritable;
    private RubyFixnum size;
    private RubyBoolean isSymlink;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyFileStat(runtime, klass);
        }
    };

    public static RubyClass createFileStatClass(Ruby runtime) {
        RubyClass fileStatClass = runtime.getFile().defineClassUnder("Stat", runtime.getObject(), ALLOCATOR);
        runtime.setFileStat(fileStatClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFileStat.class);
        fileStatClass.includeModule(runtime.fastGetModule("Comparable"));
        fileStatClass.defineMethod("<=>", callbackFactory.getFastMethod("not_implemented1", IRubyObject.class));
        fileStatClass.defineMethod("atime", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("blockdev?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("blocks", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("chardev?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("dev", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("dev_major", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("dev_minor", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("executable?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("executable_real?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("gid", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("grpowned?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("initialize_copy", callbackFactory.getFastMethod("not_implemented1", IRubyObject.class));
        fileStatClass.defineMethod("inspect", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("nlink", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("owned?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("pipe?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("rdev", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("rdev_major", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("rdev_minor", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("readable_real?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("setgid?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("setuid?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("size?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("socket?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("sticky?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("writable_real?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineMethod("zero?", callbackFactory.getFastMethod("not_implemented"));
        fileStatClass.defineAnnotatedMethods(RubyFileStat.class);
        return fileStatClass;
    }

    protected RubyFileStat(Ruby runtime, RubyClass clazz) {
        super(runtime, clazz);
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject fname, Block unusedBlock) {
        JRubyFile file;
        Ruby runtime = this.getRuntime();
        String filename = fname.toString();
        if (RubyFile.IS_WINDOWS && filename.length() == 2 && filename.charAt(1) == ':' && Character.isLetter(filename.charAt(0))) {
            filename = filename + "/";
        }
        if (!(file = JRubyFile.create(runtime.getCurrentDirectory(), filename)).exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
        }
        this.blksize = runtime.newFixnum(4096L);
        this.isDirectory = runtime.newBoolean(file.isDirectory());
        this.isFile = runtime.newBoolean(file.isFile());
        this.ftype = file.isDirectory() ? runtime.newString("directory") : (file.isFile() ? runtime.newString("file") : null);
        int baseMode = 32768;
        if (file.canRead()) {
            baseMode += 146;
        }
        if (file.canWrite()) {
            baseMode += 292;
        }
        this.mode = runtime.newFixnum(baseMode);
        this.mtime = runtime.newTime(file.lastModified());
        this.ctime = runtime.newTime(file.getParentFile().lastModified());
        this.isReadable = runtime.newBoolean(file.canRead());
        this.isWritable = runtime.newBoolean(file.canWrite());
        this.size = runtime.newFixnum(file.length());
        this.isSymlink = runtime.getFalse();
        return this;
    }

    public IRubyObject not_implemented() {
        throw this.getRuntime().newNotImplementedError("File::Stat#" + this.getRuntime().getCurrentContext().getFrameName() + " not yet implemented");
    }

    public IRubyObject not_implemented1(IRubyObject arg) {
        throw this.getRuntime().newNotImplementedError("File::Stat#" + this.getRuntime().getCurrentContext().getFrameName() + " not yet implemented");
    }

    @JRubyMethod(name={"blksize"})
    public RubyFixnum blksize() {
        return this.blksize;
    }

    @JRubyMethod(name={"directory?"})
    public RubyBoolean directory_p() {
        return this.isDirectory;
    }

    @JRubyMethod(name={"file?"})
    public RubyBoolean file_p() {
        return this.isFile;
    }

    @JRubyMethod(name={"ftype"})
    public RubyString ftype() {
        return this.ftype;
    }

    @JRubyMethod(name={"ino"})
    public IRubyObject ino() {
        return this.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"uid"})
    public IRubyObject uid() {
        return this.getRuntime().newFixnum(-1L);
    }

    @JRubyMethod(name={"mode"})
    public IRubyObject mode() {
        return this.mode;
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.mtime;
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime() {
        return this.ctime;
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject readable_p() {
        return this.isReadable;
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.size;
    }

    @JRubyMethod(name={"symlink?"})
    public IRubyObject symlink_p() {
        return this.isSymlink;
    }

    @JRubyMethod(name={"writable?"})
    public IRubyObject writable_p() {
        return this.isWritable;
    }
}

