/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.NormalizedFile;

public class RubyDir
extends RubyObject {
    private RubyString path;
    protected JRubyFile dir;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private static ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyDir(runtime, klass);
        }
    };

    public RubyDir(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static RubyClass createDirClass(Ruby runtime) {
        RubyClass dirClass = runtime.defineClass("Dir", runtime.getObject(), DIR_ALLOCATOR);
        runtime.setDir(dirClass);
        dirClass.includeModule(runtime.getEnumerable());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyDir.class);
        dirClass.defineAnnotatedMethods(RubyDir.class);
        dirClass.dispatcher = callbackFactory.createDispatcher(dirClass);
        return dirClass;
    }

    private final void checkDir() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: operation on untainted Dir");
        }
        this.testFrozen("");
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true)
    public IRubyObject initialize(IRubyObject _newPath, Block unusedBlock) {
        RubyString newPath = _newPath.convertToString();
        this.getRuntime().checkSafeString(newPath);
        this.dir = JRubyFile.create(this.getRuntime().getCurrentDirectory(), newPath.toString());
        if (!this.dir.isDirectory()) {
            this.dir = null;
            throw this.getRuntime().newErrnoENOENTError(newPath.toString() + " is not a directory");
        }
        this.path = newPath;
        ArrayList<String> snapshotList = new ArrayList<String>();
        snapshotList.add(".");
        snapshotList.add("..");
        snapshotList.addAll(RubyDir.getContents(this.dir));
        this.snapshot = snapshotList.toArray(new String[snapshotList.size()]);
        this.pos = 0;
        return this;
    }

    @JRubyMethod(name={"glob", "[]"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject glob(IRubyObject recv, IRubyObject[] args, Block block) {
        String cwd2;
        String cwd = recv.getRuntime().getCurrentDirectory();
        int flags = 0;
        if (Arity.checkArgumentCount(recv.getRuntime(), args, 1, 2) == 2) {
            flags = RubyNumeric.num2int(args[1]);
        }
        ByteList pt = args[0].convertToString().getByteList();
        try {
            cwd2 = new NormalizedFile(cwd).getCanonicalPath();
        }
        catch (Exception e) {
            cwd2 = cwd;
        }
        List<ByteList> l = Dir.push_glob(cwd2, pt.bytes, pt.begin, pt.realSize, flags);
        if (block.isGiven()) {
            ThreadContext context = recv.getRuntime().getCurrentContext();
            Iterator<ByteList> iter = l.iterator();
            while (iter.hasNext()) {
                block.yield(context, RubyString.newString(recv.getRuntime(), iter.next()));
            }
            return recv.getRuntime().getNil();
        }
        IRubyObject[] l2 = new IRubyObject[l.size()];
        int i = 0;
        Iterator<ByteList> iter = l.iterator();
        while (iter.hasNext()) {
            l2[i] = RubyString.newString(recv.getRuntime(), iter.next());
            ++i;
        }
        return recv.getRuntime().newArrayNoCopy(l2);
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries() {
        return this.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    @JRubyMethod(name={"entries"}, required=1, meta=true)
    public static RubyArray entries(IRubyObject recv, IRubyObject path) {
        JRubyFile directory = JRubyFile.create(recv.getRuntime().getCurrentDirectory(), path.convertToString().toString());
        if (!directory.isDirectory()) {
            throw recv.getRuntime().newErrnoENOENTError("No such directory");
        }
        List fileList = RubyDir.getContents(directory);
        fileList.add(0, ".");
        fileList.add(1, "..");
        Object[] files = fileList.toArray();
        return recv.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(recv.getRuntime(), files));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"chdir"}, optional=1, frame=true, meta=true)
    public static IRubyObject chdir(IRubyObject recv, IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(recv.getRuntime(), args, 0, 1);
        RubyString path = args.length == 1 ? args[0].convertToString() : RubyDir.getHomeDirectoryPath(recv);
        JRubyFile dir = RubyDir.getDir(recv.getRuntime(), path.toString(), true);
        String realPath = null;
        String oldCwd = recv.getRuntime().getCurrentDirectory();
        try {
            realPath = dir.getCanonicalPath();
        }
        catch (IOException e) {
            realPath = dir.getAbsolutePath();
        }
        IRubyObject result = null;
        if (block.isGiven()) {
            recv.getRuntime().setCurrentDirectory(realPath);
            try {
                result = block.yield(recv.getRuntime().getCurrentContext(), path);
            }
            finally {
                recv.getRuntime().setCurrentDirectory(oldCwd);
            }
        } else {
            recv.getRuntime().setCurrentDirectory(realPath);
            result = recv.getRuntime().newFixnum(0L);
        }
        return result;
    }

    @JRubyMethod(name={"chroot"}, required=1, meta=true)
    public static IRubyObject chroot(IRubyObject recv, IRubyObject path) {
        throw recv.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true)
    public static IRubyObject rmdir(IRubyObject recv, IRubyObject path) {
        JRubyFile directory = RubyDir.getDir(recv.getRuntime(), path.convertToString().toString(), true);
        if (!directory.delete()) {
            throw recv.getRuntime().newSystemCallError("No such directory");
        }
        return recv.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"foreach"}, required=1, frame=true, meta=true)
    public static IRubyObject foreach(IRubyObject recv, IRubyObject _path, Block block) {
        RubyString path = _path.convertToString();
        recv.getRuntime().checkSafeString(path);
        RubyClass dirClass = recv.getRuntime().getDir();
        RubyDir dir = (RubyDir)dirClass.newInstance(new IRubyObject[]{path}, block);
        dir.each(block);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(IRubyObject recv) {
        return recv.getRuntime().newString(recv.getRuntime().getCurrentDirectory());
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true)
    public static IRubyObject mkdir(IRubyObject recv, IRubyObject[] args) {
        if (args.length < 1) {
            throw recv.getRuntime().newArgumentError(args.length, 1);
        }
        if (args.length > 2) {
            throw recv.getRuntime().newArgumentError(args.length, 2);
        }
        recv.getRuntime().checkSafeString(args[0]);
        String path = args[0].toString();
        File newDir = RubyDir.getDir(recv.getRuntime(), path, false);
        if (File.separatorChar == '\\') {
            newDir = new File(((File)newDir).getPath());
        }
        if (newDir.mkdirs()) {
            return RubyFixnum.zero(recv.getRuntime());
        }
        throw recv.getRuntime().newSystemCallError("mkdir failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv, IRubyObject path, Block block) {
        RubyDir directory = (RubyDir)recv.getRuntime().getDir().newInstance(new IRubyObject[]{path}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            block.yield(recv.getRuntime().getCurrentContext(), directory);
        }
        finally {
            directory.close();
        }
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.checkDir();
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(Block block) {
        this.checkDir();
        String[] contents = this.snapshot;
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < contents.length; ++i) {
            block.yield(context, this.getRuntime().newString(contents[i]));
        }
        return this;
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell() {
        this.checkDir();
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"seek"}, required=1)
    public IRubyObject seek(IRubyObject newPos) {
        this.checkDir();
        this.set_pos(newPos);
        return this;
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject newPos) {
        this.pos = RubyNumeric.fix2int(newPos);
        return newPos;
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path() {
        this.checkDir();
        return this.path.strDup();
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read() {
        this.checkDir();
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return result;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        this.checkDir();
        this.pos = 0;
        return this;
    }

    protected static JRubyFile getDir(Ruby runtime, String path, boolean mustExist) {
        JRubyFile result = JRubyFile.create(runtime.getCurrentDirectory(), path);
        boolean isDirectory = result.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime.newErrnoENOENTError(path + " is not a directory");
        }
        if (!mustExist && isDirectory) {
            throw runtime.newErrnoEEXISTError("File exists - " + path);
        }
        return result;
    }

    protected static List getContents(File directory) {
        String[] contents = directory.list();
        ArrayList<String> result = new ArrayList<String>();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                result.add(contents[i]);
            }
        }
        return result;
    }

    protected static List getContents(File directory, Ruby runtime) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        for (int i = 0; i < contents.length; ++i) {
            result.add(runtime.newString(contents[i]));
        }
        return result;
    }

    public static IRubyObject getHomeDirectoryPath(IRubyObject recv, String user) {
        String passwd = null;
        try {
            FileInputStream stream = new FileInputStream("/etc/passwd");
            int totalBytes = stream.available();
            byte[] bytes = new byte[totalBytes];
            stream.read(bytes);
            passwd = new String(bytes);
        }
        catch (IOException e) {
            return recv.getRuntime().getNil();
        }
        String[] rows = passwd.split("\n");
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            String[] fields = rows[i].split(":");
            if (!fields[0].equals(user)) continue;
            return recv.getRuntime().newString(fields[5]);
        }
        throw recv.getRuntime().newArgumentError("user " + user + " doesn't exist");
    }

    public static RubyString getHomeDirectoryPath(IRubyObject recv) {
        RubyHash systemHash = (RubyHash)recv.getRuntime().getObject().fastGetConstant("ENV_JAVA");
        RubyHash envHash = (RubyHash)recv.getRuntime().getObject().fastGetConstant("ENV");
        IRubyObject home = envHash.op_aref(recv.getRuntime().newString("HOME"));
        if (home == null || home.isNil()) {
            home = systemHash.op_aref(recv.getRuntime().newString("user.home"));
        }
        if (home == null || home.isNil()) {
            home = envHash.op_aref(recv.getRuntime().newString("LOGDIR"));
        }
        if (home == null || home.isNil()) {
            throw recv.getRuntime().newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home;
    }
}

