/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.TypeMapper;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class Native {
    private static Map typeMappers = Collections.synchronizedMap(new WeakHashMap());
    private static Map alignments = Collections.synchronizedMap(new WeakHashMap());
    private static Map libraries = Collections.synchronizedMap(new WeakHashMap());
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;

    private Native() {
    }

    private static native void initIDs();

    public static native void setProtected(boolean var0);

    public static native boolean isProtected();

    public static long getWindowID(Window w) {
        return Native.getComponentID(w);
    }

    public static long getComponentID(Component c) {
        if (c.isLightweight()) {
            throw new IllegalArgumentException("Component must be heavyweight");
        }
        if (!c.isDisplayable()) {
            throw new IllegalStateException("Component must be displayable");
        }
        if (Platform.isX11() && System.getProperty("java.version").matches("^1\\.4\\..*") && !c.isVisible()) {
            throw new IllegalStateException("Component must be visible");
        }
        return Native.getWindowHandle0(c);
    }

    public static Pointer getWindowPointer(Window w) {
        return Native.getComponentPointer(w);
    }

    public static Pointer getComponentPointer(Component c) {
        return new Pointer(Native.getComponentID(c));
    }

    private static native long getWindowHandle0(Component var0);

    public static Pointer getByteBufferPointer(ByteBuffer b) {
        return Native.getDirectBufferPointer(b);
    }

    public static native Pointer getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] buf) {
        int term;
        String encoding = System.getProperty("jna.encoding");
        String s = null;
        if (encoding != null) {
            try {
                s = new String(buf, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new String(buf);
        }
        if ((term = s.indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Object loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String name, Class interfaceClass, Map options) {
        Library.Handler handler = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        if (options.containsKey("type-mapper")) {
            typeMappers.put(interfaceClass, options.get("type-mapper"));
        }
        if (options.containsKey("structure-alignment")) {
            alignments.put(interfaceClass, options.get("structure-alignment"));
        }
        return proxy;
    }

    private static boolean loadInstance(Class cls) {
        if (libraries.containsKey(cls)) {
            return true;
        }
        if (cls != null) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    libraries.put(cls, field.get(null));
                    return true;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access instance of " + cls + " (" + e + ")");
            }
        }
        return false;
    }

    public static TypeMapper getTypeMapper(Class interfaceClass) {
        if (!Native.loadInstance(interfaceClass) || !typeMappers.containsKey(interfaceClass)) {
            try {
                Field field = interfaceClass.getField("TYPE_MAPPER");
                return (TypeMapper)field.get(null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("TYPE_MAPPER must be a public TypeMapper field (" + e + "): " + interfaceClass);
            }
        }
        return (TypeMapper)typeMappers.get(interfaceClass);
    }

    public static int getStructureAlignment(Class interfaceClass) {
        Integer value;
        if (!Native.loadInstance(interfaceClass) || !alignments.containsKey(interfaceClass)) {
            try {
                Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                return (Integer)field.get(null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("STRUCTURE_ALIGNMENT must be a public int field (" + e + "): " + interfaceClass);
            }
        }
        return (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
    }

    static byte[] getBytes(String s) {
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null) {
            try {
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s.getBytes();
    }

    private static String getNativeLibraryResourcePath() {
        String osPrefix;
        String arch = System.getProperty("os.arch");
        if (Platform.isWindows()) {
            osPrefix = "win32-" + arch;
        } else if (Platform.isMac()) {
            osPrefix = "darwin";
        } else if (Platform.isLinux()) {
            osPrefix = "linux-" + arch;
        } else if (Platform.isSolaris()) {
            osPrefix = "sunos-" + arch;
        } else {
            osPrefix = System.getProperty("os.name").toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            osPrefix = osPrefix + "-" + arch;
        }
        return "/com/sun/jna/" + osPrefix;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static boolean loadNativeLibrary() {
        File lib;
        block22: {
            int buf;
            String resourceName;
            String libname = System.mapLibraryName("jnidispatch");
            URL url = Native.class.getResource(resourceName = Native.getNativeLibraryResourcePath() + "/" + libname);
            if (url == null) {
                System.err.println("Warning: jnidispatch (" + resourceName + ") not found in resource path");
                return false;
            }
            lib = null;
            if (url.getProtocol().toLowerCase().equals("file")) {
                try {
                    lib = new File(URLDecoder.decode(url.getPath(), "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("JRE is unexpectedly missing UTF8 encoding");
                }
            }
            InputStream is = Native.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain jnidispatch InputStream");
            }
            FileOutputStream fos = null;
            lib = File.createTempFile("jna", null);
            lib.deleteOnExit();
            fos = new FileOutputStream(lib);
            byte[] byArray = new byte[1024];
            while ((buf = is.read(byArray, 0, byArray.length)) > 0) {
                void count;
                fos.write((byte[])count, 0, buf);
            }
            Object var9_11 = null;
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            break block22;
            {
                catch (IOException iOException) {
                    throw new Error("Failed to create temporary file for jnidispatch library", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (Platform.isWindows()) {
            Toolkit.getDefaultToolkit();
            try {
                System.loadLibrary("jawt");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
        }
        System.load(lib.getAbsolutePath());
        return true;
    }

    private static native int pointerSize();

    private static native int longSize();

    private static native int wideCharSize();

    static {
        if (!Native.loadNativeLibrary()) {
            System.loadLibrary("jnidispatch");
        }
        POINTER_SIZE = Native.pointerSize();
        LONG_SIZE = Native.longSize();
        WCHAR_SIZE = Native.wideCharSize();
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
    }
}

