/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;

public class Memory
extends Pointer {
    protected int size;

    public Memory(int size) {
        this.size = size;
        if (size <= 0) {
            throw new IllegalArgumentException("Allocation size must be >= 0");
        }
        this.peer = Memory.malloc(size);
        if (this.peer == 0L) {
            throw new OutOfMemoryError();
        }
    }

    protected Memory() {
    }

    Pointer share(int offset, int sz) {
        this.boundsCheck(offset, sz);
        return new SharedMemory(offset);
    }

    protected void finalize() {
        if (this.peer != 0L) {
            Memory.free(this.peer);
            this.peer = 0L;
        }
    }

    public void clear() {
        this.clear(this.size);
    }

    public boolean isValid() {
        return this.peer != 0L;
    }

    public int getSize() {
        return this.size;
    }

    private void boundsCheck(int off, int sz) {
        if (off < 0) {
            throw new IndexOutOfBoundsException("Invalid offset: " + off);
        }
        if (off + sz > this.size) {
            String msg = "Bounds exceeds available space : size=" + this.size + ", offset=" + (off + sz);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public void read(int bOff, byte[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 1);
        super.read(bOff, buf, index, length);
    }

    public void read(int bOff, short[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.read(bOff, buf, index, length);
    }

    public void read(int bOff, char[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.read(bOff, buf, index, length);
    }

    public void read(int bOff, int[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.read(bOff, buf, index, length);
    }

    public void read(int bOff, long[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.read(bOff, buf, index, length);
    }

    public void read(int bOff, float[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.read(bOff, buf, index, length);
    }

    public void read(int bOff, double[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.read(bOff, buf, index, length);
    }

    public void write(int bOff, byte[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 1);
        super.write(bOff, buf, index, length);
    }

    public void write(int bOff, short[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.write(bOff, buf, index, length);
    }

    public void write(int bOff, char[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.write(bOff, buf, index, length);
    }

    public void write(int bOff, int[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.write(bOff, buf, index, length);
    }

    public void write(int bOff, long[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.write(bOff, buf, index, length);
    }

    public void write(int bOff, float[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.write(bOff, buf, index, length);
    }

    public void write(int bOff, double[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.write(bOff, buf, index, length);
    }

    public byte getByte(int offset) {
        this.boundsCheck(offset, 1);
        return super.getByte(offset);
    }

    public char getChar(int offset) {
        this.boundsCheck(offset, 1);
        return super.getChar(offset);
    }

    public short getShort(int offset) {
        this.boundsCheck(offset, 2);
        return super.getShort(offset);
    }

    public int getInt(int offset) {
        this.boundsCheck(offset, 4);
        return super.getInt(offset);
    }

    public long getLong(int offset) {
        this.boundsCheck(offset, 8);
        return super.getLong(offset);
    }

    public float getFloat(int offset) {
        this.boundsCheck(offset, 4);
        return super.getFloat(offset);
    }

    public double getDouble(int offset) {
        this.boundsCheck(offset, 8);
        return super.getDouble(offset);
    }

    public Pointer getPointer(int offset) {
        this.boundsCheck(offset, Pointer.SIZE);
        return super.getPointer(offset);
    }

    public ByteBuffer getByteBuffer(int offset, int length) {
        this.boundsCheck(offset, length);
        return super.getByteBuffer(offset, length);
    }

    public String getString(int offset, boolean wide) {
        this.boundsCheck(offset, 0);
        return super.getString(offset, wide);
    }

    public void setByte(int offset, byte value) {
        this.boundsCheck(offset, 1);
        super.setByte(offset, value);
    }

    public void setChar(int offset, char value) {
        this.boundsCheck(offset, Native.WCHAR_SIZE);
        super.setChar(offset, value);
    }

    public void setShort(int offset, short value) {
        this.boundsCheck(offset, 2);
        super.setShort(offset, value);
    }

    public void setInt(int offset, int value) {
        this.boundsCheck(offset, 4);
        super.setInt(offset, value);
    }

    public void setLong(int offset, long value) {
        this.boundsCheck(offset, 8);
        super.setLong(offset, value);
    }

    public void setFloat(int offset, float value) {
        this.boundsCheck(offset, 4);
        super.setFloat(offset, value);
    }

    public void setDouble(int offset, double value) {
        this.boundsCheck(offset, 8);
        super.setDouble(offset, value);
    }

    public void setPointer(int offset, Pointer value) {
        this.boundsCheck(offset, Pointer.SIZE);
        super.setPointer(offset, value);
    }

    public void setString(int offset, String value, boolean wide) {
        if (wide) {
            this.boundsCheck(offset, (value.length() + 1) * Native.WCHAR_SIZE);
        } else {
            this.boundsCheck(offset, value.getBytes().length + 1);
        }
        super.setString(offset, value, wide);
    }

    static native long malloc(int var0);

    static native void free(long var0);

    public String toString() {
        return "Native Allocated Memory <0x" + Long.toHexString(this.peer) + "> (" + this.size + " bytes)";
    }

    private class SharedMemory
    extends Memory {
        public SharedMemory(int offset) {
            this.size = Memory.this.size - offset;
            this.peer = Memory.this.peer + (long)offset;
        }

        protected void finalize() {
        }
    }
}

