/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubySymbol
extends RubyObject {
    private final String symbol;
    private final int id;

    private RubySymbol(Ruby runtime, String internedSymbol) {
        super(runtime, runtime.getSymbol(), false);
        assert (internedSymbol == internedSymbol.intern()) : internedSymbol + " is not interned";
        this.symbol = internedSymbol;
        this.id = runtime.allocSymbolId();
    }

    public static RubyClass createSymbolClass(Ruby runtime) {
        RubyClass symbolClass = runtime.defineClass("Symbol", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setSymbol(symbolClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubySymbol.class);
        RubyClass symbolMetaClass = symbolClass.getMetaClass();
        symbolClass.index = 8;
        symbolClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubySymbol;
            }
        };
        symbolClass.defineAnnotatedMethods(RubySymbol.class);
        symbolMetaClass.undefineMethod("new");
        symbolClass.dispatcher = callbackFactory.createDispatcher(symbolClass);
        return symbolClass;
    }

    public int getNativeTypeIndex() {
        return 8;
    }

    public String asJavaString() {
        return this.symbol;
    }

    public final boolean eql(IRubyObject other) {
        return other == this;
    }

    public boolean isImmediate() {
        return true;
    }

    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    public static RubySymbol getSymbolLong(Ruby runtime, long id) {
        return runtime.getSymbolTable().lookup(id);
    }

    public static RubySymbol newSymbol(Ruby runtime, String name) {
        return runtime.getSymbolTable().getSymbol(name);
    }

    @JRubyMethod(name={"to_i"})
    public RubyFixnum to_i() {
        return this.getRuntime().newFixnum(this.id);
    }

    @JRubyMethod(name={"to_int"})
    public RubyFixnum to_int() {
        if (this.getRuntime().getVerbose().isTrue()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYMBOL_AS_INTEGER, "treating Symbol as an integer", new Object[0]);
        }
        return this.to_i();
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.getRuntime().newString(":" + (RubySymbol.isSymbolName(this.symbol) ? this.symbol : this.getRuntime().newString(this.symbol).dump().toString()));
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.getRuntime().newString(this.symbol);
    }

    @JRubyMethod(name={"id2name"})
    public IRubyObject id2name() {
        return this.to_s();
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(IRubyObject other) {
        return super.op_equal(other);
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public int hashCode() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        return other == this;
    }

    @JRubyMethod(name={"to_sym"})
    public IRubyObject to_sym() {
        return this;
    }

    public IRubyObject freeze() {
        return this;
    }

    public IRubyObject taint() {
        return this;
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentifier(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        if (!RubySymbol.isIdentStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (RubySymbol.isIdentChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        int length = s.length();
        switch (s.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return length == 1;
            }
            case '-': {
                return length == 1 || length == 2 && RubySymbol.isIdentChar(s.charAt(1));
            }
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName(String s) {
        char d;
        int last;
        if (s == null || s.length() < 1) {
            return false;
        }
        int length = s.length();
        char c = s.charAt(0);
        switch (c) {
            case '$': {
                return length > 1 && RubySymbol.isSpecialGlobalName(s.substring(1));
            }
            case '@': {
                int offset = 1;
                if (length >= 2 && s.charAt(1) == '@') {
                    ++offset;
                }
                return RubySymbol.isIdentifier(s.substring(offset));
            }
            case '<': {
                return length == 1 || length == 2 && (s.equals("<<") || s.equals("<=")) || length == 3 && s.equals("<=>");
            }
            case '>': {
                return length == 1 || length == 2 && (s.equals(">>") || s.equals(">="));
            }
            case '=': {
                return length == 2 && (s.equals("==") || s.equals("=~")) || length == 3 && s.equals("===");
            }
            case '*': {
                return length == 1 || length == 2 && s.equals("**");
            }
            case '+': {
                return length == 1 || length == 2 && s.equals("+@");
            }
            case '-': {
                return length == 1 || length == 2 && s.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return length == 1;
            }
            case '[': {
                return s.equals("[]") || s.equals("[]=");
            }
        }
        if (!RubySymbol.isIdentStart(c)) {
            return false;
        }
        boolean localID = c >= 'a' && c <= 'z';
        for (last = 1; last < length && RubySymbol.isIdentChar(d = s.charAt(last)); ++last) {
        }
        if (last == length) {
            return true;
        }
        if (localID && last == length - 1) {
            d = s.charAt(last);
            return d == '!' || d == '?' || d == '=';
        }
        return false;
    }

    @JRubyMethod(name={"all_symbols"}, meta=true)
    public static IRubyObject all_symbols(IRubyObject recv) {
        return recv.getRuntime().getSymbolTable().all_symbols();
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol result = RubySymbol.newSymbol(input.getRuntime(), RubyString.byteListToString(input.unmarshalString()));
        input.registerLinkTarget(result);
        return result;
    }

    public static class SymbolTable {
        static final int DEFAULT_INITIAL_CAPACITY = 2048;
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final ReentrantLock tableLock = new ReentrantLock();
        private volatile SymbolEntry[] symbolTable;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final Ruby runtime;

        public SymbolTable(Ruby runtime) {
            this.runtime = runtime;
            this.loadFactor = 0.75f;
            this.threshold = 1536;
            this.symbolTable = new SymbolEntry[2048];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RubySymbol getSymbol(String name) {
            int hash = name.hashCode();
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = this.symbolTable[hash & table.length - 1];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    return e.symbol;
                }
                e = e.next;
            }
            ReentrantLock lock = this.tableLock;
            lock.lock();
            try {
                int potentialNewSize = this.size + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.symbolTable;
                int index = hash & table.length - 1;
                SymbolEntry e2 = table[index];
                while (e2 != null) {
                    if (hash == e2.hash && name.equals(e2.name)) {
                        RubySymbol rubySymbol = e2.symbol;
                        return rubySymbol;
                    }
                    e2 = e2.next;
                }
                String internedName = name.intern();
                RubySymbol symbol = new RubySymbol(this.runtime, internedName);
                table[index] = new SymbolEntry(hash, internedName, symbol, table[index]);
                this.size = potentialNewSize;
                this.symbolTable = table;
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public RubySymbol fastGetSymbol(String internedName) {
            assert (internedName == internedName.intern()) : internedName + " is not interned";
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = this.symbolTable[internedName.hashCode() & table.length - 1];
            while (e != null) {
                if (internedName == e.name) {
                    return e.symbol;
                }
                e = e.next;
            }
            ReentrantLock lock = this.tableLock;
            lock.lock();
            try {
                void index;
                int potentialNewSize = this.size + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.symbolTable;
                int n = internedName.hashCode();
                int hash = n & table.length - 1;
                SymbolEntry e2 = table[hash];
                while (e2 != null) {
                    if (internedName == e2.name) {
                        RubySymbol rubySymbol = e2.symbol;
                        return rubySymbol;
                    }
                    e2 = e2.next;
                }
                RubySymbol symbol = new RubySymbol(this.runtime, internedName);
                table[hash] = new SymbolEntry((int)index, internedName, symbol, table[hash]);
                this.size = potentialNewSize;
                this.symbolTable = table;
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock.unlock();
            }
        }

        public RubySymbol lookup(String name) {
            int hash = name.hashCode();
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = this.symbolTable[hash & table.length - 1];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    return e.symbol;
                }
                e = e.next;
            }
            return null;
        }

        public RubySymbol lookup(long id) {
            SymbolEntry[] table = this.symbolTable;
            int i = table.length;
            while (--i >= 0) {
                SymbolEntry e = table[i];
                while (e != null) {
                    if (id == (long)e.symbol.id) {
                        return e.symbol;
                    }
                    e = e.next;
                }
            }
            return null;
        }

        public RubyArray all_symbols() {
            SymbolEntry[] table = this.symbolTable;
            RubyArray array = this.runtime.newArray(this.size);
            int i = table.length;
            while (--i >= 0) {
                SymbolEntry e = table[i];
                while (e != null) {
                    array.append(e.symbol);
                    e = e.next;
                }
            }
            return array;
        }

        @Deprecated
        public void store(RubySymbol symbol) {
            throw new UnsupportedOperationException();
        }

        private SymbolEntry[] rehash() {
            SymbolEntry[] oldTable = this.symbolTable;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return oldTable;
            }
            int newCapacity = oldCapacity << 1;
            SymbolEntry[] newTable = new SymbolEntry[newCapacity];
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            int sizeMask = newCapacity - 1;
            int n = oldCapacity;
            while (--n >= 0) {
                int k;
                SymbolEntry i = oldTable[n];
                if (i == null) continue;
                SymbolEntry next = i.next;
                int idx = i.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = i;
                    continue;
                }
                SymbolEntry lastRun = i;
                int lastIdx = idx;
                SymbolEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                SymbolEntry p = i;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    SymbolEntry n2 = newTable[k];
                    newTable[k] = new SymbolEntry(p.hash, p.name, p.symbol, n2);
                    p = p.next;
                }
            }
            this.symbolTable = newTable;
            return newTable;
        }

        static class SymbolEntry {
            final int hash;
            final String name;
            final RubySymbol symbol;
            final SymbolEntry next;

            SymbolEntry(int hash, String name, RubySymbol symbol, SymbolEntry next) {
                this.hash = hash;
                this.name = name;
                this.symbol = symbol;
                this.next = next;
            }
        }
    }
}

