/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.jar.JarFile;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileTest {
    public static RubyModule createFileTestModule(Ruby runtime) {
        RubyModule fileTestModule = runtime.defineModule("FileTest");
        runtime.setFileTest(fileTestModule);
        fileTestModule.defineAnnotatedMethods(RubyFileTest.class);
        return fileTestModule;
    }

    @JRubyMethod(name={"blockdev?"}, required=1, module=true)
    public static IRubyObject blockdev_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isBlockDev());
    }

    @JRubyMethod(name={"chardev?"}, required=1, module=true)
    public static IRubyObject chardev_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isCharDev());
    }

    @JRubyMethod(name={"directory?"}, required=1, module=true)
    public static IRubyObject directory_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isDirectory());
    }

    @JRubyMethod(name={"executable?"}, required=1, module=true)
    public static IRubyObject executable_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isExecutable());
    }

    @JRubyMethod(name={"executable_real?"}, required=1, module=true)
    public static IRubyObject executable_real_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isExecutableReal());
    }

    @JRubyMethod(name={"exist?", "exists?"}, required=1, module=true)
    public static IRubyObject exist_p(IRubyObject recv, IRubyObject filename) {
        if (Ruby.isSecurityRestricted()) {
            return recv.getRuntime().newBoolean(false);
        }
        if (filename.convertToString().toString().startsWith("file:")) {
            String file = filename.convertToString().toString().substring(5);
            String jar = file.substring(0, file.indexOf("!"));
            String after = file.substring(file.indexOf("!") + 2);
            try {
                JarFile jf = new JarFile(jar);
                if (jf.getJarEntry(after) != null) {
                    return recv.getRuntime().newBoolean(true);
                }
                return recv.getRuntime().newBoolean(false);
            }
            catch (Exception e) {
                return recv.getRuntime().newBoolean(false);
            }
        }
        return recv.getRuntime().newBoolean(RubyFileTest.file(filename).exists());
    }

    @JRubyMethod(name={"file?"}, required=1, module=true)
    public static RubyBoolean file_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.file(filename);
        return filename.getRuntime().newBoolean(file.exists() && file.isFile());
    }

    @JRubyMethod(name={"grpowned?"}, required=1, module=true)
    public static IRubyObject grpowned_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isGroupOwned());
    }

    @JRubyMethod(name={"identical?"}, required=2, module=true)
    public static IRubyObject identical_p(IRubyObject recv, IRubyObject filename1, IRubyObject filename2) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file1 = RubyFileTest.file(filename1);
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime.newBoolean(file1.exists() && file2.exists() && runtime.getPosix().stat(file1.getAbsolutePath()).isIdentical(runtime.getPosix().stat(file2.getAbsolutePath())));
    }

    @JRubyMethod(name={"owned?"}, required=1, module=true)
    public static IRubyObject owned_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isOwned());
    }

    @JRubyMethod(name={"pipe?"}, required=1, module=true)
    public static IRubyObject pipe_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isNamedPipe());
    }

    @JRubyMethod(name={"readable?", "readable_real?"}, required=1, module=true)
    public static IRubyObject readable_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.file(filename);
        return recv.getRuntime().newBoolean(file.exists() && file.canRead());
    }

    public static IRubyObject rowned_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isROwned());
    }

    @JRubyMethod(name={"setgid?"}, required=1, module=true)
    public static IRubyObject setgid_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isSetgid());
    }

    @JRubyMethod(name={"setuid?"}, required=1, module=true)
    public static IRubyObject setuid_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isSetuid());
    }

    @JRubyMethod(name={"size"}, required=1, module=true)
    public static IRubyObject size(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.file(filename);
        if (!file.exists()) {
            RubyFileTest.noFileError(filename);
        }
        return recv.getRuntime().newFixnum(file.length());
    }

    @JRubyMethod(name={"size?"}, required=1, module=true)
    public static IRubyObject size_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.file(filename);
        if (!file.exists()) {
            return recv.getRuntime().getNil();
        }
        return recv.getRuntime().newFixnum(file.length());
    }

    @JRubyMethod(name={"socket?"}, required=1, module=true)
    public static IRubyObject socket_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isSocket());
    }

    @JRubyMethod(name={"sticky?"}, required=1, module=true)
    public static IRubyObject sticky_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().stat(file.getAbsolutePath()).isSticky());
    }

    @JRubyMethod(name={"symlink?"}, required=1, module=true)
    public static RubyBoolean symlink_p(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        JRubyFile file = RubyFileTest.file(filename);
        return runtime.newBoolean(file.exists() && runtime.getPosix().lstat(file.getAbsolutePath()).isSymlink());
    }

    @JRubyMethod(name={"writable?", "writable_real?"}, required=1, module=true)
    public static RubyBoolean writable_p(IRubyObject recv, IRubyObject filename) {
        return filename.getRuntime().newBoolean(RubyFileTest.file(filename).canWrite());
    }

    @JRubyMethod(name={"zero?"}, required=1, module=true)
    public static RubyBoolean zero_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.file(filename);
        return filename.getRuntime().newBoolean(file.exists() && file.length() == 0L);
    }

    private static JRubyFile file(IRubyObject path) {
        String filename = path.convertToString().toString();
        return JRubyFile.create(path.getRuntime().getCurrentDirectory(), filename);
    }

    private static void noFileError(IRubyObject filename) {
        throw filename.getRuntime().newErrnoENOENTError("No such file or directory - " + filename.convertToString());
    }
}

