/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.util.Platform;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.NormalizedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyDir
extends RubyObject {
    private RubyString path;
    protected JRubyFile dir;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private static final ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyDir(runtime, klass);
        }
    };

    public RubyDir(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static RubyClass createDirClass(Ruby runtime) {
        RubyClass dirClass = runtime.defineClass("Dir", runtime.getObject(), DIR_ALLOCATOR);
        runtime.setDir(dirClass);
        dirClass.includeModule(runtime.getEnumerable());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyDir.class);
        dirClass.defineAnnotatedMethods(RubyDir.class);
        dirClass.dispatcher = callbackFactory.createDispatcher(dirClass);
        return dirClass;
    }

    private final void checkDir() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: operation on untainted Dir");
        }
        this.testFrozen("");
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true)
    public IRubyObject initialize(IRubyObject _newPath, Block unusedBlock) {
        RubyString newPath = _newPath.convertToString();
        this.getRuntime().checkSafeString(newPath);
        String adjustedPath = RubyFile.adjustRootPathOnWindows(this.getRuntime(), newPath.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(this.getRuntime(), adjustedPath);
        this.dir = JRubyFile.create(this.getRuntime().getCurrentDirectory(), adjustedPath);
        if (!this.dir.isDirectory()) {
            this.dir = null;
            throw this.getRuntime().newErrnoENOENTError(newPath.toString() + " is not a directory");
        }
        this.path = newPath;
        ArrayList<String> snapshotList = new ArrayList<String>();
        snapshotList.add(".");
        snapshotList.add("..");
        snapshotList.addAll(RubyDir.getContents(this.dir));
        this.snapshot = snapshotList.toArray(new String[snapshotList.size()]);
        this.pos = 0;
        return this;
    }

    private static List<ByteList> dirGlobs(String cwd, IRubyObject[] args, int flags) {
        ArrayList<ByteList> dirs = new ArrayList<ByteList>();
        for (int i = 0; i < args.length; ++i) {
            ByteList globPattern = args[i].convertToString().getByteList();
            dirs.addAll(Dir.push_glob(cwd, globPattern, flags));
        }
        return dirs;
    }

    private static IRubyObject asRubyStringList(Ruby runtime, List<ByteList> dirs) {
        ArrayList<RubyString> allFiles = new ArrayList<RubyString>();
        for (ByteList dir : dirs) {
            allFiles.add(RubyString.newString(runtime, dir));
        }
        IRubyObject[] tempFileList = new IRubyObject[allFiles.size()];
        allFiles.toArray(tempFileList);
        return runtime.newArrayNoCopy(tempFileList);
    }

    private static String getCWD(Ruby runtime) {
        try {
            return new NormalizedFile(runtime.getCurrentDirectory()).getCanonicalPath();
        }
        catch (Exception e) {
            return runtime.getCurrentDirectory();
        }
    }

    @JRubyMethod(name={"[]"}, required=1, optional=1, meta=true)
    public static IRubyObject aref(IRubyObject recv, IRubyObject[] args) {
        List<ByteList> dirs;
        if (args.length == 1) {
            ByteList globPattern = args[0].convertToString().getByteList();
            dirs = Dir.push_glob(RubyDir.getCWD(recv.getRuntime()), globPattern, 0);
        } else {
            dirs = RubyDir.dirGlobs(RubyDir.getCWD(recv.getRuntime()), args, 0);
        }
        return RubyDir.asRubyStringList(recv.getRuntime(), dirs);
    }

    @JRubyMethod(name={"glob"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        List<ByteList> dirs;
        Ruby runtime = recv.getRuntime();
        int flags = args.length == 2 ? RubyNumeric.num2int(args[1]) : 0;
        IRubyObject tmp = args[0].checkArrayType();
        if (tmp.isNil()) {
            ByteList globPattern = args[0].convertToString().getByteList();
            dirs = Dir.push_glob(recv.getRuntime().getCurrentDirectory(), globPattern, flags);
        } else {
            dirs = RubyDir.dirGlobs(RubyDir.getCWD(runtime), ((RubyArray)tmp).toJavaArray(), flags);
        }
        if (block.isGiven()) {
            for (int i = 0; i < dirs.size(); ++i) {
                block.yield(context, RubyString.newString(runtime, dirs.get(i)));
            }
            return recv.getRuntime().getNil();
        }
        return RubyDir.asRubyStringList(recv.getRuntime(), dirs);
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries() {
        return this.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    @JRubyMethod(name={"entries"}, required=1, meta=true)
    public static RubyArray entries(IRubyObject recv, IRubyObject path) {
        Ruby runtime = recv.getRuntime();
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime, path.convertToString().toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime, adjustedPath);
        JRubyFile directory = JRubyFile.create(recv.getRuntime().getCurrentDirectory(), adjustedPath);
        if (!directory.isDirectory()) {
            throw recv.getRuntime().newErrnoENOENTError("No such directory");
        }
        List<String> fileList = RubyDir.getContents(directory);
        fileList.add(0, ".");
        fileList.add(1, "..");
        Object[] files = fileList.toArray();
        return recv.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(recv.getRuntime(), files));
    }

    private static void checkDirIsTwoSlashesOnWindows(Ruby runtime, String path) {
        if (Platform.IS_WINDOWS && ("//".equals(path) || "\\\\".equals(path))) {
            throw runtime.newErrnoEINVALError("Invalid argument - " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"chdir"}, optional=1, frame=true, meta=true)
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString path = args.length == 1 ? args[0].convertToString() : RubyDir.getHomeDirectoryPath(context, recv);
        String adjustedPath = RubyFile.adjustRootPathOnWindows(recv.getRuntime(), path.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(recv.getRuntime(), adjustedPath);
        JRubyFile dir = RubyDir.getDir(recv.getRuntime(), adjustedPath, true);
        String realPath = null;
        String oldCwd = recv.getRuntime().getCurrentDirectory();
        try {
            realPath = dir.getCanonicalPath();
        }
        catch (IOException e) {
            realPath = dir.getAbsolutePath();
        }
        IRubyObject result = null;
        if (block.isGiven()) {
            recv.getRuntime().setCurrentDirectory(realPath);
            try {
                result = block.yield(context, path);
            }
            finally {
                dir = RubyDir.getDir(recv.getRuntime(), oldCwd, true);
                recv.getRuntime().setCurrentDirectory(oldCwd);
            }
        } else {
            recv.getRuntime().setCurrentDirectory(realPath);
            result = recv.getRuntime().newFixnum(0L);
        }
        return result;
    }

    @JRubyMethod(name={"chroot"}, required=1, meta=true)
    public static IRubyObject chroot(IRubyObject recv, IRubyObject path) {
        throw recv.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true)
    public static IRubyObject rmdir(IRubyObject recv, IRubyObject path) {
        JRubyFile directory = RubyDir.getDir(recv.getRuntime(), path.convertToString().toString(), true);
        if (!directory.delete()) {
            throw recv.getRuntime().newSystemCallError("No such directory");
        }
        return recv.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"foreach"}, required=1, frame=true, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv, IRubyObject _path, Block block) {
        RubyString path = _path.convertToString();
        recv.getRuntime().checkSafeString(path);
        RubyClass dirClass = recv.getRuntime().getDir();
        RubyDir dir = (RubyDir)dirClass.newInstance(context, new IRubyObject[]{path}, block);
        dir.each(context, block);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(IRubyObject recv) {
        return recv.getRuntime().newString(recv.getRuntime().getCurrentDirectory());
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true)
    public static IRubyObject mkdir(IRubyObject recv, IRubyObject[] args) {
        int mode;
        Ruby runtime = recv.getRuntime();
        runtime.checkSafeString(args[0]);
        String path = args[0].toString();
        File newDir = RubyDir.getDir(runtime, path, false);
        if (File.separatorChar == '\\') {
            newDir = new File(newDir.getPath());
        }
        int n = mode = args.length == 2 ? (int)args[1].convertToInteger().getLongValue() : 511;
        if (runtime.getPosix().mkdir(newDir.getAbsolutePath(), mode) < 0) {
            throw recv.getRuntime().newSystemCallError("mkdir failed");
        }
        return RubyFixnum.zero(recv.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv, IRubyObject path, Block block) {
        RubyDir directory = (RubyDir)recv.getRuntime().getDir().newInstance(context, new IRubyObject[]{path}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, directory);
            return iRubyObject;
        }
        finally {
            directory.close();
        }
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.checkDir();
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        this.checkDir();
        String[] contents = this.snapshot;
        for (int i = 0; i < contents.length; ++i) {
            block.yield(context, this.getRuntime().newString(contents[i]));
        }
        return this;
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell() {
        this.checkDir();
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"seek"}, required=1)
    public IRubyObject seek(IRubyObject newPos) {
        this.checkDir();
        this.set_pos(newPos);
        return this;
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject newPos) {
        this.pos = RubyNumeric.fix2int(newPos);
        return newPos;
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path() {
        this.checkDir();
        return this.path.strDup();
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read() {
        this.checkDir();
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return result;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        this.checkDir();
        this.pos = 0;
        return this;
    }

    protected static JRubyFile getDir(Ruby runtime, String path, boolean mustExist) {
        JRubyFile result = JRubyFile.create(runtime.getCurrentDirectory(), path);
        if (mustExist && !result.exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + path);
        }
        boolean isDirectory = result.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime.newErrnoENOTDIRError(path + " is not a directory");
        }
        if (!mustExist && isDirectory) {
            throw runtime.newErrnoEEXISTError("File exists - " + path);
        }
        return result;
    }

    protected static List<String> getContents(File directory) {
        String[] contents = directory.list();
        ArrayList<String> result = new ArrayList<String>();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                result.add(contents[i]);
            }
        }
        return result;
    }

    protected static List<RubyString> getContents(File directory, Ruby runtime) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        for (int i = 0; i < contents.length; ++i) {
            result.add(runtime.newString(contents[i]));
        }
        return result;
    }

    public static IRubyObject getHomeDirectoryPath(IRubyObject recv, String user) {
        String passwd = null;
        try {
            FileInputStream stream = new FileInputStream("/etc/passwd");
            int totalBytes = stream.available();
            byte[] bytes = new byte[totalBytes];
            stream.read(bytes);
            stream.close();
            passwd = new String(bytes);
        }
        catch (IOException e) {
            return recv.getRuntime().getNil();
        }
        String[] rows = passwd.split("\n");
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            String[] fields = rows[i].split(":");
            if (!fields[0].equals(user)) continue;
            return recv.getRuntime().newString(fields[5]);
        }
        throw recv.getRuntime().newArgumentError("user " + user + " doesn't exist");
    }

    public static RubyString getHomeDirectoryPath(ThreadContext context, IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        RubyHash systemHash = (RubyHash)runtime.getObject().fastGetConstant("ENV_JAVA");
        RubyHash envHash = (RubyHash)runtime.getObject().fastGetConstant("ENV");
        IRubyObject home = envHash.op_aref(context, runtime.newString("HOME"));
        if (home == null || home.isNil()) {
            home = systemHash.op_aref(context, runtime.newString("user.home"));
        }
        if (home == null || home.isNil()) {
            home = envHash.op_aref(context, runtime.newString("LOGDIR"));
        }
        if (home == null || home.isNil()) {
            throw runtime.newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home;
    }
}

