/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Pointer;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jna.JNABasePointer;
import org.jruby.ext.ffi.jna.JNAMemory;
import org.jruby.ext.ffi.jna.JNAMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::MemoryPointer"}, parent="FFI::AbstractMemoryPointer")
public class JNAMemoryPointer
extends JNABasePointer
implements JNAMemory {
    public static final String MEMORY_POINTER_NAME = "MemoryPointer";

    public static RubyClass createMemoryPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(MEMORY_POINTER_NAME, module.getClass("JNAPointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(JNAMemoryPointer.class);
        result.defineAnnotatedConstants(JNAMemoryPointer.class);
        return result;
    }

    private JNAMemoryPointer(Ruby runtime2, IRubyObject klass, MemoryIO io2, long offset2, long size2) {
        super(runtime2, (RubyClass)klass, io2, offset2, size2);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        int size2 = Util.int32Value(sizeArg);
        JNAMemoryIO io2 = size2 > 0 ? JNAMemoryIO.allocateDirect(size2) : JNAMemoryIO.NULL;
        return new JNAMemoryPointer(context.getRuntime(), recv2, (MemoryIO)io2, 0L, (long)size2);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject clearArg) {
        JNAMemoryIO io2;
        int size2 = Util.int32Value(sizeArg);
        JNAMemoryIO jNAMemoryIO = io2 = size2 > 0 ? JNAMemoryIO.allocateDirect(size2) : JNAMemoryIO.NULL;
        if (clearArg.isTrue()) {
            io2.setMemory(0L, size2, (byte)0);
        }
        return new JNAMemoryPointer(context.getRuntime(), recv2, (MemoryIO)io2, 0L, (long)size2);
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        Pointer address2 = this.getAddress();
        String hex2 = address2 != null ? address2.toString() : "native@0x0";
        return RubyString.newString(context.getRuntime(), "MemoryPointer[address=" + hex2 + "]");
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        String hex2 = Long.toHexString(JNAMemoryPointer.ptr2long(this.getAddress()) + this.offset);
        return RubyString.newString(context.getRuntime(), String.format("#<MemoryPointer address=0x%s size=%d>", hex2, this.size));
    }
}

