/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockPassNode
extends Node {
    private final Node bodyNode;
    private Node argsNode;

    public BlockPassNode(ISourcePosition position, Node bodyNode) {
        super(position, NodeType.BLOCKPASSNODE);
        this.bodyNode = bodyNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitBlockPassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block block) {
        return this.bodyNode == null ? runtime2.getNil() : this.bodyNode.interpret(runtime2, context, self, block);
    }
}

