/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

public final class KCode {
    public static final KCode NIL = new KCode(null, "ASCII", 0);
    public static final KCode NONE = new KCode("NONE", "ASCII", 0);
    public static final KCode UTF8 = new KCode("UTF8", "NonStrictUTF8", 64);
    public static final KCode SJIS = new KCode("SJIS", "NonStrictSJIS", 48);
    public static final KCode EUC = new KCode("EUC", "NonStrictEUCJP", 32);
    private final String kcode;
    private final String encodingName;
    private final int code;
    private volatile Encoding encoding;

    private KCode(String kcode2, String encodingName, int code) {
        this.kcode = kcode2;
        this.encodingName = encodingName;
        this.code = code;
    }

    public static KCode create(Ruby runtime2, String lang) {
        if (lang == null) {
            return NIL;
        }
        if (lang.length() == 0) {
            return NONE;
        }
        switch (lang.charAt(0)) {
            case 'E': 
            case 'e': {
                return EUC;
            }
            case 'S': 
            case 's': {
                return SJIS;
            }
            case 'U': 
            case 'u': {
                return UTF8;
            }
            case 'A': 
            case 'N': 
            case 'a': 
            case 'n': {
                return NONE;
            }
        }
        return NIL;
    }

    public IRubyObject kcode(Ruby runtime2) {
        return this.kcode == null ? runtime2.getNil() : runtime2.newString(this.kcode);
    }

    public String getKCode() {
        return this.kcode;
    }

    public int bits() {
        return this.code;
    }

    public String name() {
        return this.kcode != null ? this.kcode.toLowerCase() : null;
    }

    public Encoding getEncoding() {
        if (this.encoding == null) {
            this.encoding = Encoding.load(this.encodingName);
        }
        return this.encoding;
    }
}

