/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule implementationClass, Arity arity2, Visibility visibility, StaticScope staticScope, Object scriptObject, Method method2, CallConfiguration callConfig) {
        super(implementationClass, arity2, visibility, staticScope, scriptObject, callConfig);
        this.method = method2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        this.callConfig.pre(context, self, this.getImplementationClass(), name2, block, this.staticScope, this);
        Ruby runtime2 = context.getRuntime();
        try {
            try {
                IRubyObject iRubyObject;
                block12: {
                    boolean isTrace = runtime2.hasEventHooks();
                    try {
                        if (isTrace) {
                            runtime2.callEventHooks(context, RubyEvent.CALL, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                        }
                        iRubyObject = (IRubyObject)this.method.invoke(this.$scriptObject, context, self, args2, block);
                        Object var11_14 = null;
                        if (!isTrace) break block12;
                        Frame frame = context.getPreviousFrame();
                        runtime2.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name2, this.getImplementationClass());
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        if (!isTrace) throw throwable;
                        Frame frame = context.getPreviousFrame();
                        runtime2.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name2, this.getImplementationClass());
                        throw throwable;
                    }
                }
                Object var14_18 = null;
                this.callConfig.post(context);
                return iRubyObject;
            }
            catch (IllegalArgumentException e) {
                throw RaiseException.createNativeRaiseException(runtime2, e);
            }
            catch (IllegalAccessException e) {
                throw RaiseException.createNativeRaiseException(runtime2, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause2 = e.getCause();
                if (cause2 instanceof JumpException.ReturnJump) {
                    IRubyObject iRubyObject = this.handleReturn(context, (JumpException.ReturnJump)cause2);
                    Object var14_19 = null;
                    this.callConfig.post(context);
                    return iRubyObject;
                }
                if (cause2 instanceof JumpException.RedoJump) {
                    IRubyObject iRubyObject = this.handleRedo(runtime2);
                    Object var14_20 = null;
                    this.callConfig.post(context);
                    return iRubyObject;
                }
                if (cause2 instanceof RuntimeException) {
                    throw (RuntimeException)cause2;
                }
                if (!(cause2 instanceof Error)) throw RaiseException.createNativeRaiseException(runtime2, cause2);
                throw (Error)cause2;
            }
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            this.callConfig.post(context);
            throw throwable;
        }
    }
}

