/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedMethod
extends DynamicMethod
implements JumpTarget,
MethodArgs {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private ISourcePosition position;
    private String name;

    public InterpretedMethod(RubyModule implementationClass, String name2, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.position = position;
        assert (argsNode != null);
    }

    public String getName() {
        return this.name;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, args2.length);
                this.argsNode.prepare(context, runtime2, self, args2, block);
                iRubyObject = this.body.interpret(runtime2, context, self, block);
                Object var11_11 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var11_12 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var11_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 0);
                this.argsNode.prepare(context, runtime2, self, Block.NULL_BLOCK);
                iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
                Object var9_9 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var9_10 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var9_11 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 0);
                this.argsNode.prepare(context, runtime2, self, block);
                iRubyObject = this.body.interpret(runtime2, context, self, block);
                Object var10_10 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var10_11 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var10_12 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 1);
                this.argsNode.prepare(context, runtime2, self, arg0, Block.NULL_BLOCK);
                iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
                Object var10_10 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var10_11 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var10_12 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 1);
                this.argsNode.prepare(context, runtime2, self, arg0, block);
                iRubyObject = this.body.interpret(runtime2, context, self, block);
                Object var11_11 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var11_12 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var11_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 2);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, Block.NULL_BLOCK);
                iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
                Object var11_11 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var11_12 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var11_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 2);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, block);
                iRubyObject = this.body.interpret(runtime2, context, self, block);
                Object var12_12 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var12_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var12_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 3);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, Block.NULL_BLOCK);
                iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
                Object var12_12 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var12_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var12_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 3);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, block);
                iRubyObject = this.body.interpret(runtime2, context, self, block);
                Object var13_13 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj);
                Object var13_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var13_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    private void pre(ThreadContext context, String name2, IRubyObject self, Block block, Ruby runtime2) {
        context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        if (runtime2.hasEventHooks()) {
            this.traceCall(context, runtime2, name2);
        }
    }

    private void post(Ruby runtime2, ThreadContext context, String name2) {
        if (runtime2.hasEventHooks()) {
            this.traceReturn(context, runtime2, name2);
        }
        context.postMethodFrameAndScope();
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    private void traceReturn(ThreadContext context, Ruby runtime2, String name2) {
        runtime2.callEventHooks(context, RubyEvent.RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime2, String name2) {
        runtime2.callEventHooks(context, RubyEvent.CALL, this.position.getFile(), this.position.getStartLine(), name2, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new InterpretedMethod(this.getImplementationClass(), this.name, this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

