/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"StructLayout"}, parent="Object")
public final class StructLayout
extends RubyObject {
    static final String CLASS_NAME = "StructLayout";
    private final Map<IRubyObject, Member> fields;
    private final int size;

    public static RubyClass createStructLayoutClass(Ruby runtime2, RubyModule module) {
        RubyClass result = runtime2.defineClassUnder(CLASS_NAME, runtime2.getObject(), Allocator.INSTANCE, module);
        result.defineAnnotatedMethods(StructLayout.class);
        result.defineAnnotatedConstants(StructLayout.class);
        return result;
    }

    StructLayout(Ruby runtime2) {
        this(runtime2, FFIProvider.getModule(runtime2).fastGetClass(CLASS_NAME));
    }

    StructLayout(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.size = 0;
        this.fields = Collections.emptyMap();
    }

    StructLayout(Ruby runtime2, Map<IRubyObject, Member> fields2, int size2) {
        super(runtime2, FFIProvider.getModule(runtime2).fastGetClass(CLASS_NAME));
        this.fields = StructLayout.immutableMap(fields2);
        this.size = size2;
    }

    private static Map<IRubyObject, Member> immutableMap(Map<IRubyObject, Member> fields2) {
        LinkedHashMap<IRubyObject, Member> tmp = new LinkedHashMap<IRubyObject, Member>(fields2.size());
        for (Map.Entry<IRubyObject, Member> e : fields2.entrySet()) {
            tmp.put(StructLayout.convertKey(e.getKey().getRuntime(), e.getKey()), e.getValue());
        }
        return Collections.unmodifiableMap(tmp);
    }

    private static IRubyObject convertKey(Ruby runtime2, IRubyObject key2) {
        if (key2 instanceof RubySymbol) {
            return key2;
        }
        return runtime2.getSymbolTable().getSymbol(key2.asJavaString());
    }

    @JRubyMethod(name={"get"}, required=2)
    public IRubyObject get(ThreadContext context, IRubyObject ptr, IRubyObject name2) {
        return this.getMember(context.getRuntime(), name2).get(context.getRuntime(), ptr);
    }

    @JRubyMethod(name={"put"}, required=3)
    public IRubyObject put(ThreadContext context, IRubyObject ptr, IRubyObject name2, IRubyObject value2) {
        this.getMember(context.getRuntime(), name2).put(context.getRuntime(), ptr, value2);
        return value2;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        return RubyArray.newArray(context.getRuntime(), this.fields.keySet());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.size);
    }

    private Member getMember(Ruby runtime2, IRubyObject name2) {
        Member f = this.fields.get(StructLayout.convertKey(runtime2, name2));
        if (f != null) {
            return f;
        }
        throw runtime2.newArgumentError("Unknown field: " + name2);
    }

    static abstract class Member {
        protected final long offset;

        protected Member(long offset2) {
            this.offset = offset2;
        }

        static final MemoryIO getMemoryIO(IRubyObject ptr) {
            return ((AbstractMemory)ptr).getMemoryIO();
        }

        public abstract void put(Ruby var1, IRubyObject var2, IRubyObject var3);

        public abstract IRubyObject get(Ruby var1, IRubyObject var2);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StructLayout(runtime2, klass);
        }
    }
}

