/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.NoFunctionalitySignalFacade;
import org.jruby.util.SignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNALS = RubySignal.getSignalFacade();
    public static final String[] NAMES = new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "INFO", "USR1", "USR2"};

    private static final SignalFacade getSignalFacade() {
        try {
            Class<?> realFacadeClass = Class.forName("org.jruby.util.SunSignalFacade");
            return (SignalFacade)realFacadeClass.newInstance();
        }
        catch (Throwable e) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby runtime2) {
        RubyModule mSignal = runtime2.defineModule("Signal");
        mSignal.defineAnnotatedMethods(RubySignal.class);
    }

    @JRubyMethod(name={"trap"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject trap(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        runtime2.getLoadService().require("jsignal");
        return RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getKernel(), "__jtrap", args2, block);
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        RubyHash names2 = RubyHash.newHash(runtime2);
        for (int i = 0; i < NAMES.length; ++i) {
            names2.op_aset(context, runtime2.newString(NAMES[i]), runtime2.newFixnum(i));
        }
        names2.op_aset(context, runtime2.newString("IOT"), runtime2.newFixnum(6));
        names2.op_aset(context, runtime2.newString("CLD"), runtime2.newFixnum(20));
        return names2;
    }

    @JRubyMethod(name={"__jtrap_kernel"}, required=3, meta=true)
    public static IRubyObject __jtrap_kernel(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return SIGNALS.trap(recv2, arg1, arg2, arg3);
    }
}

