/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.util.BytesHash;
import org.joni.Analyser;
import org.joni.Matcher;
import org.joni.MatcherFactory;
import org.joni.MinMaxLen;
import org.joni.NameEntry;
import org.joni.OptAnchorInfo;
import org.joni.OptExactInfo;
import org.joni.OptMapInfo;
import org.joni.Option;
import org.joni.Region;
import org.joni.ScanEnvironment;
import org.joni.SearchAlgorithm;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.constants.RegexState;
import org.joni.exception.InternalException;
import org.joni.exception.ValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Regex
implements RegexState {
    int[] code;
    int codeLength;
    boolean stackNeeded;
    Object[] operands;
    int operandLength;
    int state;
    int numMem;
    int numRepeat;
    int numNullCheck;
    int numCombExpCheck;
    int numCall;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int stackPopLevel;
    int[] repeatRangeLo;
    int[] repeatRangeHi;
    public WarnCallback warnings;
    public MatcherFactory factory;
    final Encoding enc;
    int options;
    int userOptions;
    final int caseFoldFlag;
    BytesHash<NameEntry> nameTable;
    SearchAlgorithm searchAlgorithm;
    int thresholdLength;
    int anchor;
    int anchorDmin;
    int anchorDmax;
    int subAnchor;
    byte[] exact;
    int exactP;
    int exactEnd;
    byte[] map;
    int[] intMap;
    int[] intMapBackward;
    int dMin;
    int dMax;

    public Regex(byte[] bytes, int p2, int end2, int option, Encoding enc) {
        this(bytes, p2, end2, option, enc, Syntax.RUBY, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes, int p2, int end2, int option, Encoding enc, Syntax syntax) {
        this(bytes, p2, end2, option, 0x40000000, enc, syntax, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes, int p2, int end2, int option, Encoding enc, WarnCallback warnings) {
        this(bytes, p2, end2, option, enc, Syntax.RUBY, warnings);
    }

    public Regex(byte[] bytes, int p2, int end2, int option, Encoding enc, Syntax syntax, WarnCallback warnings) {
        this(bytes, p2, end2, option, 0x40000000, enc, syntax, warnings);
    }

    public Regex(byte[] bytes, int p2, int end2, int option, int caseFoldFlag, Encoding enc, Syntax syntax, WarnCallback warnings) {
        if ((option & 0x180) == 384) {
            throw new ValueException("invalid combination of options");
        }
        if ((option & 0x40) != 0) {
            option |= syntax.options;
            option &= 0xFFFFFFF7;
        } else {
            option |= syntax.options;
        }
        this.enc = enc;
        this.options = option;
        this.caseFoldFlag = caseFoldFlag;
        this.warnings = warnings;
        new Analyser(new ScanEnvironment(this, syntax), bytes, p2, end2).compile();
        this.warnings = null;
    }

    public Matcher matcher(byte[] bytes) {
        return this.matcher(bytes, 0, bytes.length);
    }

    public Matcher matcher(byte[] bytes, int p2, int end2) {
        return this.factory.create(this, bytes, p2, end2);
    }

    public int numberOfCaptures() {
        return this.numMem;
    }

    public int numberOfCaptureHistories() {
        return 0;
    }

    String nameTableToString() {
        StringBuilder sb = new StringBuilder();
        if (this.nameTable != null) {
            sb.append("name table\n");
            for (NameEntry ne : this.nameTable) {
                sb.append("  " + ne + "\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    NameEntry nameFind(byte[] name2, int nameP, int nameEnd) {
        if (this.nameTable != null) {
            return this.nameTable.get(name2, nameP, nameEnd);
        }
        return null;
    }

    void renumberNameTable(int[] map) {
        if (this.nameTable != null) {
            for (NameEntry e : this.nameTable) {
                if (e.backNum > 1) {
                    for (int i = 0; i < e.backNum; ++i) {
                        e.backRefs[i] = map[e.backRefs[i]];
                    }
                    continue;
                }
                if (e.backNum != 1) continue;
                e.backRef1 = map[e.backRef1];
            }
        }
    }

    public int numberOfNames() {
        return this.nameTable == null ? 0 : this.nameTable.size();
    }

    void nameAdd(byte[] name2, int nameP, int nameEnd, int backRef, Syntax syntax) {
        if (nameEnd - nameP <= 0) {
            throw new ValueException("group name is empty");
        }
        NameEntry e = null;
        if (this.nameTable == null) {
            this.nameTable = new BytesHash();
        } else {
            e = this.nameFind(name2, nameP, nameEnd);
        }
        if (e == null) {
            e = new NameEntry(name2, nameP, nameEnd);
            this.nameTable.putDirect(name2, nameP, nameEnd, e);
        } else if (e.backNum >= 1 && !syntax.allowMultiplexDefinitionName()) {
            throw new ValueException("multiplex defined name <%n>", new String(name2, nameP, nameEnd - nameP));
        }
        e.addBackref(backRef);
    }

    NameEntry nameToGroupNumbers(byte[] name2, int nameP, int nameEnd) {
        return this.nameFind(name2, nameP, nameEnd);
    }

    public int nameToBackrefNumber(byte[] name2, int nameP, int nameEnd, Region region) {
        NameEntry e = this.nameToGroupNumbers(name2, nameP, nameEnd);
        if (e == null) {
            throw new ValueException("undefined name <%n> reference", new String(name2, nameP, nameEnd - nameP));
        }
        switch (e.backNum) {
            case 0: {
                throw new InternalException("internal parser error (bug)");
            }
            case 1: {
                return e.backRef1;
            }
        }
        if (region != null) {
            for (int i = e.backNum - 1; i >= 0; --i) {
                if (region.beg[e.backRefs[i]] == -1) continue;
                return e.backRefs[i];
            }
        }
        return e.backRefs[e.backNum - 1];
    }

    public Iterator<NameEntry> namedBackrefIterator() {
        return this.nameTable.iterator();
    }

    public boolean noNameGroupIsActive(Syntax syntax) {
        if (Option.isDontCaptureGroup(this.options)) {
            return false;
        }
        return this.numberOfNames() <= 0 || !syntax.captureOnlyNamedGroup() || Option.isCaptureGroup(this.options);
    }

    void setupBMSkipMap() {
        byte[] bytes = this.exact;
        int end2 = this.exactEnd;
        int p2 = this.exactP;
        int len = end2 - p2;
        if (len < 256) {
            int i;
            if (this.map == null) {
                this.map = new byte[256];
            }
            for (i = 0; i < 256; ++i) {
                this.map[i] = (byte)len;
            }
            for (i = 0; i < len - 1; ++i) {
                this.map[bytes[p2 + i] & 0xFF] = (byte)(len - 1 - i);
            }
        } else {
            if (this.intMap == null) {
                this.intMap = new int[256];
            }
            for (int i = 0; i < len - 1; ++i) {
                this.intMap[bytes[p2 + i] & 0xFF] = len - 1 - i;
            }
        }
    }

    void setExactInfo(OptExactInfo e) {
        if (e.length == 0) {
            return;
        }
        this.exact = e.s;
        this.exactP = 0;
        this.exactEnd = e.length;
        if (e.ignoreCase) {
            this.searchAlgorithm = this.enc.toLowerCaseTable() != null ? SearchAlgorithm.SLOW_IC_SB : new SearchAlgorithm.SLOW_IC(this);
        } else {
            boolean allowReverse = this.enc.isReverseMatchAllowed(this.exact, this.exactP, this.exactEnd);
            if (e.length >= 3 || e.length >= 2 && allowReverse) {
                this.setupBMSkipMap();
                this.searchAlgorithm = allowReverse ? SearchAlgorithm.BM : SearchAlgorithm.BM_NOT_REV;
            } else {
                this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.SLOW_SB : SearchAlgorithm.SLOW;
            }
        }
        this.dMin = e.mmd.min;
        this.dMax = e.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + (this.exactEnd - this.exactP);
        }
    }

    void setOptimizeMapInfo(OptMapInfo m) {
        this.map = m.map;
        this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.MAP_SB : SearchAlgorithm.MAP;
        this.dMin = m.mmd.min;
        this.dMax = m.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + 1;
        }
    }

    void setSubAnchor(OptAnchorInfo anc) {
        this.subAnchor |= anc.leftAnchor & 2;
        this.subAnchor |= anc.rightAnchor & 0x20;
    }

    void clearOptimizeInfo() {
        this.searchAlgorithm = SearchAlgorithm.NONE;
        this.anchor = 0;
        this.anchorDmax = 0;
        this.anchorDmin = 0;
        this.subAnchor = 0;
        this.exact = null;
        this.exactEnd = 0;
        this.exactP = 0;
    }

    public String encStringToString(byte[] bytes, int p2, int end2) {
        StringBuilder sb = new StringBuilder("\nPATTERN: /");
        if (this.enc.minLength() > 1) {
            for (int p_ = p2; p_ < end2; p_ += this.enc.length(bytes, p_, end2)) {
                int code = this.enc.mbcToCode(bytes, p_, end2);
                if (code >= 128) {
                    try {
                        sb.append(String.format(" 0x%04x ", code));
                    }
                    catch (IllegalFormatConversionException ifce) {
                        sb.append(code);
                    }
                    continue;
                }
                sb.append((char)code);
            }
        } else {
            while (p2 < end2) {
                sb.append(new String(new byte[]{bytes[p2]}));
                ++p2;
            }
        }
        return sb.append("/").toString();
    }

    public String optimizeInfoToString() {
        String s = "";
        s = s + "optimize: " + this.searchAlgorithm.getName() + "\n";
        s = s + "  anchor:     " + OptAnchorInfo.anchorToString(this.anchor);
        if ((this.anchor & 0x18) != 0) {
            s = s + MinMaxLen.distanceRangeToString(this.anchorDmin, this.anchorDmax);
        }
        s = s + "\n";
        if (this.searchAlgorithm != SearchAlgorithm.NONE) {
            s = s + "  sub anchor: " + OptAnchorInfo.anchorToString(this.subAnchor) + "\n";
        }
        s = s + "dmin: " + this.dMin + " dmax: " + this.dMax + "\n";
        s = s + "threshold length: " + this.thresholdLength + "\n";
        if (this.exact != null) {
            s = s + "exact: [" + new String(this.exact, this.exactP, this.exactEnd - this.exactP) + "]: length: " + (this.exactEnd - this.exactP) + "\n";
        } else if (this.searchAlgorithm == SearchAlgorithm.MAP || this.searchAlgorithm == SearchAlgorithm.MAP_SB) {
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                if (this.map[i] == 0) continue;
                ++n;
            }
            s = s + "map: n = " + n + "\n";
            if (n > 0) {
                int c = 0;
                s = s + "[";
                for (int i = 0; i < 256; ++i) {
                    if (this.map[i] == 0) continue;
                    if (c > 0) {
                        s = s + ", ";
                    }
                    ++c;
                    s = this.enc.maxLength() == 1 && this.enc.isPrint(i) ? s + (char)i : s + i;
                }
                s = s + "]\n";
            }
        }
        return s;
    }

    public int getOptions() {
        return this.options;
    }

    public void setUserOptions(int options2) {
        this.userOptions = options2;
    }

    public int getUserOptions() {
        return this.userOptions;
    }

    public Encoding getEncoding() {
        return this.enc;
    }

    public int adjustStartPosition(byte[] str, int start2, int len, int pos2, boolean reverse2) {
        int range = reverse2 ? -pos2 : len - pos2;
        if (pos2 > 0 && this.enc.maxLength() != 1 && pos2 < len) {
            int p2 = range > 0 ? this.enc.rightAdjustCharHead(str, start2, start2 + pos2, start2 + len) : this.enc.leftAdjustCharHead(str, start2, start2 + pos2, start2 + len);
            return p2 - start2;
        }
        return pos2;
    }
}

