/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class MethodBlock
extends BlockBody {
    private final RubyMethod method;
    private final Callback callback;
    private final Arity arity;
    private final StaticScope staticScope;

    public static Block createMethodBlock(ThreadContext context, DynamicScope dynamicScope, Callback callback, RubyMethod method2, IRubyObject self) {
        Binding binding2 = new Binding(self, context.getCurrentFrame().duplicate(), context.getCurrentFrame().getVisibility(), context.getRubyClass(), dynamicScope);
        MethodBlock body = new MethodBlock(callback, method2, dynamicScope.getStaticScope());
        return new Block(body, binding2);
    }

    public MethodBlock(Callback callback, RubyMethod method2, StaticScope staticScope) {
        super(3);
        this.callback = callback;
        this.method = method2;
        this.arity = Arity.createArity((int)method2.arity().getLongValue());
        this.staticScope = staticScope;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.yield(context, context.getRuntime().newArrayNoCopy(args2), null, null, true, binding2, type2);
    }

    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding2) {
        return context.preYieldNoScope(binding2, klass);
    }

    protected void post(ThreadContext context, Binding binding2, Frame lastFrame) {
        context.postYieldNoScope(lastFrame);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, null, null, false, binding2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        if (klass == null) {
            self = binding2.getSelf();
            binding2.getFrame().setSelf(self);
        }
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            try {
                IRubyObject iRubyObject;
                while (true) {
                    try {
                        iRubyObject = this.callback.execute(value2, new IRubyObject[]{this.method, self}, Block.NULL_BLOCK);
                    }
                    catch (JumpException.RedoJump rj) {
                        context.pollThreadEvents();
                        continue;
                    }
                    catch (JumpException.BreakJump bj) {
                        if (bj.getTarget() != null) throw bj;
                        bj.setTarget(this);
                        throw bj;
                    }
                    break;
                }
                Object var12_13 = null;
                this.post(context, binding2, lastFrame);
                return iRubyObject;
            }
            catch (JumpException.NextJump nj) {
                IRubyObject iRubyObject = (IRubyObject)nj.getValue();
                Object var12_14 = null;
                this.post(context, binding2, lastFrame);
                return iRubyObject;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.post(context, binding2, lastFrame);
            throw throwable;
        }
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public Block cloneBlock(Binding binding2) {
        binding2 = new Binding(binding2.getSelf(), binding2.getFrame().duplicate(), binding2.getVisibility(), binding2.getKlass(), binding2.getDynamicScope().cloneScope());
        return new Block(this, binding2);
    }

    public Arity arity() {
        return this.arity;
    }
}

