/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget,
MethodArgs {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int maxArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;
    private ISourcePosition position;
    private boolean noArgHack;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.maxArgsCount = argsNode.getRestArg() >= 0 ? -1 : argsNode.getRequiredArgsCount() + argsNode.getOptionalArgsCount();
        this.restArg = argsNode.getRestArg();
        this.hasOptArgs = argsNode.getOptArgs() != null;
        this.position = position;
        boolean bl = this.noArgHack = argsNode.getBlockArgNode() == null && this.requiredArgsCount == 0 && this.maxArgsCount == 0;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public int incrementCallCount() {
        return ++this.callCount;
    }

    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public Script getJITCompilerScript() {
        return this.jitCompiledScript;
    }

    public void setJITCompiledScript(Script jitCompiledScript) {
        this.jitCompiledScript = jitCompiledScript;
    }

    public CallConfiguration getJITCallConfig() {
        return this.jitCallConfig;
    }

    public void setJITCallConfig(CallConfiguration jitCallConfig) {
        this.jitCallConfig = jitCallConfig;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        Ruby runtime2 = context.getRuntime();
        if (this.callCount >= 0) {
            runtime2.getJITCompiler().tryJIT(this, context, name2);
        }
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            return this.retryJITCall(context, runtime2, self, name2, args2, block);
        }
        return this.interpretedCall(context, runtime2, self, clazz, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject retryJITCall(ThreadContext context, Ruby runtime2, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        try {
            this.jitPre(context, self, name2, block, args2.length);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args2, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.jitPost(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject interpretedCall(ThreadContext context, Ruby runtime2, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            this.preInterpret(context, name2, self, block, runtime2, args2);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.postInterpret(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, Block.NULL_BLOCK, args2.length);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args2, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, Block.NULL_BLOCK, 0);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, block, 0);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, IRubyObject.NULL_ARRAY, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, Block.NULL_BLOCK, 1);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, block, 1);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, new IRubyObject[]{arg0}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, Block.NULL_BLOCK, 2);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, block, 2);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, Block.NULL_BLOCK, 3);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime2.hasEventHooks()) {
            try {
                this.jitPre(context, self, name2, block, 3);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime2);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime2, context, name2);
            }
        }
        return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
    }

    private int assignOptArgs(IRubyObject[] args2, Ruby runtime2, ThreadContext context, IRubyObject self, int givenArgsCount) {
        int i;
        ListNode optArgs = this.argsNode.getOptArgs();
        int j = 0;
        for (i = this.requiredArgsCount; i < args2.length && j < optArgs.size(); ++i, ++j) {
            optArgs.get(j).assign(runtime2, context, self, args2[i], Block.NULL_BLOCK, true);
            ++givenArgsCount;
        }
        i = 0;
        while (j < optArgs.size()) {
            optArgs.get(j).interpret(runtime2, context, self, Block.NULL_BLOCK);
            ++i;
            ++j;
        }
        return givenArgsCount;
    }

    private void interpretArgs(Ruby runtime2, IRubyObject[] args2, ThreadContext context, IRubyObject self, Block block) {
        this.prepareArguments(context, runtime2, self, args2);
        if (this.argsNode.getBlockArgNode() != null) {
            this.processBlockArg(context, block);
        }
    }

    private void jitPre(ThreadContext context, IRubyObject self, String name2, Block block, int argsLength) {
        this.jitCallConfig.pre(context, self, this.getImplementationClass(), name2, block, this.staticScope, this);
        this.getArity().checkArity(context.getRuntime(), argsLength);
    }

    private void jitPost(Ruby runtime2, ThreadContext context, String name2) {
        if (runtime2.hasEventHooks()) {
            this.traceReturn(context, runtime2, name2);
        }
        this.jitCallConfig.post(context);
    }

    private void postInterpret(Ruby runtime2, ThreadContext context, String name2) {
        if (runtime2.hasEventHooks()) {
            this.traceReturn(context, runtime2, name2);
        }
        context.postMethodFrameAndScope();
    }

    private void preInterpret(ThreadContext context, String name2, IRubyObject self, Block block, Ruby runtime2, IRubyObject[] args2) {
        context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        if (runtime2.hasEventHooks()) {
            this.traceCall(context, runtime2, name2);
        }
        this.checkArgCount(runtime2, args2.length);
        if (!this.noArgHack) {
            this.interpretArgs(runtime2, args2, context, self, block);
        }
    }

    private void processBlockArg(ThreadContext context, Block block) {
        context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(context.getRuntime(), block), 0);
    }

    private void checkArgCount(Ruby runtime2, int argsLength) {
        Arity.checkArgumentCount(runtime2, argsLength, this.requiredArgsCount, this.maxArgsCount);
    }

    private void prepareArguments(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject[] args2) {
        if (this.requiredArgsCount > 0) {
            context.getCurrentScope().setArgValues(args2, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime2, self, args2);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject[] args2) {
        int givenArgsCount = this.interpretOptArgs(context, runtime2, self, args2);
        this.interpretRestArg(context, runtime2, args2, givenArgsCount);
    }

    private int interpretOptArgs(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject[] args2) {
        if (this.hasOptArgs) {
            return this.assignOptArgs(args2, runtime2, context, self, this.requiredArgsCount);
        }
        return this.requiredArgsCount;
    }

    private void interpretRestArg(ThreadContext context, Ruby runtime2, IRubyObject[] args2, int givenArgsCount) {
        if (this.restArg >= 0) {
            RubyArray array = RubyArray.newArrayNoCopy(runtime2, args2, givenArgsCount);
            context.getCurrentScope().setValue(this.restArg, array, 0);
        }
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    private void traceReturn(ThreadContext context, Ruby runtime2, String name2) {
        runtime2.callEventHooks(context, RubyEvent.RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime2, String name2) {
        runtime2.callEventHooks(context, RubyEvent.CALL, this.position.getFile(), this.position.getStartLine(), name2, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

