/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

@JRubyModule(name={"Readline"}, include={"Enumerable"})
public class Readline {
    public static void createReadline(Ruby runtime2) throws IOException {
        ConsoleHolder holder = new ConsoleHolder();
        holder.history = new History();
        holder.currentCompletor = null;
        RubyModule mReadline = runtime2.defineModule("Readline");
        mReadline.dataWrapStruct(holder);
        mReadline.defineAnnotatedMethods(Readline.class);
        IRubyObject hist = runtime2.getObject().callMethod(runtime2.getCurrentContext(), "new");
        mReadline.fastSetConstant("HISTORY", hist);
        hist.getSingletonClass().includeModule(runtime2.getEnumerable());
        hist.getSingletonClass().defineAnnotatedMethods(HistoryMethods.class);
        mReadline.fastSetConstant("VERSION", runtime2.newString("JLine wrapper"));
    }

    protected static void initReadline(Ruby runtime2, ConsoleHolder holder) throws IOException {
        holder.readline = new ConsoleReader();
        holder.readline.setUseHistory(false);
        holder.readline.setUsePagination(true);
        holder.readline.setBellEnabled(false);
        ((CandidateListCompletionHandler)holder.readline.getCompletionHandler()).setAlwaysIncludeNewline(false);
        if (holder.currentCompletor == null) {
            holder.currentCompletor = new RubyFileNameCompletor();
        }
        holder.readline.addCompletor(holder.currentCompletor);
        holder.readline.setHistory(holder.history);
    }

    public static History getHistory(ConsoleHolder holder) {
        return holder.history;
    }

    public static ConsoleHolder getHolder(Ruby runtime2) {
        return (ConsoleHolder)runtime2.fastGetModule("Readline").dataGetStruct();
    }

    public static void setCompletor(ConsoleHolder holder, Completor completor) {
        if (holder.readline != null) {
            holder.readline.removeCompletor(holder.currentCompletor);
        }
        holder.currentCompletor = completor;
        if (holder.readline != null) {
            holder.readline.addCompletor(holder.currentCompletor);
        }
    }

    public static Completor getCompletor(ConsoleHolder holder) {
        return holder.currentCompletor;
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv2, IRubyObject prompt, IRubyObject add_to_hist) throws IOException {
        ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
        if (holder.readline == null) {
            Readline.initReadline(recv2.getRuntime(), holder);
        }
        IRubyObject line = recv2.getRuntime().getNil();
        holder.readline.getTerminal().disableEcho();
        String v = holder.readline.readLine(prompt.toString());
        holder.readline.getTerminal().enableEcho();
        if (null != v) {
            if (add_to_hist.isTrue()) {
                holder.readline.getHistory().addToHistory(v);
            }
            line = RubyString.newUnicodeString(recv2.getRuntime(), v);
        }
        return line;
    }

    @JRubyMethod(name={"completion_append_character="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_append_character(IRubyObject recv2, IRubyObject achar) throws Exception {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"completion_proc="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_proc(IRubyObject recv2, IRubyObject proc2) throws Exception {
        if (!proc2.respondsTo("call")) {
            throw recv2.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(recv2.getRuntime()), new ProcCompletor(proc2));
        return recv2.getRuntime().getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompletor {
        public int complete(String buffer, int cursor, List candidates) {
            int index2 = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            return index2 + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompletor
    implements Completor {
        IRubyObject procCompletor;

        public ProcCompletor(IRubyObject procCompletor) {
            this.procCompletor = procCompletor;
        }

        public int complete(String buffer, int cursor, List candidates) {
            ThreadContext context;
            IRubyObject comps;
            int index2 = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            if ((comps = RuntimeHelpers.invoke(context = this.procCompletor.getRuntime().getCurrentContext(), this.procCompletor, "call", this.procCompletor.getRuntime().newString(buffer)).callMethod(context, "to_a")) instanceof List) {
                for (Object obj : (List)((Object)comps)) {
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class HistoryMethods {
        @JRubyMethod(name={"push", "<<"}, rest=true)
        public static IRubyObject s_push(IRubyObject recv2, IRubyObject[] lines) throws Exception {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            for (int i = 0; i < lines.length; ++i) {
                RubyString line = lines[i].convertToString();
                holder.history.addToHistory(line.getUnicodeValue());
            }
            return recv2.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop"})
        public static IRubyObject s_pop(IRubyObject recv2) throws Exception {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            List histList = holder.history.getHistoryList();
            String current2 = (String)histList.get(histList.size() - 1);
            return runtime2.newString(current2);
        }

        @JRubyMethod(name={"to_a"})
        public static IRubyObject s_hist_to_a(IRubyObject recv2) throws Exception {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            RubyArray histList = recv2.getRuntime().newArray();
            Iterator i = holder.history.getHistoryList().iterator();
            while (i.hasNext()) {
                histList.append(recv2.getRuntime().newString((String)i.next()));
            }
            return histList;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject s_hist_to_s(IRubyObject recv2) {
            return recv2.getRuntime().newString("HISTORY");
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject s_hist_get(IRubyObject recv2, IRubyObject index2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            int i = (int)index2.convertToInteger().getLongValue();
            try {
                return runtime2.newString((String)holder.history.getHistoryList().get(i));
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject s_hist_set(IRubyObject recv2, IRubyObject index2, IRubyObject val) {
            throw recv2.getRuntime().newNotImplementedError("the []=() function is unimplemented on this machine");
        }

        @JRubyMethod(name={"shift"})
        public static IRubyObject s_hist_shift(IRubyObject recv2) {
            throw recv2.getRuntime().newNotImplementedError("the shift function is unimplemented on this machine");
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject s_hist_length(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newFixnum(holder.history.size());
        }

        @JRubyMethod(name={"empty?"})
        public static IRubyObject s_hist_empty_p(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newBoolean(holder.history.size() == 0);
        }

        @JRubyMethod(name={"delete_at"})
        public static IRubyObject s_hist_delete_at(IRubyObject recv2, IRubyObject index2) {
            throw recv2.getRuntime().newNotImplementedError("the delete_at function is unimplemented on this machine");
        }

        @JRubyMethod(name={"each"})
        public static IRubyObject s_hist_each(IRubyObject recv2, Block block) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            Iterator i = holder.history.getHistoryList().iterator();
            while (i.hasNext()) {
                block.yield(recv2.getRuntime().getCurrentContext(), recv2.getRuntime().newString((String)i.next()));
            }
            return recv2;
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        public Completor currentCompletor;
        public History history;
    }

    public static class Service
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            Readline.createReadline(runtime2);
        }
    }
}

