/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseNode
extends Node {
    private final Node caseNode;
    private final Node caseBody;

    public CaseNode(ISourcePosition position, Node caseNode, Node caseBody) {
        super(position, NodeType.CASENODE);
        assert (caseBody != null) : "caseBody is not null";
        this.caseNode = caseNode;
        this.caseBody = caseBody;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitCaseNode(this);
    }

    public Node getCaseNode() {
        return this.caseNode;
    }

    public Node getFirstWhenNode() {
        return this.caseBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.caseNode, this.caseBody);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject value2 = this.caseNode == null ? null : this.caseNode.interpret(runtime2, context, self, aBlock);
        context.pollThreadEvents();
        Node current2 = this.caseBody;
        while (current2 != null) {
            if (!(current2 instanceof WhenNode)) {
                return current2.interpret(runtime2, context, self, aBlock);
            }
            IRubyObject result = CaseNode.interpretExpressions((WhenNode)current2, value2, context, runtime2, self, aBlock);
            if (result != null) {
                return result;
            }
            context.pollThreadEvents();
            current2 = ((WhenNode)current2).getNextCase();
        }
        return runtime2.getNil();
    }

    private static IRubyObject interpretExpressions(WhenNode whenNode, IRubyObject value2, ThreadContext context, Ruby runtime2, IRubyObject self, Block aBlock) {
        assert (CaseNode.whenIsArray(whenNode));
        for (Node expression : ((ArrayNode)whenNode.getExpressionNodes()).childNodes()) {
            IRubyObject result;
            ISourcePosition position = expression.getPosition();
            context.setFileAndLine(position.getFile(), position.getStartLine());
            if (runtime2.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.LINE);
            }
            if ((result = expression.when(whenNode, value2, context, runtime2, self, aBlock)) == null) continue;
            return result;
        }
        return null;
    }

    private static boolean whenIsArray(WhenNode whenNode) {
        return whenNode.getExpressionNodes() instanceof ArrayNode;
    }
}

