/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyIO;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyArgsFile {
    public static void setCurrentLineNumber(IRubyObject recv2, int newLineNumber) {
        ArgsFileData.getDataFrom((IRubyObject)recv2).currentLineNumber = newLineNumber;
    }

    public static void initArgsFile(Ruby runtime2) {
        RubyObject argsFile = new RubyObject(runtime2, runtime2.getObject());
        runtime2.getEnumerable().extend_object(argsFile);
        runtime2.defineReadonlyVariable("$<", argsFile);
        runtime2.defineGlobalConstant("ARGF", argsFile);
        RubyClass argfClass = argsFile.getMetaClass();
        argfClass.defineAnnotatedMethods(RubyArgsFile.class);
        runtime2.defineReadonlyVariable("$FILENAME", runtime2.newString("-"));
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw context.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)data.currentFile).fileno(context);
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw context.getRuntime().newArgumentError("no stream");
        }
        return data.currentFile;
    }

    public static IRubyObject internalGets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return context.getRuntime().getNil();
        }
        IRubyObject line = data.currentFile.callMethod(context, "gets", args2);
        while (line instanceof RubyNil) {
            data.currentFile.callMethod(context, "close");
            if (!data.nextArgsFile(context)) {
                data.currentFile = null;
                return line;
            }
            line = data.currentFile.callMethod(context, "gets", args2);
        }
        ++data.currentLineNumber;
        context.getRuntime().getGlobalVariables().set("$.", context.getRuntime().newFixnum(data.currentLineNumber));
        return line;
    }

    @JRubyMethod(name={"gets"}, optional=1, frame=true, writes={FrameField.LASTLINE})
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject result = RubyArgsFile.internalGets(context, recv2, args2);
        if (!result.isNil()) {
            context.getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"readline"}, optional=1, frame=true, writes={FrameField.LASTLINE})
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyArgsFile.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, frame=true)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        IRubyObject[] separatorArgument;
        if (args2.length > 0) {
            if (!context.getRuntime().getNilClass().isInstance(args2[0]) && !context.getRuntime().getString().isInstance(args2[0])) {
                throw context.getRuntime().newTypeError(args2[0], context.getRuntime().getString());
            }
            separatorArgument = new IRubyObject[]{args2[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = context.getRuntime().newArray();
        while (!(line = RubyArgsFile.internalGets(context, recv2, separatorArgument)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject bt;
        while (!(bt = RubyArgsFile.getc(context, recv2)).isNil()) {
            block.yield(context, bt);
        }
        return recv2;
    }

    @JRubyMethod(name={"each_byte"}, optional=1, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_byte19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each_byte");
    }

    @JRubyMethod(name={"each_line", "each"}, optional=1, frame=true)
    public static IRubyObject each_line(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject nextLine = RubyArgsFile.internalGets(context, recv2, args2);
        while (!nextLine.isNil()) {
            block.yield(context, nextLine);
            nextLine = RubyArgsFile.internalGets(context, recv2, args2);
        }
        return recv2;
    }

    @JRubyMethod(name={"each_line"}, optional=1, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_line19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each_line", args2);
    }

    @JRubyMethod(name={"each"}, optional=1, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each", args2);
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return context.getRuntime().getNil();
        }
        return data.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        data.currentFile = null;
        return recv2;
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return recv2;
        }
        data.currentFile = null;
        data.currentLineNumber = 0;
        return recv2;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return recv2;
        }
        return ((RubyIO)data.currentFile).closed_p(context);
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw context.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)data.currentFile).binmode();
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newFixnum(ArgsFileData.getDataFrom((IRubyObject)recv2).currentLineNumber);
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw context.getRuntime().newArgumentError("no stream to tell");
        }
        return ((RubyIO)data.currentFile).pos(context);
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw context.getRuntime().newArgumentError("no stream to rewind");
        }
        return ((RubyIO)data.currentFile).rewind(context);
    }

    @JRubyMethod(name={"eof", "eof?"})
    public static IRubyObject eof(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return context.getRuntime().getTrue();
        }
        return ((RubyIO)data.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public static IRubyObject set_pos(ThreadContext context, IRubyObject recv2, IRubyObject offset2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw context.getRuntime().newArgumentError("no stream to set position");
        }
        return ((RubyIO)data.currentFile).pos_set(context, offset2);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public static IRubyObject seek(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw context.getRuntime().newArgumentError("no stream to seek");
        }
        return ((RubyIO)data.currentFile).seek(context, args2);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public static IRubyObject set_lineno(ThreadContext context, IRubyObject recv2, IRubyObject line) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        data.currentLineNumber = RubyNumeric.fix2int(line);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getc(context, recv2);
        if (c.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        IRubyObject bt;
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        while (true) {
            if (data.currentFile == null && !data.nextArgsFile(context)) {
                return context.getRuntime().getNil();
            }
            bt = !(data.currentFile instanceof RubyFile) ? data.currentFile.callMethod(context, "getc") : ((RubyIO)data.currentFile).getc();
            if (!bt.isNil()) break;
            data.currentFile = null;
        }
        return bt;
    }

    @JRubyMethod(name={"read"}, optional=2)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject str;
        IRubyObject length2;
        Ruby runtime2 = context.getRuntime();
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        long len = 0L;
        if (args2.length > 0) {
            length2 = args2[0];
            str = args2.length > 1 ? args2[1] : runtime2.getNil();
        } else {
            length2 = str = runtime2.getNil();
        }
        if (!length2.isNil()) {
            len = RubyNumeric.num2long(length2);
        }
        if (!str.isNil()) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args2[1] = runtime2.getNil();
        }
        while (true) {
            if (data.currentFile == null && !data.nextArgsFile(context)) {
                return str;
            }
            IRubyObject tmp = !(data.currentFile instanceof RubyIO) ? data.currentFile.callMethod(context, "read", args2) : ((RubyIO)data.currentFile).read(args2);
            if (str.isNil()) {
                str = tmp;
            } else if (!tmp.isNil()) {
                ((RubyString)str).append(tmp);
            }
            if (tmp.isNil() || length2.isNil()) {
                data.currentFile = null;
                continue;
            }
            if (args2.length < 1 || (long)((RubyString)str).getByteList().length() >= len) break;
            args2[0] = runtime2.newFixnum(len -= (long)((RubyString)str).getByteList().length());
        }
        return str;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static RubyString filename(ThreadContext context, IRubyObject recv2) {
        return (RubyString)context.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(IRubyObject recv2) {
        return recv2.getRuntime().newString("ARGF");
    }

    private static final class ArgsFileData {
        private final Ruby runtime;
        public IRubyObject currentFile;
        public int currentLineNumber;
        public boolean startedProcessing = false;
        public boolean finishedProcessing = false;

        public ArgsFileData(Ruby runtime2) {
            this.runtime = runtime2;
        }

        public boolean nextArgsFile(ThreadContext context) {
            if (this.finishedProcessing) {
                return false;
            }
            RubyArray args2 = (RubyArray)this.runtime.getGlobalVariables().get("$*");
            if (args2.getLength() == 0) {
                if (!this.startedProcessing) {
                    this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                    ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(new ByteList(new byte[]{45}));
                    this.currentLineNumber = 0;
                    this.startedProcessing = true;
                    return true;
                }
                this.finishedProcessing = true;
                return false;
            }
            IRubyObject arg2 = args2.shift(context);
            RubyString filename2 = (RubyString)((RubyObject)arg2).to_s();
            ByteList filenameBytes = filename2.getByteList();
            ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(filenameBytes);
            this.currentFile = filenameBytes.length() == 1 && filenameBytes.get(0) == 45 ? this.runtime.getGlobalVariables().get("$stdin") : RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{filename2.strDup(context.getRuntime())}, Block.NULL_BLOCK);
            this.startedProcessing = true;
            return true;
        }

        public static ArgsFileData getDataFrom(IRubyObject recv2) {
            ArgsFileData data = (ArgsFileData)recv2.dataGetStruct();
            if (data == null) {
                data = new ArgsFileData(recv2.getRuntime());
                recv2.dataWrapStruct(data);
            }
            return data;
        }
    }
}

