/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhenNode
extends Node {
    private final Node expressionNodes;
    private final Node bodyNode;
    private final Node nextCase;

    public WhenNode(ISourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        super(position, NodeType.WHENNODE);
        this.expressionNodes = expressionNodes;
        this.bodyNode = bodyNode;
        this.nextCase = nextCase;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhenNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getNextCase() {
        return this.nextCase;
    }

    public Node getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.bodyNode == null) {
            return runtime2.getNil();
        }
        return this.bodyNode.interpret(runtime2, context, self, aBlock);
    }
}

