/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseNode
extends Node {
    private final Node caseNode;
    private final Node caseBody;

    public CaseNode(ISourcePosition position, Node caseNode, Node caseBody) {
        super(position, NodeType.CASENODE);
        assert (caseBody != null) : "caseBody is not null";
        this.caseNode = caseNode;
        this.caseBody = caseBody;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitCaseNode(this);
    }

    public Node getCaseNode() {
        return this.caseNode;
    }

    public Node getFirstWhenNode() {
        return this.caseBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.caseNode, this.caseBody);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject expression = null;
        if (this.caseNode != null) {
            expression = this.caseNode.interpret(runtime2, context, self, aBlock);
        }
        context.pollThreadEvents();
        IRubyObject result = runtime2.getNil();
        Node firstWhenNode = this.caseBody;
        while (firstWhenNode != null) {
            if (!(firstWhenNode instanceof WhenNode)) {
                return firstWhenNode.interpret(runtime2, context, self, aBlock);
            }
            WhenNode whenNode = (WhenNode)firstWhenNode;
            if (whenNode.getExpressionNodes() instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
                context.setFile(arrayNode.getPosition().getFile());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    Node tag = arrayNode.get(i);
                    context.setLine(tag.getPosition().getStartLine());
                    if (runtime2.hasEventHooks()) {
                        ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.LINE);
                    }
                    if (tag instanceof WhenNode) {
                        IRubyObject expressionsObject = ((WhenNode)tag).getExpressionNodes().interpret(runtime2, context, self, aBlock);
                        RubyArray expressions = RuntimeHelpers.splatValue(expressionsObject);
                        int k = expressions.getLength();
                        for (int j = 0; j < k; ++j) {
                            IRubyObject condition = expressions.eltInternal(j);
                            if ((expression == null || !condition.callMethod(context, MethodIndex.OP_EQQ, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
                            return firstWhenNode.interpret(runtime2, context, self, aBlock);
                        }
                        continue;
                    }
                    result = tag.interpret(runtime2, context, self, aBlock);
                    if ((expression == null || !result.callMethod(context, MethodIndex.OP_EQQ, "===", expression).isTrue()) && (expression != null || !result.isTrue())) continue;
                    return whenNode.interpret(runtime2, context, self, aBlock);
                }
            } else {
                result = whenNode.getExpressionNodes().interpret(runtime2, context, self, aBlock);
                if (expression != null && result.callMethod(context, MethodIndex.OP_EQQ, "===", expression).isTrue() || expression == null && result.isTrue()) {
                    return firstWhenNode.interpret(runtime2, context, self, aBlock);
                }
            }
            context.pollThreadEvents();
            firstWhenNode = whenNode.getNextCase();
        }
        return runtime2.getNil();
    }
}

