/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.IdUtil;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Object"}, include={"Kernel"})
public class RubyObject
implements Cloneable,
IRubyObject,
Serializable,
CoreObjectType,
InstanceVariables,
InternalVariables {
    public static final IRubyObject NEVER = new RubyObject();
    public static final IRubyObject UNDEF = new RubyObject();
    protected transient RubyClass metaClass;
    protected volatile transient VariableTableEntry[] variableTable;
    protected transient int variableTableSize;
    protected transient int variableTableThreshold;
    protected transient Object dataStruct;
    protected int flags;
    public static final int ALL_F = -1;
    public static final int FALSE_F = 1;
    public static final int NIL_F = 2;
    public static final int FROZEN_F = 4;
    public static final int TAINTED_F = 8;
    public static final int FL_USHIFT = 4;
    public static final int USER0_F = 16;
    public static final int USER1_F = 32;
    public static final int USER2_F = 64;
    public static final int USER3_F = 128;
    public static final int USER4_F = 256;
    public static final int USER5_F = 512;
    public static final int USER6_F = 1024;
    public static final int USER7_F = 2048;
    private transient Finalizer finalizer;
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyObject(runtime2, klass);
        }
    };
    protected static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    protected static final int VARIABLE_TABLE_DEFAULT_CAPACITY = 8;
    protected static final int VARIABLE_TABLE_MAXIMUM_CAPACITY = 0x40000000;
    protected static final float VARIABLE_TABLE_LOAD_FACTOR = 0.75f;
    protected static final VariableTableEntry[] VARIABLE_TABLE_EMPTY_TABLE = new VariableTableEntry[0];

    private RubyObject() {
    }

    public final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public RubyObject(Ruby runtime2, RubyClass metaClass) {
        this.metaClass = metaClass;
        if (runtime2.isObjectSpaceEnabled()) {
            this.addToObjectSpace(runtime2);
        }
        if (runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    protected RubyObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            this.addToObjectSpace(runtime2);
        }
        if (runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    private void addToObjectSpace(Ruby runtime2) {
        assert (runtime2.isObjectSpaceEnabled());
        runtime2.getObjectSpace().add(this);
    }

    public static RubyClass createObjectClass(Ruby runtime2, RubyClass objectClass) {
        objectClass.index = 14;
        objectClass.defineAnnotatedMethods(ObjectMethods.class);
        return objectClass;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    @Override
    public int getNativeTypeIndex() {
        return 14;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass);
        this.setMetaClass(klass);
        klass.setAttached(this);
        klass.setMetaClass(superClass.getRealClass().getMetaClass());
        return klass;
    }

    @Override
    public Class getJavaClass() {
        if (this.dataGetStruct() instanceof JavaObject) {
            return ((JavaObject)this.dataGetStruct()).getValue().getClass();
        }
        return this.getClass();
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQUALEQUAL, "==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        return RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s").toString();
    }

    @Override
    public final Ruby getRuntime() {
        return this.getMetaClass().getClassRuntime();
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    protected final void testFrozen(String message) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message + " " + this.getMetaClass().getName());
        }
    }

    protected void checkFrozen() {
        this.testFrozen("can't modify frozen ");
    }

    @Override
    public boolean isTaint() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setTaint(boolean taint2) {
        this.flags = taint2 ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & 1) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & 1) != 0;
    }

    @Override
    public final boolean respondsTo(String name2) {
        if (this.getMetaClass().searchMethod("respond_to?") == this.getRuntime().getRespondToMethod()) {
            return this.getMetaClass().isMethodBound(name2, false);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "respond_to?", this.getRuntime().newSymbol(name2)).isTrue();
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && ((MetaClass)this.getMetaClass()).getAttached() == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        klass.setTaint(this.isTaint());
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    protected RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone = new MetaClass(this.getRuntime());
        clone.flags = this.flags;
        if (this instanceof RubyClass) {
            clone.setMetaClass(clone);
        } else {
            clone.setMetaClass(klass.getSingletonClassClone());
        }
        clone.setSuperClass(klass.getSuperClass());
        if (klass.hasVariables()) {
            clone.syncVariables(klass.getVariableList());
        }
        klass.cloneMethods(clone);
        ((MetaClass)clone.getMetaClass()).setAttached(clone);
        clone.setAttached(((MetaClass)klass).getAttached());
        return clone;
    }

    private static void initCopy(IRubyObject clone, RubyObject original) {
        assert (!clone.isFrozen()) : "frozen object (" + clone.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone);
        if (original.hasVariables()) {
            clone.syncVariables(original.getVariableList());
        }
        clone.callMethod(clone.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    @Override
    public IRubyObject infectBy(IRubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @Override
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(this.getMetaClass(), klazz).getSuperClass();
        if (superClass == null) {
            String name2 = context.getFrameName();
            return RuntimeHelpers.callMethodMissing(context, (IRubyObject)this, klazz.searchMethod(name2), name2, args2, (IRubyObject)this, CallType.SUPER, block);
        }
        return RuntimeHelpers.invokeAs(context, superClass, this, context.getFrameName(), args2, CallType.SUPER, block);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2, block);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2, Block.NULL_BLOCK);
    }

    public final void callInit(IRubyObject[] args2, Block block) {
        this.callMethod(this.getRuntime().getCurrentContext(), "initialize", args2, block);
    }

    @Override
    public String asJavaString() {
        IRubyObject asString = this.checkStringType();
        if (!asString.isNil()) {
            return ((RubyString)asString).asJavaString();
        }
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a symbol");
    }

    @Override
    public RubyArray convertToArray() {
        return (RubyArray)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getArray(), MethodIndex.TO_ARY, "to_ary");
    }

    @Override
    public RubyHash convertToHash() {
        return (RubyHash)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getHash(), MethodIndex.TO_HASH, "to_hash");
    }

    @Override
    public RubyFloat convertToFloat() {
        return (RubyFloat)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getFloat(), MethodIndex.TO_F, "to_f");
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.convertToInteger(MethodIndex.TO_INT, "to_int");
    }

    @Override
    public RubyInteger convertToInteger(int convertMethodIndex, String convertMethod) {
        IRubyObject val = TypeConverter.convertToType(this, this.getRuntime().getInteger(), convertMethodIndex, convertMethod, true);
        if (!(val instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + convertMethod + " should return Integer");
        }
        return (RubyInteger)val;
    }

    @Override
    public RubyString convertToString() {
        return (RubyString)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getString(), MethodIndex.TO_STR, "to_str");
    }

    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex) {
        return TypeConverter.convertToType((IRubyObject)this, target, convertMethodIndex, MethodIndex.NAMES.get(convertMethodIndex));
    }

    @Override
    public RubyString asString() {
        IRubyObject str = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        if (this.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    @Override
    public IRubyObject checkStringType() {
        IRubyObject str = TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getString(), MethodIndex.TO_STR, "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = RubyString.newEmptyString(this.getRuntime());
        }
        return str;
    }

    @Override
    public IRubyObject checkArrayType() {
        return TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getArray(), MethodIndex.TO_ARY, "to_ary");
    }

    @Deprecated
    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject[] args2, Block block) {
        int line;
        String file2;
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError(args2.length, 0);
            }
            return this.yieldUnder(context, mod, block);
        }
        if (args2.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args2.length > 3) {
            String lastFuncName = context.getFrameName();
            throw this.getRuntime().newArgumentError("wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        RubyString evalStr = args2[0] instanceof RubyString ? (RubyString)args2[0] : args2[0].convertToString();
        if (args2.length > 1) {
            file2 = args2[1].convertToString().asJavaString();
            line = args2.length > 2 ? (int)(args2[2].convertToInteger().getLongValue() - 1L) : 0;
        } else {
            file2 = "(eval)";
            line = 0;
        }
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, mod, block);
        }
        throw context.getRuntime().newArgumentError("block not supplied");
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(1, 0);
        }
        RubyString evalStr = arg2 instanceof RubyString ? (RubyString)arg2 : arg2.convertToString();
        String file2 = "(eval)";
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = (int)(arg2.convertToInteger().getLongValue() - 1L);
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject evalUnder(ThreadContext context, RubyModule under, IRubyObject src, IRubyObject file2, IRubyObject line) {
        return this.evalUnder(context, under, src.convertToString(), file2.convertToString().toString(), (int)(line.convertToInteger().getLongValue() - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject evalUnder(ThreadContext context, RubyModule under, RubyString src, String file2, int line) {
        Visibility savedVisibility = context.getCurrentVisibility();
        context.setCurrentVisibility(Visibility.PUBLIC);
        context.preExecuteUnder(under, Block.NULL_BLOCK);
        try {
            IRubyObject iRubyObject = ASTInterpreter.evalSimple(context, (IRubyObject)this, src, file2, line);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
            context.setCurrentVisibility(savedVisibility);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldUnder(ThreadContext context, RubyModule under, IRubyObject[] args2, Block block) {
        context.preExecuteUnder(under, block);
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            boolean aValue;
            IRubyObject valueInYield;
            if (args2.length == 1) {
                valueInYield = args2[0];
                aValue = false;
            } else {
                valueInYield = RubyArray.newArrayNoCopy(context.getRuntime(), args2);
                aValue = true;
            }
            block = block.cloneBlock();
            block.getBinding().setSelf(this);
            block.getBinding().getFrame().setSelf(this);
            IRubyObject iRubyObject = block.yield(context, valueInYield, this, context.getRubyClass(), aValue);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = (IRubyObject)bj.getValue();
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            context.postExecuteUnder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldUnder(ThreadContext context, RubyModule under, Block block) {
        context.preExecuteUnder(under, block);
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            block = block.cloneBlock();
            block.getBinding().setSelf(this);
            block.getBinding().getFrame().setSelf(this);
            IRubyObject iRubyObject = block.yield(context, this, this, context.getRubyClass(), false);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = (IRubyObject)bj.getValue();
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            context.postExecuteUnder();
        }
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @Override
    public boolean eql(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQL_P, "eql?", other).isTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.getRuntime().newBoolean(RubyObject.equalInternal(context, this, other));
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || that.callMethod(context, MethodIndex.EQUALEQUAL, "==", other).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || that.callMethod(context, MethodIndex.EQL_P, "eql?", other).isTrue();
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    @JRubyMethod(name={"respond_to?"})
    public RubyBoolean respond_to_p(IRubyObject mname) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, true));
    }

    @JRubyMethod(name={"respond_to?"})
    public RubyBoolean respond_to_p(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
    }

    @Override
    @JRubyMethod(name={"object_id", "__id__"})
    public synchronized IRubyObject id() {
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    @JRubyMethod(name={"id"})
    public synchronized IRubyObject id_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#id will be deprecated; use Object#object_id", "Object#id", "Object#object_id");
        return this.id();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public int hashCode() {
        IRubyObject hashValue = this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.HASH, "hash");
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return super.hashCode();
    }

    @JRubyMethod(name={"class"})
    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    @JRubyMethod(name={"type"})
    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#type is deprecated; use Object#class", "Object#type", "Object#class");
        return this.type();
    }

    @Override
    @JRubyMethod(name={"clone"}, frame=true)
    public IRubyObject rbClone() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        RubyObject clone = (RubyObject)this.getMetaClass().getRealClass().allocate();
        clone.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            clone.setTaint(true);
        }
        RubyObject.initCopy(clone, this);
        if (this.isFrozen()) {
            clone.setFrozen(true);
        }
        return clone;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup2 = this.getMetaClass().getRealClass().allocate();
        if (this.isTaint()) {
            dup2.setTaint(true);
        }
        RubyObject.initCopy(dup2, this);
        return dup2;
    }

    protected void copySpecialInstanceVariables(IRubyObject clone) {
    }

    @JRubyMethod(name={"display"}, optional=1)
    public IRubyObject display(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port = args2.length == 0 ? context.getRuntime().getGlobalVariables().get("$>") : args2[0];
        port.callMethod(context, "write", this);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"tainted?"})
    public RubyBoolean tainted_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isTaint());
    }

    @JRubyMethod(name={"taint"})
    public IRubyObject taint(ThreadContext context) {
        this.taint(context.getRuntime());
        return this;
    }

    private void taint(Ruby runtime2) {
        runtime2.secure(4);
        if (!this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(true);
        }
    }

    @JRubyMethod(name={"untaint"})
    public IRubyObject untaint(ThreadContext context) {
        context.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(false);
        }
        return this;
    }

    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze(ThreadContext context) {
        if ((this.flags & 4) == 0) {
            if (context.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw context.getRuntime().newSecurityError("Insecure: can't freeze object");
            }
            this.flags |= 4;
        }
        return this;
    }

    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isFrozen());
    }

    private StringBuilder inspectObj(StringBuilder part) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        String sep = "";
        for (Variable<IRubyObject> ivar : this.getInstanceVariableList()) {
            part.append(sep).append(" ").append(ivar.getName()).append("=");
            part.append(ivar.getValue().callMethod(context, "inspect"));
            sep = ",";
        }
        part.append(">");
        return part;
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, object.callMethod(context, "inspect"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        if (!this.isImmediate() && !(this instanceof RubyClass) && this != runtime2.getObject() && this != runtime2.getModule() && !(this instanceof RubyModule) && this.hasVariables()) {
            StringBuilder part = new StringBuilder();
            String cname = this.getMetaClass().getRealClass().getName();
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(this)));
            if (runtime2.isInspecting(this)) {
                part.append(" ...>");
                return runtime2.newString(part.toString());
            }
            try {
                runtime2.registerInspecting(this);
                RubyString rubyString = runtime2.newString(this.inspectObj(part).toString());
                return rubyString;
            }
            finally {
                runtime2.unregisterInspecting(this);
            }
        }
        if (this.isNil()) {
            return RubyNil.inspect(this);
        }
        return RuntimeHelpers.invoke(runtime2.getCurrentContext(), this, "to_s");
    }

    @JRubyMethod(name={"instance_of?"}, required=1)
    public RubyBoolean instance_of_p(ThreadContext context, IRubyObject type2) {
        if (this.type() == type2) {
            return context.getRuntime().getTrue();
        }
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"kind_of?", "is_a?"}, required=1)
    public RubyBoolean kind_of_p(ThreadContext context, IRubyObject type2) {
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().newBoolean(((RubyModule)type2).isInstance(this));
    }

    @JRubyMethod(name={"methods"}, optional=1)
    public IRubyObject methods(ThreadContext context, IRubyObject[] args2) {
        boolean all = true;
        if (args2.length == 1) {
            all = args2[0].isTrue();
        }
        RubyArray singletonMethods = null;
        if (this.getMetaClass().isSingleton()) {
            singletonMethods = this.getMetaClass().instance_methods(new IRubyObject[]{context.getRuntime().getFalse()});
            if (all) {
                singletonMethods.concat(this.getMetaClass().getSuperClass().instance_methods(new IRubyObject[]{context.getRuntime().getTrue()}));
            }
        } else {
            singletonMethods = all ? this.getMetaClass().instance_methods(new IRubyObject[]{context.getRuntime().getTrue()}) : context.getRuntime().newEmptyArray();
        }
        return singletonMethods;
    }

    @JRubyMethod(name={"public_methods"}, optional=1)
    public IRubyObject public_methods(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getRuntime().getTrue()};
        }
        return this.getMetaClass().public_instance_methods(args2);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1)
    public IRubyObject protected_methods(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getRuntime().getTrue()};
        }
        return this.getMetaClass().protected_instance_methods(args2);
    }

    @JRubyMethod(name={"private_methods"}, optional=1)
    public IRubyObject private_methods(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getRuntime().getTrue()};
        }
        return this.getMetaClass().private_instance_methods(args2);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1)
    public RubyArray singleton_methods(ThreadContext context, IRubyObject[] args2) {
        RubyArray singletonMethods;
        boolean all = true;
        if (args2.length == 1) {
            all = args2[0].isTrue();
        }
        if (this.getMetaClass().isSingleton()) {
            singletonMethods = this.getMetaClass().instance_methods(new IRubyObject[]{context.getRuntime().getFalse()});
            if (all) {
                RubyClass superClass = this.getMetaClass().getSuperClass();
                while (superClass.isIncluded()) {
                    singletonMethods.concat(superClass.instance_methods(new IRubyObject[]{context.getRuntime().getFalse()}));
                    superClass = superClass.getSuperClass();
                }
            }
        } else {
            singletonMethods = context.getRuntime().newEmptyArray();
        }
        return singletonMethods;
    }

    @JRubyMethod(name={"method"}, required=1)
    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asJavaString(), true);
    }

    @Override
    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.anyToString();
    }

    @JRubyMethod(name={"to_a"}, visibility=Visibility.PUBLIC)
    public RubyArray to_a() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "default 'to_a' will be obsolete", "to_a");
        return this.getRuntime().newArray(this);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject instance_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyClass klazz = this.isImmediate() ? context.getRuntime().getDummy() : this.getSingletonClass();
        return this.specificEval(context, (RubyModule)klazz, args2, block);
    }

    private RubyModule getInstanceEvalClass() {
        if (this.isImmediate()) {
            return this.getRuntime().getDummy();
        }
        return this.getSingletonClass();
    }

    @JRubyMethod(name={"instance_exec"}, optional=3, frame=true)
    public IRubyObject instance_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newArgumentError("block not supplied");
        }
        RubyClass klazz = this.isImmediate() ? context.getRuntime().getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block);
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true)
    public IRubyObject extend(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].isModule()) continue;
            throw runtime2.newTypeError(args2[i], runtime2.getModule());
        }
        ThreadContext context = runtime2.getCurrentContext();
        for (int i = args2.length - 1; i >= 0; --i) {
            args2[i].callMethod(context, "extend_object", this);
            args2[i].callMethod(context, "extended", this);
        }
        return this;
    }

    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, Block block) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, block);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, block);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, arg2, block);
    }

    @JRubyMethod(name={"send", "__send__"}, rest=true)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs;
        String name2 = args2[0].asJavaString();
        int newArgsLength = args2.length - 1;
        if (newArgsLength == 0) {
            newArgs = IRubyObject.NULL_ARRAY;
        } else {
            newArgs = new IRubyObject[newArgsLength];
            System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        }
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, newArgs, block);
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getFalse();
    }

    public IRubyObject to_java() {
        throw this.getRuntime().newTypeError(this.getMetaClass().getBaseName() + " cannot coerce to a Java type.");
    }

    public IRubyObject as(Class javaClass) {
        throw this.getRuntime().newTypeError(this.getMetaClass().getBaseName() + " cannot coerce to a Java type.");
    }

    @Override
    public RubyClass getType() {
        return this.type();
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        this.dataStruct = obj;
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.dataStruct;
    }

    @Override
    public void addFinalizer(IRubyObject finalizer) {
        if (this.finalizer == null) {
            this.finalizer = new Finalizer(this.getRuntime().getObjectSpace().idOf(this));
            this.getRuntime().addFinalizer(this.finalizer);
        }
        this.finalizer.addFinalizer(finalizer);
    }

    @Override
    public void removeFinalizers() {
        if (this.finalizer != null) {
            this.finalizer.removeFinalizers();
            this.finalizer = null;
            this.getRuntime().removeFinalizer(this.finalizer);
        }
    }

    @JRubyMethod(name={"instance_variable_defined?"}, required=1)
    public IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject name2) {
        if (this.variableTableContains(this.validateInstanceVariable(name2.asJavaString()))) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"instance_variable_get"}, required=1)
    public IRubyObject instance_variable_get(ThreadContext context, IRubyObject name2) {
        IRubyObject value2 = this.variableTableFetch(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return value2;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"instance_variable_set"}, required=2)
    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        this.ensureInstanceVariablesSettable();
        return this.variableTableStore(this.validateInstanceVariable(name2.asJavaString()), value2);
    }

    @JRubyMethod(name={"remove_instance_variable"}, required=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject remove_instance_variable(ThreadContext context, IRubyObject name2, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject value2 = this.variableTableRemove(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return value2;
        }
        throw context.getRuntime().newNameError("instance variable " + name2.asJavaString() + " not defined", name2.asJavaString());
    }

    @JRubyMethod(name={"instance_variables"})
    public RubyArray instance_variables(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        List<String> nameList = this.getInstanceVariableNameList();
        RubyArray array = runtime2.newArray(nameList.size());
        for (String name2 : nameList) {
            array.append(runtime2.newString(name2));
        }
        return array;
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject fastGetInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(name2) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableStore(name2, value2);
    }

    @Override
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(internedName) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableFastStore(internedName, value2);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        this.ensureInstanceVariablesSettable();
        return this.variableTableRemove(name2);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isInstanceVariable(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    list2.add(new VariableEntry<IRubyObject>(e.name, readValue));
                }
                e = e.next;
            }
        }
        return list2;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<String> list2 = new ArrayList<String>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isInstanceVariable(e.name)) {
                    list2.add(e.name);
                }
                e = e.next;
            }
        }
        return list2;
    }

    protected String validateInstanceVariable(String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowable as an instance variable name", name2);
    }

    protected void ensureInstanceVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_INST_VAR);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String name2) {
        assert (!RubyObject.isRubyVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInternalVariable(String internedName) {
        assert (!RubyObject.isRubyVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInternalVariable(String name2) {
        assert (!RubyObject.isRubyVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject fastGetInternalVariable(String internedName) {
        assert (!RubyObject.isRubyVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public void setInternalVariable(String name2, IRubyObject value2) {
        assert (!RubyObject.isRubyVariable(name2));
        this.variableTableStore(name2, value2);
    }

    @Override
    public void fastSetInternalVariable(String internedName, IRubyObject value2) {
        assert (!RubyObject.isRubyVariable(internedName));
        this.variableTableFastStore(internedName, value2);
    }

    @Override
    public IRubyObject removeInternalVariable(String name2) {
        assert (!RubyObject.isRubyVariable(name2));
        return this.variableTableRemove(name2);
    }

    @Override
    public void syncVariables(List<Variable<IRubyObject>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    public List<Variable<IRubyObject>> getInternalVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (!RubyObject.isRubyVariable(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    list2.add(new VariableEntry<IRubyObject>(e.name, readValue));
                }
                e = e.next;
            }
        }
        return list2;
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                IRubyObject readValue = e.value;
                if (readValue == null) {
                    readValue = this.variableTableReadLocked(e);
                }
                list2.add(new VariableEntry<IRubyObject>(e.name, readValue));
                e = e.next;
            }
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<String> list2 = new ArrayList<String>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                list2.add(e.name);
                e = e.next;
            }
        }
        return list2;
    }

    @Deprecated
    public Map getVariableMap() {
        return this.variableTableGetMap();
    }

    protected static final boolean isRubyVariable(String name2) {
        char c;
        return name2.length() > 0 && ((c = name2.charAt(0)) == '@' || c <= 'Z' && c >= 'A');
    }

    protected synchronized IRubyObject variableTableReadLocked(VariableTableEntry entry) {
        return entry.value;
    }

    protected boolean variableTableContains(String name2) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int hash2 = name2.hashCode();
            VariableTableEntry e = table[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    protected boolean variableTableFastContains(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry e = table[internedName.hashCode() & table.length - 1];
            while (e != null) {
                if (internedName == e.name) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    protected IRubyObject variableTableFetch(String name2) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int hash2 = name2.hashCode();
            VariableTableEntry e = table[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue != null) {
                        return readValue;
                    }
                    return this.variableTableReadLocked(e);
                }
                e = e.next;
            }
        }
        return null;
    }

    protected IRubyObject variableTableFastFetch(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry e = table[internedName.hashCode() & table.length - 1];
            while (e != null) {
                if (internedName == e.name) {
                    IRubyObject readValue = e.value;
                    if (readValue != null) {
                        return readValue;
                    }
                    return this.variableTableReadLocked(e);
                }
                e = e.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableStore(String name2, IRubyObject value2) {
        int hash2 = name2.hashCode();
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry e;
                table = new VariableTableEntry[8];
                table[hash2 & 7] = e = new VariableTableEntry(hash2, name2.intern(), value2, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                return value2;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index2 = hash2 & table.length - 1;
            VariableTableEntry e = table[index2];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    e.value = value2;
                    return value2;
                }
                e = e.next;
            }
            table[index2] = e = new VariableTableEntry(hash2, name2.intern(), value2, table[index2]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableFastStore(String internedName, IRubyObject value2) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        int hash2 = internedName.hashCode();
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry e;
                table = new VariableTableEntry[8];
                table[hash2 & 7] = e = new VariableTableEntry(hash2, internedName, value2, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                return value2;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index2 = hash2 & table.length - 1;
            VariableTableEntry e = table[index2];
            while (e != null) {
                if (internedName == e.name) {
                    e.value = value2;
                    return value2;
                }
                e = e.next;
            }
            table[index2] = e = new VariableTableEntry(hash2, internedName, value2, table[index2]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableRemove(String name2) {
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable != null) {
                VariableTableEntry first2;
                int hash2 = name2.hashCode();
                int index2 = hash2 & table.length - 1;
                VariableTableEntry e = first2 = table[index2];
                while (e != null) {
                    if (hash2 == e.hash && name2.equals(e.name)) {
                        IRubyObject oldValue = e.value;
                        VariableTableEntry newFirst = e.next;
                        VariableTableEntry p2 = first2;
                        while (p2 != e) {
                            newFirst = new VariableTableEntry(p2.hash, p2.name, p2.value, newFirst);
                            p2 = p2.next;
                        }
                        table[index2] = newFirst;
                        --this.variableTableSize;
                        this.variableTable = table;
                        return oldValue;
                    }
                    e = e.next;
                }
            }
        }
        return null;
    }

    protected VariableTableEntry[] variableTableGetTable() {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            return table;
        }
        return VARIABLE_TABLE_EMPTY_TABLE;
    }

    protected int variableTableGetSize() {
        if (this.variableTable != null) {
            return this.variableTableSize;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<IRubyObject>> vars) {
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            this.variableTableSize = 0;
            this.variableTableThreshold = 6;
            this.variableTable = new VariableTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
    }

    protected final VariableTableEntry[] variableTableRehash() {
        VariableTableEntry[] oldTable = this.variableTable;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity << 1;
        VariableTableEntry[] newTable = new VariableTableEntry[newCapacity];
        this.variableTableThreshold = (int)((float)newCapacity * 0.75f);
        int sizeMask = newCapacity - 1;
        int i = oldCapacity;
        while (--i >= 0) {
            int k;
            VariableTableEntry e = oldTable[i];
            if (e == null) continue;
            VariableTableEntry next2 = e.next;
            int idx = e.hash & sizeMask;
            if (next2 == null) {
                newTable[idx] = e;
                continue;
            }
            VariableTableEntry lastRun = e;
            int lastIdx = idx;
            VariableTableEntry last2 = next2;
            while (last2 != null) {
                k = last2.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last2;
                }
                last2 = last2.next;
            }
            newTable[lastIdx] = lastRun;
            VariableTableEntry p2 = e;
            while (p2 != lastRun) {
                VariableTableEntry m;
                k = p2.hash & sizeMask;
                newTable[k] = m = new VariableTableEntry(p2.hash, p2.name, p2.value, newTable[k]);
                p2 = p2.next;
            }
        }
        this.variableTable = newTable;
        return newTable;
    }

    protected Map variableTableGetMap() {
        HashMap<String, IRubyObject> map = new HashMap<String, IRubyObject>();
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int i = table.length;
            while (--i >= 0) {
                VariableTableEntry e = table[i];
                while (e != null) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    map.put(e.name, readValue);
                    e = e.next;
                }
            }
        }
        return map;
    }

    protected Map variableTableGetMap(Map map) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int i = table.length;
            while (--i >= 0) {
                VariableTableEntry e = table[i];
                while (e != null) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    map.put(e.name, readValue);
                    e = e.next;
                }
            }
        }
        return map;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        List<String> names2 = this.getInstanceVariableNameList();
        out.writeInt(names2.size());
        for (String name2 : names2) {
            out.writeObject(name2);
            out.writeObject(this.getInstanceVariables().getInstanceVariable(name2));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int ivarCount = in.readInt();
        for (int i = 0; i < ivarCount; ++i) {
            this.setInstanceVariable((String)in.readObject(), (IRubyObject)in.readObject());
        }
    }

    protected static final class VariableTableEntry {
        final int hash;
        final String name;
        volatile IRubyObject value;
        final VariableTableEntry next;

        VariableTableEntry(int hash2, String name2, IRubyObject value2, VariableTableEntry next2) {
            assert (name2 == name2.intern()) : name2 + " is not interned";
            this.hash = hash2;
            this.name = name2;
            this.value = value2;
            this.next = next2;
        }
    }

    public static class ObjectMethods {
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
        public static IRubyObject intialize(IRubyObject self) {
            return self.getRuntime().getNil();
        }
    }

    public class Finalizer
    implements Finalizable {
        private long id;
        private List<IRubyObject> finalizers;
        private AtomicBoolean finalized;

        public Finalizer(long id2) {
            this.id = id2;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(IRubyObject finalizer) {
            if (this.finalizers == null) {
                this.finalizers = new ArrayList<IRubyObject>();
            }
            this.finalizers.add(finalizer);
        }

        public void removeFinalizers() {
            this.finalizers = null;
        }

        public void finalize() {
            if (this.finalized.compareAndSet(false, true) && this.finalizers != null) {
                for (int i = 0; i < this.finalizers.size(); ++i) {
                    IRubyObject finalizer = this.finalizers.get(i);
                    RuntimeHelpers.invoke(finalizer.getRuntime().getCurrentContext(), finalizer, "call", RubyObject.this.id());
                }
            }
        }
    }
}

