/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.CompatVersion;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.ASTInspector;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.FullFunctionCallbackMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.MethodMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.SimpleCallbackMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Module"})
public class RubyModule
extends RubyObject {
    private static final boolean DEBUG = false;
    static ObjectAllocator MODULE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyModule(runtime2, klass);
        }
    };
    protected RubyClass superClass;
    public int index;
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    public RubyModule parent;
    protected String classId;
    protected final ReentrantLock variableWriteLock = new ReentrantLock();
    protected volatile transient ConstantTableEntry[] constantTable = new ConstantTableEntry[8];
    protected transient int constantTableSize;
    protected transient int constantTableThreshold = 6;
    private final Map<String, DynamicMethod> methods = new ConcurrentHashMap<String, DynamicMethod>(12, 0.75f, 1);
    private transient List<ClassProvider> classProviders;
    private volatile String bareName;
    private volatile String fullName;
    private static MethodFactory.MethodDefiningCallback methodDefiningCallback = new MethodFactory.MethodDefiningCallback(){

        public void define(RubyModule module, JavaMethodDescriptor desc, DynamicMethod dynamicMethod) {
            block17: {
                String baseName;
                RubyClass singletonClass;
                JRubyMethod jrubyMethod;
                block18: {
                    String baseName2;
                    jrubyMethod = desc.anno;
                    if (jrubyMethod.frame()) {
                        for (String name2 : jrubyMethod.name()) {
                            ASTInspector.FRAME_AWARE_METHODS.add(name2);
                        }
                    }
                    if (jrubyMethod.compat() != CompatVersion.BOTH && module.getRuntime().getInstanceConfig().getCompatVersion() != jrubyMethod.compat()) break block17;
                    if (!jrubyMethod.meta()) break block18;
                    singletonClass = module.getSingletonClass();
                    dynamicMethod.setImplementationClass(singletonClass);
                    if (jrubyMethod.name().length == 0) {
                        baseName2 = desc.name;
                        singletonClass.addMethod(baseName2, dynamicMethod);
                    } else {
                        baseName2 = jrubyMethod.name()[0];
                        String[] arr$ = jrubyMethod.name();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            String name3 = arr$[i$];
                            singletonClass.addMethod(name3, dynamicMethod);
                        }
                    }
                    if (jrubyMethod.alias().length <= 0) break block17;
                    for (String alias : jrubyMethod.alias()) {
                        singletonClass.defineAlias(alias, baseName2);
                    }
                    break block17;
                }
                if (jrubyMethod.name().length == 0) {
                    baseName = desc.name;
                    module.addMethod(baseName, dynamicMethod);
                } else {
                    baseName = jrubyMethod.name()[0];
                    String[] arr$ = jrubyMethod.name();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String name4 = arr$[i$];
                        module.addMethod(name4, dynamicMethod);
                    }
                }
                if (jrubyMethod.alias().length > 0) {
                    for (String alias : jrubyMethod.alias()) {
                        module.defineAlias(alias, baseName);
                    }
                }
                if (jrubyMethod.module()) {
                    singletonClass = module.getSingletonClass();
                    DynamicMethod moduleMethod = dynamicMethod.dup();
                    moduleMethod.setVisibility(Visibility.PUBLIC);
                    if (jrubyMethod.name().length == 0) {
                        baseName = desc.name;
                        singletonClass.addMethod(desc.name, moduleMethod);
                    } else {
                        baseName = jrubyMethod.name()[0];
                        for (String name5 : jrubyMethod.name()) {
                            singletonClass.addMethod(name5, moduleMethod);
                        }
                    }
                    if (jrubyMethod.alias().length > 0) {
                        for (String alias : jrubyMethod.alias()) {
                            singletonClass.defineAlias(alias, baseName);
                        }
                    }
                }
            }
        }
    };
    protected static final String ERR_INSECURE_SET_CLASS_VAR = "Insecure: can't modify class variable";
    protected static final String ERR_FROZEN_CVAR_TYPE = "class/module ";
    protected static final String ERR_INSECURE_SET_CONSTANT = "Insecure: can't modify constant";
    protected static final String ERR_FROZEN_CONST_TYPE = "class/module ";
    protected static final int CONSTANT_TABLE_DEFAULT_CAPACITY = 8;
    protected static final int CONSTANT_TABLE_MAXIMUM_CAPACITY = 0x40000000;
    protected static final float CONSTANT_TABLE_LOAD_FACTOR = 0.75f;

    public static RubyClass createModuleClass(Ruby runtime2, RubyClass moduleClass) {
        moduleClass.index = 12;
        moduleClass.kindOf = new KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyModule;
            }
        };
        moduleClass.defineAnnotatedMethods(RubyModule.class);
        moduleClass.defineAnnotatedMethods(ModuleKernelMethods.class);
        return moduleClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 12;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject object) {
        return this.kindOf.isKindOf(object, this);
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass, boolean objectSpace) {
        super(runtime2, metaClass, objectSpace);
        this.id = runtime2.allocModuleId();
        this.setFlag(2048, !this.isClass());
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass) {
        this(runtime2, metaClass, runtime2.isObjectSpaceEnabled());
    }

    protected RubyModule(Ruby runtime2) {
        this(runtime2, runtime2.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(2048);
    }

    public static RubyModule newModule(Ruby runtime2) {
        return new RubyModule(runtime2);
    }

    public static RubyModule newModule(Ruby runtime2, String name2, RubyModule parent, boolean setParent) {
        RubyModule module = RubyModule.newModule(runtime2);
        module.setBaseName(name2);
        if (setParent) {
            module.setParent(parent);
        }
        parent.setConstant(name2, module);
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addClassProvider(ClassProvider provider) {
        if (this.classProviders == null) {
            List<ClassProvider> cp = Collections.synchronizedList(new ArrayList());
            cp.add(provider);
            this.classProviders = cp;
        } else {
            List<ClassProvider> list2 = this.classProviders;
            synchronized (list2) {
                if (!this.classProviders.contains(provider)) {
                    this.classProviders.add(provider);
                }
            }
        }
    }

    public void removeClassProvider(ClassProvider provider) {
        if (this.classProviders != null) {
            this.classProviders.remove(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyClass searchProvidersForClass(String name2, RubyClass superClazz) {
        if (this.classProviders != null) {
            List<ClassProvider> list2 = this.classProviders;
            synchronized (list2) {
                for (ClassProvider classProvider : this.classProviders) {
                    RubyClass clazz = classProvider.defineClassUnder(this, name2, superClazz);
                    if (clazz == null) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyModule searchProvidersForModule(String name2) {
        if (this.classProviders != null) {
            List<ClassProvider> list2 = this.classProviders;
            synchronized (list2) {
                for (ClassProvider classProvider : this.classProviders) {
                    RubyModule module = classProvider.defineModuleUnder(this, name2);
                    if (module == null) continue;
                    return module;
                }
            }
        }
        return null;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    protected void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule parent) {
        this.parent = parent;
    }

    public Map<String, DynamicMethod> getMethods() {
        return this.methods;
    }

    private void putMethod(String name2, DynamicMethod method2) {
        this.getMethods().put(name2, method2);
    }

    public boolean isIncluded() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public String getBaseName() {
        return this.classId;
    }

    public void setBaseName(String name2) {
        this.classId = name2;
    }

    public String getName() {
        if (this.fullName == null) {
            this.fullName = this.calculateFullName();
        }
        return this.fullName;
    }

    private String calculateFullName() {
        if (this.getBaseName() == null) {
            if (this.bareName == null) {
                this.bareName = this.isClass() ? "#<Class:01x" + Integer.toHexString(System.identityHashCode(this)) + ">" : "#<Module:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
            }
            return this.bareName;
        }
        String result = this.getBaseName();
        RubyClass objectClass = this.getRuntime().getObject();
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != objectClass; p2 = p2.getParent()) {
            String pName = p2.getBaseName();
            if (pName == null) {
                pName = p2.getName();
            }
            result = pName + "::" + result;
        }
        return result;
    }

    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    public RubyClass getClass(String name2) {
        IRubyObject module = this.getConstantAt(name2);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    public RubyClass fastGetClass(String internedName) {
        IRubyObject module = this.fastGetConstantAt(internedName);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    public synchronized void includeModule(IRubyObject arg2) {
        assert (arg2 != null);
        this.testFrozen("module");
        if (!this.isTaint()) {
            this.getRuntime().secure(4);
        }
        if (!(arg2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg2.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg2;
        if (this.isSame(module)) {
            return;
        }
        this.infectBy(module);
        this.doIncludeModule(module);
    }

    public void defineMethod(String name2, Callback method2) {
        Visibility visibility = name2.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name2, new FullFunctionCallbackMethod(this, method2, visibility));
    }

    public void defineAnnotatedMethod(Class clazz, String name2) {
        boolean foundMethod = false;
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (!method2.getName().equals(name2) || !this.defineAnnotatedMethod(method2, MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader()))) continue;
            foundMethod = true;
        }
        if (!foundMethod) {
            throw new RuntimeException("No JRubyMethod present for method " + name2 + "on class " + clazz.getName());
        }
    }

    public void defineAnnotatedConstants(Class clazz) {
        Field[] declaredFields;
        for (Field field2 : declaredFields = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers())) continue;
            this.defineAnnotatedConstant(field2);
        }
    }

    public boolean defineAnnotatedConstant(Field field2) {
        IRubyObject realVal;
        JRubyConstant jrubyConstant = field2.getAnnotation(JRubyConstant.class);
        if (jrubyConstant == null) {
            return false;
        }
        String[] names2 = jrubyConstant.value();
        if (names2.length == 0) {
            names2 = new String[]{field2.getName()};
        }
        Class<?> tp = field2.getType();
        try {
            realVal = tp == Integer.class || tp == Integer.TYPE || tp == Short.class || tp == Short.TYPE || tp == Byte.class || tp == Byte.TYPE ? RubyNumeric.int2fix(this.getRuntime(), field2.getInt(null)) : (tp == Boolean.class || tp == Boolean.TYPE ? (field2.getBoolean(null) ? this.getRuntime().getTrue() : this.getRuntime().getFalse()) : this.getRuntime().getNil());
        }
        catch (Exception e) {
            realVal = this.getRuntime().getNil();
        }
        for (String name2 : names2) {
            this.fastSetConstant(name2, realVal);
        }
        return true;
    }

    public void defineAnnotatedMethods(Class clazz) {
        this.defineAnnotatedMethodsIndividually(clazz);
    }

    public void defineAnnotatedMethodsIndividually(Class clazz) {
        String x = clazz.getSimpleName();
        TypePopulator populator = null;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            populator = TypePopulator.DEFAULT;
        } else {
            try {
                String qualifiedName = "org.jruby.gen." + clazz.getCanonicalName().replace('.', '$');
                Class<?> populatorClass = Class.forName(qualifiedName + "$Populator");
                populator = (TypePopulator)populatorClass.newInstance();
            }
            catch (Throwable t) {
                populator = TypePopulator.DEFAULT;
            }
        }
        populator.populate(this, clazz);
    }

    @Deprecated
    private void defineAnnotatedMethodsIndexed(Class clazz) {
        MethodFactory methodFactory = MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader());
        methodFactory.defineIndexedAnnotatedMethods(this, clazz, methodDefiningCallback);
    }

    public boolean defineAnnotatedMethod(String name2, List<JavaMethodDescriptor> methods2, MethodFactory methodFactory) {
        JavaMethodDescriptor desc = methods2.get(0);
        if (methods2.size() == 1) {
            return this.defineAnnotatedMethod(desc, methodFactory);
        }
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, methods2);
        methodDefiningCallback.define(this, desc, dynamicMethod);
        return true;
    }

    public boolean defineAnnotatedMethod(Method method2, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = method2.getAnnotation(JRubyMethod.class);
        if (jrubyMethod == null) {
            return false;
        }
        if (jrubyMethod.compat() == CompatVersion.BOTH || this.getRuntime().getInstanceConfig().getCompatVersion() == jrubyMethod.compat()) {
            JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
            methodDefiningCallback.define(this, desc, dynamicMethod);
            return true;
        }
        return false;
    }

    public boolean defineAnnotatedMethod(JavaMethodDescriptor desc, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = desc.anno;
        if (jrubyMethod == null) {
            return false;
        }
        if (jrubyMethod.compat() == CompatVersion.BOTH || this.getRuntime().getInstanceConfig().getCompatVersion() == jrubyMethod.compat()) {
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
            methodDefiningCallback.define(this, desc, dynamicMethod);
            return true;
        }
        return false;
    }

    public void defineFastMethod(String name2, Callback method2) {
        Visibility visibility = name2.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, visibility));
    }

    public void defineFastMethod(String name2, Callback method2, Visibility visibility) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, visibility));
    }

    public void definePrivateMethod(String name2, Callback method2) {
        this.addMethod(name2, new FullFunctionCallbackMethod(this, method2, Visibility.PRIVATE));
    }

    public void defineFastPrivateMethod(String name2, Callback method2) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, Visibility.PRIVATE));
    }

    public void defineFastProtectedMethod(String name2, Callback method2) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, Visibility.PROTECTED));
    }

    public void undefineMethod(String name2) {
        this.addMethod(name2, UndefinedMethod.getInstance());
    }

    public void undef(ThreadContext context, String name2) {
        DynamicMethod method2;
        Ruby runtime2 = context.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen("module");
        if (name2.equals("__id__") || name2.equals("__send__")) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, "undefining `" + name2 + "' may cause serious problem", new Object[0]);
        }
        if ((method2 = this.searchMethod(name2)).isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = ((MetaClass)c).getAttached();
                if (obj != null && obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw runtime2.newNameError("Undefined method " + name2 + " for" + s0 + " '" + c.getName() + "'", name2);
        }
        this.addMethod(name2, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_undefined", runtime2.newSymbol(name2));
        } else {
            this.callMethod(context, "method_undefined", runtime2.newSymbol(name2));
        }
    }

    @JRubyMethod(name={"include?"}, required=1)
    public IRubyObject include_p(ThreadContext context, IRubyObject arg2) {
        if (!arg2.isModule()) {
            throw context.getRuntime().newTypeError(arg2, context.getRuntime().getModule());
        }
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!(p2 instanceof IncludedModuleWrapper) || ((IncludedModuleWrapper)p2).getNonIncludedClass() != arg2) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(String name2, DynamicMethod method2) {
        Ruby runtime2 = this.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't define method");
        }
        this.testFrozen("class/module");
        Map<String, DynamicMethod> map = this.getMethods();
        synchronized (map) {
            DynamicMethod existingMethod = this.getMethods().put(name2, method2);
            if (existingMethod != null) {
                runtime2.getCacheMap().remove(existingMethod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(ThreadContext context, String name2) {
        Ruby runtime2 = context.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't remove method");
        }
        this.testFrozen("class/module");
        Map<String, DynamicMethod> map = this.getMethods();
        synchronized (map) {
            DynamicMethod method2 = this.getMethods().remove(name2);
            if (method2 == null) {
                throw runtime2.newNameError("method '" + name2 + "' not defined in " + this.getName(), name2);
            }
            runtime2.getCacheMap().remove(method2);
        }
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_removed", runtime2.newSymbol(name2));
        } else {
            this.callMethod(context, "method_removed", runtime2.newSymbol(name2));
        }
    }

    public DynamicMethod searchMethod(String name2) {
        DynamicMethod method2 = this.getMethods().get(name2);
        if (method2 != null) {
            return method2;
        }
        return this.superClass == null ? UndefinedMethod.getInstance() : this.superClass.searchMethod(name2);
    }

    public DynamicMethod retrieveMethod(String name2) {
        return this.getMethods().get(name2);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule searchModule = this; searchModule != null; searchModule = searchModule.getSuperClass()) {
            if (!searchModule.isSame(clazz)) continue;
            return searchModule;
        }
        return null;
    }

    public void addModuleFunction(String name2, DynamicMethod method2) {
        this.addMethod(name2, method2);
        this.getSingletonClass().addMethod(name2, method2);
    }

    public void defineModuleFunction(String name2, Callback method2) {
        this.definePrivateMethod(name2, method2);
        this.getSingletonClass().defineMethod(name2, method2);
    }

    public void definePublicModuleFunction(String name2, Callback method2) {
        this.defineMethod(name2, method2);
        this.getSingletonClass().defineMethod(name2, method2);
    }

    public void defineFastModuleFunction(String name2, Callback method2) {
        this.defineFastPrivateMethod(name2, method2);
        this.getSingletonClass().defineFastMethod(name2, method2);
    }

    public void defineFastPublicModuleFunction(String name2, Callback method2) {
        this.defineFastMethod(name2, method2);
        this.getSingletonClass().defineFastMethod(name2, method2);
    }

    public synchronized void defineAlias(String name2, String oldName) {
        this.testFrozen("module");
        if (oldName.equals(name2)) {
            return;
        }
        Ruby runtime2 = this.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        DynamicMethod method2 = this.searchMethod(oldName);
        DynamicMethod oldMethod = this.searchMethod(name2);
        if (method2.isUndefined()) {
            if (this.isModule()) {
                method2 = runtime2.getObject().searchMethod(oldName);
            }
            if (method2.isUndefined()) {
                throw runtime2.newNameError("undefined method `" + oldName + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", oldName);
            }
        }
        CacheMap cacheMap = runtime2.getCacheMap();
        cacheMap.remove(method2);
        cacheMap.remove(oldMethod);
        if (oldMethod != oldMethod.getRealMethod()) {
            cacheMap.remove(oldMethod.getRealMethod());
        }
        this.putMethod(name2, new AliasMethod(this, method2, oldName));
    }

    public synchronized void defineAliases(List<String> aliases, String oldName) {
        DynamicMethod method2;
        this.testFrozen("module");
        Ruby runtime2 = this.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if ((method2 = this.searchMethod(oldName)).isUndefined()) {
            if (this.isModule()) {
                method2 = runtime2.getObject().searchMethod(oldName);
            }
            if (method2.isUndefined()) {
                throw runtime2.newNameError("undefined method `" + oldName + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", oldName);
            }
        }
        CacheMap cacheMap = runtime2.getCacheMap();
        cacheMap.remove(method2);
        for (String name2 : aliases) {
            if (oldName.equals(name2)) continue;
            DynamicMethod oldMethod = this.searchMethod(name2);
            cacheMap.remove(oldMethod);
            if (oldMethod != oldMethod.getRealMethod()) {
                cacheMap.remove(oldMethod.getRealMethod());
            }
            this.putMethod(name2, new AliasMethod(this, method2, oldName));
        }
    }

    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz) {
        RubyClass clazz;
        Ruby runtime2 = this.getRuntime();
        IRubyObject classObj = this.getConstantAt(name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw runtime2.newTypeError(name2 + " is not a class");
            }
            clazz = (RubyClass)classObj;
            if (superClazz != null) {
                RubyClass tmp;
                for (tmp = clazz.getSuperClass(); tmp != null && tmp.isIncluded(); tmp = tmp.getSuperClass()) {
                }
                if (tmp != null) {
                    tmp = tmp.getRealClass();
                }
                if (tmp != superClazz) {
                    throw runtime2.newTypeError("superclass mismatch for class " + name2);
                }
            }
            if (runtime2.getSafeLevel() >= 4) {
                throw runtime2.newTypeError("extending class prohibited");
            }
        } else if (this.classProviders == null || (clazz = this.searchProvidersForClass(name2, superClazz)) == null) {
            if (superClazz == null) {
                superClazz = runtime2.getObject();
            }
            clazz = RubyClass.newClass(runtime2, superClazz, name2, superClazz.getAllocator(), this, true);
        }
        return clazz;
    }

    public RubyModule defineOrGetModuleUnder(String name2) {
        RubyModule module;
        Ruby runtime2 = this.getRuntime();
        IRubyObject moduleObj = this.getConstantAt(name2);
        if (moduleObj != null) {
            if (!moduleObj.isModule()) {
                throw runtime2.newTypeError(name2 + " is not a module");
            }
            if (runtime2.getSafeLevel() >= 4) {
                throw runtime2.newSecurityError("extending module prohibited");
            }
            module = (RubyModule)moduleObj;
        } else if (this.classProviders == null || (module = this.searchProvidersForModule(name2)) == null) {
            module = RubyModule.newModule(runtime2, name2, this, true);
        }
        return module;
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.getRuntime().defineClassUnder(name2, superClass, allocator, this);
    }

    public RubyModule defineModuleUnder(String name2) {
        return this.getRuntime().defineModuleUnder(name2, this);
    }

    private void addAccessor(ThreadContext context, String internedName, boolean readable, boolean writeable) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        final Ruby runtime2 = context.getRuntime();
        Visibility attributeScope = context.getCurrentVisibility();
        if (attributeScope != Visibility.PRIVATE && attributeScope == Visibility.MODULE_FUNCTION) {
            attributeScope = Visibility.PRIVATE;
        }
        final String variableName = ("@" + internedName).intern();
        if (readable) {
            this.addMethod(internedName, new JavaMethod(this, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    IRubyObject variable;
                    if (args2.length != 0) {
                        Arity.raiseArgumentError(runtime2, args2.length, 0, 0);
                    }
                    return (variable = self.getInstanceVariables().fastGetInstanceVariable(variableName)) == null ? runtime2.getNil() : variable;
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            this.callMethod(context, "method_added", runtime2.fastNewSymbol(internedName));
        }
        if (writeable) {
            internedName = (internedName + "=").intern();
            this.addMethod(internedName, new JavaMethod(this, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    if (args2.length != 1) {
                        Arity.raiseArgumentError(runtime2, args2.length, 1, 1);
                    }
                    return self.getInstanceVariables().fastSetInstanceVariable(variableName, args2[0]);
                }

                public Arity getArity() {
                    return Arity.singleArgument();
                }
            });
            this.callMethod(context, "method_added", runtime2.fastNewSymbol(internedName));
        }
    }

    public void setMethodVisibility(IRubyObject[] methods2, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        for (int i = 0; i < methods2.length; ++i) {
            this.exportMethod(methods2[i].asJavaString(), visibility);
        }
    }

    public void exportMethod(String name2, Visibility visibility) {
        DynamicMethod method2;
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if ((method2 = this.searchMethod(name2)).isUndefined()) {
            throw this.getRuntime().newNameError("undefined method '" + name2 + "' for " + (this.isModule() ? "module" : "class") + " '" + this.getName() + "'", name2);
        }
        if (method2.getVisibility() != visibility) {
            if (this == method2.getImplementationClass()) {
                method2.setVisibility(visibility);
            } else {
                this.addMethod(name2, new WrapperMethod(this, method2, visibility));
            }
        }
    }

    public boolean isMethodBound(String name2, boolean checkVisibility) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (!method2.isUndefined()) {
            return !checkVisibility || method2.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public IRubyObject newMethod(IRubyObject receiver, String name2, boolean bound) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (method2.isUndefined()) {
            throw this.getRuntime().newNameError("undefined method `" + name2 + "' for class `" + this.getName() + "'", name2);
        }
        RubyModule implementationModule = method2.getImplementationClass();
        RubyModule originModule = this;
        while (originModule != implementationModule && originModule.isSingleton()) {
            originModule = ((MetaClass)originModule).getRealClass();
        }
        RubyMethod newMethod = null;
        newMethod = bound ? RubyMethod.newMethod(implementationModule, name2, originModule, name2, method2, receiver) : RubyUnboundMethod.newUnboundMethod(implementationModule, name2, originModule, name2, method2);
        newMethod.infectBy(this);
        return newMethod;
    }

    @JRubyMethod(name={"define_method"}, frame=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.getRuntime();
        String name2 = arg0.asJavaString().intern();
        DynamicMethod newMethod = null;
        Visibility visibility = context.getCurrentVisibility();
        if (visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        RubyProc proc2 = runtime2.newProc(Block.Type.LAMBDA, block);
        proc2.getBlock().type = Block.Type.LAMBDA;
        newMethod = this.createProcMethod(name2, visibility, proc2);
        RuntimeHelpers.addInstanceMethod(this, name2, newMethod, context.getPreviousVisibility(), context, runtime2);
        return proc2;
    }

    @JRubyMethod(name={"define_method"}, frame=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyObject body;
        Ruby runtime2 = context.getRuntime();
        String name2 = arg0.asJavaString().intern();
        DynamicMethod newMethod = null;
        Visibility visibility = context.getCurrentVisibility();
        if (visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        if (runtime2.getProc().isInstance(arg1)) {
            RubyProc proc2;
            body = proc2 = (RubyProc)arg1;
            newMethod = this.createProcMethod(name2, visibility, proc2);
        } else if (runtime2.getMethod().isInstance(arg1)) {
            RubyMethod method2 = (RubyMethod)arg1;
            body = method2;
            newMethod = new MethodMethod(this, method2.unbind(null), visibility);
        } else {
            throw runtime2.newTypeError("wrong argument type " + arg1.getType().getName() + " (expected Proc/Method)");
        }
        RuntimeHelpers.addInstanceMethod(this, name2, newMethod, context.getPreviousVisibility(), context, runtime2);
        return body;
    }

    @Deprecated
    public IRubyObject define_method(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.define_method(context, args2[0], block);
            }
            case 2: {
                return this.define_method(context, args2[0], args2[1], block);
            }
        }
        throw context.getRuntime().newArgumentError("wrong # of arguments(" + args2.length + " for 2)");
    }

    private DynamicMethod createProcMethod(String name2, Visibility visibility, RubyProc proc2) {
        Block block = proc2.getBlock();
        block.getBinding().getFrame().setKlazz(this);
        block.getBinding().getFrame().setName(name2);
        StaticScope scope = block.getBody().getStaticScope();
        scope.setArgumentScope(true);
        Arity arity2 = block.arity();
        scope.setRequiredArgs(arity2.required());
        if (!arity2.isFixed()) {
            scope.setRestArg(arity2.required());
        }
        return new ProcMethod(this, proc2, visibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public IRubyObject executeUnder(ThreadContext context, Callback method2, IRubyObject[] args2, Block block) {
        context.preExecuteUnder(this, block);
        try {
            IRubyObject iRubyObject = method2.execute(this, args2, block);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    @JRubyMethod(name={"name"})
    public RubyString name() {
        return this.getRuntime().newString(this.getBaseName() == null ? "" : this.getName());
    }

    protected IRubyObject cloneMethods(RubyModule clone) {
        RubyModule realType = this.getNonIncludedClass();
        for (Map.Entry<String, DynamicMethod> entry : this.getMethods().entrySet()) {
            DynamicMethod method2 = entry.getValue();
            if (method2.getImplementationClass() != realType && !(method2 instanceof UndefinedMethod)) continue;
            DynamicMethod clonedMethod = method2.dup();
            clonedMethod.setImplementationClass(clone);
            clone.putMethod(entry.getKey(), clonedMethod);
        }
        return clone;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        RubyModule originalModule = (RubyModule)original;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassClone());
        }
        this.setSuperClass(originalModule.getSuperClass());
        if (originalModule.hasVariables()) {
            this.syncVariables(originalModule.getVariableList());
        }
        originalModule.cloneMethods(this);
        return this;
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules(ThreadContext context) {
        RubyArray ary = context.getRuntime().newArray();
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isIncluded()) continue;
            ary.append(p2.getNonIncludedClass());
        }
        return ary;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors(ThreadContext context) {
        return context.getRuntime().newArray(this.getAncestorList());
    }

    @Deprecated
    public RubyArray ancestors() {
        return this.getRuntime().newArray(this.getAncestorList());
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (p2.isSingleton()) continue;
            list2.add(p2.getNonIncludedClass());
        }
        return list2;
    }

    public boolean hasModuleInHierarchy(RubyModule type2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (p2.getNonIncludedClass() != type2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.isSingleton()) {
            IRubyObject attached = ((MetaClass)this).getAttached();
            StringBuilder buffer = new StringBuilder("#<Class:");
            if (attached != null) {
                if (attached instanceof RubyClass || attached instanceof RubyModule) {
                    buffer.append(attached.inspect());
                } else {
                    buffer.append(attached.anyToString());
                }
            }
            buffer.append(">");
            return this.getRuntime().newString(buffer.toString());
        }
        return this.getRuntime().newString(this.getName());
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return context.getRuntime().newBoolean(this.isInstance(obj));
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return super.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze(ThreadContext context) {
        this.to_s();
        return super.freeze(context);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)obj)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)obj).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0);
        }
        if (!(obj instanceof RubyModule)) {
            return this.getRuntime().getNil();
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isSame(type2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule module) {
        return this == module;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yield(this.getRuntime().getCurrentContext(), this, this, this, false);
        }
        return this.getRuntime().getNil();
    }

    public void addReadWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), true, true);
    }

    public void addReadAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), true, false);
    }

    public void addWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), false, true);
    }

    @JRubyMethod(name={"attr"}, required=1, optional=1, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr(ThreadContext context, IRubyObject[] args2) {
        boolean writeable = args2.length > 1 ? args2[1].isTrue() : false;
        this.addAccessor(context, args2[0].asJavaString().intern(), true, writeable);
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_reader(IRubyObject[] args2) {
        return this.attr_reader(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_reader(ThreadContext context, IRubyObject[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            this.addAccessor(context, args2[i].asJavaString().intern(), true, false);
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_writer(ThreadContext context, IRubyObject[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            this.addAccessor(context, args2[i].asJavaString().intern(), false, true);
        }
        return context.getRuntime().getNil();
    }

    public IRubyObject attr_accessor(IRubyObject[] args2) {
        return this.attr_accessor(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_accessor(ThreadContext context, IRubyObject[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            this.addAccessor(context, args2[i].asJavaString().intern(), true, true);
        }
        return context.getRuntime().getNil();
    }

    private RubyArray instance_methods(IRubyObject[] args2, Visibility visibility, boolean not) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        RubyArray ary = this.getRuntime().newArray();
        HashSet<String> seen = new HashSet<String>();
        for (RubyModule type2 = this; type2 != null; type2 = type2.getSuperClass()) {
            RubyModule realType = type2.getNonIncludedClass();
            for (Map.Entry<String, DynamicMethod> entry : type2.getMethods().entrySet()) {
                DynamicMethod method2 = entry.getValue();
                String methodName = entry.getKey();
                if (seen.contains(methodName)) continue;
                seen.add(methodName);
                if (method2.getImplementationClass() != realType || (not || method2.getVisibility() != visibility) && (!not || method2.getVisibility() == visibility) || method2.isUndefined()) continue;
                ary.append(this.getRuntime().newString(methodName));
            }
            if (!includeSuper) break;
        }
        return ary;
    }

    @JRubyMethod(name={"instance_methods"}, optional=1)
    public RubyArray instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, true);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1)
    public RubyArray public_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PUBLIC, false);
    }

    @JRubyMethod(name={"instance_method"}, required=1)
    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asJavaString(), false);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1)
    public RubyArray protected_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PROTECTED, false);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1)
    public RubyArray private_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, false);
    }

    @JRubyMethod(name={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule append_features(IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(module, this.getRuntime().getClassClass());
        }
        ((RubyModule)module).includeModule(this);
        return this;
    }

    @JRubyMethod(name={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(IRubyObject obj) {
        obj.getSingletonClass().includeModule(this);
        return obj;
    }

    @JRubyMethod(name={"include"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule include(IRubyObject[] modules) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int i = modules.length;
        while (--i >= 0) {
            IRubyObject obj = modules[i];
            if (obj.isModule()) continue;
            throw context.getRuntime().newTypeError(obj, context.getRuntime().getModule());
        }
        for (i = modules.length - 1; i >= 0; --i) {
            modules[i].callMethod(context, "append_features", this);
            modules[i].callMethod(context, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"included"}, required=1)
    public IRubyObject included(ThreadContext context, IRubyObject other) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"extended"}, required=1, frame=true)
    public IRubyObject extended(ThreadContext context, IRubyObject other, Block block) {
        return context.getRuntime().getNil();
    }

    private void setVisibility(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
        if (context.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw context.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        if (args2.length == 0) {
            context.setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args2, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPublic(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbProtected(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PROTECTED);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPrivate(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule module_function(ThreadContext context, IRubyObject[] args2) {
        if (context.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw context.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        if (args2.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args2, Visibility.PRIVATE);
            for (int i = 0; i < args2.length; ++i) {
                String name2 = args2[i].asJavaString().intern();
                DynamicMethod method2 = this.searchMethod(name2);
                assert (!method2.isUndefined()) : "undefined method '" + name2 + "'";
                this.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)this.getSingletonClass(), method2, Visibility.PUBLIC));
                this.callMethod(context, "singleton_method_added", context.getRuntime().fastNewSymbol(name2));
            }
        }
        return this;
    }

    @JRubyMethod(name={"method_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(ThreadContext context, IRubyObject nothing) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_removed"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(ThreadContext context, IRubyObject nothing) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_undefined"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(ThreadContext context, IRubyObject nothing) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_defined?"}, required=1)
    public RubyBoolean method_defined_p(ThreadContext context, IRubyObject symbol) {
        return this.isMethodBound(symbol.asJavaString(), true) ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"public_method_defined?"}, required=1)
    public IRubyObject public_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.getRuntime().newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"}, required=1)
    public IRubyObject protected_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.getRuntime().newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"}, required=1)
    public IRubyObject private_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.getRuntime().newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(IRubyObject[] args2) {
        this.getMetaClass().setMethodVisibility(args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(IRubyObject[] args2) {
        this.getMetaClass().setMethodVisibility(args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"}, required=2, visibility=Visibility.PRIVATE)
    public RubyModule alias_method(ThreadContext context, IRubyObject newId, IRubyObject oldId) {
        RubySymbol newSym;
        String newName = newId.asJavaString();
        this.defineAlias(newName, oldId.asJavaString());
        RubySymbol rubySymbol = newSym = newId instanceof RubySymbol ? (RubySymbol)newId : context.getRuntime().newSymbol(newName);
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_added", newSym);
        } else {
            this.callMethod(context, "method_added", newSym);
        }
        return this;
    }

    @JRubyMethod(name={"undef_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule undef_method(ThreadContext context, IRubyObject[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            this.undef(context, args2[i].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this, arg0, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this, arg0, arg1, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this, arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject module_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.specificEval(context, this, args2, block);
    }

    @JRubyMethod(name={"remove_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule remove_method(ThreadContext context, IRubyObject[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            this.removeMethod(context, args2[i].asJavaString());
        }
        return this;
    }

    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        output.registerLinkTarget(module);
        output.writeString(MarshalStream.getPathFromClass(module));
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyModule result = UnmarshalStream.getModuleFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result);
        return result;
    }

    @JRubyMethod(name={"nesting"}, frame=true, meta=true)
    public static RubyArray nesting(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyClass object = runtime2.getObject();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyArray result = runtime2.newArray();
        StaticScope current2 = scope;
        while (current2.getModule() != object) {
            result.append(current2.getModule());
            current2 = current2.getPreviousCRefScope();
        }
        return result;
    }

    private void doIncludeModule(RubyModule includedModule) {
        boolean skip2 = false;
        RubyModule currentModule = this;
        while (includedModule != null) {
            if (this.getNonIncludedClass() == includedModule.getNonIncludedClass()) {
                throw this.getRuntime().newArgumentError("cyclic include detected");
            }
            boolean superclassSeen = false;
            for (RubyClass superClass = this.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                if (superClass instanceof IncludedModuleWrapper) {
                    if (superClass.getNonIncludedClass() != includedModule.getNonIncludedClass()) continue;
                    if (!superclassSeen) {
                        currentModule = superClass;
                    }
                    skip2 = true;
                    break;
                }
                superclassSeen = true;
            }
            if (!skip2) {
                this.getRuntime().getCacheMap().moduleIncluded(currentModule, includedModule);
                currentModule.setSuperClass(new IncludedModuleWrapper(this.getRuntime(), currentModule.getSuperClass(), includedModule.getNonIncludedClass()));
                currentModule = currentModule.getSuperClass();
            }
            includedModule = includedModule.getSuperClass();
            skip2 = false;
        }
    }

    @JRubyMethod(name={"class_variable_defined?"}, required=1)
    public IRubyObject class_variable_defined_p(ThreadContext context, IRubyObject var) {
        String internedName = this.validateClassVariable(var.asJavaString().intern());
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return context.getRuntime().getTrue();
        } while ((module = module.getSuperClass()) != null);
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"class_variable_get"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject class_variable_get(IRubyObject var) {
        return this.fastGetClassVar(this.validateClassVariable(var.asJavaString()).intern());
    }

    @JRubyMethod(name={"class_variable_set"}, required=2, visibility=Visibility.PRIVATE)
    public IRubyObject class_variable_set(IRubyObject var, IRubyObject value2) {
        return this.fastSetClassVar(this.validateClassVariable(var.asJavaString()).intern(), value2);
    }

    @JRubyMethod(name={"remove_class_variable"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_class_variable(ThreadContext context, IRubyObject name2) {
        String javaName = this.validateClassVariable(name2.asJavaString());
        IRubyObject value2 = this.deleteClassVariable(javaName);
        if (value2 != null) {
            return value2;
        }
        if (this.fastIsClassVarDefined(javaName)) {
            throw this.cannotRemoveError(javaName);
        }
        throw context.getRuntime().newNameError("class variable " + javaName + " not defined for " + this.getName(), javaName);
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables(ThreadContext context) {
        HashSet<String> names2 = new HashSet<String>();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            for (String name2 : p2.getClassVariableNameList()) {
                names2.add(name2);
            }
        }
        Ruby runtime2 = context.getRuntime();
        RubyArray ary = runtime2.newArray();
        for (String name3 : names2) {
            ary.append(runtime2.newString(name3));
        }
        return ary;
    }

    @JRubyMethod(name={"const_defined?"}, required=1)
    public RubyBoolean const_defined_p(ThreadContext context, IRubyObject symbol) {
        return context.getRuntime().newBoolean(this.fastIsConstantDefined(this.validateConstant(symbol.asJavaString()).intern()));
    }

    @JRubyMethod(name={"const_get"}, required=1)
    public IRubyObject const_get(IRubyObject symbol) {
        return this.fastGetConstant(this.validateConstant(symbol.asJavaString()).intern());
    }

    @JRubyMethod(name={"const_set"}, required=2)
    public IRubyObject const_set(IRubyObject symbol, IRubyObject value2) {
        return this.fastSetConstant(this.validateConstant(symbol.asJavaString()).intern(), value2);
    }

    @JRubyMethod(name={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(ThreadContext context, IRubyObject name2) {
        String id2 = this.validateConstant(name2.asJavaString());
        IRubyObject value2 = this.deleteConstant(id2);
        if (value2 != null) {
            if (value2 != UNDEF) {
                return value2;
            }
            context.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + id2);
            return context.getRuntime().getNil();
        }
        if (this.hasConstantInHierarchy(id2)) {
            throw this.cannotRemoveError(id2);
        }
        throw context.getRuntime().newNameError("constant " + id2 + " not defined for " + this.getName(), id2);
    }

    private boolean hasConstantInHierarchy(String name2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.hasConstant(name2)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"}, required=1, frame=true)
    public IRubyObject const_missing(ThreadContext context, IRubyObject name2, Block block) {
        if (this != context.getRuntime().getObject()) {
            throw context.getRuntime().newNameError("uninitialized constant " + this.getName() + "::" + name2.asJavaString(), "" + this.getName() + "::" + name2.asJavaString());
        }
        throw context.getRuntime().newNameError("uninitialized constant " + name2.asJavaString(), name2.asJavaString());
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray array = runtime2.newArray();
        RubyClass objectClass = runtime2.getObject();
        if (this.getRuntime().getModule() == this) {
            for (String name2 : objectClass.getStoredConstantNameList()) {
                array.append(runtime2.newString(name2));
            }
        } else if (objectClass == this) {
            for (String name3 : this.getStoredConstantNameList()) {
                array.append(runtime2.newString(name3));
            }
        } else {
            HashSet<String> names2 = new HashSet<String>();
            for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
                if (objectClass == p2) continue;
                for (String name4 : p2.getStoredConstantNameList()) {
                    names2.add(name4);
                }
            }
            for (String name5 : names2) {
                array.append(runtime2.newString(name5));
            }
        }
        return array;
    }

    public IRubyObject setClassVar(String name2, IRubyObject value2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return module.storeClassVariable(name2, value2);
        } while ((module = module.getSuperClass()) != null);
        return this.storeClassVariable(name2, value2);
    }

    public IRubyObject fastSetClassVar(String internedName, IRubyObject value2) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return module.fastStoreClassVariable(internedName, value2);
        } while ((module = module.getSuperClass()) != null);
        return this.fastStoreClassVariable(internedName, value2);
    }

    public IRubyObject getClassVar(String name2) {
        assert (IdUtil.isClassVariable(name2));
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.variableTableFetch(name2)) == null) continue;
            return value2;
        } while ((module = module.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + name2 + " in " + this.getName(), name2);
    }

    public IRubyObject fastGetClassVar(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isClassVariable(internedName));
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.variableTableFastFetch(internedName)) == null) continue;
            return value2;
        } while ((module = module.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + internedName + " in " + this.getName(), internedName);
    }

    public boolean isClassVarDefined(String name2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsClassVarDefined(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    public IRubyObject removeCvar(IRubyObject name2) {
        String internedName = this.validateClassVariable(name2.asJavaString());
        IRubyObject value2 = this.deleteClassVariable(internedName);
        if (value2 != null) {
            return value2;
        }
        if (this.fastIsClassVarDefined(internedName)) {
            throw this.cannotRemoveError(internedName);
        }
        throw this.getRuntime().newNameError("class variable " + internedName + " not defined for " + this.getName(), internedName);
    }

    public IRubyObject getConstantAt(String name2) {
        IRubyObject value2 = this.fetchConstant(name2);
        if (value2 != UNDEF) {
            return value2;
        }
        this.deleteConstant(name2);
        return this.getRuntime().getLoadService().autoload(this.getName() + "::" + name2);
    }

    public IRubyObject fastGetConstantAt(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        IRubyObject value2 = this.fastFetchConstant(internedName);
        if (value2 != UNDEF) {
            return value2;
        }
        this.deleteConstant(internedName);
        return this.getRuntime().getLoadService().autoload(this.getName() + "::" + internedName);
    }

    public IRubyObject getConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        boolean retryForModule = false;
        RubyModule p2 = this;
        while (true) {
            if (p2 != null) {
                IRubyObject value2 = p2.constantTableFetch(name2);
                if (value2 != null) {
                    if (value2 != UNDEF) {
                        return value2;
                    }
                    p2.deleteConstant(name2);
                    if (this.getRuntime().getLoadService().autoload(p2.getName() + "::" + name2) != null) continue;
                } else {
                    p2 = p2.getSuperClass();
                    continue;
                }
            }
            if (retryForModule || this.isClass()) break;
            retryForModule = true;
            p2 = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().newSymbol(name2));
    }

    public IRubyObject fastGetConstant(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        boolean retryForModule = false;
        RubyModule p2 = this;
        while (true) {
            if (p2 != null) {
                IRubyObject value2 = p2.constantTableFastFetch(internedName);
                if (value2 != null) {
                    if (value2 != UNDEF) {
                        return value2;
                    }
                    p2.deleteConstant(internedName);
                    if (this.getRuntime().getLoadService().autoload(p2.getName() + "::" + internedName) != null) continue;
                } else {
                    p2 = p2.getSuperClass();
                    continue;
                }
            }
            if (retryForModule || this.isClass()) break;
            retryForModule = true;
            p2 = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().fastNewSymbol(internedName));
    }

    public IRubyObject getConstantFrom(String name2) {
        return this.fastGetConstantFrom(name2.intern());
    }

    public IRubyObject fastGetConstantFrom(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        RubyClass objectClass = this.getRuntime().getObject();
        RubyModule p2 = this;
        while (p2 != null) {
            IRubyObject value2 = p2.constantTableFastFetch(internedName);
            if (value2 != null) {
                if (value2 != UNDEF) {
                    if (p2 == objectClass && this != objectClass) {
                        String badCName = this.getName() + "::" + internedName;
                        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_BAD_REFERENCE, "toplevel constant " + internedName + " referenced by " + badCName, badCName);
                    }
                    return value2;
                }
                p2.deleteConstant(internedName);
                if (this.getRuntime().getLoadService().autoload(p2.getName() + "::" + internedName) != null) continue;
                break;
            }
            p2 = p2.getSuperClass();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().fastNewSymbol(internedName));
    }

    public IRubyObject setConstant(String name2, IRubyObject value2) {
        RubyModule module;
        IRubyObject oldValue = this.fetchConstant(name2);
        if (oldValue != null) {
            if (oldValue == UNDEF) {
                this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + name2);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + name2, name2);
            }
        }
        this.storeConstant(name2, value2);
        if (value2 instanceof RubyModule && (module = (RubyModule)value2).getBaseName() == null) {
            module.setBaseName(name2);
            module.setParent(this);
        }
        return value2;
    }

    public IRubyObject fastSetConstant(String internedName, IRubyObject value2) {
        RubyModule module;
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        IRubyObject oldValue = this.fastFetchConstant(internedName);
        if (oldValue != null) {
            if (oldValue == UNDEF) {
                this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + internedName);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + internedName, internedName);
            }
        }
        this.fastStoreConstant(internedName, value2);
        if (value2 instanceof RubyModule && (module = (RubyModule)value2).getBaseName() == null) {
            module.setBaseName(internedName);
            module.setParent(this);
        }
        return value2;
    }

    public void defineConstant(String name2, IRubyObject value2) {
        assert (value2 != null);
        if (this == this.getRuntime().getClassClass()) {
            this.getRuntime().secure(4);
        }
        if (!IdUtil.isValidConstantName(name2)) {
            throw this.getRuntime().newNameError("bad constant name " + name2, name2);
        }
        this.setConstant(name2, value2);
    }

    public boolean isConstantDefined(String name2) {
        assert (IdUtil.isConstant(name2));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(name2)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getRuntime().getLoadService().autoloadFor(module.getName() + "::" + name2) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFastFetch(internedName)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getRuntime().getLoadService().autoloadFor(module.getName() + "::" + internedName) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    private RaiseException cannotRemoveError(String id2) {
        return this.getRuntime().newNameError("cannot remove " + id2 + " for " + this.getName(), id2);
    }

    public boolean hasInternalModuleVariable(String name2) {
        RubyModule module = this;
        do {
            if (!module.hasInternalVariable(name2)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String name2) {
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.getInternalVariable(name2)) == null) continue;
            return value2;
        } while ((module = module.getSuperClass()) != null);
        return null;
    }

    public void setInternalModuleVariable(String name2, IRubyObject value2) {
        RubyModule module = this;
        do {
            if (!module.hasInternalVariable(name2)) continue;
            module.setInternalVariable(name2, value2);
            return;
        } while ((module = module.getSuperClass()) != null);
        this.setInternalVariable(name2, value2);
    }

    public boolean hasClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.variableTableContains(name2);
    }

    public boolean fastHasClassVariable(String internedName) {
        assert (IdUtil.isClassVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    public IRubyObject fetchClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.variableTableFetch(name2);
    }

    public IRubyObject fastFetchClassVariable(String internedName) {
        assert (IdUtil.isClassVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    public IRubyObject storeClassVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isClassVariable(name2) && value2 != null);
        this.ensureClassVariablesSettable();
        return this.variableTableStore(name2, value2);
    }

    public IRubyObject fastStoreClassVariable(String internedName, IRubyObject value2) {
        assert (IdUtil.isClassVariable(internedName) && value2 != null);
        this.ensureClassVariablesSettable();
        return this.variableTableFastStore(internedName, value2);
    }

    public IRubyObject deleteClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        this.ensureClassVariablesSettable();
        return this.variableTableRemove(name2);
    }

    public List<Variable<IRubyObject>> getClassVariableList() {
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        RubyObject.VariableTableEntry[] table = this.variableTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            RubyObject.VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isClassVariable(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    list2.add(new VariableEntry<IRubyObject>(e.name, readValue));
                }
                e = e.next;
            }
        }
        return list2;
    }

    public List<String> getClassVariableNameList() {
        ArrayList<String> list2 = new ArrayList<String>();
        RubyObject.VariableTableEntry[] table = this.variableTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            RubyObject.VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isClassVariable(e.name)) {
                    list2.add(e.name);
                }
                e = e.next;
            }
        }
        return list2;
    }

    protected final String validateClassVariable(String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowed as a class variable name", name2);
    }

    protected final void ensureClassVariablesSettable() {
        Ruby runtime2 = this.getRuntime();
        if (!this.isFrozen() && (runtime2.getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw runtime2.newFrozenError("class/module ");
            }
            throw runtime2.newFrozenError("");
        }
    }

    public boolean hasConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableContains(name2);
    }

    public boolean fastHasConstant(String internedName) {
        assert (IdUtil.isConstant(internedName));
        return this.constantTableFastContains(internedName);
    }

    public IRubyObject fetchConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableFetch(name2);
    }

    public IRubyObject fastFetchConstant(String internedName) {
        assert (IdUtil.isConstant(internedName));
        return this.constantTableFastFetch(internedName);
    }

    public IRubyObject storeConstant(String name2, IRubyObject value2) {
        assert (IdUtil.isConstant(name2) && value2 != null);
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2);
    }

    public IRubyObject fastStoreConstant(String internedName, IRubyObject value2) {
        assert (IdUtil.isConstant(internedName) && value2 != null);
        this.ensureConstantsSettable();
        return this.constantTableFastStore(internedName, value2);
    }

    public IRubyObject deleteConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        this.ensureConstantsSettable();
        return this.constantTableRemove(name2);
    }

    public List<Variable<IRubyObject>> getStoredConstantList() {
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        ConstantTableEntry[] table = this.constantTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            ConstantTableEntry e = table[i];
            while (e != null) {
                list2.add(e);
                e = e.next;
            }
        }
        return list2;
    }

    public List<String> getStoredConstantNameList() {
        ArrayList<String> list2 = new ArrayList<String>();
        ConstantTableEntry[] table = this.constantTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            ConstantTableEntry e = table[i];
            while (e != null) {
                list2.add(e.name);
                e = e.next;
            }
        }
        return list2;
    }

    protected final String validateConstant(String name2) {
        if (IdUtil.isValidConstantName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("wrong constant name " + name2, name2);
    }

    protected final void ensureConstantsSettable() {
        Ruby runtime2 = this.getRuntime();
        if (!this.isFrozen() && (runtime2.getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw runtime2.newFrozenError("class/module ");
            }
            throw runtime2.newFrozenError("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableStore(String name2, IRubyObject value2) {
        int hash2 = name2.hashCode();
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            RubyObject.VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                RubyObject.VariableTableEntry e;
                table = new RubyObject.VariableTableEntry[8];
                table[hash2 & 7] = e = new RubyObject.VariableTableEntry(hash2, name2.intern(), value2, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                IRubyObject iRubyObject = value2;
                return iRubyObject;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index2 = hash2 & table.length - 1;
            RubyObject.VariableTableEntry e = table[index2];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    e.value = value2;
                    IRubyObject iRubyObject = value2;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index2] = e = new RubyObject.VariableTableEntry(hash2, name2.intern(), value2, table[index2]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        finally {
            lock2.unlock();
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableFastStore(String internedName, IRubyObject value2) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        int hash2 = internedName.hashCode();
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            RubyObject.VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                RubyObject.VariableTableEntry e;
                table = new RubyObject.VariableTableEntry[8];
                table[hash2 & 7] = e = new RubyObject.VariableTableEntry(hash2, internedName, value2, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                IRubyObject iRubyObject = value2;
                return iRubyObject;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index2 = hash2 & table.length - 1;
            RubyObject.VariableTableEntry e = table[index2];
            while (e != null) {
                if (internedName == e.name) {
                    e.value = value2;
                    IRubyObject iRubyObject = value2;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index2] = e = new RubyObject.VariableTableEntry(hash2, internedName, value2, table[index2]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        finally {
            lock2.unlock();
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableRemove(String name2) {
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            RubyObject.VariableTableEntry[] table = this.variableTable;
            if (this.variableTable != null) {
                RubyObject.VariableTableEntry first2;
                int hash2 = name2.hashCode();
                int index2 = hash2 & table.length - 1;
                RubyObject.VariableTableEntry e = first2 = table[index2];
                while (e != null) {
                    if (hash2 == e.hash && name2.equals(e.name)) {
                        IRubyObject oldValue = e.value;
                        RubyObject.VariableTableEntry newFirst = e.next;
                        RubyObject.VariableTableEntry p2 = first2;
                        while (p2 != e) {
                            newFirst = new RubyObject.VariableTableEntry(p2.hash, p2.name, p2.value, newFirst);
                            p2 = p2.next;
                        }
                        table[index2] = newFirst;
                        --this.variableTableSize;
                        this.variableTable = table;
                        IRubyObject iRubyObject = oldValue;
                        return iRubyObject;
                    }
                    e = e.next;
                }
            }
        }
        finally {
            lock2.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableReadLocked(RubyObject.VariableTableEntry entry) {
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            IRubyObject iRubyObject = entry.value;
            return iRubyObject;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void variableTableSync(List<Variable<IRubyObject>> vars) {
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            this.variableTableSize = 0;
            this.variableTableThreshold = 6;
            this.variableTable = new RubyObject.VariableTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                assert (!var.isConstant() && var.getValue() != null);
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncVariables(List<Variable<IRubyObject>> variables) {
        ArrayList<Variable<IRubyObject>> constants2 = new ArrayList<Variable<IRubyObject>>(variables.size());
        Iterator<Variable<IRubyObject>> iter = variables.iterator();
        while (iter.hasNext()) {
            Variable<IRubyObject> var = iter.next();
            if (!var.isConstant()) continue;
            constants2.add(var);
            iter.remove();
        }
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            this.variableTableSync(variables);
            this.constantTableSync(constants2);
        }
        finally {
            lock2.unlock();
        }
    }

    @Override
    @Deprecated
    public Map getVariableMap() {
        Map map = this.variableTableGetMap();
        this.constantTableGetMap(map);
        return map;
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0 || this.constantTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize() + this.constantTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        Object e;
        RubyObject.VariableTableEntry[] vtable = this.variableTableGetTable();
        ConstantTableEntry[] ctable = this.constantTableGetTable();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        int i = vtable.length;
        while (--i >= 0) {
            e = vtable[i];
            while (e != null) {
                IRubyObject readValue = ((RubyObject.VariableTableEntry)e).value;
                if (readValue == null) {
                    readValue = this.variableTableReadLocked((RubyObject.VariableTableEntry)e);
                }
                list2.add(new VariableEntry<IRubyObject>(((RubyObject.VariableTableEntry)e).name, readValue));
                e = ((RubyObject.VariableTableEntry)e).next;
            }
        }
        i = ctable.length;
        while (--i >= 0) {
            e = ctable[i];
            while (e != null) {
                list2.add((Variable<IRubyObject>)e);
                e = ((ConstantTableEntry)e).next;
            }
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        Object e;
        RubyObject.VariableTableEntry[] vtable = this.variableTableGetTable();
        ConstantTableEntry[] ctable = this.constantTableGetTable();
        ArrayList<String> list2 = new ArrayList<String>();
        int i = vtable.length;
        while (--i >= 0) {
            e = vtable[i];
            while (e != null) {
                list2.add(((RubyObject.VariableTableEntry)e).name);
                e = ((RubyObject.VariableTableEntry)e).next;
            }
        }
        i = ctable.length;
        while (--i >= 0) {
            e = ctable[i];
            while (e != null) {
                list2.add(((ConstantTableEntry)e).name);
                e = ((ConstantTableEntry)e).next;
            }
        }
        return list2;
    }

    protected boolean constantTableContains(String name2) {
        int hash2 = name2.hashCode();
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[hash2 & table.length - 1];
        while (e != null) {
            if (hash2 == e.hash && name2.equals(e.name)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    protected boolean constantTableFastContains(String internedName) {
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[internedName.hashCode() & table.length - 1];
        while (e != null) {
            if (internedName == e.name) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    protected IRubyObject constantTableFetch(String name2) {
        int hash2 = name2.hashCode();
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[hash2 & table.length - 1];
        while (e != null) {
            if (hash2 == e.hash && name2.equals(e.name)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected IRubyObject constantTableFastFetch(String internedName) {
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[internedName.hashCode() & table.length - 1];
        while (e != null) {
            if (internedName == e.name) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        int hash2 = name2.hashCode();
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            ConstantTableEntry first2;
            int potentialNewSize = this.constantTableSize + 1;
            ConstantTableEntry[] table = potentialNewSize > this.constantTableThreshold ? this.constantTableRehash() : this.constantTable;
            int index2 = hash2 & table.length - 1;
            ConstantTableEntry e = first2 = table[index2];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    if (value2 == e.value) {
                        IRubyObject iRubyObject = value2;
                        return iRubyObject;
                    }
                    ConstantTableEntry newFirst = new ConstantTableEntry(e.hash, e.name, value2, e.next);
                    ConstantTableEntry n = first2;
                    while (n != e) {
                        newFirst = new ConstantTableEntry(n.hash, n.name, n.value, newFirst);
                        n = n.next;
                    }
                    table[index2] = newFirst;
                    this.constantTable = table;
                    IRubyObject iRubyObject = value2;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index2] = new ConstantTableEntry(hash2, name2.intern(), value2, table[index2]);
            this.constantTableSize = potentialNewSize;
            this.constantTable = table;
        }
        finally {
            lock2.unlock();
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableFastStore(String internedName, IRubyObject value2) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        int hash2 = internedName.hashCode();
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            ConstantTableEntry first2;
            int potentialNewSize = this.constantTableSize + 1;
            ConstantTableEntry[] table = potentialNewSize > this.constantTableThreshold ? this.constantTableRehash() : this.constantTable;
            int index2 = hash2 & table.length - 1;
            ConstantTableEntry e = first2 = table[index2];
            while (e != null) {
                if (internedName == e.name) {
                    if (value2 == e.value) {
                        IRubyObject iRubyObject = value2;
                        return iRubyObject;
                    }
                    ConstantTableEntry newFirst = new ConstantTableEntry(e.hash, e.name, value2, e.next);
                    ConstantTableEntry n = first2;
                    while (n != e) {
                        newFirst = new ConstantTableEntry(n.hash, n.name, n.value, newFirst);
                        n = n.next;
                    }
                    table[index2] = newFirst;
                    this.constantTable = table;
                    IRubyObject iRubyObject = value2;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index2] = new ConstantTableEntry(hash2, internedName, value2, table[index2]);
            this.constantTableSize = potentialNewSize;
            this.constantTable = table;
        }
        finally {
            lock2.unlock();
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableRemove(String name2) {
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            ConstantTableEntry[] table = this.constantTable;
            if (this.constantTable != null) {
                ConstantTableEntry first2;
                int hash2 = name2.hashCode();
                int index2 = hash2 & table.length - 1;
                ConstantTableEntry e = first2 = table[index2];
                while (e != null) {
                    if (hash2 == e.hash && name2.equals(e.name)) {
                        IRubyObject oldValue = e.value;
                        ConstantTableEntry newFirst = e.next;
                        ConstantTableEntry p2 = first2;
                        while (p2 != e) {
                            newFirst = new ConstantTableEntry(p2.hash, p2.name, p2.value, newFirst);
                            p2 = p2.next;
                        }
                        table[index2] = newFirst;
                        --this.constantTableSize;
                        this.constantTable = table;
                        IRubyObject iRubyObject = oldValue;
                        return iRubyObject;
                    }
                    e = e.next;
                }
            }
        }
        finally {
            lock2.unlock();
        }
        return null;
    }

    protected ConstantTableEntry[] constantTableGetTable() {
        return this.constantTable;
    }

    protected int constantTableGetSize() {
        if (this.constantTable != null) {
            return this.constantTableSize;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constantTableSync(List<Variable<IRubyObject>> vars) {
        ReentrantLock lock2 = this.variableWriteLock;
        lock2.lock();
        try {
            this.constantTableSize = 0;
            this.constantTableThreshold = 6;
            this.constantTable = new ConstantTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                assert (var.isConstant() && var.getValue() != null);
                this.constantTableStore(var.getName(), var.getValue());
            }
        }
        finally {
            lock2.unlock();
        }
    }

    private final ConstantTableEntry[] constantTableRehash() {
        ConstantTableEntry[] oldTable = this.constantTable;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity << 1;
        ConstantTableEntry[] newTable = new ConstantTableEntry[newCapacity];
        this.constantTableThreshold = (int)((float)newCapacity * 0.75f);
        int sizeMask = newCapacity - 1;
        int i = oldCapacity;
        while (--i >= 0) {
            int k;
            ConstantTableEntry e = oldTable[i];
            if (e == null) continue;
            ConstantTableEntry next2 = e.next;
            int idx = e.hash & sizeMask;
            if (next2 == null) {
                newTable[idx] = e;
                continue;
            }
            ConstantTableEntry lastRun = e;
            int lastIdx = idx;
            ConstantTableEntry last2 = next2;
            while (last2 != null) {
                k = last2.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last2;
                }
                last2 = last2.next;
            }
            newTable[lastIdx] = lastRun;
            ConstantTableEntry p2 = e;
            while (p2 != lastRun) {
                ConstantTableEntry m;
                k = p2.hash & sizeMask;
                newTable[k] = m = new ConstantTableEntry(p2.hash, p2.name, p2.value, newTable[k]);
                p2 = p2.next;
            }
        }
        this.constantTable = newTable;
        return newTable;
    }

    protected Map constantTableGetMap() {
        HashMap<String, IRubyObject> map = new HashMap<String, IRubyObject>();
        ConstantTableEntry[] table = this.constantTable;
        if (this.constantTable != null) {
            int i = table.length;
            while (--i >= 0) {
                ConstantTableEntry e = table[i];
                while (e != null) {
                    map.put(e.name, e.value);
                    e = e.next;
                }
            }
        }
        return map;
    }

    protected Map constantTableGetMap(Map map) {
        ConstantTableEntry[] table = this.constantTable;
        if (this.constantTable != null) {
            int i = table.length;
            while (--i >= 0) {
                ConstantTableEntry e = table[i];
                while (e != null) {
                    map.put(e.name, e.value);
                    e = e.next;
                }
            }
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ConstantTableEntry
    implements Variable<IRubyObject> {
        final int hash;
        final String name;
        final IRubyObject value;
        final ConstantTableEntry next;

        ConstantTableEntry(int hash2, String name2, IRubyObject value2, ConstantTableEntry next2) {
            this.hash = hash2;
            this.name = name2;
            this.value = value2;
            this.next = next2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IRubyObject getValue() {
            return this.value;
        }

        @Override
        public final boolean isClassVariable() {
            return false;
        }

        @Override
        public final boolean isConstant() {
            return true;
        }

        @Override
        public final boolean isInstanceVariable() {
            return false;
        }

        @Override
        public final boolean isRubyVariable() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodClumper {
        Map<String, List<JavaMethodDescriptor>> annotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> annotatedMethods1_8 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods1_8 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> annotatedMethods1_9 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods1_9 = new HashMap<String, List<JavaMethodDescriptor>>();

        public void clump(Class cls) {
            Method[] declaredMethods;
            for (Method method2 : declaredMethods = cls.getDeclaredMethods()) {
                JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
                String name2 = anno.name().length == 0 ? method2.getName() : anno.name()[0];
                Map<String, List<JavaMethodDescriptor>> methodsHash = null;
                methodsHash = desc.isStatic ? (anno.compat() == CompatVersion.RUBY1_8 ? this.staticAnnotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? this.staticAnnotatedMethods1_9 : this.staticAnnotatedMethods)) : (anno.compat() == CompatVersion.RUBY1_8 ? this.annotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? this.annotatedMethods1_9 : this.annotatedMethods));
                List<JavaMethodDescriptor> methodDescs = methodsHash.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>();
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(desc);
            }
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods() {
            return this.annotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods1_8() {
            return this.annotatedMethods1_8;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods1_9() {
            return this.annotatedMethods1_9;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods() {
            return this.staticAnnotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods1_8() {
            return this.staticAnnotatedMethods1_8;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods1_9() {
            return this.staticAnnotatedMethods1_9;
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return obj.getMetaClass().hasModuleInHierarchy(type2);
        }
    }

    public static class ModuleKernelMethods {
        @JRubyMethod
        public static IRubyObject autoload(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            return RubyKernel.autoload(recv2, arg0, arg1);
        }

        @JRubyMethod(name={"autoload?"})
        public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            return RubyKernel.autoload_p(context, recv2, arg0);
        }
    }
}

