/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.yaml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.internal.runtime.methods.SimpleCallbackMethod;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Representer;
import org.jvyamlb.SafeRepresenterImpl;
import org.jvyamlb.Serializer;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLNodeCreator;
import org.jvyamlb.nodes.Node;

public class JRubyRepresenter
extends SafeRepresenterImpl {
    public JRubyRepresenter(Serializer serializer, YAMLConfig opts) {
        super(serializer, opts);
    }

    protected YAMLNodeCreator getNodeCreatorFor(Object data) {
        if (data instanceof YAMLNodeCreator) {
            return (YAMLNodeCreator)data;
        }
        if (data instanceof IRubyObject) {
            return new IRubyObjectYAMLNodeCreator(data);
        }
        return super.getNodeCreatorFor(data);
    }

    public Node map(String tag, Map mapping, Object flowStyle) throws IOException {
        if (null == flowStyle) {
            return this.map(tag, mapping, false);
        }
        return this.map(tag, mapping, true);
    }

    public Node seq(String tag, List sequence, Object flowStyle) throws IOException {
        if (sequence instanceof RubyArray) {
            sequence = ((RubyArray)sequence).getList();
        }
        if (null == flowStyle) {
            return this.seq(tag, sequence, false);
        }
        return this.seq(tag, sequence, true);
    }

    public Node scalar(String tag, String val, String style) throws IOException {
        return this.scalar(tag, ByteList.create(val), style);
    }

    public Node scalar(String tag, ByteList val, String style) throws IOException {
        if (null == style || style.length() == 0) {
            return this.scalar(tag, val, '\u0000');
        }
        return this.scalar(tag, val, style.charAt(0));
    }

    protected boolean ignoreAliases(Object data) {
        return data instanceof IRubyObject && ((IRubyObject)data).isNil() || super.ignoreAliases(data);
    }

    public static class IRubyObjectYAMLNodeCreator
    implements YAMLNodeCreator {
        private final IRubyObject data;

        public IRubyObjectYAMLNodeCreator(Object data) {
            this.data = (IRubyObject)data;
        }

        public String taguri() {
            return this.data.callMethod(this.data.getRuntime().getCurrentContext(), "taguri").toString();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            if (this.data.getMetaClass().searchMethod("to_yaml") instanceof SimpleCallbackMethod) {
                IRubyObject val = this.data.callMethod(this.data.getRuntime().getCurrentContext(), "to_yaml_node", JavaEmbedUtils.javaToRuby(this.data.getRuntime(), representer));
                if (val instanceof Node) {
                    return (Node)((Object)val);
                }
                if (val instanceof IRubyObject) {
                    return (Node)JavaEmbedUtils.rubyToJava(this.data.getRuntime(), val, Node.class);
                }
            } else {
                IRubyObject val = this.data.callMethod(this.data.getRuntime().getCurrentContext(), "to_yaml", JavaEmbedUtils.javaToRuby(this.data.getRuntime(), representer));
                IRubyObject value = val.callMethod(this.data.getRuntime().getCurrentContext(), "value");
                IRubyObject style = val.callMethod(this.data.getRuntime().getCurrentContext(), "style");
                IRubyObject type_id = val.callMethod(this.data.getRuntime().getCurrentContext(), "type_id");
                String s = null;
                if (!style.isNil()) {
                    s = style.toString();
                }
                String t = type_id.toString();
                if (value instanceof RubyHash) {
                    return ((JRubyRepresenter)representer).map(t, (Map)((RubyHash)value), s);
                }
                if (value instanceof RubyArray) {
                    return ((JRubyRepresenter)representer).seq(t, (List)((RubyArray)value), s);
                }
                return ((JRubyRepresenter)representer).scalar(t, ((RubyString)value).getByteList(), s);
            }
            return null;
        }
    }
}

