/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor.rewriter;

import java.util.Iterator;
import org.jruby.ast.BlockNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.jruby.ast.visitor.rewriter.utils.ReWriterContext;

public class ClassBodyWriter {
    private ReWriteVisitor visitor;
    private Node bodyNode;
    private ReWriterContext context;

    public ClassBodyWriter(ReWriteVisitor visitor, Node bodyNode) {
        this.visitor = visitor;
        this.bodyNode = bodyNode;
        this.context = visitor.getConfig();
    }

    public void write() {
        if (this.bodyNode instanceof BlockNode) {
            this.context.getIndentor().indent();
            this.writeContent((BlockNode)this.bodyNode);
            this.context.getIndentor().outdent();
        } else if (this.bodyNode instanceof NewlineNode) {
            this.visitor.visitNodeInIndentation(this.bodyNode);
        } else {
            this.visitor.visitNode(this.bodyNode);
        }
    }

    private void writeContent(BlockNode node) {
        Iterator it = node.childNodes().iterator();
        while (it.hasNext()) {
            this.visitor.visitNode((Node)it.next());
            if (!it.hasNext()) continue;
            this.context.getOutput().print(this.context.getFormatHelper().classBodyElementsSeparator());
        }
    }
}

