/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.text.DecimalFormat;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Convert;

public class RubyFloat
extends RubyNumeric {
    private final double value;
    private static final DecimalFormat FORMAT = new DecimalFormat("##############0.0##############");

    public static RubyClass createFloatClass(Ruby runtime) {
        RubyClass floatc = runtime.defineClass("Float", runtime.getClass("Numeric"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        floatc.index = 11;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFloat.class);
        floatc.getSingletonClass().undefineMethod("allocate");
        floatc.getSingletonClass().undefineMethod("new");
        floatc.getMetaClass().defineFastMethod("induced_from", callbackFactory.getFastSingletonMethod("induced_from", RubyKernel.IRUBY_OBJECT));
        floatc.includeModule(runtime.getModule("Precision"));
        floatc.defineConstant("ROUNDS", RubyFixnum.newFixnum(runtime, 1L));
        floatc.defineConstant("RADIX", RubyFixnum.newFixnum(runtime, 2L));
        floatc.defineConstant("MANT_DIG", RubyFixnum.newFixnum(runtime, 53L));
        floatc.defineConstant("DIG", RubyFixnum.newFixnum(runtime, 15L));
        floatc.defineConstant("MIN_EXP", RubyFixnum.newFixnum(runtime, -1021L));
        floatc.defineConstant("MAX_EXP", RubyFixnum.newFixnum(runtime, 1024L));
        floatc.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(runtime, -307L));
        floatc.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(runtime, -308L));
        floatc.defineConstant("MIN", RubyFloat.newFloat(runtime, Double.MIN_VALUE));
        floatc.defineConstant("MAX", RubyFloat.newFloat(runtime, Double.MAX_VALUE));
        floatc.defineConstant("EPSILON", RubyFloat.newFloat(runtime, 2.220446049250313E-16));
        floatc.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        floatc.defineFastMethod("coerce", callbackFactory.getFastMethod("coerce", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("-@", callbackFactory.getFastMethod("uminus"));
        floatc.defineFastMethod("+", callbackFactory.getFastMethod("plus", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("-", callbackFactory.getFastMethod("minus", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("*", callbackFactory.getFastMethod("mul", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("/", callbackFactory.getFastMethod("fdiv", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("%", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("modulo", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("divmod", callbackFactory.getFastMethod("divmod", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("**", callbackFactory.getFastMethod("pow", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("<=>", callbackFactory.getFastMethod("cmp", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod(">", callbackFactory.getFastMethod("gt", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod(">=", callbackFactory.getFastMethod("ge", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("<", callbackFactory.getFastMethod("lt", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("<=", callbackFactory.getFastMethod("le", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        floatc.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        floatc.defineFastMethod("to_f", callbackFactory.getFastMethod("to_f"));
        floatc.defineFastMethod("abs", callbackFactory.getFastMethod("abs"));
        floatc.defineFastMethod("zero?", callbackFactory.getFastMethod("zero_p"));
        floatc.defineFastMethod("to_i", callbackFactory.getFastMethod("truncate"));
        floatc.defineFastMethod("to_int", callbackFactory.getFastMethod("truncate"));
        floatc.defineFastMethod("floor", callbackFactory.getFastMethod("floor"));
        floatc.defineFastMethod("ceil", callbackFactory.getFastMethod("ceil"));
        floatc.defineFastMethod("round", callbackFactory.getFastMethod("round"));
        floatc.defineFastMethod("truncate", callbackFactory.getFastMethod("truncate"));
        floatc.defineFastMethod("nan?", callbackFactory.getFastMethod("nan_p"));
        floatc.defineFastMethod("infinite?", callbackFactory.getFastMethod("infinite_p"));
        floatc.defineFastMethod("finite?", callbackFactory.getFastMethod("finite_p"));
        return floatc;
    }

    public int getNativeTypeIndex() {
        return 11;
    }

    public RubyFloat(Ruby runtime) {
        this(runtime, 0.0);
    }

    public RubyFloat(Ruby runtime, double value) {
        super(runtime, runtime.getClass("Float"));
        this.value = value;
    }

    public Class getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return (long)this.value;
    }

    public RubyFloat convertToFloat() {
        return this;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby runtime, double value) {
        return new RubyFloat(runtime, value);
    }

    public static IRubyObject induced_from(IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum) {
            return number.callMethod(recv.getRuntime().getCurrentContext(), 20, "to_f");
        }
        if (number instanceof RubyFloat) {
            return number;
        }
        throw recv.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    public IRubyObject to_s() {
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(this.getRuntime(), this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(this.getRuntime(), "NaN");
        }
        String val = "" + this.value;
        if (val.indexOf(69) != -1) {
            String v2 = FORMAT.format(this.value);
            int ix = v2.length() - 1;
            while (v2.charAt(ix) == '0' && v2.charAt(ix - 1) != '.') {
                --ix;
            }
            val = ix > 15 || "0.0".equals(v2.substring(0, ix + 1)) ? val.replaceFirst("E(\\d)", "e+$1").replaceFirst("E-", "e-") : v2.substring(0, ix + 1);
        }
        return RubyString.newString(this.getRuntime(), val);
    }

    public IRubyObject coerce(IRubyObject other) {
        return this.getRuntime().newArray(RubyFloat.newFloat(this.getRuntime(), ((RubyNumeric)other).getDoubleValue()), this);
    }

    public IRubyObject uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    public IRubyObject plus(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value + ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("+", other);
    }

    public IRubyObject minus(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value - ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("-", other);
    }

    public IRubyObject mul(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value * ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("*", other);
    }

    public IRubyObject fdiv(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.value / ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("div", other);
    }

    public IRubyObject mod(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double x;
            double mod;
            double y = ((RubyNumeric)other).getDoubleValue();
            if (y * (mod = Math.IEEEremainder(x = this.value, y)) < 0.0) {
                mod += y;
            }
            return RubyFloat.newFloat(this.getRuntime(), mod);
        }
        return this.coerceBin("%", other);
    }

    public IRubyObject divmod(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double y = ((RubyNumeric)other).getDoubleValue();
            double x = this.value;
            double mod = Math.IEEEremainder(x, y);
            double div = (x - mod) / y;
            if (y * mod < 0.0) {
                mod += y;
                div -= 1.0;
            }
            Ruby runtime = this.getRuntime();
            IRubyObject car = RubyFloat.dbl2num(runtime, div);
            RubyFloat cdr = RubyFloat.newFloat(runtime, mod);
            return RubyArray.newArray(runtime, car, cdr);
        }
        return this.coerceBin("%", other);
    }

    public IRubyObject pow(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyNumeric)other).getDoubleValue()));
        }
        return this.coerceBin("/", other);
    }

    public IRubyObject equal(IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        if (other instanceof RubyNumeric) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyNumeric)other).getDoubleValue());
        }
        return super.equal(other);
    }

    public IRubyObject cmp(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyFloat.dbl_cmp(this.getRuntime(), this.value, b);
        }
        return this.coerceCmp("<=>", other);
    }

    public IRubyObject gt(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value > b);
        }
        return this.coerceRelOp(">", other);
    }

    public IRubyObject ge(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value >= b);
        }
        return this.coerceRelOp(">=", other);
    }

    public IRubyObject lt(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value < b);
        }
        return this.coerceRelOp("<", other);
    }

    public IRubyObject le(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double b = ((RubyNumeric)other).getDoubleValue();
            return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value <= b);
        }
        return this.coerceRelOp("<=", other);
    }

    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyFloat) {
            double b = ((RubyFloat)other).value;
            if (Double.isNaN(this.value) || Double.isNaN(b)) {
                return this.getRuntime().getFalse();
            }
            if (this.value == b) {
                return this.getRuntime().getTrue();
            }
        }
        return this.getRuntime().getFalse();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public IRubyObject to_f() {
        return this;
    }

    public IRubyObject abs() {
        if (this.value < 0.0) {
            return RubyFloat.newFloat(this.getRuntime(), Math.abs(this.value));
        }
        return this;
    }

    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0.0);
    }

    public IRubyObject truncate() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f);
        }
        if (f > 0.0) {
            f = Math.ceil(f);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    public IRubyObject floor() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.floor(this.value));
    }

    public IRubyObject ceil() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.ceil(this.value));
    }

    public IRubyObject round() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f + 0.5);
        }
        if (f < 0.0) {
            f = Math.ceil(f - 0.5);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Double.isNaN(this.value));
    }

    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.value < 0.0 ? -1L : 1L);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject finite_p() {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        String strValue = aFloat.toString();
        if (Double.isInfinite(aFloat.value)) {
            strValue = aFloat.value < 0.0 ? "-inf" : "inf";
        } else if (Double.isNaN(aFloat.value)) {
            strValue = "nan";
        }
        output.writeString(strValue);
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyFloat result = RubyFloat.newFloat(input.getRuntime(), Convert.byteListToDouble(input.unmarshalString(), false));
        input.registerLinkTarget(result);
        return result;
    }
}

