/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyBinding
extends RubyObject {
    private Block block;
    private static ObjectAllocator BINDING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyBinding instance = runtime.newBinding();
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyBinding(Ruby runtime, RubyClass rubyClass, Block block) {
        super(runtime, rubyClass);
        this.block = block;
    }

    public static RubyClass createBindingClass(Ruby runtime) {
        RubyClass bindingClass = runtime.defineClass("Binding", runtime.getObject(), BINDING_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyBinding.class);
        bindingClass.getMetaClass().defineMethod("of_caller", callbackFactory.getSingletonMethod("of_caller"));
        return bindingClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public static RubyBinding newBinding(Ruby runtime, Block block) {
        return new RubyBinding(runtime, runtime.getClass("Binding"), block);
    }

    public static RubyBinding newBinding(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        Frame frame = context.getCurrentFrame();
        Block bindingBlock = Block.createBinding(frame, context.getCurrentScope());
        return new RubyBinding(runtime, runtime.getClass("Binding"), bindingBlock);
    }

    public static RubyBinding newBindingForEval(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        Frame previousFrame = context.getPreviousFrame();
        Frame currentFrame = context.getCurrentFrame();
        currentFrame.setKlazz(previousFrame.getKlazz());
        currentFrame.setJumpTarget(previousFrame.getJumpTarget() != null ? previousFrame.getJumpTarget() : previousFrame);
        Block bindingBlock = Block.createBinding(previousFrame, context.getCurrentScope());
        return new RubyBinding(runtime, runtime.getClass("Binding"), bindingBlock);
    }

    public static RubyBinding newBindingOfCaller(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        Frame frame = context.getPreviousFrame();
        Block bindingBlock = Block.createBinding(frame, context.getPreviousScope());
        return new RubyBinding(runtime, runtime.getClass("Binding"), bindingBlock);
    }

    public static IRubyObject of_caller(IRubyObject recv, Block aBlock) {
        return RubyBinding.newBindingOfCaller(recv.getRuntime());
    }
}

