/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock
extends Block {
    private Arity arity;
    private CompiledBlockCallback callback;
    private ThreadContext context;
    private IRubyObject self;
    private IRubyObject[][] scopes;
    private Block block;

    public CompiledBlock(ThreadContext context, IRubyObject self, Arity arity, IRubyObject[][] scopes, Block block, CompiledBlockCallback callback) {
        super(null, null, self, context.getCurrentFrame(), context.peekCRef(), Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope());
        this.arity = arity;
        this.callback = callback;
        this.context = context;
        this.self = self;
        this.scopes = scopes;
        this.block = block;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.callback.call(context, this.self, args, this.block, this.scopes);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject args, IRubyObject self, RubyModule klass, boolean aValue) {
        IRubyObject[] realArgs = null;
        realArgs = !aValue ? new IRubyObject[]{args} : ArgsUtil.convertToJavaArray(args);
        return this.callback.call(context, this.self, realArgs, this.block, this.scopes);
    }

    public Block cloneBlock() {
        return new CompiledBlock(this.context, this.self, this.arity, this.scopes, this.block, this.callback);
    }

    public Arity arity() {
        return this.arity;
    }
}

