/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyBinding;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class FullFunctionCallbackMethod
extends DynamicMethod {
    private Callback callback;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FullFunctionCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility);
        this.callback = callback;
    }

    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preReflectedMethodInternalCall(this.implementationClass, clazz, self, name, args, this.getArity().required(), noSuper, block, this);
    }

    public void postMethod(ThreadContext context) {
        context.postReflectedMethodInternalCall();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject internalCall(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        boolean isTrace;
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError();
        }
        Ruby runtime = context.getRuntime();
        ISourcePosition position = null;
        RubyBinding binding = null;
        boolean bl = isTrace = runtime.getTraceFunction() != null;
        if (isTrace) {
            position = context.getPosition();
            binding = RubyBinding.newBinding(runtime);
            runtime.callTraceFunction(context, "c-call", position, binding, name, this.getImplementationClass());
        }
        try {
            IRubyObject iRubyObject;
            try {
                iRubyObject = this.callback.execute(self, args, block);
                Object var15_14 = null;
                if (!isTrace) return iRubyObject;
            }
            catch (JumpException je) {
                switch (je.getJumpType().getTypeId()) {
                    case 4: {
                        if (je.getTarget() != this) throw je;
                        IRubyObject iRubyObject2 = (IRubyObject)je.getValue();
                        Object var15_15 = null;
                        if (!isTrace) return iRubyObject2;
                        runtime.callTraceFunction(context, "c-return", position, binding, name, this.getImplementationClass());
                        return iRubyObject2;
                    }
                }
                throw je;
            }
            runtime.callTraceFunction(context, "c-return", position, binding, name, this.getImplementationClass());
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (!isTrace) throw throwable;
            runtime.callTraceFunction(context, "c-return", position, binding, name, this.getImplementationClass());
            throw throwable;
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Arity getArity() {
        return this.getCallback().getArity();
    }

    public DynamicMethod dup() {
        return new FullFunctionCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }

    static {
        $assertionsDisabled = !FullFunctionCallbackMethod.class.desiredAssertionStatus();
    }
}

