/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.collections.SinglyLinkedList;

public final class DefaultMethod
extends DynamicMethod {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private SinglyLinkedList cref;
    private int callCount = 0;
    private Script jitCompiledScript;
    private static final boolean JIT_ENABLED;
    private static final boolean JIT_LOGGING;
    private static final boolean JIT_LOGGING_VERBOSE;
    private static final int JIT_THRESHOLD;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, SinglyLinkedList cref) {
        super(implementationClass, visibility);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.cref = cref;
        if (!$assertionsDisabled && argsNode == null) {
            throw new AssertionError();
        }
    }

    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preDefMethodInternalCall(clazz, name, self, args, this.getArity().required(), block, noSuper, this.cref, this.staticScope, this);
    }

    public void postMethod(ThreadContext context) {
        context.postDefMethodInternalCall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        if (this.jitCompiledScript != null) {
            try {
                context.preCompiledMethod(this.implementationClass, this.cref);
                IRubyObject iRubyObject = this.jitCompiledScript.run(context, self, args, block);
                return iRubyObject;
            }
            finally {
                context.postCompiledMethod();
            }
        }
        return super.call(context, self, clazz, name, args, noSuper, block);
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        IRubyObject iRubyObject;
        block13: {
            if (!$assertionsDisabled && args == null) {
                throw new AssertionError();
            }
            Ruby runtime = context.getRuntime();
            if (JIT_ENABLED) {
                this.runJIT(runtime, name);
            }
            if (JIT_ENABLED && this.jitCompiledScript != null) {
                return this.jitCompiledScript.run(context, self, args, block);
            }
            if (this.argsNode.getBlockArgNode() != null && block.isGiven()) {
                RubyProc blockArg;
                if (block.getProcObject() != null) {
                    blockArg = block.getProcObject();
                } else {
                    blockArg = runtime.newProc(false, block);
                    blockArg.getBlock().isLambda = block.isLambda;
                }
                context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), blockArg, 0);
            }
            RubyBinding binding = null;
            try {
                this.prepareArguments(context, runtime, args);
                this.getArity().checkArity(runtime, args);
                if (runtime.getTraceFunction() != null) {
                    binding = RubyBinding.newBinding(runtime);
                    this.traceCall(context, runtime, binding, name);
                }
                iRubyObject = EvaluationState.eval(runtime, context, this.body, self, block);
                Object var13_12 = null;
                if (binding == null) break block13;
            }
            catch (JumpException je) {
                block14: {
                    try {
                        if (je.getJumpType() != JumpException.JumpType.ReturnJump || je.getTarget() != this) break block14;
                        IRubyObject iRubyObject2 = (IRubyObject)je.getValue();
                        Object var13_13 = null;
                        if (binding != null) {
                            this.traceReturn(context, runtime, binding, name);
                        }
                        return iRubyObject2;
                    }
                    catch (Throwable throwable) {
                        block15: {
                            Object var13_14 = null;
                            if (binding == null) break block15;
                            this.traceReturn(context, runtime, binding, name);
                        }
                        throw throwable;
                    }
                }
                throw je;
            }
            this.traceReturn(context, runtime, binding, name);
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJIT(Ruby runtime, String name) {
        if (this.callCount >= 0) {
            if (!this.getArity().isFixed() || this.argsNode.getBlockArgNode() != null || this.argsNode.getOptArgs() != null || this.argsNode.getRestArg() != -1 || this.implementationClass.getName() == null) {
                this.callCount = -1;
                return;
            }
            ++this.callCount;
            if (this.callCount >= JIT_THRESHOLD) {
                String className = null;
                if (JIT_LOGGING && (className = this.getImplementationClass().getBaseName()) == null) {
                    className = "<anon class>";
                }
                try {
                    String cleanName = CodegenUtils.cleanJavaIdentifier(name);
                    StandardASMCompiler compiler = new StandardASMCompiler(cleanName + this.hashCode(), this.body.getPosition().getFile());
                    compiler.startScript();
                    Object methodToken = compiler.beginMethod("__file__", this.getArity().getValue(), this.staticScope.getNumberOfVariables());
                    NodeCompilerFactory.getCompiler(this.body).compile(this.body, compiler);
                    compiler.endMethod(methodToken);
                    compiler.endScript();
                    Class sourceClass = compiler.loadClass(runtime);
                    this.jitCompiledScript = (Script)sourceClass.newInstance();
                    if (JIT_LOGGING) {
                        System.err.println("compiled: " + className + "." + name);
                    }
                }
                catch (Exception e) {
                    if (JIT_LOGGING_VERBOSE) {
                        System.err.println("could not compile: " + className + "." + name + " because of: \"" + e.getMessage() + '\"');
                    }
                }
                finally {
                    this.callCount = -1;
                }
            }
        }
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        boolean hasOptArgs;
        int expectedArgsCount = this.argsNode.getArgsCount();
        int restArg = this.argsNode.getRestArg();
        boolean bl = hasOptArgs = this.argsNode.getOptArgs() != null;
        if (expectedArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + expectedArgsCount + ")");
        }
        if (expectedArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, expectedArgsCount);
        }
        if (hasOptArgs || restArg != -1) {
            args = this.prepareOptOrRestArgs(context, runtime, args, expectedArgsCount, restArg, hasOptArgs);
        }
        context.setFrameArgs(args);
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args, int expectedArgsCount, int restArg, boolean hasOptArgs) {
        int i;
        int opt;
        if (restArg == -1 && hasOptArgs && (opt = expectedArgsCount + this.argsNode.getOptArgs().size()) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + opt + ")");
        }
        int count = expectedArgsCount;
        if (this.argsNode.getOptArgs() != null) {
            count += this.argsNode.getOptArgs().size();
        }
        ArrayList<IRubyObject> allArgs = new ArrayList<IRubyObject>();
        for (i = 0; i < count && i < args.length; ++i) {
            allArgs.add(args[i]);
        }
        if (hasOptArgs) {
            ListNode optArgs = this.argsNode.getOptArgs();
            int j = 0;
            for (int i2 = expectedArgsCount; i2 < args.length && j < optArgs.size(); ++i2, ++j) {
                AssignmentVisitor.assign(runtime, context, context.getFrameSelf(), optArgs.get(j), args[i2], Block.NULL_BLOCK, true);
                ++expectedArgsCount;
            }
            while (j < optArgs.size()) {
                allArgs.add(EvaluationState.eval(runtime, context, optArgs.get(j++), context.getFrameSelf(), Block.NULL_BLOCK));
            }
        }
        if (restArg != -1) {
            for (i = expectedArgsCount; i < args.length; ++i) {
                allArgs.add(args[i]);
            }
            if (restArg >= 0) {
                RubyArray array = runtime.newArray(args.length - expectedArgsCount);
                for (int i3 = expectedArgsCount; i3 < args.length; ++i3) {
                    array.append(args[i3]);
                }
                context.getCurrentScope().setValue(restArg, array, 0);
            }
        }
        args = allArgs.toArray(new IRubyObject[allArgs.size()]);
        return args;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, RubyBinding binding, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callTraceFunction(context, "return", position, binding, name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, RubyBinding binding, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = this.body != null ? this.body.getPosition() : context.getPosition();
        runtime.callTraceFunction(context, "call", position, binding, name, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.cref);
    }

    static {
        boolean bl = $assertionsDisabled = !DefaultMethod.class.desiredAssertionStatus();
        if (Ruby.isSecurityRestricted()) {
            JIT_ENABLED = false;
            JIT_LOGGING = false;
            JIT_LOGGING_VERBOSE = false;
            JIT_THRESHOLD = 50;
        } else {
            JIT_ENABLED = Boolean.getBoolean("jruby.jit.enabled");
            JIT_LOGGING = Boolean.getBoolean("jruby.jit.logging");
            JIT_LOGGING_VERBOSE = Boolean.getBoolean("jruby.jit.logging.verbose");
            JIT_THRESHOLD = Integer.parseInt(System.getProperty("jruby.jit.threshold", "50"));
        }
    }
}

