/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyBinding;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public abstract class CompiledMethod
extends DynamicMethod
implements Cloneable {
    private Arity arity;
    private SinglyLinkedList cref;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, SinglyLinkedList cref) {
        super(implementationClass, visibility);
        this.arity = arity;
        this.cref = cref;
    }

    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper) {
        context.preCompiledMethod(this.implementationClass, this.cref);
    }

    public void postMethod(ThreadContext context) {
        context.postCompiledMethod();
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private IRubyObject wrap(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject[] args, Block block) {
        try {
            return this.call(context, self, args, block);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (JumpException e) {
            throw e;
        }
        catch (ThreadKill e) {
            throw e;
        }
        catch (MainExitException e) {
            throw e;
        }
        catch (Exception e) {
            runtime.getJavaSupport().handleNativeException(e);
            return runtime.getNil();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        Ruby runtime = context.getRuntime();
        this.arity.checkArity(runtime, args);
        if (runtime.getTraceFunction() != null) {
            ISourcePosition position = context.getPosition();
            RubyBinding binding = RubyBinding.newBinding(runtime);
            runtime.callTraceFunction(context, "c-call", position, binding, name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.wrap(context, runtime, self, args, block);
                return iRubyObject;
            }
            finally {
                runtime.callTraceFunction(context, "c-return", position, binding, name, this.getImplementationClass());
            }
        }
        return this.wrap(context, runtime, self, args, block);
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public DynamicMethod dup() {
        try {
            CompiledMethod msm = (CompiledMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public Arity getArity() {
        return this.arity;
    }

    static {
        $assertionsDisabled = !CompiledMethod.class.desiredAssertionStatus();
    }
}

