/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class RubyBoolean
extends RubyObject {
    private final Ruby runtime;

    public RubyBoolean(Ruby runtime, boolean value) {
        super(runtime, value ? runtime.getClass("TrueClass") : runtime.getClass("FalseClass"), false);
        this.isTrue = value;
        this.runtime = runtime;
    }

    public int getNativeTypeIndex() {
        return this.isTrue ? 6 : 7;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public boolean isImmediate() {
        return true;
    }

    public Class getJavaClass() {
        return Boolean.TYPE;
    }

    public RubyFixnum id() {
        return this.getRuntime().newFixnum(this.isTrue ? 2L : 0L);
    }

    public static RubyClass createFalseClass(Ruby runtime) {
        RubyClass falseClass = runtime.defineClass("FalseClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        falseClass.index = 7;
        CallbackFactory fact = runtime.callbackFactory(RubyBoolean.class);
        falseClass.defineFastMethod("type", fact.getFastMethod("type"));
        falseClass.defineFastMethod("&", fact.getFastMethod("false_and", RubyKernel.IRUBY_OBJECT));
        falseClass.defineFastMethod("|", fact.getFastMethod("false_or", RubyKernel.IRUBY_OBJECT));
        falseClass.defineFastMethod("^", fact.getFastMethod("false_xor", RubyKernel.IRUBY_OBJECT));
        falseClass.defineFastMethod("id", fact.getFastMethod("false_id"));
        falseClass.defineFastMethod("to_s", fact.getFastMethod("false_to_s"));
        return falseClass;
    }

    public static RubyClass createTrueClass(Ruby runtime) {
        RubyClass trueClass = runtime.defineClass("TrueClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        trueClass.index = 6;
        CallbackFactory fact = runtime.callbackFactory(RubyBoolean.class);
        trueClass.defineFastMethod("type", fact.getFastMethod("type"));
        trueClass.defineFastMethod("&", fact.getFastMethod("true_and", RubyKernel.IRUBY_OBJECT));
        trueClass.defineFastMethod("|", fact.getFastMethod("true_or", RubyKernel.IRUBY_OBJECT));
        trueClass.defineFastMethod("^", fact.getFastMethod("true_xor", RubyKernel.IRUBY_OBJECT));
        trueClass.defineFastMethod("id", fact.getFastMethod("true_id"));
        trueClass.defineFastMethod("to_s", fact.getFastMethod("true_to_s"));
        return trueClass;
    }

    public static RubyBoolean newBoolean(Ruby runtime, boolean value) {
        return value ? runtime.getTrue() : runtime.getFalse();
    }

    public RubyClass type() {
        return this.getMetaClass();
    }

    public IRubyObject false_and(IRubyObject oth) {
        return this;
    }

    public IRubyObject false_or(IRubyObject oth) {
        return oth.isTrue() ? this.getRuntime().getTrue() : this;
    }

    public IRubyObject false_xor(IRubyObject oth) {
        return oth.isTrue() ? this.getRuntime().getTrue() : this;
    }

    public IRubyObject false_id() {
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject false_to_s() {
        return this.getRuntime().newString("false");
    }

    public IRubyObject true_and(IRubyObject oth) {
        return oth.isTrue() ? this : this.getRuntime().getFalse();
    }

    public IRubyObject true_or(IRubyObject oth) {
        return this;
    }

    public IRubyObject true_xor(IRubyObject oth) {
        return oth.isTrue() ? this.getRuntime().getFalse() : this;
    }

    public IRubyObject true_id() {
        return this.getRuntime().newFixnum(2L);
    }

    public IRubyObject true_to_s() {
        return this.getRuntime().newString("true");
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }
}

