/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.WeakHashMap;
import org.jruby.NativeException;
import org.jruby.Profile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyContinuation;
import org.jruby.RubyDir;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyPrecision;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySignal;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.TopSelfFactory;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.executable.Script;
import org.jruby.ast.executable.YARVCompiledRunner;
import org.jruby.common.RubyWarnings;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.yarv.StandardYARVCompiler;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.Generator;
import org.jruby.ext.Readline;
import org.jruby.ext.socket.RubySocket;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaSupport;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.libraries.BigDecimalLibrary;
import org.jruby.libraries.DigestLibrary;
import org.jruby.libraries.EnumeratorLibrary;
import org.jruby.libraries.IConvLibrary;
import org.jruby.libraries.JRubyLibrary;
import org.jruby.libraries.RbConfigLibrary;
import org.jruby.libraries.StringIOLibrary;
import org.jruby.libraries.StringScannerLibrary;
import org.jruby.libraries.ThreadLibrary;
import org.jruby.libraries.YamlLibrary;
import org.jruby.libraries.ZlibLibrary;
import org.jruby.parser.Parser;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.MethodSelectorTable;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.BuiltinScript;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.KCode;
import org.jruby.util.NormalizedFile;
import org.jruby.util.SwallowingOutputStream;
import org.jruby.util.collections.SinglyLinkedList;

public final class Ruby {
    private static String[] BUILTIN_LIBRARIES;
    private CacheMap cacheMap = new CacheMap(this);
    private ThreadService threadService = new ThreadService(this);
    private Hashtable runtimeInformation;
    private final MethodSelectorTable selectorTable = new MethodSelectorTable();
    private int stackTraces = 0;
    private ObjectSpace objectSpace = new ObjectSpace();
    private final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable();
    private Hashtable ioHandlers = new Hashtable();
    private long randomSeed = 0L;
    private long randomSeedSequence = 0L;
    private Random random = new Random();
    private RubyProc traceFunction;
    private boolean globalAbortOnExceptionEnabled = false;
    private boolean doNotReverseLookupEnabled = false;
    private final boolean objectSpaceEnabled;
    private long globalState = 1L;
    private int safeLevel = 0;
    private IRubyObject nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    private RubyClass objectClass;
    private RubyClass stringClass;
    private RubyModule enumerableModule;
    private RubyClass systemCallError = null;
    private RubyModule errnoModule = null;
    private IRubyObject topSelf;
    private String currentDirectory;
    private long startTime = System.currentTimeMillis();
    private RubyInstanceConfig config;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private IRubyObject verbose;
    private IRubyObject debug;
    private JavaSupport javaSupport;
    private static JRubyClassLoader jrubyClassLoader;
    private Parser parser = new Parser(this);
    private LoadService loadService;
    private GlobalVariables globalVariables = new GlobalVariables(this);
    private RubyWarnings warnings = new RubyWarnings(this);
    private Stack atExitBlocks = new Stack();
    private RubyModule kernelModule;
    private RubyClass nilClass;
    private RubyClass fixnumClass;
    private RubyClass arrayClass;
    private RubyClass hashClass;
    private IRubyObject tmsStruct;
    private Profile profile;
    private String jrubyHome;
    private KCode kcode = KCode.NONE;
    public int symbolLastId = 0;
    public int moduleLastId = 0;
    private Object respondToMethod;
    private Map finalizers;
    private ThreadLocal inspect = new ThreadLocal();
    static final /* synthetic */ boolean $assertionsDisabled;

    private Ruby(RubyInstanceConfig config) {
        this.config = config;
        this.in = config.getInput();
        this.out = config.getOutput();
        this.err = config.getError();
        this.objectSpaceEnabled = config.isObjectSpaceEnabled();
        this.profile = config.getProfile();
        this.currentDirectory = config.getCurrentDirectory();
    }

    public static Ruby getDefaultInstance() {
        return Ruby.newInstance(new RubyInstanceConfig());
    }

    public static Ruby newInstance(RubyInstanceConfig config) {
        Ruby ruby = new Ruby(config);
        ruby.init();
        return ruby;
    }

    public static Ruby newInstance(InputStream in, PrintStream out, PrintStream err) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setInput(in);
        config.setOutput(out);
        config.setError(err);
        return Ruby.newInstance(config);
    }

    public IRubyObject evalScript(String script) {
        return this.eval(this.parse(script, "<script>", this.getCurrentContext().getCurrentScope()));
    }

    public IRubyObject eval(Node node) {
        try {
            ThreadContext tc = this.getCurrentContext();
            return EvaluationState.eval(this, tc, node, tc.getFrameSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                throw this.newLocalJumpError("unexpected return");
            }
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                throw this.newLocalJumpError("unexpected break");
            }
            throw je;
        }
    }

    public IRubyObject compileAndRun(Node node) {
        try {
            StandardASMCompiler compiler = new StandardASMCompiler(node);
            NodeCompilerFactory.getCompiler(node).compile(node, compiler);
            Class scriptClass = compiler.loadClass(this);
            Script script = (Script)scriptClass.newInstance();
            return script.run(this.getCurrentContext(), this.getTopSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        catch (NotCompilableException nce) {
            System.err.println("Error -- Not compileable: " + nce.getMessage());
            return null;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                return (IRubyObject)je.getValue();
            }
            throw je;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IRubyObject ycompileAndRun(Node node) {
        try {
            StandardYARVCompiler compiler = new StandardYARVCompiler(this);
            NodeCompilerFactory.getYARVCompiler().compile(node, compiler);
            ISourcePosition p = node.getPosition();
            if (p == null && node instanceof RootNode) {
                p = ((RootNode)node).getBodyNode().getPosition();
            }
            return new YARVCompiledRunner(this, compiler.getInstructionSequence("<main>", p.getFile(), "toplevel")).run();
        }
        catch (NotCompilableException nce) {
            System.err.println("Error -- Not compileable: " + nce.getMessage());
            return null;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                return (IRubyObject)je.getValue();
            }
            throw je;
        }
    }

    Object getRespondToMethod() {
        return this.respondToMethod;
    }

    void setRespondToMethod(Object rtm) {
        this.respondToMethod = rtm;
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    public RubyModule getEnumerable() {
        return this.enumerableModule;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    public RubyClass getHash() {
        return this.hashClass;
    }

    public RubyClass getArray() {
        return this.arrayClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyModule getModule(String name) {
        return (RubyModule)this.objectClass.getConstantAt(name);
    }

    public RubyClass getClass(String name) {
        try {
            return this.objectClass.getClass(name);
        }
        catch (ClassCastException e) {
            throw this.newTypeError(name + " is not a Class");
        }
    }

    public RubyClass defineClass(String name, RubyClass superClass, ObjectAllocator allocator) {
        return this.defineClassUnder(name, superClass, allocator, this.objectClass.getCRef());
    }

    public RubyClass defineClassUnder(String name, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        if (superClass == null) {
            superClass = this.objectClass;
        }
        return superClass.newSubClass(name, allocator, parentCRef);
    }

    public RubyModule defineModule(String name) {
        return this.defineModuleUnder(name, this.objectClass.getCRef());
    }

    public RubyModule defineModuleUnder(String name, SinglyLinkedList parentCRef) {
        RubyModule newModule = RubyModule.newModule(this, name, parentCRef);
        ((RubyModule)parentCRef.getValue()).setConstant(name, newModule);
        return newModule;
    }

    public RubyModule getOrCreateModule(String name) {
        ThreadContext tc = this.getCurrentContext();
        RubyModule module = (RubyModule)tc.getRubyClass().getConstantAt(name);
        if (module == null) {
            module = this.defineModule(name);
        } else if (this.getSafeLevel() >= 4) {
            throw this.newSecurityError("Extending module prohibited.");
        }
        return module;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode) {
        this.kcode = kcode;
    }

    public void secure(int level) {
        if (level <= this.safeLevel) {
            throw this.newSecurityError("Insecure operation '" + this.getCurrentContext().getFrameName() + "' at level " + this.safeLevel);
        }
    }

    public void checkSafeString(IRubyObject object) {
        if (this.getSafeLevel() > 0 && object.isTaint()) {
            ThreadContext tc = this.getCurrentContext();
            if (tc.getFrameName() != null) {
                throw this.newSecurityError("Insecure operation - " + tc.getFrameName());
            }
            throw this.newSecurityError("Insecure operation: -r");
        }
        this.secure(4);
        if (!(object instanceof RubyString)) {
            throw this.newTypeError("wrong argument type " + object.getMetaClass().getName() + " (expected String)");
        }
    }

    public CacheMap getCacheMap() {
        return this.cacheMap;
    }

    public Map getRuntimeInformation() {
        return this.runtimeInformation == null ? (this.runtimeInformation = new Hashtable()) : this.runtimeInformation;
    }

    public MethodSelectorTable getSelectorTable() {
        return this.selectorTable;
    }

    public void defineGlobalConstant(String name, IRubyObject value) {
        this.objectClass.defineConstant(name, value);
    }

    public IRubyObject getTopConstant(String name) {
        IRubyObject constant = this.getModule(name);
        if (constant == null) {
            constant = this.getLoadService().autoload(name);
        }
        return constant;
    }

    public boolean isClassDefined(String name) {
        return this.getModule(name) != null;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    private void init() {
        ThreadContext tc = this.getCurrentContext();
        this.javaSupport = new JavaSupport(this);
        tc.preInitCoreClasses();
        this.initCoreClasses();
        this.verbose = this.falseObject;
        this.debug = this.falseObject;
        this.selectorTable.init();
        this.initLibraries();
        this.topSelf = TopSelfFactory.createTopSelf(this);
        tc.preInitBuiltinClasses(this.objectClass, this.topSelf);
        RubyGlobal.createGlobals(this);
        this.defineGlobalConstant("TRUE", this.trueObject);
        this.defineGlobalConstant("FALSE", this.falseObject);
        this.defineGlobalConstant("NIL", this.nilObject);
        this.getObject().defineConstant("TOPLEVEL_BINDING", this.newBinding());
        RubyKernel.autoload(this.topSelf, this.newSymbol("Java"), this.newString("java"));
    }

    private void initLibraries() {
        this.loadService = new LoadService(this);
        this.registerBuiltin("java.rb", new Library(){

            public void load(Ruby runtime) throws IOException {
                Java.createJavaModule(runtime);
                new BuiltinScript("javasupport").load(runtime);
            }
        });
        this.registerBuiltin("socket.rb", new RubySocket.Service());
        this.registerBuiltin("rbconfig.rb", new RbConfigLibrary());
        for (int i = 0; i < BUILTIN_LIBRARIES.length; ++i) {
            if (!this.profile.allowBuiltin(BUILTIN_LIBRARIES[i])) continue;
            this.loadService.registerRubyBuiltin(BUILTIN_LIBRARIES[i]);
        }
        this.registerBuiltin("jruby.rb", new JRubyLibrary());
        this.registerBuiltin("iconv.rb", new IConvLibrary());
        this.registerBuiltin("stringio.rb", new StringIOLibrary());
        this.registerBuiltin("strscan.rb", new StringScannerLibrary());
        this.registerBuiltin("zlib.rb", new ZlibLibrary());
        this.registerBuiltin("yaml_internal.rb", new YamlLibrary());
        this.registerBuiltin("enumerator.rb", new EnumeratorLibrary());
        this.registerBuiltin("generator_internal.rb", new Generator.Service());
        this.registerBuiltin("readline.rb", new Readline.Service());
        this.registerBuiltin("thread.so", new ThreadLibrary());
        this.registerBuiltin("openssl.so", new Library(){

            public void load(Ruby runtime) throws IOException {
                runtime.getModule("Kernel").callMethod(runtime.getCurrentContext(), "require", runtime.newString("rubygems"));
                runtime.getTopSelf().callMethod(runtime.getCurrentContext(), "gem", runtime.newString("jruby-openssl"));
                runtime.getModule("Kernel").callMethod(runtime.getCurrentContext(), "require", runtime.newString("jopenssl"));
            }
        });
        this.registerBuiltin("digest.so", new DigestLibrary());
        this.registerBuiltin("digest.rb", new DigestLibrary());
        this.registerBuiltin("digest/md5.rb", new DigestLibrary.MD5());
        this.registerBuiltin("digest/rmd160.rb", new DigestLibrary.RMD160());
        this.registerBuiltin("digest/sha1.rb", new DigestLibrary.SHA1());
        this.registerBuiltin("digest/sha2.rb", new DigestLibrary.SHA2());
        this.registerBuiltin("bigdecimal.rb", new BigDecimalLibrary());
    }

    private void registerBuiltin(String nm, Library lib) {
        if (this.profile.allowBuiltin(nm)) {
            this.loadService.registerBuiltin(nm, lib);
        }
    }

    private void initCoreClasses() {
        RubyClass objectMetaClass = RubyClass.createBootstrapMetaClass(this, "Object", null, RubyObject.OBJECT_ALLOCATOR, null);
        RubyObject.createObjectClass(this, objectMetaClass);
        this.objectClass = objectMetaClass;
        this.objectClass.setConstant("Object", this.objectClass);
        RubyClass moduleClass = RubyClass.createBootstrapMetaClass(this, "Module", this.objectClass, RubyModule.MODULE_ALLOCATOR, this.objectClass.getCRef());
        this.objectClass.setConstant("Module", moduleClass);
        RubyClass classClass = RubyClass.newClassClass(this, moduleClass);
        this.objectClass.setConstant("Class", classClass);
        classClass.setMetaClass(classClass);
        moduleClass.setMetaClass(classClass);
        this.objectClass.setMetaClass(classClass);
        RubyClass metaClass = this.objectClass.makeMetaClass(classClass, objectMetaClass.getCRef());
        metaClass = moduleClass.makeMetaClass(metaClass, objectMetaClass.getCRef());
        metaClass = classClass.makeMetaClass(metaClass, objectMetaClass.getCRef());
        RubyModule.createModuleClass(this, moduleClass);
        this.kernelModule = RubyKernel.createKernelModule(this);
        this.objectClass.includeModule(this.kernelModule);
        RubyClass.createClassClass(classClass);
        this.nilClass = RubyNil.createNilClass(this);
        RubyBoolean.createFalseClass(this);
        RubyBoolean.createTrueClass(this);
        this.nilObject = new RubyNil(this);
        this.trueObject = new RubyBoolean(this, true);
        this.falseObject = new RubyBoolean(this, false);
        RubyComparable.createComparable(this);
        this.enumerableModule = RubyEnumerable.createEnumerableModule(this);
        this.stringClass = RubyString.createStringClass(this);
        RubySymbol.createSymbolClass(this);
        if (this.profile.allowClass("ThreadGroup")) {
            RubyThreadGroup.createThreadGroupClass(this);
        }
        if (this.profile.allowClass("Thread")) {
            RubyThread.createThreadClass(this);
        }
        if (this.profile.allowClass("Exception")) {
            RubyException.createExceptionClass(this);
        }
        if (this.profile.allowModule("Precision")) {
            RubyPrecision.createPrecisionModule(this);
        }
        if (this.profile.allowClass("Numeric")) {
            RubyNumeric.createNumericClass(this);
        }
        if (this.profile.allowClass("Integer")) {
            RubyInteger.createIntegerClass(this);
        }
        if (this.profile.allowClass("Fixnum")) {
            this.fixnumClass = RubyFixnum.createFixnumClass(this);
        }
        if (this.profile.allowClass("Hash")) {
            this.hashClass = RubyHash.createHashClass(this);
        }
        RubyIO.createIOClass(this);
        if (this.profile.allowClass("Array")) {
            this.arrayClass = RubyArray.createArrayClass(this);
        }
        RubyClass structClass = null;
        if (this.profile.allowClass("Struct")) {
            structClass = RubyStruct.createStructClass(this);
        }
        if (this.profile.allowClass("Tms")) {
            this.tmsStruct = RubyStruct.newInstance(structClass, new IRubyObject[]{this.newString("Tms"), this.newSymbol("utime"), this.newSymbol("stime"), this.newSymbol("cutime"), this.newSymbol("cstime")}, Block.NULL_BLOCK);
        }
        if (this.profile.allowClass("Float")) {
            RubyFloat.createFloatClass(this);
        }
        if (this.profile.allowClass("Bignum")) {
            RubyBignum.createBignumClass(this);
        }
        if (this.profile.allowClass("Binding")) {
            RubyBinding.createBindingClass(this);
        }
        if (this.profile.allowModule("Math")) {
            RubyMath.createMathModule(this);
        }
        if (this.profile.allowClass("Regexp")) {
            RubyRegexp.createRegexpClass(this);
        }
        if (this.profile.allowClass("Range")) {
            RubyRange.createRangeClass(this);
        }
        if (this.profile.allowModule("ObjectSpace")) {
            RubyObjectSpace.createObjectSpaceModule(this);
        }
        if (this.profile.allowModule("GC")) {
            RubyGC.createGCModule(this);
        }
        if (this.profile.allowClass("Proc")) {
            RubyProc.createProcClass(this);
        }
        if (this.profile.allowClass("Method")) {
            RubyMethod.createMethodClass(this);
        }
        if (this.profile.allowClass("MatchData")) {
            RubyMatchData.createMatchDataClass(this);
        }
        if (this.profile.allowModule("Marshal")) {
            RubyMarshal.createMarshalModule(this);
        }
        if (this.profile.allowClass("Dir")) {
            RubyDir.createDirClass(this);
        }
        if (this.profile.allowModule("FileTest")) {
            RubyFileTest.createFileTestModule(this);
        }
        if (this.profile.allowClass("File")) {
            RubyFile.createFileClass(this);
        }
        if (this.profile.allowModule("Process")) {
            RubyProcess.createProcessModule(this);
        }
        if (this.profile.allowClass("Time")) {
            RubyTime.createTimeClass(this);
        }
        if (this.profile.allowClass("UnboundMethod")) {
            RubyUnboundMethod.defineUnboundMethodClass(this);
        }
        RubyClass exceptionClass = this.getClass("Exception");
        RubyClass standardError = null;
        RubyClass runtimeError = null;
        RubyClass ioError = null;
        RubyClass scriptError = null;
        RubyClass nameError = null;
        RubyClass rangeError = null;
        if (this.profile.allowClass("StandardError")) {
            standardError = this.defineClass("StandardError", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("RuntimeError")) {
            runtimeError = this.defineClass("RuntimeError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("IOError")) {
            ioError = this.defineClass("IOError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("ScriptError")) {
            scriptError = this.defineClass("ScriptError", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("NameError")) {
            nameError = RubyNameError.createNameErrorClass(this, standardError);
        }
        if (this.profile.allowClass("RangeError")) {
            rangeError = this.defineClass("RangeError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("SystemExit")) {
            this.defineClass("SystemExit", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("Fatal")) {
            this.defineClass("Fatal", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("Interrupt")) {
            this.defineClass("Interrupt", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("SignalException")) {
            this.defineClass("SignalException", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("TypeError")) {
            this.defineClass("TypeError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("ArgumentError")) {
            this.defineClass("ArgumentError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("IndexError")) {
            this.defineClass("IndexError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("SyntaxError")) {
            this.defineClass("SyntaxError", scriptError, scriptError.getAllocator());
        }
        if (this.profile.allowClass("LoadError")) {
            this.defineClass("LoadError", scriptError, scriptError.getAllocator());
        }
        if (this.profile.allowClass("NotImplementedError")) {
            this.defineClass("NotImplementedError", scriptError, scriptError.getAllocator());
        }
        if (this.profile.allowClass("NoMethodError")) {
            this.defineClass("NoMethodError", nameError, nameError.getAllocator());
        }
        if (this.profile.allowClass("SecurityError")) {
            this.defineClass("SecurityError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("NoMemoryError")) {
            this.defineClass("NoMemoryError", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("RegexpError")) {
            this.defineClass("RegexpError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("EOFError")) {
            this.defineClass("EOFError", ioError, ioError.getAllocator());
        }
        if (this.profile.allowClass("LocalJumpError")) {
            this.defineClass("LocalJumpError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("ThreadError")) {
            this.defineClass("ThreadError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("SystemStackError")) {
            this.defineClass("SystemStackError", exceptionClass, exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("ZeroDivisionError")) {
            this.defineClass("ZeroDivisionError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowClass("FloatDomainError")) {
            this.defineClass("FloatDomainError", rangeError, rangeError.getAllocator());
        }
        if (this.profile.allowClass("NativeException")) {
            NativeException.createClass(this, runtimeError);
        }
        if (this.profile.allowClass("SystemCallError")) {
            this.systemCallError = this.defineClass("SystemCallError", standardError, standardError.getAllocator());
        }
        if (this.profile.allowModule("Errno")) {
            this.errnoModule = this.defineModule("Errno");
        }
        this.initErrnoErrors();
        if (this.profile.allowClass("Data")) {
            this.defineClass("Data", this.objectClass, this.objectClass.getAllocator());
        }
        if (this.profile.allowModule("Signal")) {
            RubySignal.createSignal(this);
        }
        if (this.profile.allowClass("Continuation")) {
            RubyContinuation.createContinuation(this);
        }
    }

    private void initErrnoErrors() {
        this.createSysErr(1, "ENOTEMPTY");
        this.createSysErr(2, "ERANGE");
        this.createSysErr(3, "ESPIPE");
        this.createSysErr(4, "ENFILE");
        this.createSysErr(5, "EXDEV");
        this.createSysErr(6, "ENOMEM");
        this.createSysErr(7, "E2BIG");
        this.createSysErr(8, "ENOENT");
        this.createSysErr(9, "ENOSYS");
        this.createSysErr(10, "EDOM");
        this.createSysErr(11, "ENOSPC");
        this.createSysErr(42, "EINVAL");
        this.createSysErr(43, "EEXIST");
        this.createSysErr(44, "EAGAIN");
        this.createSysErr(45, "ENXIO");
        this.createSysErr(46, "EILSEQ");
        this.createSysErr(47, "ENOLCK");
        this.createSysErr(48, "EPIPE");
        this.createSysErr(49, "EFBIG");
        this.createSysErr(50, "EISDIR");
        this.createSysErr(51, "EBUSY");
        this.createSysErr(52, "ECHILD");
        this.createSysErr(53, "EIO");
        this.createSysErr(54, "EPERM");
        this.createSysErr(55, "EDEADLOCK");
        this.createSysErr(56, "ENAMETOOLONG");
        this.createSysErr(57, "EMLINK");
        this.createSysErr(58, "ENOTTY");
        this.createSysErr(59, "ENOTDIR");
        this.createSysErr(60, "EFAULT");
        this.createSysErr(61, "EBADF");
        this.createSysErr(62, "EINTR");
        this.createSysErr(63, "EWOULDBLOCK");
        this.createSysErr(64, "EDEADLK");
        this.createSysErr(65, "EROFS");
        this.createSysErr(66, "EMFILE");
        this.createSysErr(67, "ENODEV");
        this.createSysErr(68, "EACCES");
        this.createSysErr(69, "ENOEXEC");
        this.createSysErr(70, "ESRCH");
        this.createSysErr(71, "ECONNREFUSED");
        this.createSysErr(72, "ECONNRESET");
        this.createSysErr(73, "EADDRINUSE");
    }

    private void createSysErr(int i, String name) {
        if (this.profile.allowClass(name)) {
            this.errnoModule.defineClassUnder(name, this.systemCallError, this.systemCallError.getAllocator()).defineConstant("Errno", this.newFixnum(i));
        }
    }

    public IRubyObject getVerbose() {
        return this.verbose;
    }

    public void setVerbose(IRubyObject verbose) {
        this.verbose = verbose;
    }

    public IRubyObject getDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject debug) {
        this.debug = debug;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public JRubyClassLoader getJRubyClassLoader() {
        if (!Ruby.isSecurityRestricted() && jrubyClassLoader == null) {
            jrubyClassLoader = new JRubyClassLoader(Thread.currentThread().getContextClassLoader());
        }
        return jrubyClassLoader;
    }

    public void defineVariable(final GlobalVariable variable) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            public IRubyObject getValue() {
                return variable.get();
            }

            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        });
    }

    public void defineReadonlyVariable(String name, IRubyObject value) {
        this.globalVariables.defineReadonly(name, new ValueAccessor(value));
    }

    public Node parse(Reader content, String file, DynamicScope scope) {
        return this.parser.parse(file, content, scope);
    }

    public Node parse(String content, String file, DynamicScope scope) {
        return this.parser.parse(file, content, scope);
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return this.threadService.getCurrentContext();
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    public PrintStream getErrorStream() {
        OutputStream os = ((RubyIO)this.getGlobalVariables().get("$stderr")).getOutStream();
        if (null != os) {
            return new PrintStream(os);
        }
        return new PrintStream(new SwallowingOutputStream());
    }

    public InputStream getInputStream() {
        return ((RubyIO)this.getGlobalVariables().get("$stdin")).getInStream();
    }

    public PrintStream getOutputStream() {
        return new PrintStream(((RubyIO)this.getGlobalVariables().get("$stdout")).getOutStream());
    }

    public RubyModule getClassFromPath(String path) {
        if (path.length() == 0 || path.charAt(0) == '#') {
            throw this.newTypeError("can't retrieve anonymous class " + path);
        }
        IRubyObject type = this.evalScript(path);
        if (!(type instanceof RubyModule)) {
            throw this.newTypeError("class path " + path + " does not point class");
        }
        return (RubyModule)type;
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        ThreadContext tc = this.getCurrentContext();
        IRubyObject backtrace = excp.callMethod(tc, "backtrace");
        PrintStream errorStream = this.getErrorStream();
        if (backtrace.isNil() || !(backtrace instanceof RubyArray)) {
            if (tc.getSourceFile() != null) {
                errorStream.print(tc.getPosition());
            } else {
                errorStream.print(tc.getSourceLine());
            }
        } else if (((RubyArray)backtrace).getLength() == 0) {
            this.printErrorPos(errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace).first(IRubyObject.NULL_ARRAY);
            if (mesg.isNil()) {
                this.printErrorPos(errorStream);
            } else {
                errorStream.print(mesg);
            }
        }
        RubyClass type = excp.getMetaClass();
        String info = excp.toString();
        if (type == this.getClass("RuntimeError") && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            String path = type.getName();
            if (info.length() == 0) {
                errorStream.print(": " + path + '\n');
            } else {
                if (path.startsWith("#")) {
                    path = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                errorStream.print(": " + info);
                if (path != null) {
                    errorStream.print(" (" + path + ")\n");
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        excp.printBacktrace(errorStream);
    }

    private void printErrorPos(PrintStream errorStream) {
        ThreadContext tc = this.getCurrentContext();
        if (tc.getSourceFile() != null) {
            if (tc.getFrameName() != null) {
                errorStream.print(tc.getPosition());
                errorStream.print(":in '" + tc.getFrameName() + '\'');
            } else if (tc.getSourceLine() != 0) {
                errorStream.print(tc.getPosition());
            } else {
                errorStream.print(tc.getSourceFile());
            }
        }
    }

    public void loadScript(RubyString scriptName, RubyString source) {
        this.loadScript(scriptName.toString(), new StringReader(source.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(String scriptName, Reader source) {
        block7: {
            File f;
            if (!Ruby.isSecurityRestricted() && (f = new File(scriptName)).exists() && !f.isAbsolute() && !scriptName.startsWith("./")) {
                scriptName = "./" + scriptName;
            }
            IRubyObject self = this.getTopSelf();
            ThreadContext context = this.getCurrentContext();
            try {
                this.secure(4);
                context.preNodeEval(this.objectClass, self);
                Node node = this.parse(source, scriptName, null);
                EvaluationState.eval(this, context, node, self, Block.NULL_BLOCK);
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                    break block7;
                }
                throw je;
            }
            finally {
                context.postNodeEval();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNode(String scriptName, Node node) {
        block6: {
            IRubyObject self = this.getTopSelf();
            ThreadContext context = this.getCurrentContext();
            try {
                this.secure(4);
                context.preNodeEval(this.objectClass, self);
                EvaluationState.eval(this, context, node, self, Block.NULL_BLOCK);
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                    break block6;
                }
                throw je;
            }
            finally {
                context.postNodeEval();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFile(File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"No such file to load");
        }
        BufferedReader source = null;
        try {
            try {
                source = new BufferedReader(new FileReader(file));
                this.loadScript(file.getPath().replace(File.separatorChar, '/'), source);
            }
            catch (IOException ioExcptn) {
                throw this.newIOErrorFromException(ioExcptn);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (source != null) throw throwable;
                source.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (source != null) return;
        source.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callTraceFunction(ThreadContext context, String event, ISourcePosition position, RubyBinding binding, String name, IRubyObject type) {
        if (this.traceFunction == null) {
            return;
        }
        if (!context.isWithinTrace()) {
            context.setWithinTrace(true);
            ISourcePosition savePosition = context.getPosition();
            String file = position.getFile();
            if (file == null) {
                file = "(ruby)";
            }
            if (type == null) {
                type = this.getFalse();
            }
            context.preTrace();
            try {
                this.traceFunction.call(new IRubyObject[]{this.newString(event), this.newString(file), this.newFixnum(position.getStartLine() + 1), name != null ? RubySymbol.newSymbol(this, name) : this.getNil(), binding != null ? binding : this.getNil(), type});
                Object var10_9 = null;
                context.postTrace();
                context.setPosition(savePosition);
                context.setWithinTrace(false);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                context.postTrace();
                context.setPosition(savePosition);
                context.setWithinTrace(false);
                throw throwable;
            }
        }
    }

    public RubyProc getTraceFunction() {
        return this.traceFunction;
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.traceFunction = traceFunction;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public CallbackFactory callbackFactory(Class type) {
        return CallbackFactory.createFactory(this, type);
    }

    public IRubyObject pushExitBlock(RubyProc proc) {
        this.atExitBlocks.push(proc);
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalizer(RubyObject.Finalizer finalizer) {
        Object object = this;
        synchronized (object) {
            if (this.finalizers == null) {
                this.finalizers = new WeakHashMap();
            }
        }
        object = this.finalizers;
        synchronized (object) {
            this.finalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinalizer(RubyObject.Finalizer finalizer) {
        if (this.finalizers != null) {
            Map map = this.finalizers;
            synchronized (map) {
                this.finalizers.remove(finalizer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        while (!this.atExitBlocks.empty()) {
            RubyProc proc = (RubyProc)this.atExitBlocks.pop();
            proc.call(IRubyObject.NULL_ARRAY);
        }
        if (this.finalizers != null) {
            Map map = this.finalizers;
            synchronized (map) {
                Iterator finalIter = this.finalizers.keySet().iterator();
                while (finalIter.hasNext()) {
                    ((RubyObject.Finalizer)finalIter.next()).finalize();
                    finalIter.remove();
                }
            }
        }
    }

    public RubyArray newArray() {
        return RubyArray.newArray(this);
    }

    public RubyArray newArrayLight() {
        return RubyArray.newArrayLight(this);
    }

    public RubyArray newArray(IRubyObject object) {
        return RubyArray.newArray(this, object);
    }

    public RubyArray newArray(IRubyObject car, IRubyObject cdr) {
        return RubyArray.newArray(this, car, cdr);
    }

    public RubyArray newArray(IRubyObject[] objects) {
        return RubyArray.newArray(this, objects);
    }

    public RubyArray newArrayNoCopy(IRubyObject[] objects) {
        return RubyArray.newArrayNoCopy(this, objects);
    }

    public RubyArray newArrayNoCopyLight(IRubyObject[] objects) {
        return RubyArray.newArrayNoCopyLight(this, objects);
    }

    public RubyArray newArray(List list) {
        return RubyArray.newArray(this, list);
    }

    public RubyArray newArray(int size) {
        return RubyArray.newArray(this, size);
    }

    public RubyBoolean newBoolean(boolean value) {
        return RubyBoolean.newBoolean(this, value);
    }

    public RubyFileStat newRubyFileStat(String file) {
        return (RubyFileStat)this.getClass("File").getClass("Stat").callMethod(this.getCurrentContext(), "new", this.newString(file));
    }

    public RubyFixnum newFixnum(long value) {
        return RubyFixnum.newFixnum(this, value);
    }

    public RubyFloat newFloat(double value) {
        return RubyFloat.newFloat(this, value);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyProc newProc(boolean isLambda, Block block) {
        if (!isLambda && block.getProcObject() != null) {
            return block.getProcObject();
        }
        RubyProc proc = RubyProc.newProc(this, isLambda);
        proc.callInit(IRubyObject.NULL_ARRAY, block);
        return proc;
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this);
    }

    public RubyBinding newBinding(Block block) {
        return RubyBinding.newBinding(this, block);
    }

    public RubyString newString() {
        return RubyString.newString(this, "");
    }

    public RubyString newString(String string) {
        return RubyString.newString(this, string);
    }

    public RubyString newString(ByteList byteList) {
        return RubyString.newString(this, byteList);
    }

    public RubyString newStringShared(ByteList byteList) {
        return RubyString.newStringShared(this, byteList);
    }

    public RubySymbol newSymbol(String string) {
        return RubySymbol.newSymbol(this, string);
    }

    public RubyTime newTime(long milliseconds) {
        return RubyTime.newTime(this, milliseconds);
    }

    public RaiseException newRuntimeError(String message) {
        return this.newRaiseException(this.getClass("RuntimeError"), message);
    }

    public RaiseException newArgumentError(String message) {
        return this.newRaiseException(this.getClass("ArgumentError"), message);
    }

    public RaiseException newArgumentError(int got, int expected) {
        return this.newRaiseException(this.getClass("ArgumentError"), "wrong # of arguments(" + got + " for " + expected + ")");
    }

    public RaiseException newErrnoEBADFError() {
        return this.newRaiseException(this.getModule("Errno").getClass("EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoECONNREFUSEDError() {
        return this.newRaiseException(this.getModule("Errno").getClass("ECONNREFUSED"), "Connection refused");
    }

    public RaiseException newErrnoEADDRINUSEError() {
        return this.newRaiseException(this.getModule("Errno").getClass("EADDRINUSE"), "Address in use");
    }

    public RaiseException newErrnoEINVALError() {
        return this.newRaiseException(this.getModule("Errno").getClass("EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoENOENTError() {
        return this.newRaiseException(this.getModule("Errno").getClass("ENOENT"), "File not found");
    }

    public RaiseException newErrnoESPIPEError() {
        return this.newRaiseException(this.getModule("Errno").getClass("ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("EBADF"), message);
    }

    public RaiseException newErrnoEINVALError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("EINVAL"), message);
    }

    public RaiseException newErrnoENOENTError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("ENOENT"), message);
    }

    public RaiseException newErrnoESPIPEError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("ESPIPE"), message);
    }

    public RaiseException newErrnoEEXISTError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("EEXIST"), message);
    }

    public RaiseException newErrnoEDOMError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("EDOM"), "Domain error - " + message);
    }

    public RaiseException newIndexError(String message) {
        return this.newRaiseException(this.getClass("IndexError"), message);
    }

    public RaiseException newSecurityError(String message) {
        return this.newRaiseException(this.getClass("SecurityError"), message);
    }

    public RaiseException newSystemCallError(String message) {
        return this.newRaiseException(this.getClass("SystemCallError"), message);
    }

    public RaiseException newTypeError(String message) {
        return this.newRaiseException(this.getClass("TypeError"), message);
    }

    public RaiseException newThreadError(String message) {
        return this.newRaiseException(this.getClass("ThreadError"), message);
    }

    public RaiseException newSyntaxError(String message) {
        return this.newRaiseException(this.getClass("SyntaxError"), message);
    }

    public RaiseException newRegexpError(String message) {
        return this.newRaiseException(this.getClass("RegexpError"), message);
    }

    public RaiseException newRangeError(String message) {
        return this.newRaiseException(this.getClass("RangeError"), message);
    }

    public RaiseException newNotImplementedError(String message) {
        return this.newRaiseException(this.getClass("NotImplementedError"), message);
    }

    public RaiseException newInvalidEncoding(String message) {
        return this.newRaiseException(this.getClass("Iconv").getClass("InvalidEncoding"), message);
    }

    public RaiseException newNoMethodError(String message, String name) {
        return new RaiseException(new RubyNameError(this, this.getClass("NoMethodError"), message, name), true);
    }

    public RaiseException newNameError(String message, String name) {
        return new RaiseException(new RubyNameError(this, this.getClass("NameError"), message, name), true);
    }

    public RaiseException newLocalJumpError(String message) {
        return this.newRaiseException(this.getClass("LocalJumpError"), message);
    }

    public RaiseException newLoadError(String message) {
        return this.newRaiseException(this.getClass("LoadError"), message);
    }

    public RaiseException newFrozenError(String objectType) {
        return this.newRaiseException(this.getClass("TypeError"), "can't modify frozen " + objectType);
    }

    public RaiseException newSystemStackError(String message) {
        return this.newRaiseException(this.getClass("SystemStackError"), message);
    }

    public RaiseException newSystemExit(int status) {
        RaiseException re = this.newRaiseException(this.getClass("SystemExit"), "");
        re.getException().setInstanceVariable("status", this.newFixnum(status));
        return re;
    }

    public RaiseException newIOError(String message) {
        return this.newRaiseException(this.getClass("IOError"), message);
    }

    public RaiseException newStandardError(String message) {
        return this.newRaiseException(this.getClass("StandardError"), message);
    }

    public RaiseException newIOErrorFromException(IOException ioe) {
        return this.newRaiseException(this.getClass("IOError"), ioe.getMessage());
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyClass expectedType) {
        return this.newRaiseException(this.getClass("TypeError"), "wrong argument type " + receivedObject.getMetaClass() + " (expected " + expectedType);
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.getClass("EOFError"), "End of file reached");
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.getClass("ZeroDivisionError"), "divided by 0");
    }

    public RaiseException newFloatDomainError(String message) {
        return this.newRaiseException(this.getClass("FloatDomainError"), message);
    }

    private RaiseException newRaiseException(RubyClass exceptionClass, String message) {
        RaiseException re = new RaiseException(this, exceptionClass, message, true);
        return re;
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void setStackTraces(int stackTraces) {
        this.stackTraces = stackTraces;
    }

    public int getStackTraces() {
        return this.stackTraces;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public Random getRandom() {
        return this.random;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public Hashtable getIoHandlers() {
        return this.ioHandlers;
    }

    public RubyFixnum[] getFixnumCache() {
        return this.fixnumCache;
    }

    public long incrementRandomSeedSequence() {
        return this.randomSeedSequence++;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.globalAbortOnExceptionEnabled;
    }

    public void setGlobalAbortOnExceptionEnabled(boolean enable) {
        this.globalAbortOnExceptionEnabled = enable;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean b) {
        this.doNotReverseLookupEnabled = b;
    }

    public boolean registerInspecting(Object obj) {
        IdentityHashMap<Object, Object> val = (IdentityHashMap<Object, Object>)this.inspect.get();
        if (null == val) {
            val = new IdentityHashMap<Object, Object>();
            this.inspect.set(val);
        }
        if (val.containsKey(obj)) {
            return false;
        }
        val.put(obj, null);
        return true;
    }

    public void unregisterInspecting(Object obj) {
        Map val = (Map)this.inspect.get();
        val.remove(obj);
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            this.jrubyHome = this.verifyHome(System.getProperty("jruby.home", System.getProperty("user.home") + "/.jruby"));
        }
        return this.jrubyHome;
    }

    public void setJRubyHome(String home) {
        this.jrubyHome = this.verifyHome(home);
    }

    private String verifyHome(String home) {
        NormalizedFile f = new NormalizedFile(home);
        if (!f.isAbsolute()) {
            home = f.getAbsolutePath();
        }
        f.mkdirs();
        return home;
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            return this.globalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            this.globalState = this.globalState + 1L & 0xFFFFFFFF8FFFFFFFL;
        }
    }

    public static boolean isSecurityRestricted() {
        return System.getSecurityManager() != null;
    }

    static {
        $assertionsDisabled = !Ruby.class.desiredAssertionStatus();
        BUILTIN_LIBRARIES = new String[]{"fcntl", "yaml", "nkf", "yaml/syck"};
    }
}

