/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class MarshalCache {
    private Map linkCache = new HashMap();
    private Map symbolCache = new HashMap();

    public boolean isRegistered(IRubyObject value) {
        return this.selectCache(value).containsKey(value);
    }

    public void register(IRubyObject value) {
        Map cache = this.selectCache(value);
        cache.put(value, new Integer(cache.size()));
    }

    private int registeredIndex(IRubyObject value) {
        return (Integer)this.selectCache(value).get(value);
    }

    private Map selectCache(IRubyObject value) {
        return value instanceof RubySymbol ? this.symbolCache : this.linkCache;
    }

    public void writeLink(MarshalStream output, IRubyObject value) throws IOException {
        output.write(MarshalCache.linkType(value));
        output.writeInt(this.registeredIndex(value));
    }

    private static char linkType(IRubyObject value) {
        return value instanceof RubySymbol ? (char)';' : '@';
    }
}

