/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class StringMetaClass
extends ObjectMetaClass {
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyString newString = runtime.newString("");
            newString.setMetaClass(klass);
            return newString;
        }
    };

    public StringMetaClass(Ruby runtime) {
        super("String", RubyString.class, runtime.getObject(), STRING_ALLOCATOR);
        this.index = 4;
    }

    private StringMetaClass(String name, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        super(name, RubyString.class, superClass, allocator, parentCRef);
        this.index = 4;
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new StringMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new StringMetaClass(name, (RubyClass)this, STRING_ALLOCATOR, parentCRef);
    }

    protected class StringMeta
    extends AbstractMetaClass.Meta {
        protected StringMeta() {
        }

        protected void initializeClass() {
            StringMetaClass.this.includeModule(StringMetaClass.this.getRuntime().getModule("Comparable"));
            StringMetaClass.this.includeModule(StringMetaClass.this.getRuntime().getModule("Enumerable"));
            StringMetaClass.this.defineFastMethod("<=>", Arity.singleArgument(), "op_cmp");
            StringMetaClass.this.defineFastMethod("==", Arity.singleArgument(), "eql");
            StringMetaClass.this.defineFastMethod("+", Arity.singleArgument(), "op_plus");
            StringMetaClass.this.defineFastMethod("*", Arity.singleArgument(), "op_mul");
            StringMetaClass.this.defineFastMethod("%", Arity.singleArgument(), "format");
            StringMetaClass.this.defineFastMethod("hash", Arity.noArguments(), "hash");
            StringMetaClass.this.defineFastMethod("to_s", Arity.noArguments(), "to_s");
            StringMetaClass.this.defineFastMethod(">=", Arity.singleArgument(), "op_ge");
            StringMetaClass.this.defineFastMethod(">", Arity.singleArgument(), "op_gt");
            StringMetaClass.this.defineFastMethod("<=", Arity.singleArgument(), "op_le");
            StringMetaClass.this.defineFastMethod("<", Arity.singleArgument(), "op_lt");
            StringMetaClass.this.defineFastMethod("eql?", Arity.singleArgument(), "op_eql");
            StringMetaClass.this.defineFastMethod("[]", Arity.optional(), "aref");
            StringMetaClass.this.defineFastMethod("[]=", Arity.optional(), "aset");
            StringMetaClass.this.defineFastMethod("=~", Arity.singleArgument(), "match");
            StringMetaClass.this.defineFastMethod("~", Arity.noArguments(), "match2");
            StringMetaClass.this.defineFastMethod("capitalize", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("capitalize!", Arity.noArguments(), "capitalize_bang");
            StringMetaClass.this.defineFastMethod("casecmp", Arity.singleArgument());
            StringMetaClass.this.defineFastMethod("center", Arity.optional());
            StringMetaClass.this.defineFastMethod("chop", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("chop!", Arity.noArguments(), "chop_bang");
            StringMetaClass.this.defineFastMethod("chomp", Arity.optional());
            StringMetaClass.this.defineFastMethod("chomp!", Arity.optional(), "chomp_bang");
            StringMetaClass.this.defineFastMethod("concat", Arity.singleArgument());
            StringMetaClass.this.defineFastMethod("count", Arity.optional());
            StringMetaClass.this.defineFastMethod("crypt", Arity.singleArgument());
            StringMetaClass.this.defineFastMethod("delete", Arity.optional());
            StringMetaClass.this.defineFastMethod("delete!", Arity.optional(), "delete_bang");
            StringMetaClass.this.defineFastMethod("downcase", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("downcase!", Arity.noArguments(), "downcase_bang");
            StringMetaClass.this.defineFastMethod("dump", Arity.noArguments());
            StringMetaClass.this.defineMethod("each_line", Arity.optional());
            StringMetaClass.this.defineMethod("each_byte", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("empty?", Arity.noArguments(), "empty");
            StringMetaClass.this.defineMethod("gsub", Arity.optional());
            StringMetaClass.this.defineMethod("gsub!", Arity.optional(), "gsub_bang");
            StringMetaClass.this.defineFastMethod("hex", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("include?", Arity.singleArgument(), "include");
            StringMetaClass.this.defineFastMethod("index", Arity.optional());
            StringMetaClass.this.defineMethod("initialize", Arity.optional(), "initialize");
            StringMetaClass.this.defineFastMethod("initialize_copy", Arity.singleArgument(), "replace");
            StringMetaClass.this.defineFastMethod("insert", Arity.twoArguments());
            StringMetaClass.this.defineFastMethod("inspect", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("length", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("ljust", Arity.optional());
            StringMetaClass.this.defineFastMethod("lstrip", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("lstrip!", Arity.noArguments(), "lstrip_bang");
            StringMetaClass.this.defineFastMethod("match", Arity.singleArgument(), "match3");
            StringMetaClass.this.defineFastMethod("oct", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("replace", Arity.singleArgument());
            StringMetaClass.this.defineFastMethod("reverse", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("reverse!", Arity.noArguments(), "reverse_bang");
            StringMetaClass.this.defineFastMethod("rindex", Arity.optional());
            StringMetaClass.this.defineFastMethod("rjust", Arity.optional());
            StringMetaClass.this.defineFastMethod("rstrip", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("rstrip!", Arity.noArguments(), "rstrip_bang");
            StringMetaClass.this.defineMethod("scan", Arity.singleArgument());
            StringMetaClass.this.defineFastMethod("slice!", Arity.optional(), "slice_bang");
            StringMetaClass.this.defineFastMethod("split", Arity.optional());
            StringMetaClass.this.defineFastMethod("strip", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("strip!", Arity.noArguments(), "strip_bang");
            StringMetaClass.this.defineFastMethod("succ", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("succ!", Arity.noArguments(), "succ_bang");
            StringMetaClass.this.defineFastMethod("squeeze", Arity.optional());
            StringMetaClass.this.defineFastMethod("squeeze!", Arity.optional(), "squeeze_bang");
            StringMetaClass.this.defineMethod("sub", Arity.optional());
            StringMetaClass.this.defineMethod("sub!", Arity.optional(), "sub_bang");
            StringMetaClass.this.defineFastMethod("sum", Arity.optional());
            StringMetaClass.this.defineFastMethod("swapcase", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("swapcase!", Arity.noArguments(), "swapcase_bang");
            StringMetaClass.this.defineFastMethod("to_f", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("to_i", Arity.optional());
            StringMetaClass.this.defineFastMethod("to_str", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("to_sym", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("tr", Arity.twoArguments());
            StringMetaClass.this.defineFastMethod("tr!", Arity.twoArguments(), "tr_bang");
            StringMetaClass.this.defineFastMethod("tr_s", Arity.twoArguments());
            StringMetaClass.this.defineFastMethod("tr_s!", Arity.twoArguments(), "tr_s_bang");
            StringMetaClass.this.defineFastMethod("unpack", Arity.singleArgument());
            StringMetaClass.this.defineFastMethod("upcase", Arity.noArguments());
            StringMetaClass.this.defineFastMethod("upcase!", Arity.noArguments(), "upcase_bang");
            StringMetaClass.this.defineMethod("upto", Arity.singleArgument());
            StringMetaClass.this.defineAlias("<<", "concat");
            StringMetaClass.this.defineAlias("each", "each_line");
            StringMetaClass.this.defineAlias("intern", "to_sym");
            StringMetaClass.this.defineAlias("next", "succ");
            StringMetaClass.this.defineAlias("next!", "succ!");
            StringMetaClass.this.defineAlias("size", "length");
            StringMetaClass.this.defineAlias("slice", "[]");
        }
    }
}

