/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class HashMetaClass
extends ObjectMetaClass {
    private static ObjectAllocator HASH_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyHash instance = new RubyHash(runtime);
            instance.setMetaClass(klass);
            return instance;
        }
    };
    static /* synthetic */ Class class$org$jruby$runtime$builtin$meta$HashMetaClass;

    public HashMetaClass(Ruby runtime) {
        super("Hash", RubyHash.class, runtime.getObject(), HASH_ALLOCATOR);
        this.index = 10;
    }

    public HashMetaClass(String name, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        super(name, RubyHash.class, superClass, allocator, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new HashMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new HashMetaClass(name, (RubyClass)this, HASH_ALLOCATOR, parentCRef);
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyHash hash = (RubyHash)((RubyClass)recv).allocate();
        hash.callInit(args, block);
        return hash;
    }

    public static IRubyObject create(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyClass klass = (RubyClass)recv;
        RubyHash hash = (RubyHash)klass.allocate();
        if (args.length == 1) {
            hash.setValueMap(new HashMap(((RubyHash)args[0]).getValueMap()));
        } else {
            if (args.length % 2 != 0) {
                throw runtime.newArgumentError("odd number of args for Hash");
            }
            for (int i = 0; i < args.length; i += 2) {
                hash.aset(args[i], args[i + 1]);
            }
        }
        return hash;
    }

    protected class HashMeta
    extends AbstractMetaClass.Meta {
        protected HashMeta() {
        }

        protected void initializeClass() {
            HashMetaClass.this.includeModule(HashMetaClass.this.getRuntime().getModule("Enumerable"));
            HashMetaClass.this.defineFastMethod("==", Arity.singleArgument(), "equal");
            HashMetaClass.this.defineFastMethod("[]", Arity.singleArgument(), "aref");
            HashMetaClass.this.defineFastMethod("[]=", Arity.twoArguments(), "aset");
            HashMetaClass.this.defineFastMethod("clear", Arity.noArguments(), "rb_clear");
            HashMetaClass.this.defineMethod("default", Arity.optional(), "getDefaultValue");
            HashMetaClass.this.defineMethod("default_proc", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("default=", Arity.singleArgument(), "setDefaultValue");
            HashMetaClass.this.defineMethod("delete", Arity.singleArgument());
            HashMetaClass.this.defineMethod("delete_if", Arity.noArguments());
            HashMetaClass.this.defineMethod("each", Arity.noArguments());
            HashMetaClass.this.defineMethod("each_pair", Arity.noArguments());
            HashMetaClass.this.defineMethod("each_value", Arity.noArguments());
            HashMetaClass.this.defineMethod("each_key", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("empty?", Arity.noArguments(), "empty_p");
            HashMetaClass.this.defineMethod("fetch", Arity.optional());
            HashMetaClass.this.defineFastMethod("has_value?", Arity.singleArgument(), "has_value");
            HashMetaClass.this.defineFastMethod("index", Arity.singleArgument());
            HashMetaClass.this.defineFastMethod("indices", Arity.optional());
            HashMetaClass.this.defineMethod("initialize", Arity.optional());
            HashMetaClass.this.defineFastMethod("initialize_copy", Arity.singleArgument(), "replace");
            HashMetaClass.this.defineFastMethod("inspect", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("invert", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("include?", Arity.singleArgument(), "has_key");
            HashMetaClass.this.defineFastMethod("keys", Arity.noArguments());
            HashMetaClass.this.defineMethod("merge", Arity.singleArgument());
            HashMetaClass.this.defineFastMethod("rehash", Arity.noArguments());
            HashMetaClass.this.defineMethod("reject", Arity.noArguments());
            HashMetaClass.this.defineMethod("reject!", Arity.noArguments(), "reject_bang");
            HashMetaClass.this.defineFastMethod("replace", Arity.singleArgument());
            HashMetaClass.this.defineFastMethod("shift", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("size", Arity.noArguments(), "rb_size");
            HashMetaClass.this.defineMethod("sort", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("to_a", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("to_hash", Arity.noArguments());
            HashMetaClass.this.defineFastMethod("to_s", Arity.noArguments());
            HashMetaClass.this.defineMethod("update", Arity.singleArgument());
            HashMetaClass.this.defineFastMethod("values", Arity.noArguments(), "rb_values");
            HashMetaClass.this.defineFastMethod("values_at", Arity.optional());
            HashMetaClass.this.defineAlias("has_key?", "include?");
            HashMetaClass.this.defineAlias("indexes", "indices");
            HashMetaClass.this.defineAlias("key?", "include?");
            HashMetaClass.this.defineAlias("length", "size");
            HashMetaClass.this.defineAlias("member?", "include?");
            HashMetaClass.this.defineAlias("merge!", "update");
            HashMetaClass.this.defineAlias("store", "[]=");
            HashMetaClass.this.defineAlias("value?", "has_value?");
            CallbackFactory hashCB = HashMetaClass.this.getRuntime().callbackFactory(class$org$jruby$runtime$builtin$meta$HashMetaClass == null ? (class$org$jruby$runtime$builtin$meta$HashMetaClass = HashMetaClass.class$("org.jruby.runtime.builtin.meta.HashMetaClass")) : class$org$jruby$runtime$builtin$meta$HashMetaClass);
            HashMetaClass.this.getMetaClass().defineMethod("new", hashCB.getOptSingletonMethod("newInstance"));
            HashMetaClass.this.getMetaClass().defineFastMethod("[]", hashCB.getOptSingletonMethod("create"));
        }
    }
}

