/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DumpingInvocationMethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.internal.runtime.methods.ReflectionMethodFactory;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.util.collections.SinglyLinkedList;

public abstract class MethodFactory {
    private static boolean reflection = false;
    private static boolean dumping = false;
    private static String dumpingPath = null;

    public abstract DynamicMethod getFullMethod(RubyModule var1, Class var2, String var3, Arity var4, Visibility var5);

    public abstract DynamicMethod getSimpleMethod(RubyModule var1, Class var2, String var3, Arity var4, Visibility var5);

    public abstract DynamicMethod getCompiledMethod(RubyModule var1, Class var2, String var3, Arity var4, Visibility var5, SinglyLinkedList var6);

    public static MethodFactory createFactory() {
        if (reflection) {
            return new ReflectionMethodFactory();
        }
        if (dumping) {
            return new DumpingInvocationMethodFactory(dumpingPath);
        }
        return new InvocationMethodFactory();
    }

    static {
        if (System.getProperty("jruby.reflection") != null && Boolean.getBoolean("jruby.reflection")) {
            reflection = true;
        }
        if (System.getProperty("jruby.dump_invocations") != null) {
            dumping = true;
            dumpingPath = System.getProperty("jruby.dump_invocations").toString();
        }
    }
}

