/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.DumpingInvocationCallbackFactory;
import org.jruby.runtime.callback.InvocationCallbackFactory;
import org.jruby.runtime.callback.ReflectionCallbackFactory;

public abstract class CallbackFactory {
    public static final Class[] NULL_CLASS_ARRAY = new Class[0];
    private static boolean reflection = false;
    private static boolean dumping = false;
    private static String dumpingPath = null;

    public abstract Callback getMethod(String var1);

    public abstract Callback getFastMethod(String var1);

    public abstract Callback getMethod(String var1, Class var2);

    public abstract Callback getFastMethod(String var1, Class var2);

    public abstract Callback getMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3);

    public abstract Callback getMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getSingletonMethod(String var1);

    public abstract Callback getFastSingletonMethod(String var1);

    public abstract Callback getSingletonMethod(String var1, Class var2);

    public abstract Callback getFastSingletonMethod(String var1, Class var2);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getBlockMethod(String var1);

    public abstract CompiledBlockCallback getBlockCallback(String var1);

    public abstract Callback getOptSingletonMethod(String var1);

    public abstract Callback getFastOptSingletonMethod(String var1);

    public abstract Callback getOptMethod(String var1);

    public abstract Callback getFastOptMethod(String var1);

    public static CallbackFactory createFactory(Ruby runtime, Class type) {
        if (reflection) {
            return new ReflectionCallbackFactory(type);
        }
        if (dumping) {
            return new DumpingInvocationCallbackFactory(runtime, type, dumpingPath);
        }
        return new InvocationCallbackFactory(runtime, type);
    }

    static {
        if (System.getProperty("jruby.reflection") != null && Boolean.getBoolean("jruby.reflection")) {
            reflection = true;
        }
        if (System.getProperty("jruby.dump_invocations") != null) {
            dumping = true;
            dumpingPath = System.getProperty("jruby.dump_invocations").toString();
        }
    }
}

