/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class JavaClass
extends JavaObject {
    private static final Pattern CAMEL_CASE_SPLITTER;
    private static final Callback __jsend_method;
    static /* synthetic */ Class class$java$lang$Boolean;
    static final /* synthetic */ boolean $assertionsDisabled;

    private JavaClass(Ruby runtime, Class javaClass) {
        super(runtime, runtime.getModule("Java").getClass("JavaClass"), javaClass);
    }

    public static synchronized JavaClass get(Ruby runtime, Class klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = new JavaClass(runtime, klass);
            runtime.getJavaSupport().putJavaClassIntoCache(javaClass);
        }
        return javaClass;
    }

    public static RubyClass createJavaClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaClass", javaModule.getClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaClass.class);
        result.includeModule(runtime.getModule("Comparable"));
        JavaObject.registerRubyMethods(runtime, result);
        result.getMetaClass().defineFastMethod("for_name", callbackFactory.getFastSingletonMethod("for_name", IRubyObject.class));
        result.defineFastMethod("public?", callbackFactory.getFastMethod("public_p"));
        result.defineFastMethod("protected?", callbackFactory.getFastMethod("protected_p"));
        result.defineFastMethod("private?", callbackFactory.getFastMethod("private_p"));
        result.defineFastMethod("final?", callbackFactory.getFastMethod("final_p"));
        result.defineFastMethod("interface?", callbackFactory.getFastMethod("interface_p"));
        result.defineFastMethod("array?", callbackFactory.getFastMethod("array_p"));
        result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("simple_name", callbackFactory.getFastMethod("simple_name"));
        result.defineFastMethod("to_s", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("superclass", callbackFactory.getFastMethod("superclass"));
        result.defineFastMethod("<=>", callbackFactory.getFastMethod("op_cmp", IRubyObject.class));
        result.defineFastMethod("java_instance_methods", callbackFactory.getFastMethod("java_instance_methods"));
        result.defineFastMethod("java_class_methods", callbackFactory.getFastMethod("java_class_methods"));
        result.defineFastMethod("java_method", callbackFactory.getFastOptMethod("java_method"));
        result.defineFastMethod("constructors", callbackFactory.getFastMethod("constructors"));
        result.defineFastMethod("constructor", callbackFactory.getFastOptMethod("constructor"));
        result.defineFastMethod("array_class", callbackFactory.getFastMethod("array_class"));
        result.defineFastMethod("new_array", callbackFactory.getFastMethod("new_array", IRubyObject.class));
        result.defineFastMethod("fields", callbackFactory.getFastMethod("fields"));
        result.defineFastMethod("field", callbackFactory.getFastMethod("field", IRubyObject.class));
        result.defineFastMethod("interfaces", callbackFactory.getFastMethod("interfaces"));
        result.defineFastMethod("primitive?", callbackFactory.getFastMethod("primitive_p"));
        result.defineFastMethod("assignable_from?", callbackFactory.getFastMethod("assignable_from_p", IRubyObject.class));
        result.defineFastMethod("component_type", callbackFactory.getFastMethod("component_type"));
        result.defineFastMethod("declared_instance_methods", callbackFactory.getFastMethod("declared_instance_methods"));
        result.defineFastMethod("declared_class_methods", callbackFactory.getFastMethod("declared_class_methods"));
        result.defineFastMethod("declared_fields", callbackFactory.getFastMethod("declared_fields"));
        result.defineFastMethod("declared_field", callbackFactory.getFastMethod("declared_field", IRubyObject.class));
        result.defineFastMethod("declared_constructors", callbackFactory.getFastMethod("declared_constructors"));
        result.defineFastMethod("declared_constructor", callbackFactory.getFastOptMethod("declared_constructor"));
        result.defineFastMethod("declared_classes", callbackFactory.getFastMethod("declared_classes"));
        result.defineFastMethod("declared_method", callbackFactory.getFastOptMethod("declared_method"));
        result.defineFastMethod("define_instance_methods_for_proxy", callbackFactory.getFastMethod("define_instance_methods_for_proxy", IRubyObject.class));
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        return result;
    }

    public static synchronized JavaClass for_name(IRubyObject recv, IRubyObject name) {
        String className = name.asSymbol();
        Class klass = recv.getRuntime().getJavaSupport().loadJavaClass(className);
        return JavaClass.get(recv.getRuntime(), klass);
    }

    private Map getMethodsClumped(boolean isStatic) {
        HashMap<String, RubyArray> map = new HashMap<String, RubyArray>();
        if (((Class)this.getValue()).isInterface()) {
            return map;
        }
        Method[] methods = this.javaClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (isStatic != Modifier.isStatic(methods[i].getModifiers())) continue;
            String key = methods[i].getName();
            RubyArray methodsWithName = (RubyArray)map.get(key);
            if (methodsWithName == null) {
                methodsWithName = RubyArray.newArrayLight(this.getRuntime());
                map.put(key, methodsWithName);
            }
            methodsWithName.append(JavaMethod.create(this.getRuntime(), methods[i]));
        }
        return map;
    }

    private Map getPropertysClumped() {
        BeanInfo info;
        HashMap map = new HashMap();
        try {
            info = Introspector.getBeanInfo(this.javaClass());
        }
        catch (IntrospectionException e) {
            return map;
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            Method writeMethod;
            Method readMethod = descriptors[i].getReadMethod();
            if (readMethod != null) {
                String key = readMethod.getName();
                ArrayList<String> aliases = (ArrayList<String>)map.get(key);
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                    map.put(key, aliases);
                }
                if (readMethod.getReturnType() == (class$java$lang$Boolean == null ? JavaClass.class$("java.lang.Boolean") : class$java$lang$Boolean) || readMethod.getReturnType() == Boolean.TYPE) {
                    aliases.add(descriptors[i].getName() + "?");
                }
                aliases.add(descriptors[i].getName());
            }
            if ((writeMethod = descriptors[i].getWriteMethod()) == null) continue;
            String key = writeMethod.getName();
            ArrayList<String> aliases = (ArrayList<String>)map.get(key);
            if (aliases == null) {
                aliases = new ArrayList<String>();
                map.put(key, aliases);
            }
            aliases.add(descriptors[i].getName() + "=");
        }
        return map;
    }

    private void define_instance_method_for_proxy(final RubyClass proxy, List names, final RubyArray methods) {
        final RubyModule javaUtilities = this.getRuntime().getModule("JavaUtilities");
        Callback method = new Callback(){
            private Map matchingMethods;

            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                IRubyObject match;
                IRubyObject[] argsArray = new IRubyObject[args.length + 1];
                ThreadContext context = self.getRuntime().getCurrentContext();
                argsArray[0] = self.getInstanceVariable("@java_object");
                RubyArray argsAsArray = RubyArray.newArrayLight(JavaClass.this.getRuntime());
                int argsTypeHash = 0;
                for (int j = 0; j < args.length; ++j) {
                    argsArray[j + 1] = Java.ruby_to_java(proxy, args[j], Block.NULL_BLOCK);
                    argsAsArray.append(argsArray[j + 1]);
                    argsTypeHash += System.identityHashCode(args[j].getMetaClass());
                }
                Integer argsKey = new Integer(argsTypeHash);
                if (this.matchingMethods == null) {
                    this.matchingMethods = new HashMap();
                }
                if ((match = (IRubyObject)this.matchingMethods.get(argsKey)) == null) {
                    IRubyObject[] mmArgs = new IRubyObject[]{methods, argsAsArray};
                    match = javaUtilities.callMethod(context, "matching_method", mmArgs);
                    this.matchingMethods.put(argsKey, match);
                }
                return Java.java_to_ruby(self, match.callMethod(context, "invoke", argsArray), Block.NULL_BLOCK);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        };
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String methodName = (String)iter.next();
            if (methodName.equals("class")) continue;
            proxy.defineFastMethod(methodName, method);
            String rubyCasedName = JavaClass.getRubyCasedName(methodName);
            if (rubyCasedName == null) continue;
            proxy.defineAlias(rubyCasedName, methodName);
        }
    }

    public static String getRubyCasedName(String javaCasedName) {
        Matcher m = CAMEL_CASE_SPLITTER.matcher(javaCasedName);
        String rubyCasedName = m.replaceAll("$1_$2").toLowerCase();
        if (rubyCasedName.equals(javaCasedName)) {
            return null;
        }
        return rubyCasedName;
    }

    public IRubyObject define_instance_methods_for_proxy(IRubyObject arg) {
        if (!$assertionsDisabled && !(arg instanceof RubyClass)) {
            throw new AssertionError();
        }
        Map aliasesClump = this.getPropertysClumped();
        Map methodsClump = this.getMethodsClumped(false);
        RubyClass proxy = (RubyClass)arg;
        proxy.defineFastMethod("__jsend!", __jsend_method);
        Iterator iter = methodsClump.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            RubyArray methods = (RubyArray)methodsClump.get(name);
            ArrayList<String> aliases = (ArrayList<String>)aliasesClump.get(name);
            if (aliases == null) {
                aliases = new ArrayList<String>();
            }
            aliases.add(name);
            this.define_instance_method_for_proxy(proxy, aliases, methods);
        }
        return this.getRuntime().getNil();
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    Class javaClass() {
        return (Class)this.getValue();
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    private static String getSimpleName(Class class_) {
        if (class_.isArray()) {
            return JavaClass.getSimpleName(class_.getComponentType()) + "[]";
        }
        String className = class_.getName();
        int i = className.lastIndexOf(36);
        if (i != -1) {
            while (++i < className.length() && Character.isDigit(className.charAt(i))) {
            }
            return className.substring(i);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    public IRubyObject superclass() {
        Class superclass = this.javaClass().getSuperclass();
        if (superclass == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass);
    }

    public RubyFixnum op_cmp(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("<=> requires JavaClass (" + other.getType() + " given)");
        }
        JavaClass otherClass = (JavaClass)other;
        if (this.javaClass() == otherClass.javaClass()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (otherClass.javaClass().isAssignableFrom(this.javaClass())) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().newFixnum(1L);
    }

    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methods, boolean isStatic) {
        RubyArray result = this.getRuntime().newArray(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (isStatic != Modifier.isStatic(method.getModifiers())) continue;
            result.append(JavaMethod.create(this.getRuntime(), method));
        }
        return result;
    }

    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    public JavaMethod java_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asSymbol();
        Class[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.create(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    public JavaMethod declared_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asSymbol();
        Class[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    private Class[] buildArgumentTypes(IRubyObject[] args) throws ClassNotFoundException {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError(args.length, 1);
        }
        Class[] argumentTypes = new Class[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            JavaClass type = JavaClass.for_name(this, args[i]);
            argumentTypes[i - 1] = type.javaClass();
        }
        return argumentTypes;
    }

    public RubyArray constructors() {
        return this.buildConstructors(this.javaClass().getConstructors());
    }

    public RubyArray declared_classes() {
        return this.buildClasses(this.javaClass().getDeclaredClasses());
    }

    private RubyArray buildClasses(Class[] classes) {
        RubyArray result = this.getRuntime().newArray(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            result.append(new JavaClass(this.getRuntime(), classes[i]));
        }
        return result;
    }

    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor[] constructors) {
        RubyArray result = this.getRuntime().newArray(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            result.append(new JavaConstructor(this.getRuntime(), constructors[i]));
        }
        return result;
    }

    public JavaConstructor constructor(IRubyObject[] args) {
        try {
            Class[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    public JavaConstructor declared_constructor(IRubyObject[] args) {
        try {
            Class[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class[] buildClassArgs(IRubyObject[] args) {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            String name = args[i].asSymbol();
            parameterTypes[i] = this.getRuntime().getJavaSupport().loadJavaClass(name);
        }
        return parameterTypes;
    }

    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    public JavaObject new_array(IRubyObject lengthArgument) {
        if (lengthArgument instanceof RubyInteger) {
            int length = (int)((RubyInteger)lengthArgument).getLongValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length));
        }
        if (lengthArgument instanceof RubyArray) {
            List list = ((RubyArray)lengthArgument).getList();
            int length = list.size();
            if (length == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] dimensions = new int[length];
            int i = length;
            while (--i >= 0) {
                IRubyObject dimensionLength = (IRubyObject)list.get(i);
                if (!(dimensionLength instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(dimensionLength, this.getRuntime().getClass("Integer"));
                }
                dimensions[i] = (int)((RubyInteger)dimensionLength).getLongValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), dimensions));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fields) {
        RubyArray result = this.getRuntime().newArray(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            result.append(new JavaField(this.getRuntime(), fields[i]));
        }
        return result;
    }

    public JavaField field(IRubyObject name) {
        String stringName = name.asSymbol();
        try {
            Field field = this.javaClass().getField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    public JavaField declared_field(IRubyObject name) {
        String stringName = name.asSymbol();
        try {
            Field field = this.javaClass().getDeclaredField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    private RaiseException undefinedFieldError(String name) {
        return this.getRuntime().newNameError("undefined field '" + name + "' for class '" + this.javaClass().getName() + "'", name);
    }

    public RubyArray interfaces() {
        Class<?>[] interfaces = this.javaClass().getInterfaces();
        RubyArray result = this.getRuntime().newArray(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            result.append(JavaClass.get(this.getRuntime(), interfaces[i]));
        }
        return result;
    }

    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        if (!this.javaClass().isPrimitive() && otherClass == Void.TYPE || this.javaClass().isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        Class thisJavaClass = JavaUtil.primitiveToWrapper(this.javaClass());
        if (thisJavaClass.isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        if (Number.class.isAssignableFrom(thisJavaClass)) {
            if (Number.class.isAssignableFrom(otherClass)) {
                return this.getRuntime().getTrue();
            }
            if (otherClass.equals(Character.class)) {
                return this.getRuntime().getTrue();
            }
        }
        if (thisJavaClass.equals(Character.class) && Number.class.isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    static {
        $assertionsDisabled = !JavaClass.class.desiredAssertionStatus();
        CAMEL_CASE_SPLITTER = Pattern.compile("([a-z])([A-Z])");
        __jsend_method = new Callback(){

            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                int v = RubyNumeric.fix2int(((RubyMethod)self.method((RubySymbol)args[0].callMethod(self.getRuntime().getCurrentContext(), "to_sym"))).arity());
                String name = args[0].asSymbol();
                IRubyObject[] newArgs = new IRubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                if (v < 0 || v == newArgs.length) {
                    return self.callMethod(self.getRuntime().getCurrentContext(), name, newArgs, CallType.FUNCTIONAL, block);
                }
                return self.callMethod(self.getRuntime().getCurrentContext(), (RubyModule)self.getMetaClass().getSuperClass(), name, newArgs, CallType.SUPER, block);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        };
    }
}

