/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected Visibility visibility;
    private boolean implIsClass;
    private boolean implIsKernel;

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility) {
        this.visibility = visibility;
        this.implementationClass = implementationClass;
        if (implementationClass != null) {
            this.implIsClass = implementationClass.isClass();
            this.implIsKernel = implementationClass == implementationClass.getRuntime().getKernel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        this.preMethod(context, clazz, self, name, args, noSuper, block);
        try {
            IRubyObject iRubyObject = this.internalCall(context, clazz, self, name, args, noSuper, block);
            return iRubyObject;
        }
        finally {
            this.postMethod(context);
        }
    }

    protected abstract void postMethod(ThreadContext var1);

    protected abstract IRubyObject internalCall(ThreadContext var1, RubyModule var2, IRubyObject var3, String var4, IRubyObject[] var5, boolean var6, Block var7);

    protected abstract void preMethod(ThreadContext var1, RubyModule var2, IRubyObject var3, String var4, IRubyObject[] var5, boolean var6, Block var7);

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject caller, CallType callType) {
        if (this.getVisibility().isPrivate() && callType == CallType.NORMAL) {
            return false;
        }
        if (this.getVisibility().isProtected()) {
            RubyModule defined = this.getImplementationClass();
            while (defined.isIncluded()) {
                defined = defined.getMetaClass();
            }
            if (!caller.isKindOf(defined)) {
                return false;
            }
        }
        return true;
    }

    public boolean needsImplementer() {
        return !this.implIsClass && !this.implIsKernel;
    }

    public String getOriginalName() {
        return null;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(RubyModule implClass) {
        this.implementationClass = implClass;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isUndefined() {
        return false;
    }

    public Arity getArity() {
        return Arity.optional();
    }
}

